# Copyright (c) 2014 JohnyMoSwag <johnymoswag@gmail.com>

import hashlib
import os
import sys
from getpass import getpass


class SetupConfig(object):
    # If left None "Not_So_TUF" will be used
    APP_NAME = None

    # Directory for updater to downlaod and
    # verify files.  If left blank will be place
    # in the users home directory Unix ".Not_So_TUF"
    # windows "Not_So_Tuf"
    APP_DATA_DIR = None

    # If set more debug info will be printed to console
    DEBUG = False

    # Work directory on dev machine for framework to
    # do its business. sign updates, get hashes etc...
    # If None a data folder will be created in the
    # current directory
    DEV_DATA_DIR = None

    # Length of keys to sign and verify files with
    # If left None 2048 key size will be used
    KEY_LENGTH = None

    # Name made for your private key. If left
    # None "Not_So_TUF.pem" will be used
    PRIVATE_KEY_NAME = None

    # Public Key used by your app to verify update data
    # REQUIRED
    PUBLIC_KEY = None

    # Name made for your public key.  If left
    # None "Not_So_TUF.pub" will be used
    PUBLIC_KEY_NAME = None

    # Online repository where you host your packages
    # and version file
    # REQUIRED
    UPDATE_URL = None

    # Support for patch updates
    UPDATE_PATCHES = True

    # Upload Setup
    REMOTE_DIR = None
    # SSH settings
    # Path to ssh key of server
    SSH_HOST = None
    SSH_USERNAME = None
    SSH_KEY_PATH = ''

    # FTP settings
    FTP_HOST = None
    FTP_USERNAME = None
    FTP_PASSWORD = None

    # S3 settings
    ACCESS_KEY_ID = None
    SECRET_ACCESS_KEY = None
    BUCKET_NAME = None

    def add_private_key_name(self, name):
        self.PRIVATE_KEY_NAME = name + '.pem'

    def add_public_key_name(self, name):
        self.PUBLIC_KEY_NAME = name + '.pub'


def get_correct_answer(question, default=None, required=False,
                       password=False, create_account=False):
    while 1:
        if default is None:
            msg = ''
        else:
            msg = '\n[DEFAULT] -> {}'.format(default)
        prompt = question + msg + '\n--> '
        if password:
            answer = getpass(prompt)
            if create_account is False:
                return answer
            print '\n\n'
            answer1 = getpass('Again ' + prompt)
            if answer == answer1:
                return answer
            print 'Passwords didn\'t match\n'
            continue
        else:
            answer = raw_input(prompt)
        if answer == '' and required is True:
            print 'You have to enter a value\n\n'
            raw_input('Press enter to continue')
            print '\n\n'
            continue
        if answer == '' and default is not None:
            answer = default
        _ans = ask_yes_no('You entered {}, is this correct?'.format(answer))
        if _ans:
            return answer


def ask_yes_no(question, default='no'):
    default = default.lower()
    yes = ['yes', 'ye', 'y']
    no = ['no', 'n']
    if default in no:
        help = '[N/y]?'
        default = False
    else:
        default = True
        help = '[Y/n]?'
    while 1:
        display = question + '\n' + help
        answer = raw_input(display)
        if answer == '':
            return default
        if answer in yes:
            return True
        elif answer in no:
            return False
        else:
            print 'Please answer yes or no only!\n'
            raw_input('Press enter to continue')
            print '\n\n\n\n'


# Fixed path to work without quotes
def path_fixer(path):
    # Removing ' & " in case user used them
    # for path with spaces
    path.replace("'", "")
    path.replace('"', '')

    # Correcting the path with spaces to work
    # without quotes
    return path.replace(' ', '\ ')


# Explains itself
def sha_digest(data):
    return hashlib.sha256(data).hexdigest()


if getattr(sys, 'frozen', False):
    # we are running in a |PyInstaller| bundle
    _cwd = os.path.dirname(sys.argv[0])
else:
    # we are running in a normal Python environment
    _cwd = os.getcwd()


# Makes inputting directory more like shell
def _directory_fixer(_dir):
    if _dir == 'Current Working Directory':
        _dir = _cwd
    elif _dir.startswith('~'):
        _dir = _dir[2:]
        _dir = os.path.join(os.path.expanduser('~'), _dir)
    return _dir
