# The MIT License (MIT)
#
# Copyright (c) 2014 JohnyMoSwag <johnymoswag@gmail.com>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from ftplib import FTP_TLS

from not_so_tuf.uploader.common import BaseUploader


class SFTPUploader(BaseUploader):

    def __init__(self, *args, **kwargs):
        super(SFTPUploader, self).__init__()

    def _reconnect(self):
        sftp_uploader = FTP_TLS(self.host, user='', passwd='')
        sftp_uploader.login()
        sftp_uploader.prot_p()
        return sftp_uploader

    def _connect(self):
        self.client = self._reconnect()

    def _upload_file(self, filename):
        try:
            payload = 'STOR {}'.format(filename)
            self.client.storbinary(payload, open(filename, 'rb'))
            return True
        except:
            self._reconnect()
            return False
