# The MIT License (MIT)
#
# Copyright (c) 2014 JohnyMoSwag <johnymoswag@gmail.com>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

import sys
import traceback


class STDError(Exception):
    """Extends exceptions to show added message if error isn't expected.

    Args:

        msg (str): error message

    Kwargs:

        tb (obj): is the original traceback so that it can be printed.

        expected (bool): Meaning:

                            True - Report issue msg not shown

                            False - Report issue msg shown
    """
    def __init__(self, msg, tb=None, expected=False):
        if not expected:
            msg = msg + (u'; please report this issue on https://github.com'
                         '/JohnyMoSwag/Not-So-TUF/issues')
        super(Exception, self).__init__(msg)

        self.traceback = tb
        self.exc_info = sys.exc_info()  # preserve original exception

    def format_traceback(self):
        if self.traceback is None:
            return None
        return u''.join(traceback.format_tb(self.traceback))


class ClientException(STDError):
    """Raised for Client exceptions"""
    def __init__(self, *args, **kwargs):
        super(ClientException, self).__init__(*args, **kwargs)


class ConfigException(STDError):
    """Raised for Config exceptions"""
    def __init__(self, *args, **kwargs):
        super(ConfigException, self).__init__(*args, **kwargs)


class FileDownloaderError(STDError):
    """Raised for File Downloader exceptions"""
    def __init__(self, *args, **kwargs):
        super(PackageHandlerError, self).__init__(*args, **kwargs)


class KeyHandlerError(STDError):
    """Raised for Key Handler exceptions"""
    def __init__(self, *args, **kwargs):
        super(KeyHandlerError, self).__init__(*args, **kwargs)


class NotSoTufError(STDError):
    """Raised for Framework exceptions"""
    def __init__(self, *args, **kwargs):
        super(NotSoTufError, self).__init__(*args, **kwargs)


class PackageHandlerError(STDError):
    """Raised for Package Handler exceptions"""
    def __init__(self, *args, **kwargs):
        super(PackageHandlerError, self).__init__(*args, **kwargs)


class UpdaterError(STDError):
    """Raised for Updater exceptions"""
    def __init__(self, *args, **kwargs):
        super(UpdaterError, self).__init__(*args, **kwargs)


class UploaderError(STDError):
    """Raised for Uploader exceptions"""
    def __init__(self, *args, **kwargs):
        super(UploaderError, self).__init__(*args, **kwargs)
