#!/usr/bin/env python

# The MIT License (MIT)
#
# Copyright (c) 2014 JohnyMoSwag <johnymoswag@gmail.com>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

import logging
import os
import shutil
import sys

from cli.core import Worker

# framework stuff
from not_so_tuf import Client
from not_so_tuf.compat import print_function, urllib2
from not_so_tuf.utils import FROZEN, cwd_, ChDir
from not_so_tuf.version import __version__

log = logging.getLogger(__name__)


class ClientConfig(object):

    UPDATE_URL = 'https://s3-us-west-1.amazonaws.com/not-so-tuf/'
    PUBLIC_KEY = (20108396243319911582598596115745239989885400175227707389521317729033635840299100098853596321405101734772502480347809316412443410341343456658819303295609568503560590213458417406289673047067061470663007934259038584291430372736269382548148746125115340848958555445285186466072484498307728141378225246810783728748418077590393647140601680370572187285974144350446751248280469500607629543851685059723717251232927793777304500418725557133877789415933828850137864470404672129358052555306788192180685116519389020808027326496485426387958512948345437474857267466312681047488723469520344767349264331943557545878009395265009303779143L, 65537L)


def install_client_package(test=False):
    files = ['client.py', 'compat.py', 'config.py', 'downloader.py',
             'patcher.py', 'utils.py', 'version.py']
    package_name = 'not_so_tuf'
    if test:
        dir_ = os.getcwd()
        version_file = '0'
    else:
        dir_ = os.path.abspath(sys._MEIPASS)
        url = ('https://raw.github.com/JohnyMoSwag/Not-So-'
               'TUF/master/not_so_tuf/version.py')
        try:
            version_file = urllib2.urlopen(url).read()
            version_file = version_file.replace('__version__ = ', '')
        except Exception as e:
            log.warning(str(e), exc_info=True)
            version_file = '0'

    if __version__ != version_file:
        if test:
            package_dir = os.path.abspath(os.path.join('tests/not_so_tuf'))
            with ChDir('tests'):
                if os.path.exists(package_name):
                    shutil.rmtree(package_name)
                os.mkdir(package_name)
            with ChDir(package_name):
                for f in files:
                    shutil.copy(f, package_dir)
            with ChDir(package_dir):
                with open('__init__.py', 'w') as f:
                    f.write('# Nothing to see here')

        else:
            with ChDir(cwd_):
                if os.path.exists(package_name):
                    shutil.rmtree(package_name, ignore_errors=True)
                os.mkdir(package_name)
                for f in files:
                    shutil.copy(os.path.join(dir_, f), package_name)
                with ChDir(package_name):
                    with open('__init__.py', 'w') as f:
                        f.write('# Nothing to see here')


def main():
    try:
        if FROZEN:
            client = Client(ClientConfig())
            print('Current Version {}'.format(__version__))
            update_check = client.update_check('Not So TUF', __version__)

            # Downloading Update
            if update_check is True:
                downloaded = client.download()
                # Installing Update
                if downloaded is True:
                    client.install_restart()

            install_client_package()
        try:
            worker = Worker()
            worker.start()
        except KeyboardInterrupt:
            # ToDo: Add clean up stuff here
            sys.stdout.write('\n\nExited by user\n')
            sys.stdout.flush()
    except Exception as e:
        print(str(e))
        log.error(str(e), exc_info=True)
