# The MIT License (MIT)
#
# Copyright (c) 2014 JohnyMoSwag <johnymoswag@gmail.com>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

import logging

from cli.core.common import CommonLogic
from cli.ui.menu import Menu


log = logging.getLogger(__name__)


class Keys(CommonLogic, Menu):

    def __init__(self, helpers):
        self.unpack_helpers(helpers)

        header = 'Keys'
        options = [('Show Public Key', self.show_public_key),
                   ('Make Decrypted Copy of Private Key',
                    self.private_key_copy),
                   ('Main Menu', self.done)]

        super(Keys, self).__init__(header, options)
        # self.menu = Menu(header, options)

    def show_public_key(self):
        log.debug('Show public key')
        self.key_handler.print_public_key()
        self.display_msg('Press enter to continue')
        raw_input()
        self()

    def private_key_copy(self):
        log.debug('Copied private key')
        self.key_handler.copy_decrypted_private_key()
        msg = 'Private key decrypted. Press enter to continue'
        self.display_msg(msg)
        raw_input()
        self()

    def replace_keys(self):
        log.debug('Replacing keys')
        self.key_handler.make_keys(overwrite=True)

    def make_keys(self):
        log.debug('Making keys')
        self.key_handler.make_keys()
        pub_key = self.key_handler.get_public_key()
        self.config.PUBLIC_KEY = pub_key
        self.save(self.config)
