# The MIT License (MIT)
#
# Copyright (c) 2014 JohnyMoSwag <johnymoswag@gmail.com>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

import logging
import time

from cli.core.common import CommonLogic
from cli.ui.menu import Menu

from not_so_tuf.compat import input_


log = logging.getLogger(__name__)


class Upload(CommonLogic, Menu):

    def __init__(self, helpers):
        self.unpack_helpers(helpers)

        header = 'Upload'
        message = ('Make sure updates are in "new" folder '
                   'then press "1" to start.')

        options = [('S3', self.s3_upload), ('SCP', self.scp_upload),
                   ('Main Menu', self.done)]
        super(Upload, self).__init__(header, options, message)
        # self.menu = Menu(header, options, message)

    def s3_upload(self):
        log.debug('S3 Uploader')
        self.display_menu_header('S3 Uploader')

        self.uploader.set_uploader('s3')
        if self.uploader.ready:
            self.uploader.upload()
            time.sleep(3)
        else:
            del self.uploader
            msg = ('I told you to update your settings right? Right! Press '
                   'enter to return to main menu and please this time update '
                   'your settings.')
            self.display_msg(msg)
            input_()

    def scp_upload(self):
        log.debug('SCP Uploader')

        self.display_menu_header('SCP Uploader')

        self.uploader.set_uploader('scp')
        if self.uploader.ready:
            self.uploader.upload()
        else:
            del self.uploader
            msg = ('I told you to update your settings right? Right! Press '
                   'enter to return to main menu and please this time update '
                   'your settings.')
            self.display_msg(msg)
            input_()
