# The MIT License (MIT)
#
# Copyright (c) 2014 JohnyMoSwag <johnymoswag@gmail.com>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

import logging
import time

from cli.core.common import CommonLogic
from cli.ui.menu import Menu


log = logging.getLogger(__name__)


class Sign(CommonLogic, Menu):

    def __init__(self, helpers):
        self.unpack_helpers(helpers)

        header = 'Sign Updates'
        message = ('Make sure updates are in "new" folder '
                   'then press "1" to start.')

        options = [('Start', self.start_sign_updates),
                   ('Main Menu', self.done)]
        super(Sign, self).__init__(header, options, message)
        # self.menu = Menu(header, options, message)

    def start_sign_updates(self):
        s_menu = Menu()
        s_menu.display_menu_header('Signing updates...')
        s_menu.display_msg('Please wait...')

        self.package_handler.setup()
        self.package_handler.update_package_list()
        self.key_handler.sign_update()
        self.package_handler.deploy()

        s_menu.display_msg('Update signing complete...')
        time.sleep(3)
