notigen
=======

OpenStack-like notification generator.

It works like this: In OpenStack an operation is a series of notifications
connected by a common request_id. For example, to create an instance we would
have the following events:

compute.run_instance.start
scheduler.run_instance.start
scheduler.run_instance.scheduled
scheduler.run_instance.end
compute.instance.update
compute.instance.update
compute.instance.update
compute.instance.update
compute.instance.update
compute.instance.update
compute.run_instance.end

But, since this is a large system, we could have lots of these operations
going on currently. Each operation takes time to perform. So the
notifications generated by these operations are interleaved.

This library simulates these many concurrent operations. You tell 
the EventGenerator how many new operations to start per minute
and it will. Note that you'll get a lot more notificationis than 
the operations/second (since the operations persist over time in the
future). 

The library tries to avoid bad sequences (like doing an update on 
a deleted instance), but it can happen in some race conditions.

You can generate in real-time by passing in a real datetime or
you can generate the events as fast as possible by incrementing
a starting time by the tick amount. See the examples below.

To generate events in real-time ...

    g = notigen.EventGenerator(100)  # Number of operations per minute
    now = datetime.datetime.utcnow()
    start = now
    nevents = 0
    while nevents < 10000:
        e = g.generate(now)
        if e:
            nevents += len(e)

        now = datetime.datetime.utcnow()

To generate events as fast as possible ...

    g = notigen.EventGenerator(100)  # Not really relevant
    now = datetime.datetime.utcnow()
    start = now
    nevents = 0
    while nevents < 10000:
        e = g.generate(now)
        if e:
            nevents += len(e)

        now = g.move_to_next_tick(now)

Datetimes are returned as strings as OpenStack would. 
