serialization_rules = []


def serialize(obj):
    for rule in serialization_rules:
        if rule.is_applicable_for_serialization(obj):
            return rule.serialize(obj)

    return obj


def deserialize(obj):
    for rule in serialization_rules:
        if rule.is_applicable_for_deserialization(obj):
            return rule.deserialize(obj)

    return obj


def nox_serializer(serializer):
    serialization_rules.append(serializer)
    return serializer


class BaseSerializationRule(object):

    def is_applicable_for_serialization(self, obj):
        raise NotImplementedError

    def is_applicable_for_deserialization(self, obj):
        raise NotImplementedError

    def serialize(self, obj):
        raise NotImplementedError

    def deserialize(self, obj):
        raise NotImplementedError
