from nox.abstractions.base_abstractions import TraitMutatorMixin, BaseTrait, BaseTraitMeta, TraitDefinitionError
from nox.elements.vertex import VertexMutator
from nox.elements import Edge


class EdgeTraitMutator(TraitMutatorMixin, VertexMutator):
    pass


class EdgeTraitMixin(BaseTrait):
    ELEMENT_MUTATOR = EdgeTraitMutator

    __label__ = None

    __slots__ = ()

    def __init__(self, eid, out_v, in_v, label, **properties):
        self._process_properties(properties)
        super(EdgeTraitMixin, self).__init__(eid, out_v, in_v, label, **properties)

    @classmethod
    def create(cls, out_v, in_v, label=None, **properties):
        label = cls._validate_label(label or cls.__label__)
        cls._process_properties(properties)
        return super(EdgeTraitMixin, cls).create(out_v, in_v, label, **properties)

    @classmethod
    def _validate_label(cls, label):
        """
        :rtype: str
        """
        if not label:
            raise ValueError("You're trying to create {0} though you haven't specified label value, "
                             "yet you have not set __label__ field for {0}".format(cls.__name__))
        elif not isinstance(label, str):
            raise ValueError("Label value should be a str instance!")

        return str(label)


class EdgeTraitMeta(BaseTraitMeta):
    SLOTS_ERROR_MESSAGE = "The '{name}' edge trait has nor __label__ nor  __slots__ defined!"
    LABEL_ERROR_MESSAGE = "The '{name}' edge trait has invalid __labels__ value (should be a str instance)"

    @classmethod
    def _validate_cls_dict(mcs, name, bases, cls_dict):
        label = cls_dict.get('__label__', None)
        if label:
            if isinstance(label, str):
                return cls_dict
            else:
                raise TraitDefinitionError(mcs._format_label_error(name, bases, cls_dict))

        else:
            return super(EdgeTraitMeta, mcs)._validate_cls_dict(name, bases, cls_dict)

    @classmethod
    def _format_label_error(mcs, name, bases, cls_dict):
        return mcs.LABEL_ERROR_MESSAGE.format(name=name)


class EdgeTrait(EdgeTraitMixin, Edge):
    """
    """
    __metaclass__ = EdgeTraitMeta

    __label__ = None
    __slots__ = ()
