from nox.abstractions.base_abstractions import TraitMutatorMixin, BaseTrait, BaseTraitMeta
from nox.elements.vertex import VertexMutator, Vertex


class VertexTraitMutator(TraitMutatorMixin, VertexMutator):
    pass


class VertexTraitMixin(BaseTrait):
    ELEMENT_MUTATOR = VertexTraitMutator

    __slots__ = ()

    def __init__(self, vid, **properties):
        self._process_properties(properties)
        super(VertexTraitMixin, self).__init__(vid, **properties)

    @classmethod
    def create(cls, **properties):
        cls._process_properties(properties)
        return super(VertexTraitMixin, cls).create(**properties)


class VertexTraitMeta(BaseTraitMeta):
    """
    VertexTrait metaclass.

    """
    SLOTS_ERROR_MESSAGE = "The '{name}' vertex trait has no __slots__ defined!"


class VertexTrait(VertexTraitMixin, Vertex):
    """
    Base class for user-defined vertex traits:

    >>> class PersonTrait(VertexTrait):
    ...     __slots__ = ('first_name', 'last_name')
    """
    __metaclass__ = VertexTraitMeta

    __slots__ = ()
