from distutils.core import setup
import os

version = open(os.path.join('nox', 'VERSION'), 'r').readline().strip()

setup(
    name='nox',
    version=version,
    description='TinkerPop 2.X compatible object-graph mapper (OGM) designed to be used with Titan graph database.',
    url='https://github.com/Ashald/nox',
    packages=['nox'],
    license='MIT',
    author='Borys Pierov',
    author_email='xashald@gmail.com',
    install_requires=[
        "rexpro == 0.2.0",
        "decorator == 3.4.0",
    ],
    classifiers=[
        "Development Status :: 2 - Pre-Alpha",
        "Environment :: Plugins",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 2.7",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ]
)
