# `nr.c4d.dev` - Cinema 4D Python development tools

`nr.c4d.dev` is a Python package that aids during the development of
Cinema 4D plugins. Shipping the plugin with the `nr.c4d.dev` module
is absolutely __not a requirement__.

## Requirements

- [six](https://pypi.python.org/pypi/six) (`nr.c4d.dev.__main__` only)

## Command-line interface

    usage: nr.c4d.dev [-h] {symbols} ...

    Cinema 4D Python development toolbelt.

    positional arguments:
      {symbols}     The name of a sub-command
      command_args  Arguments for the sub-command

    optional arguments:
      -h, --help    show this help message and exit

### Resource symbols

    usage: nr.c4d.dev symbols [-h] [-d] {json,pyclass,pydict} [plugdir]

    positional arguments:
      {json,pyclass,pydict}
                            The output format of the extracted symbols.
      plugdir               The plugin directory that contains a res/ directory.
                            Default is the current working directory.

    optional arguments:
      -h, --help            show this help message and exit
      -d, --description     If specified, description symbols are included
      -F, --features        Output additional features for the formatting type, if
                            available.

The `nr.c4d.dev symbols` command will extract the resource symbols it
can find, optionally including the resource symbols for description
headers. Additionally, using the `pyclass` formatting, it will output
valid Python code that makes it easy to load resource strings.

    universe $ python -m nr.c4d.dev symbols pyclass --description --features
    class res:
      def __getitem__(self, name):
          value = getattr(self, name)
          return value, c4d.plugins.GeLoadString(value)
      def __call__(self, name):
          return c4d.plugins.GeLoadString(getattr(self, name))
      def file(self, *parts):
          return os.path.join(os.path.dirname(__file__), 'res', *parts)
      def bitmap(self, *parts):
          bmp = c4d.bitmaps.BaseBitmap()
          res, ismovie = bmp.InitWith(self.file(*parts))
          if res != c4d.IMAGERESULT_OK: return None
          return bmp

        DLG_MAINDIALOG = 10000
        EDT_FILENAME   = 10001

        MYTAG_SOURCEOBJECT = 2000
        MYTAG_DESTOBJECT   = 2001
        MYTAG_MODE         = 2002
        MYTAG_MODE_SIMPLE  = 2003
        MYTAG_MODE_COMPLEX = 2004
    res = res()

## Runtime interface

If you choose to use the runtime interface by delivering the module
with your plugin, you can use the `runtime` module.

```python
from nr.c4d.dev.runtime import parse_resource
res = parse_resource()
```

## License & Notes

`nr.c4d.dev` is licensed under the MIT license.
