# Copyright (c) 2013-2014,  Niklas Rosenstein
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

import os
import glob

def get_resource_files(pluginfolder):
    """ Returns a dictionary with various contents about a plugin's
    resource folder. Returns None if there is not resource folder. """

    resfolder = os.path.join(pluginfolder, 'res')
    c4d_symbols = os.path.join(resfolder, 'c4d_symbols.h')
    if not os.path.isdir(resfolder) or not os.path.isfile(c4d_symbols):
        return None

    results = {
        'res': resfolder,
        'c4d_symbols': c4d_symbols,
        'description': [],
        }

    for desc in glob.iglob(os.path.join(resfolder, 'description', '*.h')):
        results['description'].append(desc)

    return results

