# Cinema 4D development toolbelt

This Python package provides useful tools and a command-line interface
for Python plugin development inside Cinema 4D. It's main focus is on
making the development process easier, while at the same time not be
a required dependency of the Plugin.

One common pain with Python plugin development is the management of
description and resource symbols. For C++ plugins, these can easily be
included as the resource files are created using plain C/C++ enums, but
that is not so simple in Python.

For this, the `nr.c4d.dev` command-line interface provides an interface
to parse the symbols and format them in the desired way.

    niklas $ pwd
    /Users/niklas/Applications/Cinema 4D R15/plugins/my-cool-plugin
    niklas $ c4ddev.py symbols pyclass --description --features
    class res:
        def __getitem__(self, name):
            value = getattr(self, name)
            return value, c4d.plugins.GeLoadString(value)
        def __call__(self, name):
            return c4d.plugins.GeLoadString(getattr(self, name))
        def file(self, *parts):
            return os.path.join(os.path.dirname(__file__), 'res', *parts)
        def bitmap(self, *parts):
            bmp = c4d.bitmaps.BaseBitmap()
            res, ismovie = bmp.InitWith(self.file(*parts))
            if res != c4d.IMAGERESULT_OK: return None
            return bmp

        MYCOOLPLUGIN_NAME = 100001
        MYCOOLPLUGIN_HELP = 100002

        MYCOOLPLUGIN_PARAMETER1 = 1001
        MYCOOLPLUGIN_PARAMETER2 = 1002
        Omycoolplugin = 1033725
    res = res()

This code can easily be pasted into your Plugins source code. If you
don't want the methods on the `res` object that allow you to easily
generate filenames and load strings and bitmaps, don't pass the
`--features` option.

## Commandline Interface

    usage: c4ddev.py [-h] {symbols,bootstrap} ...

    Cinema 4D development toolbelt

    positional arguments:
      {symbols,bootstrap}  The name of a sub-command
      command_args         Arguments for the sub-command

    optional arguments:
      -h, --help           show this help message and exit

## Installation & Requirements

    pip install nr.c4d.dev

- [six](https://pypi.python.org/pypi/six) (`nr.c4d.dev.__main__` only)

