
from setuptools import setup, find_packages

def read(filename):
    with open(filename) as fp:
        return fp.read()

long_description = (
    read('README.md') +
    '\n' +
    'Changes\n' +
    '=======\n' +
    read('CHANGES.md')
    )

setup(
    name='nr.c4d.dev',
    version='0.0.8',
    description='Cinema 4D Plugin development tools',
    long_description=long_description,
    author='Niklas Rosenstein',
    author_email='rosensteinniklas@gmail.com',
    url='https://github.com/nr-libs/py-nr.c4d.dev',
    install_requires=[
        'six',
        ],
    packages=find_packages('src'),
    package_dir={'': 'src'},
    package_data={
        'nr.c4d.dev': ['pkgres/*'], # must also be listed in MANIFEST.in
        },
    namespace_packages=['nr', 'nr.c4d'],
    scripts=['scripts/c4ddev.py'],
     #include_package_data=True,
    zip_safe=False,
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Programming Language :: Python",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Topic :: Utilities",
        "Topic :: Software Development :: Libraries",
        "Topic :: Software Development :: Libraries :: Python Modules",
        ],
    license="MIT License",
    )
