# `nr.cli` - a Python command-line interface wrapper

`nr.cli` is a small module for creating command-line interface
wrappers easily. A `nr.cli.CLI` object represents a command-line
program and can issue requests resulting in a `nrcli.Response`
object that can be used to communicate with the process.

Take a look at the `examples/` folder. A small example for
using the `ffmpeg.py` example:

```python
decoder = ffmpeg()
audio = decoder.decode('my_song.m4a', 44100)
print("Sound length:", int(audio.length), "seconds")
print(len(audio), "samples at", audio.hz, "Hz")
print("Sample at 1.0:", audio.get_sample(1.0))
```
