# `nr.enum` - Simple Python 2/3 compatible Enumeration

This module implements a simple framework for creating
C-like enumerations in Python using classes. Simply
inherit from the `Enumeration` class.

    >>> class Color(enum.Enumeration):
    ...     red = 0
    ...     green = 1
    ...     blue = 2
    >>> print Color.red
    <Color: red>
    >>> print Color('green')
    <Color: green>
    >>> print Color(2)
    <Color: blue>
    >>> print Color('red') is Color.red
    True
    >>> print Color.blue.name
    blue
    >>> Color(343)
    Traceback (most recent call last):
      File "test.py", line 10, in <module>
        Color(343)
      File "C:\\repositories\\py-nr.enum\\nr\\enum.py", line 159, in __new__
        raise NoSuchEnumerationValue(cls.__name__, value)
    nr.enum.NoSuchEnumerationValue: ('Color', 343)

If you want to disable that an invalid enumeration value
will raise an error, a `__fallback__` value can be
specified on class-level.

.. code-block:: python

    >>> class Color(enum.Enumeration):
    ...     red = 0
    ...     green = 1
    ...     blue = 2
    ...     __fallback__ = -1
    >>> print Color(42)
    <Color -invalid->
    >>> print Color(7).value
    -1
    >>> print Color(16).name
    -invalid-

You can also iterate over an enumeration class. Note that
the order of the items yielded is value-sorted and the order
of declaration does not play a role.

.. code-block:: python

    >>> class Color(enum.Enumeration):
    ...     red = 0
    ...     green = 1
    ...     blue = 2
    ...     __fallback__ = -1
    >>> for color in Color:
    ...     print color
    <Color: red>
    <Color: green>
    <Color: blue>

You can add data or actual methods to an enumeration
class by wrapping it with the `Data` class.

    class Color(enum.Enumeration):
        red = 0
        green = 1
        blue = 2

        @enum.Data
        @property
        def astuple(self):
            if self == Color.red:
                return (1, 0, 0)
            elif self == Color.green:
                return (0, 1, 0)
            elif self == Color.blue:
                return (0, 0, 1)
            else:
                assert False

    print Color.red.astuple
    # (1, 0, 0)
