"""
configuration for the (py.test based) tests
"""

import pytest

from random import randint

from django.conf import settings

# this is to create a Domain entries in the database, so they can be used for unit tests:
BASEDOMAIN = "nsupdate.info"
TESTDOMAIN = "tests." + BASEDOMAIN
TEST_HOST = 'test%da.%s' % (randint(1, 1000000), TESTDOMAIN)  # unit tests can update this host ONLY
TEST_SECRET = "secret"
TEST_HOST2 = 'test%db.%s' % (randint(1, 1000000), TESTDOMAIN)
TEST_SECRET2 = "somethingelse"
NAMESERVER_IP = "85.10.192.104"
NAMESERVER_UPDATE_ALGORITHM = "HMAC_SHA512"
# no problem, you can ONLY update the TESTDOMAIN with this secret, nothing else:
NAMESERVER_UPDATE_SECRET = "YWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYQ=="
NAMESERVER_PUBLIC = True

USERNAME = 'test'
USERNAME2 = 'test2'
PASSWORD = 'pass'

HOSTNAME = 'nsupdate-ddns-client-unittest.' + BASEDOMAIN
_PASSWORD = 'yUTvxjRwNu'  # no problem, is only used for this unit test
SERVER = 'ipv4.' + BASEDOMAIN
SECURE = False  # TLS/SNI support on python 2.x sucks :(

from django.utils.translation import activate

from nsupdate.main.dnstools import update_ns


@pytest.yield_fixture(scope="function")
def ddns_hostname():
    """
    get a random hostname for tests and make sure it is removed from dns
    after the test
    """
    hostname = "test%d" % randint(1000000000, 2000000000)
    yield hostname
    update_ns(hostname + '.' + TESTDOMAIN, 'A', action='del')
    update_ns(hostname + '.' + TESTDOMAIN, 'AAAA', action='del')


@pytest.yield_fixture(scope="function")
def ddns_fqdn(ddns_hostname):
    yield ddns_hostname + '.' + TESTDOMAIN


# Note: fixture must be "function" scope (default), see https://github.com/pelme/pytest_django/issues/33
@pytest.fixture(autouse=True)
def db_init(db):  # note: db is a predefined fixture and required here to have the db available
    """
    Init the database contents for testing, so we have a service domain, ...
    """
    from django.contrib.auth import get_user_model
    from nsupdate.main.models import Host, Domain, ServiceUpdater, ServiceUpdaterHostConfig
    user_model = get_user_model()
    # create a fresh test user
    u = user_model.objects.create_user(USERNAME, settings.DEFAULT_FROM_EMAIL, PASSWORD)
    u.save()
    u2 = user_model.objects.create_user(USERNAME2, 'test@example.org', PASSWORD)
    u2.save()
    # this is for tests:
    dt = Domain.objects.create(
        domain=TESTDOMAIN,  # special: test-domain update secret!
        nameserver_ip=NAMESERVER_IP,
        nameserver_update_algorithm=NAMESERVER_UPDATE_ALGORITHM,
        nameserver_update_secret=NAMESERVER_UPDATE_SECRET,
        public=NAMESERVER_PUBLIC,
        created_by=u,
    )
    # this is for querying:
    d = Domain.objects.create(
        domain=BASEDOMAIN,
        nameserver_ip=NAMESERVER_IP,
        nameserver_update_algorithm=NAMESERVER_UPDATE_ALGORITHM,
        nameserver_update_secret='invalid=',  # we don't send updates there (and the real key is really secret)
        public=NAMESERVER_PUBLIC,
        created_by=u2,
    )
    # a Host for api / session update tests
    hostname = TEST_HOST.split('.', 1)[0]
    h = Host(subdomain=hostname, domain=dt, created_by=u)
    h.generate_secret(secret=TEST_SECRET)
    hostname2 = TEST_HOST2.split('.', 1)[0]
    h2 = Host(subdomain=hostname2, domain=dt, created_by=u2)
    h2.generate_secret(secret=TEST_SECRET2)

    # "update other service" ddns_client feature
    s = ServiceUpdater.objects.create(
        name='nsupdate',
        server=SERVER,
        secure=SECURE,
        accept_ipv4=True,
        accept_ipv6=False,
        created_by=u,
    )
    ServiceUpdaterHostConfig.objects.create(
        hostname=None,  # not needed for nsupdate.info, see below
        name=HOSTNAME,
        password=_PASSWORD,
        service=s,
        host=h,
        give_ipv4=True,
        give_ipv6=False,
        created_by=u,
    )


def pytest_runtest_setup(item):
    activate('en')
