/* Generated by Cython 0.11.2 on Tue Oct 19 16:10:58 2010 */

#define PY_SSIZE_T_CLEAN
#include "Python.h"
#include "structmember.h"
#ifndef Py_PYTHON_H
    #error Python headers needed to compile C extensions, please install development version of Python.
#endif
#ifndef PY_LONG_LONG
  #define PY_LONG_LONG LONG_LONG
#endif
#ifndef DL_EXPORT
  #define DL_EXPORT(t) t
#endif
#if PY_VERSION_HEX < 0x02040000
  #define METH_COEXIST 0
  #define PyDict_CheckExact(op) (Py_TYPE(op) == &PyDict_Type)
#endif
#if PY_VERSION_HEX < 0x02050000
  typedef int Py_ssize_t;
  #define PY_SSIZE_T_MAX INT_MAX
  #define PY_SSIZE_T_MIN INT_MIN
  #define PY_FORMAT_SIZE_T ""
  #define PyInt_FromSsize_t(z) PyInt_FromLong(z)
  #define PyInt_AsSsize_t(o)   PyInt_AsLong(o)
  #define PyNumber_Index(o)    PyNumber_Int(o)
  #define PyIndex_Check(o)     PyNumber_Check(o)
#endif
#if PY_VERSION_HEX < 0x02060000
  #define Py_REFCNT(ob) (((PyObject*)(ob))->ob_refcnt)
  #define Py_TYPE(ob)   (((PyObject*)(ob))->ob_type)
  #define Py_SIZE(ob)   (((PyVarObject*)(ob))->ob_size)
  #define PyVarObject_HEAD_INIT(type, size) \
          PyObject_HEAD_INIT(type) size,
  #define PyType_Modified(t)

  typedef struct {
       void *buf;
       PyObject *obj;
       Py_ssize_t len;
       Py_ssize_t itemsize;
       int readonly;
       int ndim;
       char *format;
       Py_ssize_t *shape;
       Py_ssize_t *strides;
       Py_ssize_t *suboffsets;
       void *internal;
  } Py_buffer;

  #define PyBUF_SIMPLE 0
  #define PyBUF_WRITABLE 0x0001
  #define PyBUF_FORMAT 0x0004
  #define PyBUF_ND 0x0008
  #define PyBUF_STRIDES (0x0010 | PyBUF_ND)
  #define PyBUF_C_CONTIGUOUS (0x0020 | PyBUF_STRIDES)
  #define PyBUF_F_CONTIGUOUS (0x0040 | PyBUF_STRIDES)
  #define PyBUF_ANY_CONTIGUOUS (0x0080 | PyBUF_STRIDES)
  #define PyBUF_INDIRECT (0x0100 | PyBUF_STRIDES)

#endif
#if PY_MAJOR_VERSION < 3
  #define __Pyx_BUILTIN_MODULE_NAME "__builtin__"
#else
  #define __Pyx_BUILTIN_MODULE_NAME "builtins"
#endif
#if PY_MAJOR_VERSION >= 3
  #define Py_TPFLAGS_CHECKTYPES 0
  #define Py_TPFLAGS_HAVE_INDEX 0
#endif
#if (PY_VERSION_HEX < 0x02060000) || (PY_MAJOR_VERSION >= 3)
  #define Py_TPFLAGS_HAVE_NEWBUFFER 0
#endif
#if PY_MAJOR_VERSION >= 3
  #define PyBaseString_Type            PyUnicode_Type
  #define PyString_Type                PyBytes_Type
  #define PyString_CheckExact          PyBytes_CheckExact
  #define PyInt_Type                   PyLong_Type
  #define PyInt_Check(op)              PyLong_Check(op)
  #define PyInt_CheckExact(op)         PyLong_CheckExact(op)
  #define PyInt_FromString             PyLong_FromString
  #define PyInt_FromUnicode            PyLong_FromUnicode
  #define PyInt_FromLong               PyLong_FromLong
  #define PyInt_FromSize_t             PyLong_FromSize_t
  #define PyInt_FromSsize_t            PyLong_FromSsize_t
  #define PyInt_AsLong                 PyLong_AsLong
  #define PyInt_AS_LONG                PyLong_AS_LONG
  #define PyInt_AsSsize_t              PyLong_AsSsize_t
  #define PyInt_AsUnsignedLongMask     PyLong_AsUnsignedLongMask
  #define PyInt_AsUnsignedLongLongMask PyLong_AsUnsignedLongLongMask
  #define __Pyx_PyNumber_Divide(x,y)         PyNumber_TrueDivide(x,y)
#else
  #define __Pyx_PyNumber_Divide(x,y)         PyNumber_Divide(x,y)
  #define PyBytes_Type                 PyString_Type
#endif
#if PY_MAJOR_VERSION >= 3
  #define PyMethod_New(func, self, klass) PyInstanceMethod_New(func)
#endif
#if !defined(WIN32) && !defined(MS_WINDOWS)
  #ifndef __stdcall
    #define __stdcall
  #endif
  #ifndef __cdecl
    #define __cdecl
  #endif
  #ifndef __fastcall
    #define __fastcall
  #endif
#else
  #define _USE_MATH_DEFINES
#endif
#if PY_VERSION_HEX < 0x02050000
  #define __Pyx_GetAttrString(o,n)   PyObject_GetAttrString((o),((char *)(n)))
  #define __Pyx_SetAttrString(o,n,a) PyObject_SetAttrString((o),((char *)(n)),(a))
  #define __Pyx_DelAttrString(o,n)   PyObject_DelAttrString((o),((char *)(n)))
#else
  #define __Pyx_GetAttrString(o,n)   PyObject_GetAttrString((o),(n))
  #define __Pyx_SetAttrString(o,n,a) PyObject_SetAttrString((o),(n),(a))
  #define __Pyx_DelAttrString(o,n)   PyObject_DelAttrString((o),(n))
#endif
#if PY_VERSION_HEX < 0x02050000
  #define __Pyx_NAMESTR(n) ((char *)(n))
  #define __Pyx_DOCSTR(n)  ((char *)(n))
#else
  #define __Pyx_NAMESTR(n) (n)
  #define __Pyx_DOCSTR(n)  (n)
#endif
#ifdef __cplusplus
#define __PYX_EXTERN_C extern "C"
#else
#define __PYX_EXTERN_C extern
#endif
#include <math.h>
#define __PYX_HAVE_API__numa
#include "numa.h"
#include "sched.h"
#define __PYX_USE_C99_COMPLEX defined(_Complex_I)


#ifdef __GNUC__
#define INLINE __inline__
#elif _WIN32
#define INLINE __inline
#else
#define INLINE 
#endif

typedef struct {PyObject **p; char *s; long n; char is_unicode; char intern; char is_identifier;} __Pyx_StringTabEntry; /*proto*/



static int __pyx_skip_dispatch = 0;


/* Type Conversion Predeclarations */

#if PY_MAJOR_VERSION < 3
#define __Pyx_PyBytes_FromString          PyString_FromString
#define __Pyx_PyBytes_FromStringAndSize   PyString_FromStringAndSize
#define __Pyx_PyBytes_AsString            PyString_AsString
#else
#define __Pyx_PyBytes_FromString          PyBytes_FromString
#define __Pyx_PyBytes_FromStringAndSize   PyBytes_FromStringAndSize
#define __Pyx_PyBytes_AsString            PyBytes_AsString
#endif

#define __Pyx_PyBool_FromLong(b) ((b) ? (Py_INCREF(Py_True), Py_True) : (Py_INCREF(Py_False), Py_False))
static INLINE int __Pyx_PyObject_IsTrue(PyObject*);
static INLINE PyObject* __Pyx_PyNumber_Int(PyObject* x);

#if !defined(T_PYSSIZET)
#if PY_VERSION_HEX < 0x02050000
#define T_PYSSIZET T_INT
#elif !defined(T_LONGLONG)
#define T_PYSSIZET \
        ((sizeof(Py_ssize_t) == sizeof(int))  ? T_INT  : \
        ((sizeof(Py_ssize_t) == sizeof(long)) ? T_LONG : -1))
#else
#define T_PYSSIZET \
        ((sizeof(Py_ssize_t) == sizeof(int))          ? T_INT      : \
        ((sizeof(Py_ssize_t) == sizeof(long))         ? T_LONG     : \
        ((sizeof(Py_ssize_t) == sizeof(PY_LONG_LONG)) ? T_LONGLONG : -1)))
#endif
#endif

#if !defined(T_SIZET)
#if !defined(T_ULONGLONG)
#define T_SIZET \
        ((sizeof(size_t) == sizeof(unsigned int))  ? T_UINT  : \
        ((sizeof(size_t) == sizeof(unsigned long)) ? T_ULONG : -1))
#else
#define T_SIZET \
        ((sizeof(size_t) == sizeof(unsigned int))          ? T_UINT      : \
        ((sizeof(size_t) == sizeof(unsigned long))         ? T_ULONG     : \
        ((sizeof(size_t) == sizeof(unsigned PY_LONG_LONG)) ? T_ULONGLONG : -1)))
#endif
#endif

static INLINE Py_ssize_t __Pyx_PyIndex_AsSsize_t(PyObject*);
static INLINE PyObject * __Pyx_PyInt_FromSize_t(size_t);
static INLINE size_t __Pyx_PyInt_AsSize_t(PyObject*);

#define __pyx_PyFloat_AsDouble(x) (PyFloat_CheckExact(x) ? PyFloat_AS_DOUBLE(x) : PyFloat_AsDouble(x))


#ifdef __GNUC__
/* Test for GCC > 2.95 */
#if __GNUC__ > 2 ||               (__GNUC__ == 2 && (__GNUC_MINOR__ > 95)) 
#define likely(x)   __builtin_expect(!!(x), 1)
#define unlikely(x) __builtin_expect(!!(x), 0)
#else /* __GNUC__ > 2 ... */
#define likely(x)   (x)
#define unlikely(x) (x)
#endif /* __GNUC__ > 2 ... */
#else /* __GNUC__ */
#define likely(x)   (x)
#define unlikely(x) (x)
#endif /* __GNUC__ */
    
static PyObject *__pyx_m;
static PyObject *__pyx_b;
static PyObject *__pyx_empty_tuple;
static int __pyx_lineno;
static int __pyx_clineno = 0;
static const char * __pyx_cfilenm= __FILE__;
static const char *__pyx_filename;
static const char **__pyx_f;

static char __pyx_mdoc[] = "\nInterface to numa(3) Linux library.\n\nIt allows querying internal NUMA status, changing policies, binding to CPUs, etc.\n";


#ifdef CYTHON_REFNANNY
typedef struct {
  void (*INCREF)(void*, PyObject*, int);
  void (*DECREF)(void*, PyObject*, int);
  void (*GOTREF)(void*, PyObject*, int);
  void (*GIVEREF)(void*, PyObject*, int);
  void* (*NewContext)(const char*, int, const char*);
  void (*FinishContext)(void**);
} __Pyx_RefnannyAPIStruct;
static __Pyx_RefnannyAPIStruct *__Pyx_Refnanny = NULL;
#define __Pyx_ImportRefcountAPI(name)   (__Pyx_RefnannyAPIStruct *) PyCObject_Import((char *)name, (char *)"RefnannyAPI")
#define __Pyx_INCREF(r) __Pyx_Refnanny->INCREF(__pyx_refchk, (PyObject *)(r), __LINE__)
#define __Pyx_DECREF(r) __Pyx_Refnanny->DECREF(__pyx_refchk, (PyObject *)(r), __LINE__)
#define __Pyx_GOTREF(r) __Pyx_Refnanny->GOTREF(__pyx_refchk, (PyObject *)(r), __LINE__)
#define __Pyx_GIVEREF(r) __Pyx_Refnanny->GIVEREF(__pyx_refchk, (PyObject *)(r), __LINE__)
#define __Pyx_XDECREF(r) if((r) == NULL) ; else __Pyx_DECREF(r)
#define __Pyx_SetupRefcountContext(name)   void* __pyx_refchk = __Pyx_Refnanny->NewContext((name), __LINE__, __FILE__)
#define __Pyx_FinishRefcountContext()   __Pyx_Refnanny->FinishContext(&__pyx_refchk)
#else
#define __Pyx_INCREF(r) Py_INCREF(r)
#define __Pyx_DECREF(r) Py_DECREF(r)
#define __Pyx_GOTREF(r)
#define __Pyx_GIVEREF(r)
#define __Pyx_XDECREF(r) Py_XDECREF(r)
#define __Pyx_SetupRefcountContext(name)
#define __Pyx_FinishRefcountContext()
#endif /* CYTHON_REFNANNY */
#define __Pyx_XGIVEREF(r) if((r) == NULL) ; else __Pyx_GIVEREF(r)
#define __Pyx_XGOTREF(r) if((r) == NULL) ; else __Pyx_GOTREF(r)

#if PY_VERSION_HEX < 0x02050000
#ifndef PyAnySet_CheckExact

#define PyAnySet_CheckExact(ob) \
    ((ob)->ob_type == &PySet_Type || \
     (ob)->ob_type == &PyFrozenSet_Type)

#define PySet_New(iterable) \
    PyObject_CallFunctionObjArgs((PyObject *)&PySet_Type, (iterable), NULL)

#define Pyx_PyFrozenSet_New(iterable) \
    PyObject_CallFunctionObjArgs((PyObject *)&PyFrozenSet_Type, (iterable), NULL)

#define PySet_Size(anyset) \
    PyObject_Size((anyset))

#define PySet_Contains(anyset, key) \
    PySequence_Contains((anyset), (key))

#define PySet_Pop(set) \
    PyObject_CallMethod(set, (char *)"pop", NULL)

static INLINE int PySet_Clear(PyObject *set) {
    PyObject *ret = PyObject_CallMethod(set, (char *)"clear", NULL);
    if (!ret) return -1;
    Py_DECREF(ret); return 0;
}

static INLINE int PySet_Discard(PyObject *set, PyObject *key) {
    PyObject *ret = PyObject_CallMethod(set, (char *)"discard", (char *)"O", key);
    if (!ret) return -1;
    Py_DECREF(ret); return 0;
}

static INLINE int PySet_Add(PyObject *set, PyObject *key) {
    PyObject *ret = PyObject_CallMethod(set, (char *)"add", (char *)"O", key);
    if (!ret) return -1;
    Py_DECREF(ret); return 0;
}

#endif /* PyAnySet_CheckExact (<= Py2.4) */

#if PY_VERSION_HEX < 0x02040000
#ifndef Py_SETOBJECT_H
#define Py_SETOBJECT_H

static PyTypeObject *__Pyx_PySet_Type = NULL;
static PyTypeObject *__Pyx_PyFrozenSet_Type = NULL;

#define PySet_Type (*__Pyx_PySet_Type)
#define PyFrozenSet_Type (*__Pyx_PyFrozenSet_Type)

#define PyAnySet_Check(ob) \
    (PyAnySet_CheckExact(ob) || \
     PyType_IsSubtype((ob)->ob_type, &PySet_Type) || \
     PyType_IsSubtype((ob)->ob_type, &PyFrozenSet_Type))

#define PyFrozenSet_CheckExact(ob) ((ob)->ob_type == &PyFrozenSet_Type)

static int __Pyx_Py23SetsImport(void) {
    PyObject *sets=0, *Set=0, *ImmutableSet=0;

    sets = PyImport_ImportModule((char *)"sets");
    if (!sets) goto bad;
    Set = PyObject_GetAttrString(sets, (char *)"Set");
    if (!Set) goto bad;
    ImmutableSet = PyObject_GetAttrString(sets, (char *)"ImmutableSet");
    if (!ImmutableSet) goto bad;
    Py_DECREF(sets);

    __Pyx_PySet_Type       = (PyTypeObject*) Set;
    __Pyx_PyFrozenSet_Type = (PyTypeObject*) ImmutableSet;

    return 0;

 bad:
    Py_XDECREF(sets);
    Py_XDECREF(Set);
    Py_XDECREF(ImmutableSet);
    return -1;
}

#else
static int __Pyx_Py23SetsImport(void) { return 0; }
#endif /* !Py_SETOBJECT_H */
#endif /* < Py2.4  */
#endif /* < Py2.5  */

static void __Pyx_RaiseDoubleKeywordsError(
    const char* func_name, PyObject* kw_name); /*proto*/

static void __Pyx_RaiseArgtupleInvalid(const char* func_name, int exact,
    Py_ssize_t num_min, Py_ssize_t num_max, Py_ssize_t num_found); /*proto*/

static int __Pyx_ParseOptionalKeywords(PyObject *kwds, PyObject **argnames[],     PyObject *kwds2, PyObject *values[], Py_ssize_t num_pos_args,     const char* function_name); /*proto*/

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name); /*proto*/

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb); /*proto*/

static INLINE void __Pyx_ErrRestore(PyObject *type, PyObject *value, PyObject *tb); /*proto*/
static INLINE void __Pyx_ErrFetch(PyObject **type, PyObject **value, PyObject **tb); /*proto*/

static INLINE int __Pyx_StrEq(const char *, const char *); /*proto*/

static INLINE unsigned char __Pyx_PyInt_AsUnsignedChar(PyObject *);

static INLINE unsigned short __Pyx_PyInt_AsUnsignedShort(PyObject *);

static INLINE unsigned int __Pyx_PyInt_AsUnsignedInt(PyObject *);

static INLINE char __Pyx_PyInt_AsChar(PyObject *);

static INLINE short __Pyx_PyInt_AsShort(PyObject *);

static INLINE int __Pyx_PyInt_AsInt(PyObject *);

static INLINE signed char __Pyx_PyInt_AsSignedChar(PyObject *);

static INLINE signed short __Pyx_PyInt_AsSignedShort(PyObject *);

static INLINE signed int __Pyx_PyInt_AsSignedInt(PyObject *);

static INLINE unsigned long __Pyx_PyInt_AsUnsignedLong(PyObject *);

static INLINE unsigned PY_LONG_LONG __Pyx_PyInt_AsUnsignedLongLong(PyObject *);

static INLINE long __Pyx_PyInt_AsLong(PyObject *);

static INLINE PY_LONG_LONG __Pyx_PyInt_AsLongLong(PyObject *);

static INLINE signed long __Pyx_PyInt_AsSignedLong(PyObject *);

static INLINE signed PY_LONG_LONG __Pyx_PyInt_AsSignedLongLong(PyObject *);

static void __Pyx_AddTraceback(const char *funcname); /*proto*/

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t); /*proto*/

/* Type declarations */
/* Module declarations from numa */

static PyObject *__pyx_f_4numa_numa_nodemask_to_set(nodemask_t); /*proto*/
static PyObject *__pyx_f_4numa_set_to_numa_nodemask(PyObject *, nodemask_t *); /*proto*/
#define __Pyx_MODULE_NAME "numa"
int __pyx_module_is_main_numa = 0;

/* Implementation of numa */
static PyObject *__pyx_int_0;
static PyObject *__pyx_int_8;
static char __pyx_k___main__[] = "__main__";
static PyObject *__pyx_kp___main__;
static char __pyx_k_node[] = "node";
static PyObject *__pyx_kp_node;
static char __pyx_k_nodemask[] = "nodemask";
static PyObject *__pyx_kp_nodemask;
static char __pyx_k_1[] = "node1";
static PyObject *__pyx_kp_1;
static char __pyx_k_2[] = "node2";
static PyObject *__pyx_kp_2;
static char __pyx_k_pid[] = "pid";
static PyObject *__pyx_kp_pid;
static char __pyx_k_cpuset[] = "cpuset";
static PyObject *__pyx_kp_cpuset;
static char __pyx_k_get_max_node[] = "get_max_node";
static PyObject *__pyx_kp_get_max_node;
static char __pyx_k_ValueError[] = "ValueError";
static PyObject *__pyx_kp_ValueError;
static char __pyx_k_RuntimeError[] = "RuntimeError";
static PyObject *__pyx_kp_RuntimeError;
static char __pyx_k_range[] = "range";
static PyObject *__pyx_kp_range;
static char __pyx_k_add[] = "add";
static PyObject *__pyx_kp_add;
static PyObject *__pyx_builtin_ValueError;
static PyObject *__pyx_builtin_RuntimeError;
static PyObject *__pyx_builtin_range;

/* "/home/smira/Projects/py-numa/numa.pyx":9
 * cimport numa
 * 
 * def available():             # <<<<<<<<<<<<<<
 *     """
 *     Is numa(3) available?
 */

static PyObject *__pyx_pf_4numa_available(PyObject *__pyx_self, PyObject *unused); /*proto*/
static char __pyx_doc_4numa_available[] = "\n    Is numa(3) available?\n\n    @rtype: C{bool}\n    ";
static PyObject *__pyx_pf_4numa_available(PyObject *__pyx_self, PyObject *unused) {
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  __Pyx_SetupRefcountContext("available");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":15
 *     @rtype: C{bool}
 *     """
 *     return numa_available() != -1             # <<<<<<<<<<<<<<
 * 
 * def get_max_node():
 */
  __Pyx_XDECREF(__pyx_r);
  __pyx_t_1 = __Pyx_PyBool_FromLong((numa_available() != -1)); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 15; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_r = __pyx_t_1;
  __pyx_t_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.available");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":17
 *     return numa_available() != -1
 * 
 * def get_max_node():             # <<<<<<<<<<<<<<
 *     """
 *     Maximum number of NUMA node.
 */

static PyObject *__pyx_pf_4numa_get_max_node(PyObject *__pyx_self, PyObject *unused); /*proto*/
static char __pyx_doc_4numa_get_max_node[] = "\n    Maximum number of NUMA node.\n\n    @rtype: C{int}\n    ";
static PyObject *__pyx_pf_4numa_get_max_node(PyObject *__pyx_self, PyObject *unused) {
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  __Pyx_SetupRefcountContext("get_max_node");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":23
 *     @rtype: C{int}
 *     """
 *     return numa_max_node()             # <<<<<<<<<<<<<<
 * 
 * def get_node_size(node):
 */
  __Pyx_XDECREF(__pyx_r);
  __pyx_t_1 = PyInt_FromLong(numa_max_node()); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 23; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_r = __pyx_t_1;
  __pyx_t_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.get_max_node");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":25
 *     return numa_max_node()
 * 
 * def get_node_size(node):             # <<<<<<<<<<<<<<
 *     """
 *     Get size of memory on C{node}.
 */

static PyObject *__pyx_pf_4numa_get_node_size(PyObject *__pyx_self, PyObject *__pyx_v_node); /*proto*/
static char __pyx_doc_4numa_get_node_size[] = "\n    Get size of memory on C{node}.\n\n    @param node: node idx\n    @type node: C{int}\n    @return: free memory/total memory\n    @rtype: C{tuple}(C{int}, C{int})\n    ";
static PyObject *__pyx_pf_4numa_get_node_size(PyObject *__pyx_self, PyObject *__pyx_v_node) {
  PY_LONG_LONG __pyx_v_free;
  PY_LONG_LONG __pyx_v_size;
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_t_1 = NULL;
  int __pyx_t_2;
  PyObject *__pyx_t_3 = NULL;
  int __pyx_t_4;
  int __pyx_t_5;
  int __pyx_t_6;
  PyObject *__pyx_t_7 = NULL;
  __Pyx_SetupRefcountContext("get_node_size");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":37
 *     cdef long long size
 * 
 *     if node < 0 or node > get_max_node():             # <<<<<<<<<<<<<<
 *         raise ValueError, node
 * 
 */
  __pyx_t_1 = PyObject_RichCompare(__pyx_v_node, __pyx_int_0, Py_LT); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 37; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_t_2 = __Pyx_PyObject_IsTrue(__pyx_t_1); if (unlikely(__pyx_t_2 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 37; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
  if (!__pyx_t_2) {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_kp_get_max_node); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 37; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_1);
    __pyx_t_1 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 37; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_1);
    __Pyx_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_t_3 = PyObject_RichCompare(__pyx_v_node, __pyx_t_1, Py_GT); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 37; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_3);
    __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    __pyx_t_4 = __Pyx_PyObject_IsTrue(__pyx_t_3); if (unlikely(__pyx_t_4 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 37; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_DECREF(__pyx_t_3); __pyx_t_3 = 0;
    __pyx_t_5 = __pyx_t_4;
  } else {
    __pyx_t_5 = __pyx_t_2;
  }
  if (__pyx_t_5) {

    /* "/home/smira/Projects/py-numa/numa.pyx":38
 * 
 *     if node < 0 or node > get_max_node():
 *         raise ValueError, node             # <<<<<<<<<<<<<<
 * 
 *     size = numa_node_size64(node, &free)
 */
    __Pyx_Raise(__pyx_builtin_ValueError, __pyx_v_node, 0);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 38; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/smira/Projects/py-numa/numa.pyx":40
 *         raise ValueError, node
 * 
 *     size = numa_node_size64(node, &free)             # <<<<<<<<<<<<<<
 * 
 *     return (free, size)
 */
  __pyx_t_6 = __Pyx_PyInt_AsInt(__pyx_v_node); if (unlikely((__pyx_t_6 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 40; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_v_size = numa_node_size64(__pyx_t_6, (&__pyx_v_free));

  /* "/home/smira/Projects/py-numa/numa.pyx":42
 *     size = numa_node_size64(node, &free)
 * 
 *     return (free, size)             # <<<<<<<<<<<<<<
 * 
 * def get_preferred():
 */
  __Pyx_XDECREF(__pyx_r);
  __pyx_t_3 = PyLong_FromLongLong(__pyx_v_free); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 42; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_3);
  __pyx_t_1 = PyLong_FromLongLong(__pyx_v_size); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 42; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_t_7 = PyTuple_New(2); if (unlikely(!__pyx_t_7)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 42; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(((PyObject *)__pyx_t_7));
  PyTuple_SET_ITEM(__pyx_t_7, 0, __pyx_t_3);
  __Pyx_GIVEREF(__pyx_t_3);
  PyTuple_SET_ITEM(__pyx_t_7, 1, __pyx_t_1);
  __Pyx_GIVEREF(__pyx_t_1);
  __pyx_t_3 = 0;
  __pyx_t_1 = 0;
  __pyx_r = ((PyObject *)__pyx_t_7);
  __pyx_t_7 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_1);
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_XDECREF(__pyx_t_3);
  __Pyx_XDECREF(__pyx_t_7);
  __Pyx_AddTraceback("numa.get_node_size");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":44
 *     return (free, size)
 * 
 * def get_preferred():             # <<<<<<<<<<<<<<
 *     """
 *     Return preferred node for this process.
 */

static PyObject *__pyx_pf_4numa_get_preferred(PyObject *__pyx_self, PyObject *unused); /*proto*/
static char __pyx_doc_4numa_get_preferred[] = "\n    Return preferred node for this process.\n\n    @rtype: C{int}\n    ";
static PyObject *__pyx_pf_4numa_get_preferred(PyObject *__pyx_self, PyObject *unused) {
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  __Pyx_SetupRefcountContext("get_preferred");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":50
 *     @rtype: C{int}
 *     """
 *     return numa_preferred()             # <<<<<<<<<<<<<<
 * 
 * def node_to_cpus(node):
 */
  __Pyx_XDECREF(__pyx_r);
  __pyx_t_1 = PyInt_FromLong(numa_preferred()); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 50; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_r = __pyx_t_1;
  __pyx_t_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.get_preferred");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":52
 *     return numa_preferred()
 * 
 * def node_to_cpus(node):             # <<<<<<<<<<<<<<
 *     """
 *     Get CPUs available on C{node}.
 */

static PyObject *__pyx_pf_4numa_node_to_cpus(PyObject *__pyx_self, PyObject *__pyx_v_node); /*proto*/
static char __pyx_doc_4numa_node_to_cpus[] = "\n    Get CPUs available on C{node}.\n\n    @return: set of CPU ids\n    @rtype: C{set}\n    ";
static PyObject *__pyx_pf_4numa_node_to_cpus(PyObject *__pyx_self, PyObject *__pyx_v_node) {
  unsigned long __pyx_v_buf[8];
  int __pyx_v_i;
  int __pyx_v_j;
  PyObject *__pyx_v_result;
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_t_1 = NULL;
  int __pyx_t_2;
  PyObject *__pyx_t_3 = NULL;
  int __pyx_t_4;
  int __pyx_t_5;
  int __pyx_t_6;
  int __pyx_t_7;
  PyObject *__pyx_t_8 = NULL;
  __Pyx_SetupRefcountContext("node_to_cpus");
  __pyx_self = __pyx_self;
  __pyx_v_result = Py_None; __Pyx_INCREF(Py_None);

  /* "/home/smira/Projects/py-numa/numa.pyx":63
 *     cdef int j
 * 
 *     result = set()             # <<<<<<<<<<<<<<
 * 
 *     if node < 0 or node > get_max_node():
 */
  __pyx_t_1 = PySet_New(0); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 63; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(((PyObject *)__pyx_t_1));
  __Pyx_DECREF(__pyx_v_result);
  __pyx_v_result = ((PyObject *)__pyx_t_1);
  __pyx_t_1 = 0;

  /* "/home/smira/Projects/py-numa/numa.pyx":65
 *     result = set()
 * 
 *     if node < 0 or node > get_max_node():             # <<<<<<<<<<<<<<
 *         raise ValueError, node
 * 
 */
  __pyx_t_1 = PyObject_RichCompare(__pyx_v_node, __pyx_int_0, Py_LT); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 65; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_t_2 = __Pyx_PyObject_IsTrue(__pyx_t_1); if (unlikely(__pyx_t_2 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 65; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
  if (!__pyx_t_2) {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_kp_get_max_node); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 65; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_1);
    __pyx_t_1 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 65; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_1);
    __Pyx_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_t_3 = PyObject_RichCompare(__pyx_v_node, __pyx_t_1, Py_GT); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 65; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_3);
    __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    __pyx_t_4 = __Pyx_PyObject_IsTrue(__pyx_t_3); if (unlikely(__pyx_t_4 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 65; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_DECREF(__pyx_t_3); __pyx_t_3 = 0;
    __pyx_t_5 = __pyx_t_4;
  } else {
    __pyx_t_5 = __pyx_t_2;
  }
  if (__pyx_t_5) {

    /* "/home/smira/Projects/py-numa/numa.pyx":66
 * 
 *     if node < 0 or node > get_max_node():
 *         raise ValueError, node             # <<<<<<<<<<<<<<
 * 
 *     if numa_node_to_cpus(node, buf, sizeof(buf)) < 0:
 */
    __Pyx_Raise(__pyx_builtin_ValueError, __pyx_v_node, 0);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 66; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/smira/Projects/py-numa/numa.pyx":68
 *         raise ValueError, node
 * 
 *     if numa_node_to_cpus(node, buf, sizeof(buf)) < 0:             # <<<<<<<<<<<<<<
 *         raise RuntimeError, node
 * 
 */
  __pyx_t_6 = __Pyx_PyInt_AsInt(__pyx_v_node); if (unlikely((__pyx_t_6 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 68; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_t_5 = (numa_node_to_cpus(__pyx_t_6, __pyx_v_buf, (sizeof(__pyx_v_buf))) < 0);
  if (__pyx_t_5) {

    /* "/home/smira/Projects/py-numa/numa.pyx":69
 * 
 *     if numa_node_to_cpus(node, buf, sizeof(buf)) < 0:
 *         raise RuntimeError, node             # <<<<<<<<<<<<<<
 * 
 *     for i in range(0, 8):
 */
    __Pyx_Raise(__pyx_builtin_RuntimeError, __pyx_v_node, 0);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 69; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    goto __pyx_L6;
  }
  __pyx_L6:;

  /* "/home/smira/Projects/py-numa/numa.pyx":71
 *         raise RuntimeError, node
 * 
 *     for i in range(0, 8):             # <<<<<<<<<<<<<<
 *         for j in range (0, sizeof(unsigned long)*8):
 *             if buf[i] & (1L << j) == (1L << j):
 */
  for (__pyx_t_6 = 0; __pyx_t_6 < 8; __pyx_t_6+=1) {
    __pyx_v_i = __pyx_t_6;

    /* "/home/smira/Projects/py-numa/numa.pyx":72
 * 
 *     for i in range(0, 8):
 *         for j in range (0, sizeof(unsigned long)*8):             # <<<<<<<<<<<<<<
 *             if buf[i] & (1L << j) == (1L << j):
 *                 result.add(i*sizeof(unsigned long)*8 + j)
 */
    for (__pyx_t_7 = 0; __pyx_t_7 < ((sizeof(unsigned long)) * 8); __pyx_t_7+=1) {
      __pyx_v_j = __pyx_t_7;

      /* "/home/smira/Projects/py-numa/numa.pyx":73
 *     for i in range(0, 8):
 *         for j in range (0, sizeof(unsigned long)*8):
 *             if buf[i] & (1L << j) == (1L << j):             # <<<<<<<<<<<<<<
 *                 result.add(i*sizeof(unsigned long)*8 + j)
 * 
 */
      __pyx_t_5 = (((__pyx_v_buf[__pyx_v_i]) & (1L << __pyx_v_j)) == (1L << __pyx_v_j));
      if (__pyx_t_5) {

        /* "/home/smira/Projects/py-numa/numa.pyx":74
 *         for j in range (0, sizeof(unsigned long)*8):
 *             if buf[i] & (1L << j) == (1L << j):
 *                 result.add(i*sizeof(unsigned long)*8 + j)             # <<<<<<<<<<<<<<
 * 
 *     return result
 */
        __pyx_t_3 = PyObject_GetAttr(__pyx_v_result, __pyx_kp_add); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 74; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __Pyx_GOTREF(__pyx_t_3);
        __pyx_t_1 = __Pyx_PyInt_FromSize_t((((__pyx_v_i * (sizeof(unsigned long))) * 8) + __pyx_v_j)); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 74; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __Pyx_GOTREF(__pyx_t_1);
        __pyx_t_8 = PyTuple_New(1); if (unlikely(!__pyx_t_8)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 74; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __Pyx_GOTREF(((PyObject *)__pyx_t_8));
        PyTuple_SET_ITEM(__pyx_t_8, 0, __pyx_t_1);
        __Pyx_GIVEREF(__pyx_t_1);
        __pyx_t_1 = 0;
        __pyx_t_1 = PyObject_Call(__pyx_t_3, ((PyObject *)__pyx_t_8), NULL); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 74; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
        __Pyx_GOTREF(__pyx_t_1);
        __Pyx_DECREF(__pyx_t_3); __pyx_t_3 = 0;
        __Pyx_DECREF(((PyObject *)__pyx_t_8)); __pyx_t_8 = 0;
        __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
        goto __pyx_L11;
      }
      __pyx_L11:;
    }
  }

  /* "/home/smira/Projects/py-numa/numa.pyx":76
 *                 result.add(i*sizeof(unsigned long)*8 + j)
 * 
 *     return result             # <<<<<<<<<<<<<<
 * 
 * cdef object numa_nodemask_to_set(nodemask_t mask):
 */
  __Pyx_XDECREF(__pyx_r);
  __Pyx_INCREF(__pyx_v_result);
  __pyx_r = __pyx_v_result;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_1);
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_XDECREF(__pyx_t_3);
  __Pyx_XDECREF(__pyx_t_8);
  __Pyx_AddTraceback("numa.node_to_cpus");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_DECREF(__pyx_v_result);
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":78
 *     return result
 * 
 * cdef object numa_nodemask_to_set(nodemask_t mask):             # <<<<<<<<<<<<<<
 *     """
 *     Conver NUMA nodemask to Python set.
 */

static  PyObject *__pyx_f_4numa_numa_nodemask_to_set(nodemask_t __pyx_v_mask) {
  PyObject *__pyx_v_result = 0;
  int __pyx_v_i;
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_t_1 = NULL;
  long __pyx_t_2;
  int __pyx_t_3;
  int __pyx_t_4;
  PyObject *__pyx_t_5 = NULL;
  PyObject *__pyx_t_6 = NULL;
  __Pyx_SetupRefcountContext("numa_nodemask_to_set");

  /* "/home/smira/Projects/py-numa/numa.pyx":82
 *     Conver NUMA nodemask to Python set.
 *     """
 *     cdef object result = set()             # <<<<<<<<<<<<<<
 *     cdef int i
 * 
 */
  __pyx_t_1 = PySet_New(0); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 82; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(((PyObject *)__pyx_t_1));
  __pyx_v_result = ((PyObject *)__pyx_t_1);
  __pyx_t_1 = 0;

  /* "/home/smira/Projects/py-numa/numa.pyx":85
 *     cdef int i
 * 
 *     for i in range(0, get_max_node()):             # <<<<<<<<<<<<<<
 *         if nodemask_isset(&mask, i):
 *             result.add(i)
 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_kp_get_max_node); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 85; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_1);
  __pyx_t_1 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 85; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __Pyx_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_t_2 = __Pyx_PyInt_AsLong(__pyx_t_1); if (unlikely((__pyx_t_2 == (long)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 85; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
  for (__pyx_t_3 = 0; __pyx_t_3 < __pyx_t_2; __pyx_t_3+=1) {
    __pyx_v_i = __pyx_t_3;

    /* "/home/smira/Projects/py-numa/numa.pyx":86
 * 
 *     for i in range(0, get_max_node()):
 *         if nodemask_isset(&mask, i):             # <<<<<<<<<<<<<<
 *             result.add(i)
 * 
 */
    __pyx_t_4 = nodemask_isset((&__pyx_v_mask), __pyx_v_i);
    if (__pyx_t_4) {

      /* "/home/smira/Projects/py-numa/numa.pyx":87
 *     for i in range(0, get_max_node()):
 *         if nodemask_isset(&mask, i):
 *             result.add(i)             # <<<<<<<<<<<<<<
 * 
 *     return result
 */
      __pyx_t_1 = PyObject_GetAttr(__pyx_v_result, __pyx_kp_add); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 87; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __Pyx_GOTREF(__pyx_t_1);
      __pyx_t_5 = PyInt_FromLong(__pyx_v_i); if (unlikely(!__pyx_t_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 87; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __Pyx_GOTREF(__pyx_t_5);
      __pyx_t_6 = PyTuple_New(1); if (unlikely(!__pyx_t_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 87; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __Pyx_GOTREF(((PyObject *)__pyx_t_6));
      PyTuple_SET_ITEM(__pyx_t_6, 0, __pyx_t_5);
      __Pyx_GIVEREF(__pyx_t_5);
      __pyx_t_5 = 0;
      __pyx_t_5 = PyObject_Call(__pyx_t_1, ((PyObject *)__pyx_t_6), NULL); if (unlikely(!__pyx_t_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 87; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __Pyx_GOTREF(__pyx_t_5);
      __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
      __Pyx_DECREF(((PyObject *)__pyx_t_6)); __pyx_t_6 = 0;
      __Pyx_DECREF(__pyx_t_5); __pyx_t_5 = 0;
      goto __pyx_L5;
    }
    __pyx_L5:;
  }

  /* "/home/smira/Projects/py-numa/numa.pyx":89
 *             result.add(i)
 * 
 *     return result             # <<<<<<<<<<<<<<
 * 
 * cdef set_to_numa_nodemask(object mask, nodemask_t *result):
 */
  __Pyx_XDECREF(__pyx_r);
  __Pyx_INCREF(__pyx_v_result);
  __pyx_r = __pyx_v_result;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_1);
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_XDECREF(__pyx_t_5);
  __Pyx_XDECREF(__pyx_t_6);
  __Pyx_AddTraceback("numa.numa_nodemask_to_set");
  __pyx_r = 0;
  __pyx_L0:;
  __Pyx_XDECREF(__pyx_v_result);
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":91
 *     return result
 * 
 * cdef set_to_numa_nodemask(object mask, nodemask_t *result):             # <<<<<<<<<<<<<<
 *     """
 *     Conver Python set to NUMA nodemask.
 */

static  PyObject *__pyx_f_4numa_set_to_numa_nodemask(PyObject *__pyx_v_mask, nodemask_t *__pyx_v_result) {
  int __pyx_v_i;
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_t_1 = NULL;
  long __pyx_t_2;
  int __pyx_t_3;
  int __pyx_t_4;
  __Pyx_SetupRefcountContext("set_to_numa_nodemask");

  /* "/home/smira/Projects/py-numa/numa.pyx":97
 *     cdef int i
 * 
 *     nodemask_zero(result)             # <<<<<<<<<<<<<<
 * 
 *     for i in range(0, get_max_node()):
 */
  nodemask_zero(__pyx_v_result);

  /* "/home/smira/Projects/py-numa/numa.pyx":99
 *     nodemask_zero(result)
 * 
 *     for i in range(0, get_max_node()):             # <<<<<<<<<<<<<<
 *         if i in mask:
 *             nodemask_set(result, i)
 */
  __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_kp_get_max_node); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 99; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_1);
  __pyx_t_1 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 99; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __Pyx_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_t_2 = __Pyx_PyInt_AsLong(__pyx_t_1); if (unlikely((__pyx_t_2 == (long)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 99; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
  for (__pyx_t_3 = 0; __pyx_t_3 < __pyx_t_2; __pyx_t_3+=1) {
    __pyx_v_i = __pyx_t_3;

    /* "/home/smira/Projects/py-numa/numa.pyx":100
 * 
 *     for i in range(0, get_max_node()):
 *         if i in mask:             # <<<<<<<<<<<<<<
 *             nodemask_set(result, i)
 * 
 */
    __pyx_t_1 = PyInt_FromLong(__pyx_v_i); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 100; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_1);
    __pyx_t_4 = (PySequence_Contains(__pyx_v_mask, __pyx_t_1)); if (unlikely(__pyx_t_4 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 100; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    if (__pyx_t_4) {

      /* "/home/smira/Projects/py-numa/numa.pyx":101
 *     for i in range(0, get_max_node()):
 *         if i in mask:
 *             nodemask_set(result, i)             # <<<<<<<<<<<<<<
 * 
 * def set_interleave_mask(nodemask):
 */
      nodemask_set(__pyx_v_result, __pyx_v_i);
      goto __pyx_L5;
    }
    __pyx_L5:;
  }

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_1);
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.set_to_numa_nodemask");
  __pyx_r = 0;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":103
 *             nodemask_set(result, i)
 * 
 * def set_interleave_mask(nodemask):             # <<<<<<<<<<<<<<
 *     """
 *     Sets the memory interleave mask for the current thread to C{nodemask}.
 */

static PyObject *__pyx_pf_4numa_set_interleave_mask(PyObject *__pyx_self, PyObject *__pyx_v_nodemask); /*proto*/
static char __pyx_doc_4numa_set_interleave_mask[] = "\n    Sets the memory interleave mask for the current thread to C{nodemask}.\n\n    @param nodemask: node mask\n    @type nodemask: C{set}\n    ";
static PyObject *__pyx_pf_4numa_set_interleave_mask(PyObject *__pyx_self, PyObject *__pyx_v_nodemask) {
  nodemask_t __pyx_v_mask;
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  __Pyx_SetupRefcountContext("set_interleave_mask");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":112
 *     cdef nodemask_t mask
 * 
 *     set_to_numa_nodemask(nodemask, &mask)             # <<<<<<<<<<<<<<
 * 
 *     numa_set_interleave_mask(&mask)
 */
  __pyx_t_1 = __pyx_f_4numa_set_to_numa_nodemask(__pyx_v_nodemask, (&__pyx_v_mask)); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;

  /* "/home/smira/Projects/py-numa/numa.pyx":114
 *     set_to_numa_nodemask(nodemask, &mask)
 * 
 *     numa_set_interleave_mask(&mask)             # <<<<<<<<<<<<<<
 * 
 * def get_interleave_mask():
 */
  numa_set_interleave_mask((&__pyx_v_mask));

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.set_interleave_mask");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":116
 *     numa_set_interleave_mask(&mask)
 * 
 * def get_interleave_mask():             # <<<<<<<<<<<<<<
 *     """
 *     Get interleave mask for current thread.
 */

static PyObject *__pyx_pf_4numa_get_interleave_mask(PyObject *__pyx_self, PyObject *unused); /*proto*/
static char __pyx_doc_4numa_get_interleave_mask[] = "\n    Get interleave mask for current thread.\n\n    @return: node mask\n    @rtype: C{set}\n    ";
static PyObject *__pyx_pf_4numa_get_interleave_mask(PyObject *__pyx_self, PyObject *unused) {
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  __Pyx_SetupRefcountContext("get_interleave_mask");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":123
 *     @rtype: C{set}
 *     """
 *     return numa_nodemask_to_set(numa_get_interleave_mask())             # <<<<<<<<<<<<<<
 * 
 * def bind(nodemask):
 */
  __Pyx_XDECREF(__pyx_r);
  __pyx_t_1 = __pyx_f_4numa_numa_nodemask_to_set(numa_get_interleave_mask()); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 123; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_r = __pyx_t_1;
  __pyx_t_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.get_interleave_mask");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":125
 *     return numa_nodemask_to_set(numa_get_interleave_mask())
 * 
 * def bind(nodemask):             # <<<<<<<<<<<<<<
 *     """
 *     Binds the current thread and its children to the nodes specified in nodemask.
 */

static PyObject *__pyx_pf_4numa_bind(PyObject *__pyx_self, PyObject *__pyx_v_nodemask); /*proto*/
static char __pyx_doc_4numa_bind[] = "\n    Binds the current thread and its children to the nodes specified in nodemask.  \n    They will only run on the CPUs of the specified nodes and only be able to allocate memory from them. \n\n    @param nodemask: node mask\n    @type nodemask: C{set}\n    ";
static PyObject *__pyx_pf_4numa_bind(PyObject *__pyx_self, PyObject *__pyx_v_nodemask) {
  nodemask_t __pyx_v_mask;
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  __Pyx_SetupRefcountContext("bind");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":135
 *     cdef nodemask_t mask
 * 
 *     set_to_numa_nodemask(nodemask, &mask)             # <<<<<<<<<<<<<<
 * 
 *     numa_bind(&mask)
 */
  __pyx_t_1 = __pyx_f_4numa_set_to_numa_nodemask(__pyx_v_nodemask, (&__pyx_v_mask)); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 135; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;

  /* "/home/smira/Projects/py-numa/numa.pyx":137
 *     set_to_numa_nodemask(nodemask, &mask)
 * 
 *     numa_bind(&mask)             # <<<<<<<<<<<<<<
 * 
 * def set_preferred(node):
 */
  numa_bind((&__pyx_v_mask));

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.bind");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":139
 *     numa_bind(&mask)
 * 
 * def set_preferred(node):             # <<<<<<<<<<<<<<
 *     """
 *     Sets  the preferred node for the current thread to node.
 */

static PyObject *__pyx_pf_4numa_set_preferred(PyObject *__pyx_self, PyObject *__pyx_v_node); /*proto*/
static char __pyx_doc_4numa_set_preferred[] = "\n    Sets  the preferred node for the current thread to node.\n    \n    The preferred node is the node on which memory is preferably allocated before falling back to other\n    nodes. The default is to use the node on which the process is currently running (local policy).\n\n    @param node: node idx\n    @type node: C{int}\n    ";
static PyObject *__pyx_pf_4numa_set_preferred(PyObject *__pyx_self, PyObject *__pyx_v_node) {
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_t_1 = NULL;
  int __pyx_t_2;
  PyObject *__pyx_t_3 = NULL;
  int __pyx_t_4;
  int __pyx_t_5;
  int __pyx_t_6;
  __Pyx_SetupRefcountContext("set_preferred");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":149
 *     @type node: C{int}
 *     """
 *     if node < 0 or node > get_max_node():             # <<<<<<<<<<<<<<
 *         raise ValueError, node
 * 
 */
  __pyx_t_1 = PyObject_RichCompare(__pyx_v_node, __pyx_int_0, Py_LT); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_t_2 = __Pyx_PyObject_IsTrue(__pyx_t_1); if (unlikely(__pyx_t_2 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
  if (!__pyx_t_2) {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_kp_get_max_node); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_1);
    __pyx_t_1 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_1);
    __Pyx_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_t_3 = PyObject_RichCompare(__pyx_v_node, __pyx_t_1, Py_GT); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_3);
    __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    __pyx_t_4 = __Pyx_PyObject_IsTrue(__pyx_t_3); if (unlikely(__pyx_t_4 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 149; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_DECREF(__pyx_t_3); __pyx_t_3 = 0;
    __pyx_t_5 = __pyx_t_4;
  } else {
    __pyx_t_5 = __pyx_t_2;
  }
  if (__pyx_t_5) {

    /* "/home/smira/Projects/py-numa/numa.pyx":150
 *     """
 *     if node < 0 or node > get_max_node():
 *         raise ValueError, node             # <<<<<<<<<<<<<<
 * 
 *     numa_set_preferred(node)
 */
    __Pyx_Raise(__pyx_builtin_ValueError, __pyx_v_node, 0);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 150; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/smira/Projects/py-numa/numa.pyx":152
 *         raise ValueError, node
 * 
 *     numa_set_preferred(node)             # <<<<<<<<<<<<<<
 * 
 * def set_localalloc():
 */
  __pyx_t_6 = __Pyx_PyInt_AsInt(__pyx_v_node); if (unlikely((__pyx_t_6 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 152; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  numa_set_preferred(__pyx_t_6);

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_1);
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_XDECREF(__pyx_t_3);
  __Pyx_AddTraceback("numa.set_preferred");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":154
 *     numa_set_preferred(node)
 * 
 * def set_localalloc():             # <<<<<<<<<<<<<<
 *     """
 *     Sets a local memory allocation policy for the calling thread.
 */

static PyObject *__pyx_pf_4numa_set_localalloc(PyObject *__pyx_self, PyObject *unused); /*proto*/
static char __pyx_doc_4numa_set_localalloc[] = "\n    Sets a local memory allocation policy for the calling thread.  \n    \n    Memory is preferably allocated on the node on which the thread is currently running.\n    ";
static PyObject *__pyx_pf_4numa_set_localalloc(PyObject *__pyx_self, PyObject *unused) {
  PyObject *__pyx_r = NULL;
  __Pyx_SetupRefcountContext("set_localalloc");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":160
 *     Memory is preferably allocated on the node on which the thread is currently running.
 *     """
 *     numa_set_localalloc()             # <<<<<<<<<<<<<<
 * 
 * def set_membind(nodemask):
 */
  numa_set_localalloc();

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":162
 *     numa_set_localalloc()
 * 
 * def set_membind(nodemask):             # <<<<<<<<<<<<<<
 *     """
 *     Sets the memory allocation mask.
 */

static PyObject *__pyx_pf_4numa_set_membind(PyObject *__pyx_self, PyObject *__pyx_v_nodemask); /*proto*/
static char __pyx_doc_4numa_set_membind[] = "\n    Sets the memory allocation mask.  \n    \n    The thread will only allocate memory from the nodes set in nodemask.\n\n    @param nodemask: node mask\n    @type nodemask: C{set}\n    ";
static PyObject *__pyx_pf_4numa_set_membind(PyObject *__pyx_self, PyObject *__pyx_v_nodemask) {
  nodemask_t __pyx_v_mask;
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  __Pyx_SetupRefcountContext("set_membind");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":173
 *     cdef nodemask_t mask
 * 
 *     set_to_numa_nodemask(nodemask, &mask)             # <<<<<<<<<<<<<<
 *     numa_set_membind(&mask)
 * 
 */
  __pyx_t_1 = __pyx_f_4numa_set_to_numa_nodemask(__pyx_v_nodemask, (&__pyx_v_mask)); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 173; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;

  /* "/home/smira/Projects/py-numa/numa.pyx":174
 * 
 *     set_to_numa_nodemask(nodemask, &mask)
 *     numa_set_membind(&mask)             # <<<<<<<<<<<<<<
 * 
 * def get_membind():
 */
  numa_set_membind((&__pyx_v_mask));

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.set_membind");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":176
 *     numa_set_membind(&mask)
 * 
 * def get_membind():             # <<<<<<<<<<<<<<
 *     """
 *     Returns  the  mask of nodes from which memory can currently be allocated.
 */

static PyObject *__pyx_pf_4numa_get_membind(PyObject *__pyx_self, PyObject *unused); /*proto*/
static char __pyx_doc_4numa_get_membind[] = "\n    Returns  the  mask of nodes from which memory can currently be allocated.\n\n    @return: node mask\n    @rtype: C{set}\n    ";
static PyObject *__pyx_pf_4numa_get_membind(PyObject *__pyx_self, PyObject *unused) {
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  __Pyx_SetupRefcountContext("get_membind");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":183
 *     @rtype: C{set}
 *     """
 *     return numa_nodemask_to_set(numa_get_membind())             # <<<<<<<<<<<<<<
 * 
 * def set_run_on_node_mask(nodemask):
 */
  __Pyx_XDECREF(__pyx_r);
  __pyx_t_1 = __pyx_f_4numa_numa_nodemask_to_set(numa_get_membind()); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 183; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_r = __pyx_t_1;
  __pyx_t_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.get_membind");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":185
 *     return numa_nodemask_to_set(numa_get_membind())
 * 
 * def set_run_on_node_mask(nodemask):             # <<<<<<<<<<<<<<
 *     """
 *     Runs the  current thread and its children only on nodes specified in nodemask.
 */

static PyObject *__pyx_pf_4numa_set_run_on_node_mask(PyObject *__pyx_self, PyObject *__pyx_v_nodemask); /*proto*/
static char __pyx_doc_4numa_set_run_on_node_mask[] = "\n    Runs the  current thread and its children only on nodes specified in nodemask.\n    \n    They will not migrate to CPUs of other nodes until the node affinity is\n    reset with a new call to L{set_run_on_node_mask}.\n\n    @param nodemask: node mask\n    @type nodemask: C{set}\n    ";
static PyObject *__pyx_pf_4numa_set_run_on_node_mask(PyObject *__pyx_self, PyObject *__pyx_v_nodemask) {
  nodemask_t __pyx_v_mask;
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  int __pyx_t_2;
  __Pyx_SetupRefcountContext("set_run_on_node_mask");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":197
 *     cdef nodemask_t mask
 * 
 *     set_to_numa_nodemask(nodemask, &mask)             # <<<<<<<<<<<<<<
 * 
 *     if numa_run_on_node_mask(&mask) < 0:
 */
  __pyx_t_1 = __pyx_f_4numa_set_to_numa_nodemask(__pyx_v_nodemask, (&__pyx_v_mask)); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 197; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;

  /* "/home/smira/Projects/py-numa/numa.pyx":199
 *     set_to_numa_nodemask(nodemask, &mask)
 * 
 *     if numa_run_on_node_mask(&mask) < 0:             # <<<<<<<<<<<<<<
 *         raise RuntimeError
 * 
 */
  __pyx_t_2 = (numa_run_on_node_mask((&__pyx_v_mask)) < 0);
  if (__pyx_t_2) {

    /* "/home/smira/Projects/py-numa/numa.pyx":200
 * 
 *     if numa_run_on_node_mask(&mask) < 0:
 *         raise RuntimeError             # <<<<<<<<<<<<<<
 * 
 * def get_run_on_node_mask():
 */
    __Pyx_Raise(__pyx_builtin_RuntimeError, 0, 0);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 200; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    goto __pyx_L5;
  }
  __pyx_L5:;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.set_run_on_node_mask");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":202
 *         raise RuntimeError
 * 
 * def get_run_on_node_mask():             # <<<<<<<<<<<<<<
 *     """
 *     Returns the mask of nodes that the current thread is allowed to run on.
 */

static PyObject *__pyx_pf_4numa_get_run_on_node_mask(PyObject *__pyx_self, PyObject *unused); /*proto*/
static char __pyx_doc_4numa_get_run_on_node_mask[] = "\n    Returns the mask of nodes that the current thread is allowed to run on.\n\n    @return: node mask\n    @rtype: C{set}\n    ";
static PyObject *__pyx_pf_4numa_get_run_on_node_mask(PyObject *__pyx_self, PyObject *unused) {
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  __Pyx_SetupRefcountContext("get_run_on_node_mask");
  __pyx_self = __pyx_self;

  /* "/home/smira/Projects/py-numa/numa.pyx":209
 *     @rtype: C{set}
 *     """
 *     return numa_nodemask_to_set(numa_get_run_node_mask())             # <<<<<<<<<<<<<<
 * 
 * def get_distance(node1, node2):
 */
  __Pyx_XDECREF(__pyx_r);
  __pyx_t_1 = __pyx_f_4numa_numa_nodemask_to_set(numa_get_run_node_mask()); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 209; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_r = __pyx_t_1;
  __pyx_t_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_AddTraceback("numa.get_run_on_node_mask");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":211
 *     return numa_nodemask_to_set(numa_get_run_node_mask())
 * 
 * def get_distance(node1, node2):             # <<<<<<<<<<<<<<
 *     """
 *     Reports the distance in the machine topology between two nodes.
 */

static PyObject *__pyx_pf_4numa_get_distance(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4numa_get_distance[] = "\n    Reports the distance in the machine topology between two nodes.  \n    \n    The factors are a multiple of 10. It returns 0 when the distance cannot be determined. A node  has\n    distance 10 to itself.  Reporting the distance requires a Linux kernel version of 2.6.10 or newer.\n\n    @param node1: node idx\n    @type node1: C{int}\n    @param node2: node idx\n    @type node2: C{int}\n    @rtype: C{int}\n    ";
static PyObject *__pyx_pf_4numa_get_distance(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_node1 = 0;
  PyObject *__pyx_v_node2 = 0;
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_t_1 = NULL;
  int __pyx_t_2;
  PyObject *__pyx_t_3 = NULL;
  int __pyx_t_4;
  int __pyx_t_5;
  int __pyx_t_6;
  int __pyx_t_7;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_1,&__pyx_kp_2,0};
  __Pyx_SetupRefcountContext("get_distance");
  __pyx_self = __pyx_self;
  if (unlikely(__pyx_kwds)) {
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    PyObject* values[2] = {0,0};
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_1);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_2);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("get_distance", 1, 2, 2, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 211; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "get_distance") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 211; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_node1 = values[0];
    __pyx_v_node2 = values[1];
  } else if (PyTuple_GET_SIZE(__pyx_args) != 2) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_node1 = PyTuple_GET_ITEM(__pyx_args, 0);
    __pyx_v_node2 = PyTuple_GET_ITEM(__pyx_args, 1);
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("get_distance", 1, 2, 2, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 211; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("numa.get_distance");
  return NULL;
  __pyx_L4_argument_unpacking_done:;

  /* "/home/smira/Projects/py-numa/numa.pyx":224
 *     @rtype: C{int}
 *     """
 *     if node1 < 0 or node1 > get_max_node():             # <<<<<<<<<<<<<<
 *         raise ValueError, node1
 *     if node2 < 0 or node2 > get_max_node():
 */
  __pyx_t_1 = PyObject_RichCompare(__pyx_v_node1, __pyx_int_0, Py_LT); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 224; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_t_2 = __Pyx_PyObject_IsTrue(__pyx_t_1); if (unlikely(__pyx_t_2 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 224; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
  if (!__pyx_t_2) {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_kp_get_max_node); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 224; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_1);
    __pyx_t_1 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 224; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_1);
    __Pyx_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_t_3 = PyObject_RichCompare(__pyx_v_node1, __pyx_t_1, Py_GT); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 224; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_3);
    __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    __pyx_t_4 = __Pyx_PyObject_IsTrue(__pyx_t_3); if (unlikely(__pyx_t_4 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 224; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_DECREF(__pyx_t_3); __pyx_t_3 = 0;
    __pyx_t_5 = __pyx_t_4;
  } else {
    __pyx_t_5 = __pyx_t_2;
  }
  if (__pyx_t_5) {

    /* "/home/smira/Projects/py-numa/numa.pyx":225
 *     """
 *     if node1 < 0 or node1 > get_max_node():
 *         raise ValueError, node1             # <<<<<<<<<<<<<<
 *     if node2 < 0 or node2 > get_max_node():
 *         raise ValueError, node2
 */
    __Pyx_Raise(__pyx_builtin_ValueError, __pyx_v_node1, 0);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    goto __pyx_L6;
  }
  __pyx_L6:;

  /* "/home/smira/Projects/py-numa/numa.pyx":226
 *     if node1 < 0 or node1 > get_max_node():
 *         raise ValueError, node1
 *     if node2 < 0 or node2 > get_max_node():             # <<<<<<<<<<<<<<
 *         raise ValueError, node2
 * 
 */
  __pyx_t_3 = PyObject_RichCompare(__pyx_v_node2, __pyx_int_0, Py_LT); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_3);
  __pyx_t_5 = __Pyx_PyObject_IsTrue(__pyx_t_3); if (unlikely(__pyx_t_5 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_DECREF(__pyx_t_3); __pyx_t_3 = 0;
  if (!__pyx_t_5) {
    __pyx_1 = __Pyx_GetName(__pyx_m, __pyx_kp_get_max_node); if (unlikely(!__pyx_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_1);
    __pyx_t_3 = PyObject_Call(__pyx_1, ((PyObject *)__pyx_empty_tuple), NULL); if (unlikely(!__pyx_t_3)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_3);
    __Pyx_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_t_1 = PyObject_RichCompare(__pyx_v_node2, __pyx_t_3, Py_GT); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_1);
    __Pyx_DECREF(__pyx_t_3); __pyx_t_3 = 0;
    __pyx_t_2 = __Pyx_PyObject_IsTrue(__pyx_t_1); if (unlikely(__pyx_t_2 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
    __pyx_t_4 = __pyx_t_2;
  } else {
    __pyx_t_4 = __pyx_t_5;
  }
  if (__pyx_t_4) {

    /* "/home/smira/Projects/py-numa/numa.pyx":227
 *         raise ValueError, node1
 *     if node2 < 0 or node2 > get_max_node():
 *         raise ValueError, node2             # <<<<<<<<<<<<<<
 * 
 *     return numa_distance(node1, node2)
 */
    __Pyx_Raise(__pyx_builtin_ValueError, __pyx_v_node2, 0);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 227; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    goto __pyx_L7;
  }
  __pyx_L7:;

  /* "/home/smira/Projects/py-numa/numa.pyx":229
 *         raise ValueError, node2
 * 
 *     return numa_distance(node1, node2)             # <<<<<<<<<<<<<<
 * 
 * def get_affinity(pid):
 */
  __Pyx_XDECREF(__pyx_r);
  __pyx_t_6 = __Pyx_PyInt_AsInt(__pyx_v_node1); if (unlikely((__pyx_t_6 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 229; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_t_7 = __Pyx_PyInt_AsInt(__pyx_v_node2); if (unlikely((__pyx_t_7 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 229; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_t_1 = PyInt_FromLong(numa_distance(__pyx_t_6, __pyx_t_7)); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 229; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(__pyx_t_1);
  __pyx_r = __pyx_t_1;
  __pyx_t_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_1);
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_XDECREF(__pyx_t_3);
  __Pyx_AddTraceback("numa.get_distance");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":231
 *     return numa_distance(node1, node2)
 * 
 * def get_affinity(pid):             # <<<<<<<<<<<<<<
 *     """
 *     Returns the affinity mask of the process whose ID is pid.
 */

static PyObject *__pyx_pf_4numa_get_affinity(PyObject *__pyx_self, PyObject *__pyx_v_pid); /*proto*/
static char __pyx_doc_4numa_get_affinity[] = "\n    Returns the affinity mask of the process whose ID is pid.\n\n    @param pid: process PID (0 == current process)\n    @type pid: C{int}\n    @return: set of CPU ids\n    @rtype: C{set}\n    ";
static PyObject *__pyx_pf_4numa_get_affinity(PyObject *__pyx_self, PyObject *__pyx_v_pid) {
  cpu_set_t __pyx_v_cpuset;
  int __pyx_v_i;
  PyObject *__pyx_v_result;
  PyObject *__pyx_r = NULL;
  PyObject *__pyx_t_1 = NULL;
  pid_t __pyx_t_2;
  int __pyx_t_3;
  int __pyx_t_4;
  PyObject *__pyx_t_5 = NULL;
  PyObject *__pyx_t_6 = NULL;
  __Pyx_SetupRefcountContext("get_affinity");
  __pyx_self = __pyx_self;
  __pyx_v_result = Py_None; __Pyx_INCREF(Py_None);

  /* "/home/smira/Projects/py-numa/numa.pyx":243
 *     cdef int i
 * 
 *     result = set()             # <<<<<<<<<<<<<<
 * 
 *     sched_getaffinity(pid, sizeof(cpu_set_t), &cpuset)
 */
  __pyx_t_1 = PySet_New(0); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 243; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __Pyx_GOTREF(((PyObject *)__pyx_t_1));
  __Pyx_DECREF(__pyx_v_result);
  __pyx_v_result = ((PyObject *)__pyx_t_1);
  __pyx_t_1 = 0;

  /* "/home/smira/Projects/py-numa/numa.pyx":245
 *     result = set()
 * 
 *     sched_getaffinity(pid, sizeof(cpu_set_t), &cpuset)             # <<<<<<<<<<<<<<
 * 
 *     for i in range(0, sizeof(cpu_set_t)*8):
 */
  __pyx_t_2 = __Pyx_PyInt_AsInt(__pyx_v_pid); if (unlikely((__pyx_t_2 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 245; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  sched_getaffinity(__pyx_t_2, (sizeof(cpu_set_t)), (&__pyx_v_cpuset));

  /* "/home/smira/Projects/py-numa/numa.pyx":247
 *     sched_getaffinity(pid, sizeof(cpu_set_t), &cpuset)
 * 
 *     for i in range(0, sizeof(cpu_set_t)*8):             # <<<<<<<<<<<<<<
 *         if CPU_ISSET(i, &cpuset):
 *             result.add(i)
 */
  for (__pyx_t_3 = 0; __pyx_t_3 < ((sizeof(cpu_set_t)) * 8); __pyx_t_3+=1) {
    __pyx_v_i = __pyx_t_3;

    /* "/home/smira/Projects/py-numa/numa.pyx":248
 * 
 *     for i in range(0, sizeof(cpu_set_t)*8):
 *         if CPU_ISSET(i, &cpuset):             # <<<<<<<<<<<<<<
 *             result.add(i)
 * 
 */
    __pyx_t_4 = CPU_ISSET(__pyx_v_i, (&__pyx_v_cpuset));
    if (__pyx_t_4) {

      /* "/home/smira/Projects/py-numa/numa.pyx":249
 *     for i in range(0, sizeof(cpu_set_t)*8):
 *         if CPU_ISSET(i, &cpuset):
 *             result.add(i)             # <<<<<<<<<<<<<<
 * 
 *     return result
 */
      __pyx_t_1 = PyObject_GetAttr(__pyx_v_result, __pyx_kp_add); if (unlikely(!__pyx_t_1)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 249; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __Pyx_GOTREF(__pyx_t_1);
      __pyx_t_5 = PyInt_FromLong(__pyx_v_i); if (unlikely(!__pyx_t_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 249; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __Pyx_GOTREF(__pyx_t_5);
      __pyx_t_6 = PyTuple_New(1); if (unlikely(!__pyx_t_6)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 249; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __Pyx_GOTREF(((PyObject *)__pyx_t_6));
      PyTuple_SET_ITEM(__pyx_t_6, 0, __pyx_t_5);
      __Pyx_GIVEREF(__pyx_t_5);
      __pyx_t_5 = 0;
      __pyx_t_5 = PyObject_Call(__pyx_t_1, ((PyObject *)__pyx_t_6), NULL); if (unlikely(!__pyx_t_5)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 249; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
      __Pyx_GOTREF(__pyx_t_5);
      __Pyx_DECREF(__pyx_t_1); __pyx_t_1 = 0;
      __Pyx_DECREF(((PyObject *)__pyx_t_6)); __pyx_t_6 = 0;
      __Pyx_DECREF(__pyx_t_5); __pyx_t_5 = 0;
      goto __pyx_L7;
    }
    __pyx_L7:;
  }

  /* "/home/smira/Projects/py-numa/numa.pyx":251
 *             result.add(i)
 * 
 *     return result             # <<<<<<<<<<<<<<
 * 
 * def set_affinity(pid, cpuset):
 */
  __Pyx_XDECREF(__pyx_r);
  __Pyx_INCREF(__pyx_v_result);
  __pyx_r = __pyx_v_result;
  goto __pyx_L0;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_1);
  __Pyx_XDECREF(__pyx_t_5);
  __Pyx_XDECREF(__pyx_t_6);
  __Pyx_AddTraceback("numa.get_affinity");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_DECREF(__pyx_v_result);
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

/* "/home/smira/Projects/py-numa/numa.pyx":253
 *     return result
 * 
 * def set_affinity(pid, cpuset):             # <<<<<<<<<<<<<<
 *     """
 *     Sets  the  CPU  affinity  mask of the process whose ID is pid to the value specified by mask.
 */

static PyObject *__pyx_pf_4numa_set_affinity(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4numa_set_affinity[] = "\n    Sets  the  CPU  affinity  mask of the process whose ID is pid to the value specified by mask.  \n    \n    If pid is zero, then the calling process is used.\n\n    @param pid: process PID (0 == current process)\n    @type pid: C{int}\n    @param cpuset: set of CPU ids\n    @type cpuset: C{set}\n    ";
static PyObject *__pyx_pf_4numa_set_affinity(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_pid = 0;
  PyObject *__pyx_v_cpuset = 0;
  cpu_set_t __pyx_v__cpuset;
  int __pyx_v_i;
  PyObject *__pyx_r = NULL;
  int __pyx_t_1;
  PyObject *__pyx_t_2 = NULL;
  int __pyx_t_3;
  pid_t __pyx_t_4;
  static PyObject **__pyx_pyargnames[] = {&__pyx_kp_pid,&__pyx_kp_cpuset,0};
  __Pyx_SetupRefcountContext("set_affinity");
  __pyx_self = __pyx_self;
  if (unlikely(__pyx_kwds)) {
    Py_ssize_t kw_args = PyDict_Size(__pyx_kwds);
    PyObject* values[2] = {0,0};
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  2: values[1] = PyTuple_GET_ITEM(__pyx_args, 1);
      case  1: values[0] = PyTuple_GET_ITEM(__pyx_args, 0);
      case  0: break;
      default: goto __pyx_L5_argtuple_error;
    }
    switch (PyTuple_GET_SIZE(__pyx_args)) {
      case  0:
      values[0] = PyDict_GetItem(__pyx_kwds, __pyx_kp_pid);
      if (likely(values[0])) kw_args--;
      else goto __pyx_L5_argtuple_error;
      case  1:
      values[1] = PyDict_GetItem(__pyx_kwds, __pyx_kp_cpuset);
      if (likely(values[1])) kw_args--;
      else {
        __Pyx_RaiseArgtupleInvalid("set_affinity", 1, 2, 2, 1); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 253; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
      }
    }
    if (unlikely(kw_args > 0)) {
      if (unlikely(__Pyx_ParseOptionalKeywords(__pyx_kwds, __pyx_pyargnames, 0, values, PyTuple_GET_SIZE(__pyx_args), "set_affinity") < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 253; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
    }
    __pyx_v_pid = values[0];
    __pyx_v_cpuset = values[1];
  } else if (PyTuple_GET_SIZE(__pyx_args) != 2) {
    goto __pyx_L5_argtuple_error;
  } else {
    __pyx_v_pid = PyTuple_GET_ITEM(__pyx_args, 0);
    __pyx_v_cpuset = PyTuple_GET_ITEM(__pyx_args, 1);
  }
  goto __pyx_L4_argument_unpacking_done;
  __pyx_L5_argtuple_error:;
  __Pyx_RaiseArgtupleInvalid("set_affinity", 1, 2, 2, PyTuple_GET_SIZE(__pyx_args)); {__pyx_filename = __pyx_f[0]; __pyx_lineno = 253; __pyx_clineno = __LINE__; goto __pyx_L3_error;}
  __pyx_L3_error:;
  __Pyx_AddTraceback("numa.set_affinity");
  return NULL;
  __pyx_L4_argument_unpacking_done:;

  /* "/home/smira/Projects/py-numa/numa.pyx":267
 *     cdef int i
 * 
 *     CPU_ZERO(&_cpuset)             # <<<<<<<<<<<<<<
 * 
 *     for i in range(0, sizeof(cpu_set_t)*8):
 */
  CPU_ZERO((&__pyx_v__cpuset));

  /* "/home/smira/Projects/py-numa/numa.pyx":269
 *     CPU_ZERO(&_cpuset)
 * 
 *     for i in range(0, sizeof(cpu_set_t)*8):             # <<<<<<<<<<<<<<
 *         if i in cpuset:
 *             CPU_SET(i, &_cpuset)
 */
  for (__pyx_t_1 = 0; __pyx_t_1 < ((sizeof(cpu_set_t)) * 8); __pyx_t_1+=1) {
    __pyx_v_i = __pyx_t_1;

    /* "/home/smira/Projects/py-numa/numa.pyx":270
 * 
 *     for i in range(0, sizeof(cpu_set_t)*8):
 *         if i in cpuset:             # <<<<<<<<<<<<<<
 *             CPU_SET(i, &_cpuset)
 * 
 */
    __pyx_t_2 = PyInt_FromLong(__pyx_v_i); if (unlikely(!__pyx_t_2)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 270; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_GOTREF(__pyx_t_2);
    __pyx_t_3 = (PySequence_Contains(__pyx_v_cpuset, __pyx_t_2)); if (unlikely(__pyx_t_3 < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 270; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    __Pyx_DECREF(__pyx_t_2); __pyx_t_2 = 0;
    if (__pyx_t_3) {

      /* "/home/smira/Projects/py-numa/numa.pyx":271
 *     for i in range(0, sizeof(cpu_set_t)*8):
 *         if i in cpuset:
 *             CPU_SET(i, &_cpuset)             # <<<<<<<<<<<<<<
 * 
 *     if sched_setaffinity(pid, sizeof(cpu_set_t), &_cpuset) < 0:
 */
      CPU_SET(__pyx_v_i, (&__pyx_v__cpuset));
      goto __pyx_L8;
    }
    __pyx_L8:;
  }

  /* "/home/smira/Projects/py-numa/numa.pyx":273
 *             CPU_SET(i, &_cpuset)
 * 
 *     if sched_setaffinity(pid, sizeof(cpu_set_t), &_cpuset) < 0:             # <<<<<<<<<<<<<<
 *         raise RuntimeError
 * 
 */
  __pyx_t_4 = __Pyx_PyInt_AsInt(__pyx_v_pid); if (unlikely((__pyx_t_4 == (int)-1) && PyErr_Occurred())) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 273; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_t_3 = (sched_setaffinity(__pyx_t_4, (sizeof(cpu_set_t)), (&__pyx_v__cpuset)) < 0);
  if (__pyx_t_3) {

    /* "/home/smira/Projects/py-numa/numa.pyx":274
 * 
 *     if sched_setaffinity(pid, sizeof(cpu_set_t), &_cpuset) < 0:
 *         raise RuntimeError             # <<<<<<<<<<<<<<
 * 
 * 
 */
    __Pyx_Raise(__pyx_builtin_RuntimeError, 0, 0);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 274; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
    goto __pyx_L9;
  }
  __pyx_L9:;

  __pyx_r = Py_None; __Pyx_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_XDECREF(__pyx_t_2);
  __Pyx_AddTraceback("numa.set_affinity");
  __pyx_r = NULL;
  __pyx_L0:;
  __Pyx_XGIVEREF(__pyx_r);
  __Pyx_FinishRefcountContext();
  return __pyx_r;
}

static struct PyMethodDef __pyx_methods[] = {
  {__Pyx_NAMESTR("available"), (PyCFunction)__pyx_pf_4numa_available, METH_NOARGS, __Pyx_DOCSTR(__pyx_doc_4numa_available)},
  {__Pyx_NAMESTR("get_max_node"), (PyCFunction)__pyx_pf_4numa_get_max_node, METH_NOARGS, __Pyx_DOCSTR(__pyx_doc_4numa_get_max_node)},
  {__Pyx_NAMESTR("get_node_size"), (PyCFunction)__pyx_pf_4numa_get_node_size, METH_O, __Pyx_DOCSTR(__pyx_doc_4numa_get_node_size)},
  {__Pyx_NAMESTR("get_preferred"), (PyCFunction)__pyx_pf_4numa_get_preferred, METH_NOARGS, __Pyx_DOCSTR(__pyx_doc_4numa_get_preferred)},
  {__Pyx_NAMESTR("node_to_cpus"), (PyCFunction)__pyx_pf_4numa_node_to_cpus, METH_O, __Pyx_DOCSTR(__pyx_doc_4numa_node_to_cpus)},
  {__Pyx_NAMESTR("set_interleave_mask"), (PyCFunction)__pyx_pf_4numa_set_interleave_mask, METH_O, __Pyx_DOCSTR(__pyx_doc_4numa_set_interleave_mask)},
  {__Pyx_NAMESTR("get_interleave_mask"), (PyCFunction)__pyx_pf_4numa_get_interleave_mask, METH_NOARGS, __Pyx_DOCSTR(__pyx_doc_4numa_get_interleave_mask)},
  {__Pyx_NAMESTR("bind"), (PyCFunction)__pyx_pf_4numa_bind, METH_O, __Pyx_DOCSTR(__pyx_doc_4numa_bind)},
  {__Pyx_NAMESTR("set_preferred"), (PyCFunction)__pyx_pf_4numa_set_preferred, METH_O, __Pyx_DOCSTR(__pyx_doc_4numa_set_preferred)},
  {__Pyx_NAMESTR("set_localalloc"), (PyCFunction)__pyx_pf_4numa_set_localalloc, METH_NOARGS, __Pyx_DOCSTR(__pyx_doc_4numa_set_localalloc)},
  {__Pyx_NAMESTR("set_membind"), (PyCFunction)__pyx_pf_4numa_set_membind, METH_O, __Pyx_DOCSTR(__pyx_doc_4numa_set_membind)},
  {__Pyx_NAMESTR("get_membind"), (PyCFunction)__pyx_pf_4numa_get_membind, METH_NOARGS, __Pyx_DOCSTR(__pyx_doc_4numa_get_membind)},
  {__Pyx_NAMESTR("set_run_on_node_mask"), (PyCFunction)__pyx_pf_4numa_set_run_on_node_mask, METH_O, __Pyx_DOCSTR(__pyx_doc_4numa_set_run_on_node_mask)},
  {__Pyx_NAMESTR("get_run_on_node_mask"), (PyCFunction)__pyx_pf_4numa_get_run_on_node_mask, METH_NOARGS, __Pyx_DOCSTR(__pyx_doc_4numa_get_run_on_node_mask)},
  {__Pyx_NAMESTR("get_distance"), (PyCFunction)__pyx_pf_4numa_get_distance, METH_VARARGS|METH_KEYWORDS, __Pyx_DOCSTR(__pyx_doc_4numa_get_distance)},
  {__Pyx_NAMESTR("get_affinity"), (PyCFunction)__pyx_pf_4numa_get_affinity, METH_O, __Pyx_DOCSTR(__pyx_doc_4numa_get_affinity)},
  {__Pyx_NAMESTR("set_affinity"), (PyCFunction)__pyx_pf_4numa_set_affinity, METH_VARARGS|METH_KEYWORDS, __Pyx_DOCSTR(__pyx_doc_4numa_set_affinity)},
  {0, 0, 0, 0}
};

static void __pyx_init_filenames(void); /*proto*/

#if PY_MAJOR_VERSION >= 3
static struct PyModuleDef __pyx_moduledef = {
    PyModuleDef_HEAD_INIT,
    __Pyx_NAMESTR("numa"),
    __Pyx_DOCSTR(__pyx_mdoc), /* m_doc */
    -1, /* m_size */
    __pyx_methods /* m_methods */,
    NULL, /* m_reload */
    NULL, /* m_traverse */
    NULL, /* m_clear */
    NULL /* m_free */
};
#endif

static __Pyx_StringTabEntry __pyx_string_tab[] = {
  {&__pyx_kp___main__, __pyx_k___main__, sizeof(__pyx_k___main__), 1, 1, 1},
  {&__pyx_kp_node, __pyx_k_node, sizeof(__pyx_k_node), 1, 1, 1},
  {&__pyx_kp_nodemask, __pyx_k_nodemask, sizeof(__pyx_k_nodemask), 1, 1, 1},
  {&__pyx_kp_1, __pyx_k_1, sizeof(__pyx_k_1), 1, 1, 1},
  {&__pyx_kp_2, __pyx_k_2, sizeof(__pyx_k_2), 1, 1, 1},
  {&__pyx_kp_pid, __pyx_k_pid, sizeof(__pyx_k_pid), 1, 1, 1},
  {&__pyx_kp_cpuset, __pyx_k_cpuset, sizeof(__pyx_k_cpuset), 1, 1, 1},
  {&__pyx_kp_get_max_node, __pyx_k_get_max_node, sizeof(__pyx_k_get_max_node), 1, 1, 1},
  {&__pyx_kp_ValueError, __pyx_k_ValueError, sizeof(__pyx_k_ValueError), 1, 1, 1},
  {&__pyx_kp_RuntimeError, __pyx_k_RuntimeError, sizeof(__pyx_k_RuntimeError), 1, 1, 1},
  {&__pyx_kp_range, __pyx_k_range, sizeof(__pyx_k_range), 1, 1, 1},
  {&__pyx_kp_add, __pyx_k_add, sizeof(__pyx_k_add), 1, 1, 1},
  {0, 0, 0, 0, 0, 0}
};
static int __Pyx_InitCachedBuiltins(void) {
  __pyx_builtin_ValueError = __Pyx_GetName(__pyx_b, __pyx_kp_ValueError); if (!__pyx_builtin_ValueError) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 38; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_builtin_RuntimeError = __Pyx_GetName(__pyx_b, __pyx_kp_RuntimeError); if (!__pyx_builtin_RuntimeError) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 69; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_builtin_range = __Pyx_GetName(__pyx_b, __pyx_kp_range); if (!__pyx_builtin_range) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 71; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  return 0;
  __pyx_L1_error:;
  return -1;
}

static int __Pyx_InitGlobals(void) {
  __pyx_int_0 = PyInt_FromLong(0); if (unlikely(!__pyx_int_0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  __pyx_int_8 = PyInt_FromLong(8); if (unlikely(!__pyx_int_8)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  #if PY_VERSION_HEX < 0x02040000
  if (unlikely(__Pyx_Py23SetsImport() < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  #endif
  if (__Pyx_InitStrings(__pyx_string_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  return 0;
  __pyx_L1_error:;
  return -1;
}

#if PY_MAJOR_VERSION < 3
PyMODINIT_FUNC initnuma(void); /*proto*/
PyMODINIT_FUNC initnuma(void)
#else
PyMODINIT_FUNC PyInit_numa(void); /*proto*/
PyMODINIT_FUNC PyInit_numa(void)
#endif
{
  #ifdef CYTHON_REFNANNY
  void* __pyx_refchk = NULL;
  __Pyx_Refnanny = __Pyx_ImportRefcountAPI("refnanny");
  if (!__Pyx_Refnanny) {
      PyErr_Clear();
      __Pyx_Refnanny = __Pyx_ImportRefcountAPI("Cython.Runtime.refnanny");
      if (!__Pyx_Refnanny)
          Py_FatalError("failed to import refnanny module");
  }
  __pyx_refchk = __Pyx_Refnanny->NewContext("PyMODINIT_FUNC PyInit_numa(void)", __LINE__, __FILE__);
  #endif
  __pyx_empty_tuple = PyTuple_New(0); if (unlikely(!__pyx_empty_tuple)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  /*--- Library function declarations ---*/
  __pyx_init_filenames();
  /*--- Threads initialization code ---*/
  #if defined(__PYX_FORCE_INIT_THREADS) && __PYX_FORCE_INIT_THREADS
  #ifdef WITH_THREAD /* Python build with threading support? */
  PyEval_InitThreads();
  #endif
  #endif
  /*--- Initialize various global constants etc. ---*/
  if (unlikely(__Pyx_InitGlobals() < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  /*--- Module creation code ---*/
  #if PY_MAJOR_VERSION < 3
  __pyx_m = Py_InitModule4(__Pyx_NAMESTR("numa"), __pyx_methods, __pyx_mdoc, 0, PYTHON_API_VERSION);
  #else
  __pyx_m = PyModule_Create(&__pyx_moduledef);
  #endif
  if (!__pyx_m) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  #if PY_MAJOR_VERSION < 3
  Py_INCREF(__pyx_m);
  #endif
  __pyx_b = PyImport_AddModule(__Pyx_NAMESTR(__Pyx_BUILTIN_MODULE_NAME));
  if (!__pyx_b) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  if (__Pyx_SetAttrString(__pyx_m, "__builtins__", __pyx_b) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  if (__pyx_module_is_main_numa) {
    if (__Pyx_SetAttrString(__pyx_m, "__name__", __pyx_kp___main__) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;};
  }
  /*--- Builtin init code ---*/
  if (unlikely(__Pyx_InitCachedBuiltins() < 0)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; __pyx_clineno = __LINE__; goto __pyx_L1_error;}
  __pyx_skip_dispatch = 0;
  /*--- Global init code ---*/
  /*--- Function export code ---*/
  /*--- Type init code ---*/
  /*--- Type import code ---*/
  /*--- Function import code ---*/
  /*--- Execution code ---*/

  /* "/home/smira/Projects/py-numa/numa.pxd":1
 * cdef extern from "numa.h":             # <<<<<<<<<<<<<<
 *     ctypedef int nodemask_t
 * 
 */
  goto __pyx_L0;
  __pyx_L1_error:;
  __Pyx_AddTraceback("numa");
  Py_DECREF(__pyx_m); __pyx_m = 0;
  __pyx_L0:;
  __Pyx_FinishRefcountContext();
  #if PY_MAJOR_VERSION < 3
  return;
  #else
  return __pyx_m;
  #endif
}

static const char *__pyx_filenames[] = {
  "numa.pyx",
};

/* Runtime support code */

static void __pyx_init_filenames(void) {
  __pyx_f = __pyx_filenames;
}

static void __Pyx_RaiseDoubleKeywordsError(
    const char* func_name,
    PyObject* kw_name)
{
    PyErr_Format(PyExc_TypeError,
        #if PY_MAJOR_VERSION >= 3
        "%s() got multiple values for keyword argument '%U'", func_name, kw_name);
        #else
        "%s() got multiple values for keyword argument '%s'", func_name,
        PyString_AS_STRING(kw_name));
        #endif
}

static void __Pyx_RaiseArgtupleInvalid(
    const char* func_name,
    int exact,
    Py_ssize_t num_min,
    Py_ssize_t num_max,
    Py_ssize_t num_found)
{
    Py_ssize_t num_expected;
    const char *number, *more_or_less;

    if (num_found < num_min) {
        num_expected = num_min;
        more_or_less = "at least";
    } else {
        num_expected = num_max;
        more_or_less = "at most";
    }
    if (exact) {
        more_or_less = "exactly";
    }
    number = (num_expected == 1) ? "" : "s";
    PyErr_Format(PyExc_TypeError,
        #if PY_VERSION_HEX < 0x02050000
            "%s() takes %s %d positional argument%s (%d given)",
        #else
            "%s() takes %s %zd positional argument%s (%zd given)",
        #endif
        func_name, more_or_less, num_expected, number, num_found);
}

static int __Pyx_ParseOptionalKeywords(
    PyObject *kwds,
    PyObject **argnames[],
    PyObject *kwds2,
    PyObject *values[],
    Py_ssize_t num_pos_args,
    const char* function_name)
{
    PyObject *key = 0, *value = 0;
    Py_ssize_t pos = 0;
    PyObject*** name;
    PyObject*** first_kw_arg = argnames + num_pos_args;

    while (PyDict_Next(kwds, &pos, &key, &value)) {
        name = first_kw_arg;
        while (*name && (**name != key)) name++;
        if (*name) {
            values[name-argnames] = value;
        } else {
            #if PY_MAJOR_VERSION < 3
            if (unlikely(!PyString_CheckExact(key)) && unlikely(!PyString_Check(key))) {
            #else
            if (unlikely(!PyUnicode_CheckExact(key)) && unlikely(!PyUnicode_Check(key))) {
            #endif
                goto invalid_keyword_type;
            } else {
                for (name = first_kw_arg; *name; name++) {
                    #if PY_MAJOR_VERSION >= 3
                    if (PyUnicode_GET_SIZE(**name) == PyUnicode_GET_SIZE(key) &&
                        PyUnicode_Compare(**name, key) == 0) break;
                    #else
                    if (PyString_GET_SIZE(**name) == PyString_GET_SIZE(key) &&
                        _PyString_Eq(**name, key)) break;
                    #endif
                }
                if (*name) {
                    values[name-argnames] = value;
                } else {
                    /* unexpected keyword found */
                    for (name=argnames; name != first_kw_arg; name++) {
                        if (**name == key) goto arg_passed_twice;
                        #if PY_MAJOR_VERSION >= 3
                        if (PyUnicode_GET_SIZE(**name) == PyUnicode_GET_SIZE(key) &&
                            PyUnicode_Compare(**name, key) == 0) goto arg_passed_twice;
                        #else
                        if (PyString_GET_SIZE(**name) == PyString_GET_SIZE(key) &&
                            _PyString_Eq(**name, key)) goto arg_passed_twice;
                        #endif
                    }
                    if (kwds2) {
                        if (unlikely(PyDict_SetItem(kwds2, key, value))) goto bad;
                    } else {
                        goto invalid_keyword;
                    }
                }
            }
        }
    }
    return 0;
arg_passed_twice:
    __Pyx_RaiseDoubleKeywordsError(function_name, **name);
    goto bad;
invalid_keyword_type:
    PyErr_Format(PyExc_TypeError,
        "%s() keywords must be strings", function_name);
    goto bad;
invalid_keyword:
    PyErr_Format(PyExc_TypeError,
    #if PY_MAJOR_VERSION < 3
        "%s() got an unexpected keyword argument '%s'",
        function_name, PyString_AsString(key));
    #else
        "%s() got an unexpected keyword argument '%U'",
        function_name, key);
    #endif
bad:
    return -1;
}

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name) {
    PyObject *result;
    result = PyObject_GetAttr(dict, name);
    if (!result)
        PyErr_SetObject(PyExc_NameError, name);
    return result;
}

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb) {
    Py_XINCREF(type);
    Py_XINCREF(value);
    Py_XINCREF(tb);
    /* First, check the traceback argument, replacing None with NULL. */
    if (tb == Py_None) {
        Py_DECREF(tb);
        tb = 0;
    }
    else if (tb != NULL && !PyTraceBack_Check(tb)) {
        PyErr_SetString(PyExc_TypeError,
            "raise: arg 3 must be a traceback or None");
        goto raise_error;
    }
    /* Next, replace a missing value with None */
    if (value == NULL) {
        value = Py_None;
        Py_INCREF(value);
    }
    #if PY_VERSION_HEX < 0x02050000
    if (!PyClass_Check(type))
    #else
    if (!PyType_Check(type))
    #endif
    {
        /* Raising an instance.  The value should be a dummy. */
        if (value != Py_None) {
            PyErr_SetString(PyExc_TypeError,
                "instance exception may not have a separate value");
            goto raise_error;
        }
        /* Normalize to raise <class>, <instance> */
        Py_DECREF(value);
        value = type;
        #if PY_VERSION_HEX < 0x02050000
            if (PyInstance_Check(type)) {
                type = (PyObject*) ((PyInstanceObject*)type)->in_class;
                Py_INCREF(type);
            }
            else {
                type = 0;
                PyErr_SetString(PyExc_TypeError,
                    "raise: exception must be an old-style class or instance");
                goto raise_error;
            }
        #else
            type = (PyObject*) Py_TYPE(type);
            Py_INCREF(type);
            if (!PyType_IsSubtype((PyTypeObject *)type, (PyTypeObject *)PyExc_BaseException)) {
                PyErr_SetString(PyExc_TypeError,
                    "raise: exception class must be a subclass of BaseException");
                goto raise_error;
            }
        #endif
    }
    __Pyx_ErrRestore(type, value, tb);
    return;
raise_error:
    Py_XDECREF(value);
    Py_XDECREF(type);
    Py_XDECREF(tb);
    return;
}

static INLINE void __Pyx_ErrRestore(PyObject *type, PyObject *value, PyObject *tb) {
    PyObject *tmp_type, *tmp_value, *tmp_tb;
    PyThreadState *tstate = PyThreadState_GET();

#if PY_MAJOR_VERSION >= 3
    /* Note: this is a temporary work-around to prevent crashes in Python 3.0 */
    if ((tstate->exc_type != NULL) & (tstate->exc_type != Py_None)) {
        tmp_type = tstate->exc_type;
        tmp_value = tstate->exc_value;
        tmp_tb = tstate->exc_traceback;
        PyErr_NormalizeException(&type, &value, &tb);
        PyErr_NormalizeException(&tmp_type, &tmp_value, &tmp_tb);
        tstate->exc_type = 0;
        tstate->exc_value = 0;
        tstate->exc_traceback = 0;
        PyException_SetContext(value, tmp_value);
        Py_DECREF(tmp_type);
        Py_XDECREF(tmp_tb);
    }
#endif

    tmp_type = tstate->curexc_type;
    tmp_value = tstate->curexc_value;
    tmp_tb = tstate->curexc_traceback;
    tstate->curexc_type = type;
    tstate->curexc_value = value;
    tstate->curexc_traceback = tb;
    Py_XDECREF(tmp_type);
    Py_XDECREF(tmp_value);
    Py_XDECREF(tmp_tb);
}

static INLINE void __Pyx_ErrFetch(PyObject **type, PyObject **value, PyObject **tb) {
    PyThreadState *tstate = PyThreadState_GET();
    *type = tstate->curexc_type;
    *value = tstate->curexc_value;
    *tb = tstate->curexc_traceback;

    tstate->curexc_type = 0;
    tstate->curexc_value = 0;
    tstate->curexc_traceback = 0;
}


static INLINE int __Pyx_StrEq(const char *s1, const char *s2) {
     while (*s1 != '\0' && *s1 == *s2) { s1++; s2++; }
     return *s1 == *s2;
}

static INLINE unsigned char __Pyx_PyInt_AsUnsignedChar(PyObject* x) {
    if (sizeof(unsigned char) < sizeof(long)) {
        long val = __Pyx_PyInt_AsLong(x);
        if (unlikely(val != (long)(unsigned char)val)) {
            if (unlikely(val == -1 && PyErr_Occurred()))
                return (unsigned char)-1;
            if (unlikely(val < 0)) {
                PyErr_SetString(PyExc_OverflowError,
                                "can't convert negative value to unsigned char");
                return (unsigned char)-1;
            }
            PyErr_SetString(PyExc_OverflowError,
                           "value too large to convert to unsigned char");
            return (unsigned char)-1;
        }
        return (unsigned char)val;
    }
    return (unsigned char)__Pyx_PyInt_AsUnsignedLong(x);
}

static INLINE unsigned short __Pyx_PyInt_AsUnsignedShort(PyObject* x) {
    if (sizeof(unsigned short) < sizeof(long)) {
        long val = __Pyx_PyInt_AsLong(x);
        if (unlikely(val != (long)(unsigned short)val)) {
            if (unlikely(val == -1 && PyErr_Occurred()))
                return (unsigned short)-1;
            if (unlikely(val < 0)) {
                PyErr_SetString(PyExc_OverflowError,
                                "can't convert negative value to unsigned short");
                return (unsigned short)-1;
            }
            PyErr_SetString(PyExc_OverflowError,
                           "value too large to convert to unsigned short");
            return (unsigned short)-1;
        }
        return (unsigned short)val;
    }
    return (unsigned short)__Pyx_PyInt_AsUnsignedLong(x);
}

static INLINE unsigned int __Pyx_PyInt_AsUnsignedInt(PyObject* x) {
    if (sizeof(unsigned int) < sizeof(long)) {
        long val = __Pyx_PyInt_AsLong(x);
        if (unlikely(val != (long)(unsigned int)val)) {
            if (unlikely(val == -1 && PyErr_Occurred()))
                return (unsigned int)-1;
            if (unlikely(val < 0)) {
                PyErr_SetString(PyExc_OverflowError,
                                "can't convert negative value to unsigned int");
                return (unsigned int)-1;
            }
            PyErr_SetString(PyExc_OverflowError,
                           "value too large to convert to unsigned int");
            return (unsigned int)-1;
        }
        return (unsigned int)val;
    }
    return (unsigned int)__Pyx_PyInt_AsUnsignedLong(x);
}

static INLINE char __Pyx_PyInt_AsChar(PyObject* x) {
    if (sizeof(char) < sizeof(long)) {
        long val = __Pyx_PyInt_AsLong(x);
        if (unlikely(val != (long)(char)val)) {
            if (unlikely(val == -1 && PyErr_Occurred()))
                return (char)-1;
            PyErr_SetString(PyExc_OverflowError,
                           "value too large to convert to char");
            return (char)-1;
        }
        return (char)val;
    }
    return (char)__Pyx_PyInt_AsLong(x);
}

static INLINE short __Pyx_PyInt_AsShort(PyObject* x) {
    if (sizeof(short) < sizeof(long)) {
        long val = __Pyx_PyInt_AsLong(x);
        if (unlikely(val != (long)(short)val)) {
            if (unlikely(val == -1 && PyErr_Occurred()))
                return (short)-1;
            PyErr_SetString(PyExc_OverflowError,
                           "value too large to convert to short");
            return (short)-1;
        }
        return (short)val;
    }
    return (short)__Pyx_PyInt_AsLong(x);
}

static INLINE int __Pyx_PyInt_AsInt(PyObject* x) {
    if (sizeof(int) < sizeof(long)) {
        long val = __Pyx_PyInt_AsLong(x);
        if (unlikely(val != (long)(int)val)) {
            if (unlikely(val == -1 && PyErr_Occurred()))
                return (int)-1;
            PyErr_SetString(PyExc_OverflowError,
                           "value too large to convert to int");
            return (int)-1;
        }
        return (int)val;
    }
    return (int)__Pyx_PyInt_AsLong(x);
}

static INLINE signed char __Pyx_PyInt_AsSignedChar(PyObject* x) {
    if (sizeof(signed char) < sizeof(long)) {
        long val = __Pyx_PyInt_AsLong(x);
        if (unlikely(val != (long)(signed char)val)) {
            if (unlikely(val == -1 && PyErr_Occurred()))
                return (signed char)-1;
            PyErr_SetString(PyExc_OverflowError,
                           "value too large to convert to signed char");
            return (signed char)-1;
        }
        return (signed char)val;
    }
    return (signed char)__Pyx_PyInt_AsSignedLong(x);
}

static INLINE signed short __Pyx_PyInt_AsSignedShort(PyObject* x) {
    if (sizeof(signed short) < sizeof(long)) {
        long val = __Pyx_PyInt_AsLong(x);
        if (unlikely(val != (long)(signed short)val)) {
            if (unlikely(val == -1 && PyErr_Occurred()))
                return (signed short)-1;
            PyErr_SetString(PyExc_OverflowError,
                           "value too large to convert to signed short");
            return (signed short)-1;
        }
        return (signed short)val;
    }
    return (signed short)__Pyx_PyInt_AsSignedLong(x);
}

static INLINE signed int __Pyx_PyInt_AsSignedInt(PyObject* x) {
    if (sizeof(signed int) < sizeof(long)) {
        long val = __Pyx_PyInt_AsLong(x);
        if (unlikely(val != (long)(signed int)val)) {
            if (unlikely(val == -1 && PyErr_Occurred()))
                return (signed int)-1;
            PyErr_SetString(PyExc_OverflowError,
                           "value too large to convert to signed int");
            return (signed int)-1;
        }
        return (signed int)val;
    }
    return (signed int)__Pyx_PyInt_AsSignedLong(x);
}

static INLINE unsigned long __Pyx_PyInt_AsUnsignedLong(PyObject* x) {
#if PY_VERSION_HEX < 0x03000000
    if (likely(PyInt_CheckExact(x) || PyInt_Check(x))) {
        long val = PyInt_AS_LONG(x);
        if (unlikely(val < 0)) {
            PyErr_SetString(PyExc_OverflowError,
                            "can't convert negative value to unsigned long");
            return (unsigned long)-1;
        }
        return (unsigned long)val;
    } else
#endif
    if (likely(PyLong_CheckExact(x) || PyLong_Check(x))) {
        if (unlikely(Py_SIZE(x) < 0)) {
            PyErr_SetString(PyExc_OverflowError,
                            "can't convert negative value to unsigned long");
            return (unsigned long)-1;
        }
        return PyLong_AsUnsignedLong(x);
    } else {
        unsigned long val;
        PyObject *tmp = __Pyx_PyNumber_Int(x);
        if (!tmp) return (unsigned long)-1;
        val = __Pyx_PyInt_AsUnsignedLong(tmp);
        Py_DECREF(tmp);
        return val;
    }
}

static INLINE unsigned PY_LONG_LONG __Pyx_PyInt_AsUnsignedLongLong(PyObject* x) {
#if PY_VERSION_HEX < 0x03000000
    if (likely(PyInt_CheckExact(x) || PyInt_Check(x))) {
        long val = PyInt_AS_LONG(x);
        if (unlikely(val < 0)) {
            PyErr_SetString(PyExc_OverflowError,
                            "can't convert negative value to unsigned PY_LONG_LONG");
            return (unsigned PY_LONG_LONG)-1;
        }
        return (unsigned PY_LONG_LONG)val;
    } else
#endif
    if (likely(PyLong_CheckExact(x) || PyLong_Check(x))) {
        if (unlikely(Py_SIZE(x) < 0)) {
            PyErr_SetString(PyExc_OverflowError,
                            "can't convert negative value to unsigned PY_LONG_LONG");
            return (unsigned PY_LONG_LONG)-1;
        }
        return PyLong_AsUnsignedLongLong(x);
    } else {
        unsigned PY_LONG_LONG val;
        PyObject *tmp = __Pyx_PyNumber_Int(x);
        if (!tmp) return (unsigned PY_LONG_LONG)-1;
        val = __Pyx_PyInt_AsUnsignedLongLong(tmp);
        Py_DECREF(tmp);
        return val;
    }
}

static INLINE long __Pyx_PyInt_AsLong(PyObject* x) {
#if PY_VERSION_HEX < 0x03000000
    if (likely(PyInt_CheckExact(x) || PyInt_Check(x))) {
        long val = PyInt_AS_LONG(x);
        return (long)val;
    } else
#endif
    if (likely(PyLong_CheckExact(x) || PyLong_Check(x))) {
        return PyLong_AsLong(x);
    } else {
        long val;
        PyObject *tmp = __Pyx_PyNumber_Int(x);
        if (!tmp) return (long)-1;
        val = __Pyx_PyInt_AsLong(tmp);
        Py_DECREF(tmp);
        return val;
    }
}

static INLINE PY_LONG_LONG __Pyx_PyInt_AsLongLong(PyObject* x) {
#if PY_VERSION_HEX < 0x03000000
    if (likely(PyInt_CheckExact(x) || PyInt_Check(x))) {
        long val = PyInt_AS_LONG(x);
        return (PY_LONG_LONG)val;
    } else
#endif
    if (likely(PyLong_CheckExact(x) || PyLong_Check(x))) {
        return PyLong_AsLongLong(x);
    } else {
        PY_LONG_LONG val;
        PyObject *tmp = __Pyx_PyNumber_Int(x);
        if (!tmp) return (PY_LONG_LONG)-1;
        val = __Pyx_PyInt_AsLongLong(tmp);
        Py_DECREF(tmp);
        return val;
    }
}

static INLINE signed long __Pyx_PyInt_AsSignedLong(PyObject* x) {
#if PY_VERSION_HEX < 0x03000000
    if (likely(PyInt_CheckExact(x) || PyInt_Check(x))) {
        long val = PyInt_AS_LONG(x);
        return (signed long)val;
    } else
#endif
    if (likely(PyLong_CheckExact(x) || PyLong_Check(x))) {
        return PyLong_AsLong(x);
    } else {
        signed long val;
        PyObject *tmp = __Pyx_PyNumber_Int(x);
        if (!tmp) return (signed long)-1;
        val = __Pyx_PyInt_AsSignedLong(tmp);
        Py_DECREF(tmp);
        return val;
    }
}

static INLINE signed PY_LONG_LONG __Pyx_PyInt_AsSignedLongLong(PyObject* x) {
#if PY_VERSION_HEX < 0x03000000
    if (likely(PyInt_CheckExact(x) || PyInt_Check(x))) {
        long val = PyInt_AS_LONG(x);
        return (signed PY_LONG_LONG)val;
    } else
#endif
    if (likely(PyLong_CheckExact(x) || PyLong_Check(x))) {
        return PyLong_AsLongLong(x);
    } else {
        signed PY_LONG_LONG val;
        PyObject *tmp = __Pyx_PyNumber_Int(x);
        if (!tmp) return (signed PY_LONG_LONG)-1;
        val = __Pyx_PyInt_AsSignedLongLong(tmp);
        Py_DECREF(tmp);
        return val;
    }
}

#include "compile.h"
#include "frameobject.h"
#include "traceback.h"

static void __Pyx_AddTraceback(const char *funcname) {
    PyObject *py_srcfile = 0;
    PyObject *py_funcname = 0;
    PyObject *py_globals = 0;
    PyObject *empty_string = 0;
    PyCodeObject *py_code = 0;
    PyFrameObject *py_frame = 0;

    #if PY_MAJOR_VERSION < 3
    py_srcfile = PyString_FromString(__pyx_filename);
    #else
    py_srcfile = PyUnicode_FromString(__pyx_filename);
    #endif
    if (!py_srcfile) goto bad;
    if (__pyx_clineno) {
        #if PY_MAJOR_VERSION < 3
        py_funcname = PyString_FromFormat( "%s (%s:%d)", funcname, __pyx_cfilenm, __pyx_clineno);
        #else
        py_funcname = PyUnicode_FromFormat( "%s (%s:%d)", funcname, __pyx_cfilenm, __pyx_clineno);
        #endif
    }
    else {
        #if PY_MAJOR_VERSION < 3
        py_funcname = PyString_FromString(funcname);
        #else
        py_funcname = PyUnicode_FromString(funcname);
        #endif
    }
    if (!py_funcname) goto bad;
    py_globals = PyModule_GetDict(__pyx_m);
    if (!py_globals) goto bad;
    #if PY_MAJOR_VERSION < 3
    empty_string = PyString_FromStringAndSize("", 0);
    #else
    empty_string = PyBytes_FromStringAndSize("", 0);
    #endif
    if (!empty_string) goto bad;
    py_code = PyCode_New(
        0,            /*int argcount,*/
        #if PY_MAJOR_VERSION >= 3
        0,            /*int kwonlyargcount,*/
        #endif
        0,            /*int nlocals,*/
        0,            /*int stacksize,*/
        0,            /*int flags,*/
        empty_string, /*PyObject *code,*/
        __pyx_empty_tuple,  /*PyObject *consts,*/
        __pyx_empty_tuple,  /*PyObject *names,*/
        __pyx_empty_tuple,  /*PyObject *varnames,*/
        __pyx_empty_tuple,  /*PyObject *freevars,*/
        __pyx_empty_tuple,  /*PyObject *cellvars,*/
        py_srcfile,   /*PyObject *filename,*/
        py_funcname,  /*PyObject *name,*/
        __pyx_lineno,   /*int firstlineno,*/
        empty_string  /*PyObject *lnotab*/
    );
    if (!py_code) goto bad;
    py_frame = PyFrame_New(
        PyThreadState_GET(), /*PyThreadState *tstate,*/
        py_code,             /*PyCodeObject *code,*/
        py_globals,          /*PyObject *globals,*/
        0                    /*PyObject *locals*/
    );
    if (!py_frame) goto bad;
    py_frame->f_lineno = __pyx_lineno;
    PyTraceBack_Here(py_frame);
bad:
    Py_XDECREF(py_srcfile);
    Py_XDECREF(py_funcname);
    Py_XDECREF(empty_string);
    Py_XDECREF(py_code);
    Py_XDECREF(py_frame);
}

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t) {
    while (t->p) {
        #if PY_MAJOR_VERSION < 3
        if (t->is_unicode && (!t->is_identifier)) {
            *t->p = PyUnicode_DecodeUTF8(t->s, t->n - 1, NULL);
        } else if (t->intern) {
            *t->p = PyString_InternFromString(t->s);
        } else {
            *t->p = PyString_FromStringAndSize(t->s, t->n - 1);
        }
        #else  /* Python 3+ has unicode identifiers */
        if (t->is_identifier || (t->is_unicode && t->intern)) {
            *t->p = PyUnicode_InternFromString(t->s);
        } else if (t->is_unicode) {
            *t->p = PyUnicode_FromStringAndSize(t->s, t->n - 1);
        } else {
            *t->p = PyBytes_FromStringAndSize(t->s, t->n - 1);
        }
        #endif
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

/* Type Conversion Functions */

static INLINE int __Pyx_PyObject_IsTrue(PyObject* x) {
   if (x == Py_True) return 1;
   else if ((x == Py_False) | (x == Py_None)) return 0;
   else return PyObject_IsTrue(x);
}

static INLINE PyObject* __Pyx_PyNumber_Int(PyObject* x) {
  PyNumberMethods *m;
  const char *name = NULL;
  PyObject *res = NULL;
#if PY_VERSION_HEX < 0x03000000
  if (PyInt_Check(x) || PyLong_Check(x))
#else
  if (PyLong_Check(x))
#endif
    return Py_INCREF(x), x;
  m = Py_TYPE(x)->tp_as_number;
#if PY_VERSION_HEX < 0x03000000
  if (m && m->nb_int) {
    name = "int";
    res = PyNumber_Int(x);
  }
  else if (m && m->nb_long) {
    name = "long";
    res = PyNumber_Long(x);
  }
#else
  if (m && m->nb_int) {
    name = "int";
    res = PyNumber_Long(x);
  }
#endif
  if (res) {
#if PY_VERSION_HEX < 0x03000000
    if (!PyInt_Check(res) && !PyLong_Check(res)) {
#else
    if (!PyLong_Check(res)) {
#endif
      PyErr_Format(PyExc_TypeError,
                   "__%s__ returned non-%s (type %.200s)",
                   name, name, Py_TYPE(res)->tp_name);
      Py_DECREF(res);
      return NULL;
    }
  }
  else if (!PyErr_Occurred()) {
    PyErr_SetString(PyExc_TypeError,
                    "an integer is required");
  }
  return res;
}

static INLINE Py_ssize_t __Pyx_PyIndex_AsSsize_t(PyObject* b) {
  Py_ssize_t ival;
  PyObject* x = PyNumber_Index(b);
  if (!x) return -1;
  ival = PyInt_AsSsize_t(x);
  Py_DECREF(x);
  return ival;
}

static INLINE PyObject * __Pyx_PyInt_FromSize_t(size_t ival) {
#if PY_VERSION_HEX < 0x02050000
   if (ival <= LONG_MAX)
       return PyInt_FromLong((long)ival);
   else {
       unsigned char *bytes = (unsigned char *) &ival;
       int one = 1; int little = (int)*(unsigned char*)&one;
       return _PyLong_FromByteArray(bytes, sizeof(size_t), little, 0);
   }
#else
   return PyInt_FromSize_t(ival);
#endif
}

static INLINE size_t __Pyx_PyInt_AsSize_t(PyObject* x) {
   unsigned PY_LONG_LONG val = __Pyx_PyInt_AsUnsignedLongLong(x);
   if (unlikely(val == (unsigned PY_LONG_LONG)-1 && PyErr_Occurred())) {
       return (size_t)-1;
   } else if (unlikely(val != (unsigned PY_LONG_LONG)(size_t)val)) {
       PyErr_SetString(PyExc_OverflowError,
                       "value too large to convert to size_t");
       return (size_t)-1;
   }
   return (size_t)val;
}


