#!/usr/bin/env python
try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

import os
import sys

def read(*rnames):
    return open(os.path.join(os.path.dirname(__file__), *rnames)).read()

if float('%d.%d' % sys.version_info[:2]) < 2.7 or float('%d.%d' % sys.version_info[:2]) >= 3.0:
    sys.stderr.write("Your Python version %d.%d.%d is not supported.\n" %
                     sys.version_info[:3])
    sys.stderr.write("OAS Python SDK requires Python between 2.7 and 3.0.\n")
    sys.exit(1)

setup(
    name='oassdk',
    version='0.1.7',
    description='Python SDK for Aliyun OAS (Open Archive Service)', 
    author='Aliyun OAS', 
    author_email='jianyi.weng@alibaba-inc.com', 
    url='http://www.aliyun.com/product/oas', 
    packages=['oas', 'oas.ease'], 
    license='GPL version 2', 
    install_requires=[
        'simplejson', 
        'pyaml', 
    ],
    scripts=['oascmd'], 
)
