ObjectJSON
==========

A python tool to create Python objects from large, complicated JSON objects.

#Attribution

This project is based on a code sample found on http://ideone.com/O6KGB3, but modified for Python 3 compatibility.
The site above does not provide any reference to the author of the code. If this is your project, please let me know so I can give you the credit you deserve and add you as a contributor to this project. In the mean time, I've put this code up on Github (and PyPi - https://pypi.python.org/pypi/objectjson) so that it may be programatically imported and used in projects.

#How it works

Instantiate the `ObjectJSON` class with a properly-formatted JSON object. The class will use Python's __getattr__ function to allow you to recursively access deserialized JSON objects as if they were regular Python objects.

Please feel free to create issues if you find any bugs or would like the package to be enhanced.

#Code Sample

```python
from objectjson import ObjectJSON

json_str = '{ "test": {"a":1,"b": {"c":3} } }'

json_obj = ObjectJSON(json_str)

print(json_obj)           # {'test': {'b': {'c': 3}, 'a': 1}}
print(json_obj.test)      # {'b': {'c': 3}, 'a': 1}
print(json_obj.test.a)    # 1
print(json_obj.test.b.c)  # 3
```
