# -*- coding: utf-8 -*-
#!/usr/bin/python

import json

class ObjectJSON:

  def __init__(self, json_data):

    self.json_data = ""

    if isinstance(json_data, str):
      json_data = json.loads(json_data)
      self.json_data = json_data

    elif isinstance(json_data, dict):
      self.json_data = json_data

  def __getattr__(self, key):
    if key in self.json_data:
      if isinstance(self.json_data[key], (list, dict)):
        return ObjectJSON(self.json_data[key])
      else:
        return self.json_data[key]
    else:
      raise Exception('There is no json_data[\'{key}\'].'.format(key=key))

  def __repr__(self):
    out = self.__dict__
    return '%r' % (out['json_data'])
