# -*- coding: utf-8 -*-
"""
objectjson library
~~~~~~~~~~~~~~~~~~
A python tool to create Python objects from large, complicated JSON objects.

Dictionaries are great and all, but large nested ones can get tedious.

Usage:
  >>> from objectjson import ObjectJSON

  >>> json_str = '{ "test": {"a":1,"b": {"c":3} } }'
  >>> json_obj = ObjectJSON(json_str)

  >>> print(json_obj)
  {'test': {'b': {'c': 3}, 'a': 1}}

  >>> print(json_obj.test)
  {'b': {'c': 3}, 'a': 1}

  >>> print(json_obj.test.a)
  1

  >>> print(json_obj.test.b.c)
  3

:license: Apache 2.0, see LICENSE.txt for details.
"""

__title__ = 'objectjson'
__version__ = '0.1.3'
__author__ = 'Ashwin Balamohan'
__license__ = 'Apache 2.0'

from .objectjson import ObjectJSON
