#!/usr/bin/env python
# -*- coding: utf-8 -*-

#       setup.py
#
#       Copyright 2008 Universidad de las Ciencias Informáticas
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.

from setuptools import setup, find_packages
import os

version = '1.0'

setup(name='oice.langdet',
      version=version,
      description="Automatic Language Detector",
      long_description=open("README.txt").read() + "\n" +
                       open(os.path.join("docs", "HISTORY.txt")).read(),
      # Get more strings from http://www.python.org/pypi?%3Aaction=list_classifiers
      classifiers=[
        "Development Status :: 3 - Alpha",
        "Programming Language :: Python",
        "Topic :: Utilities",
        "Topic :: Scientific/Engineering",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "License :: OSI Approved :: GNU General Public License (GPL)",
        "Intended Audience :: Developers",
        ],
      keywords='',
      author='Universidad de las Ciencias Informáticas',
      author_email='',
      url='http://www.uci.cu/',
      license='GPL 3.0',
      packages=find_packages(exclude=['ez_setup']),
      namespace_packages=['oice'],
      include_package_data=True,
      zip_safe=False,
      install_requires=[
          'setuptools',
          # -*- Extra requirements: -*-
          'chardet',
      ],
      entry_points="""
      # -*- Entry points: -*-
      [console_scripts]
      langdet=oice.langdet.langdet:main
      langdetvector=oice.langdet.langdet:vector
      """,
      )
