Oncogenomics Report for patient ID <code class="knitr inline">SRR1027180</code>
========================================================

<!-- dataTables -->
<script src="http://ajax.aspnetcdn.com/ajax/jquery.dataTables/1.9.4/jquery.dataTables.js"></script>
<link rel="stylesheet" href="http://ajax.aspnetcdn.com/ajax/jquery.dataTables/1.9.4/css/jquery.dataTables.css"/>
<script src="http://next.datatables.net/release-datatables/examples/resources/bootstrap/3/dataTables.bootstrap.js"></script>
<link rel="stylesheet" href="http://next.datatables.net/release-datatables/examples/resources/bootstrap/3/dataTables.bootstrap.css"/>

<!-- TableTools -->
<script src="http://cdn.aldu.net/jquery.datatables/extras/tabletools/2.0.3/js/TableTools.js"></script>
<link rel="stylesheet" href="http://cdn.aldu.net/jquery.datatables/extras/tabletools/2.0.3/css/TableTools.css"/>

<!-- ZeroClipboard -->
<script src="http://cdn.aldu.net/jquery.datatables/extras/tabletools/2.0.3/js/ZeroClipboard.js"></script>

<!-- ColViz -->
<script src="http://cdn.eventcore.com/js/plugins/dataTables.ColVis-1.07.js"></script>

<!-- read in external core code -->


<!-- read in all optional modules from the module folder -->


<div class="chunk" id="setup"><div class="rcode"><div class="error"><pre class="knitr r">## Error: Invalid name specified, see ?BibOptions
</pre></div>
</div></div>



# Quality Control & Preprocessing

## Raw data QC

The quality of the RNA-seq reads was assessed using FASTQC <code class="knitr inline">(, 2014)</code>. The table below lists basic QC statistics. Click on the provided links to open up the full FastQC report.


<table id="fastqc_table", class="stdTable">
<tbody>
  <tr>
   <td align="left">  </td>
   <td align="left"> Pair_1 </td>
   <td align="left"> Pair_2 </td>
  </tr>
  <tr>
   <td align="left"> file </td>
   <td align="left"> SRR1027180_1.fastq </td>
   <td align="left"> SRR1027180_2.fastq </td>
  </tr>
  <tr>
   <td align="left"> basic_statistics </td>
   <td align="left"> pass </td>
   <td align="left"> pass </td>
  </tr>
  <tr>
   <td align="left"> file_type </td>
   <td align="left"> Conventional base calls </td>
   <td align="left"> Conventional base calls </td>
  </tr>
  <tr>
   <td align="left"> encoding </td>
   <td align="left"> Illumina 1.5 </td>
   <td align="left"> Illumina 1.5 </td>
  </tr>
  <tr>
   <td align="left"> total_seq </td>
   <td align="left"> 64735155 </td>
   <td align="left"> 64735155 </td>
  </tr>
  <tr>
   <td align="left"> filtered_seq </td>
   <td align="left"> 0 </td>
   <td align="left"> 0 </td>
  </tr>
  <tr>
   <td align="left"> seq_length </td>
   <td align="left"> 60 </td>
   <td align="left"> 60 </td>
  </tr>
  <tr>
   <td align="left"> percent_gc </td>
   <td align="left"> 54 </td>
   <td align="left"> 55 </td>
  </tr>
  <tr>
   <td align="left"> link_to_report </td>
   <td align="left"> <a href =  '/gpfs/group/su/kfisch/Cancer/Kumar/QC/SRR1027180_1/SRR1027180_1_fastqc/fastqc_report.html' target="_blank" > FastQC report </a> </td>
   <td align="left"> <a href =  '/gpfs/group/su/kfisch/Cancer/Kumar/QC/SRR1027180_2/SRR1027180_2_fastqc/fastqc_report.html' target="_blank" > FastQC report </a> </td>
  </tr>
</tbody>
</table>


******

## Alignment

Reads were aligned to the human genome (hg19) using the STAR aligner <code class="knitr inline">(Dobin, Davis, Schlesinger, Drenkow, Zaleski, Jha, Batut, Chaisson, and Gingeras, 2012)</code>. Resulting .SAM files were sorted and converted to .BAM files using SAMtools software <code class="knitr inline">(Li, Handsaker, Wysoker, Fennell, Ruan, Homer, Marth, Abecasis, and Durbin, 2009)</code>. The table below lists the alignment statistics as provided by the STAR output:

<div style="width:40%;padding:0 10pt 0 0;float:left;">
<div class="warning"><pre class="knitr r">## Warning: is.na() applied to non-(list or vector) of type 'NULL'
## Warning: is.na() applied to non-(list or vector) of type 'NULL'
</pre></div>
<table id="star_table", class="stdTable">
<tbody>
  <tr>
   <td align="left"> Metric </td>
   <td align="left"> Value </td>
  </tr>
  <tr>
   <td align="left"> Started job on  </td>
   <td align="left"> Jun 29 17:55:51 </td>
  </tr>
  <tr>
   <td align="left"> Started mapping on  </td>
   <td align="left"> Jun 29 18:09:03 </td>
  </tr>
  <tr>
   <td align="left"> Finished on  </td>
   <td align="left"> Jun 29 18:27:48 </td>
  </tr>
  <tr>
   <td align="left"> Mapping speed, Million of reads per hour  </td>
   <td align="left"> 207.15 </td>
  </tr>
  <tr>
   <td align="left"> Number of input reads  </td>
   <td align="left"> 64735155 </td>
  </tr>
  <tr>
   <td align="left"> Average input read length  </td>
   <td align="left"> 120 </td>
  </tr>
  <tr>
   <td align="left"> UNIQUE READS: </td>
   <td align="left">  </td>
  </tr>
  <tr>
   <td align="left"> Uniquely mapped reads number  </td>
   <td align="left"> 40326071 </td>
  </tr>
  <tr>
   <td align="left"> Uniquely mapped reads %  </td>
   <td align="left"> 62.29% </td>
  </tr>
  <tr>
   <td align="left"> Average mapped length  </td>
   <td align="left"> 116.45 </td>
  </tr>
  <tr>
   <td align="left"> Number of splices: Total  </td>
   <td align="left"> 2372488 </td>
  </tr>
  <tr>
   <td align="left"> Number of splices: Annotated (sjdb)  </td>
   <td align="left"> 0 </td>
  </tr>
  <tr>
   <td align="left"> Number of splices: GT/AG  </td>
   <td align="left"> 2357460 </td>
  </tr>
  <tr>
   <td align="left"> Number of splices: GC/AG  </td>
   <td align="left"> 13998 </td>
  </tr>
  <tr>
   <td align="left"> Number of splices: AT/AC  </td>
   <td align="left"> 1030 </td>
  </tr>
  <tr>
   <td align="left"> Number of splices: Non-canonical  </td>
   <td align="left"> 0 </td>
  </tr>
  <tr>
   <td align="left"> Mismatch rate per base, %  </td>
   <td align="left"> 1.39% </td>
  </tr>
  <tr>
   <td align="left"> Deletion rate per base  </td>
   <td align="left"> 0.01% </td>
  </tr>
  <tr>
   <td align="left"> Deletion average length  </td>
   <td align="left"> 2.19 </td>
  </tr>
  <tr>
   <td align="left"> Insertion rate per base  </td>
   <td align="left"> 0.01% </td>
  </tr>
  <tr>
   <td align="left"> Insertion average length  </td>
   <td align="left"> 1.59 </td>
  </tr>
  <tr>
   <td align="left"> MULTI-MAPPING READS: </td>
   <td align="left">  </td>
  </tr>
  <tr>
   <td align="left"> Number of reads mapped to multiple loci  </td>
   <td align="left"> 3062905 </td>
  </tr>
  <tr>
   <td align="left"> % of reads mapped to multiple loci  </td>
   <td align="left"> 4.73% </td>
  </tr>
  <tr>
   <td align="left"> Number of reads mapped to too many loci  </td>
   <td align="left"> 27110 </td>
  </tr>
  <tr>
   <td align="left"> % of reads mapped to too many loci  </td>
   <td align="left"> 0.04% </td>
  </tr>
  <tr>
   <td align="left"> UNMAPPED READS: </td>
   <td align="left">  </td>
  </tr>
  <tr>
   <td align="left"> % of reads unmapped: too many mismatches  </td>
   <td align="left"> 0.00% </td>
  </tr>
  <tr>
   <td align="left"> % of reads unmapped: too short  </td>
   <td align="left"> 32.88% </td>
  </tr>
  <tr>
   <td align="left"> % of reads unmapped: other  </td>
   <td align="left"> 0.05% </td>
  </tr>
</tbody>
</table>

</div>

<div style="width:60%;padding:0 10pt 0 0;float:right;">
<iframe src='
figure/starQCPie.html
' scrolling='no' seamless class='rChart 
nvd3
 '
id=iframe-
chart517fac5773
></iframe>
<style>iframe.rChart{ width: 100%; height: 400px;}</style>

</div>
<div style="clear:both;"></div>

## Insert size distribution

Insert size distribution is calculated using Picard tools [CollectInsertSizeMetrics](http://picard.sourceforge.net/command-line-overview.shtml#CollectInsertSizeMetrics) function <code class="knitr inline">(, 2014)</code>. The table lists statistics as provided by this tool:

<div style="width:40%;padding:0 10pt 0 0;float:left;">
<div class="warning"><pre class="knitr r">## Warning: is.na() applied to non-(list or vector) of type 'NULL'
## Warning: is.na() applied to non-(list or vector) of type 'NULL'
</pre></div>
<table id="insertSize_table", class="stdTable">
<tbody>
  <tr>
   <td align="left"> Metric </td>
   <td align="left"> Value </td>
  </tr>
  <tr>
   <td align="left"> MEDIAN_INSERT_SIZE </td>
   <td align="left"> 193 </td>
  </tr>
  <tr>
   <td align="left"> MEDIAN_ABSOLUTE_DEVIATION </td>
   <td align="left"> 32 </td>
  </tr>
  <tr>
   <td align="left"> MIN_INSERT_SIZE </td>
   <td align="left"> 20 </td>
  </tr>
  <tr>
   <td align="left"> MAX_INSERT_SIZE </td>
   <td align="left"> 1948013 </td>
  </tr>
  <tr>
   <td align="left"> MEAN_INSERT_SIZE </td>
   <td align="left"> 175.580151 </td>
  </tr>
  <tr>
   <td align="left"> STANDARD_DEVIATION </td>
   <td align="left"> 57.937573 </td>
  </tr>
  <tr>
   <td align="left"> READ_PAIRS </td>
   <td align="left"> 43388976 </td>
  </tr>
  <tr>
   <td align="left"> PAIR_ORIENTATION </td>
   <td align="left"> FR </td>
  </tr>
  <tr>
   <td align="left"> WIDTH_OF_10_PERCENT </td>
   <td align="left"> 9 </td>
  </tr>
  <tr>
   <td align="left"> WIDTH_OF_20_PERCENT </td>
   <td align="left"> 19 </td>
  </tr>
  <tr>
   <td align="left"> WIDTH_OF_30_PERCENT </td>
   <td align="left"> 29 </td>
  </tr>
  <tr>
   <td align="left"> WIDTH_OF_40_PERCENT </td>
   <td align="left"> 45 </td>
  </tr>
  <tr>
   <td align="left"> WIDTH_OF_50_PERCENT </td>
   <td align="left"> 65 </td>
  </tr>
  <tr>
   <td align="left"> WIDTH_OF_60_PERCENT </td>
   <td align="left"> 91 </td>
  </tr>
  <tr>
   <td align="left"> WIDTH_OF_70_PERCENT </td>
   <td align="left"> 131 </td>
  </tr>
  <tr>
   <td align="left"> WIDTH_OF_80_PERCENT </td>
   <td align="left"> 199 </td>
  </tr>
  <tr>
   <td align="left"> WIDTH_OF_90_PERCENT </td>
   <td align="left"> 279 </td>
  </tr>
  <tr>
   <td align="left"> WIDTH_OF_99_PERCENT </td>
   <td align="left"> 22787 </td>
  </tr>
</tbody>
</table>

</div>

<div style="width:60%;padding:0 10pt 0 0;float:right;">
<img src='/gpfs/group/su/kfisch/Cancer/Kumar/QC/SRR1027180/insertSizeHist.png'>
</div>
<div style="clear:both;"></div>

## RNA sequencing metrics

Metrics are assessed using Picard tools [CollectRnaSeqMetrics](http://picard.sourceforge.net/command-line-overview.shtml#CollectRnaSeqMetrics) function <code class="knitr inline">(, 2014)</code>. Metrics about the alignment of RNA to various functional classes of loci in the genome are collected: coding, intronic, UTR, intergenic, ribosomal. The table below lists the metrics provided by this tool:

<div style="width:40%;padding:0 10pt 0 0;float:left;">
<div class="warning"><pre class="knitr r">## Warning: cannot open file
## '/gpfs/group/su/kfisch/Cancer/Kumar/QC/SRR1027180/rnaseqmetrics': No such
## file or directory
</pre></div>
<div class="error"><pre class="knitr r">## Error: cannot open the connection
</pre></div>
<div class="error"><pre class="knitr r">## Error: object 'rnaSeqMetricsTable' not found
</pre></div>
<div class="error"><pre class="knitr r">## Error: object 'rnaSeqMetricsTable' not found
</pre></div>
<div class="error"><pre class="knitr r">## Error: object 'rnaSeqMetricsTable' not found
</pre></div>

</div>

<div style="width:60%;padding:0 10pt 0 0;float:right;">
<div class="error"><pre class="knitr r">## Error: object 'rnaSeqMetricsTable' not found
</pre></div>
<div class="error"><pre class="knitr r">## Error: object 'rnaSeqMetricsDfPie' not found
</pre></div>
<div class="error"><pre class="knitr r">## Error: object 'rnaSeqMetricsDfPie' not found
</pre></div>
<div class="error"><pre class="knitr r">## Error: error in evaluating the argument 'x' in selecting a method for function 'as.vector': Error: object 'rnaSeqMetricsDfPie' not found
</pre></div>
<div class="error"><pre class="knitr r">## Error: object 'rnaSeqMetricsDfPie' not found
</pre></div>
<div class="error"><pre class="knitr r">## Error: object 'rnaSeqMetricsPie' not found
</pre></div>
<div class="error"><pre class="knitr r">## Error: object 'rnaSeqMetricsPie' not found
</pre></div>
<div class="error"><pre class="knitr r">## Error: object 'rnaSeqMetricsPie' not found
</pre></div>

</div>
<div style="clear:both;"></div>

******

## Gene expression quantification 

Gene expression quantification was done using [htseq-count](http://www-huber.embl.de/users/anders/HTSeq/doc/count.html) function within the python HTSeq analysis package <code class="knitr inline">(, 2014)</code>, which counts all reads overlapping known exons.

<div style="width:40%;padding:0 10pt 0 0;float:left;">
<div class="warning"><pre class="knitr r">## Warning: is.na() applied to non-(list or vector) of type 'NULL'
## Warning: is.na() applied to non-(list or vector) of type 'NULL'
</pre></div>
<table id="htseq_table", class="stdTable">
<tbody>
  <tr>
   <td align="left"> Metric </td>
   <td align="left"> Value </td>
  </tr>
  <tr>
   <td align="left"> __no_feature </td>
   <td align="left"> 31577367 </td>
  </tr>
  <tr>
   <td align="left"> __ambiguous </td>
   <td align="left"> 94473 </td>
  </tr>
  <tr>
   <td align="left"> __too_low_aQual </td>
   <td align="left"> 0 </td>
  </tr>
  <tr>
   <td align="left"> __not_aligned </td>
   <td align="left"> 0 </td>
  </tr>
  <tr>
   <td align="left"> __alignment_not_unique </td>
   <td align="left"> 7346442 </td>
  </tr>
</tbody>
</table>

</div>

<div style="width:60%;padding:0 10pt 0 0;float:right;">
<iframe src='
figure/htseqQCPie.html
' scrolling='no' seamless class='rChart 
nvd3
 '
id=iframe-
chart5171cece13e
></iframe>
<style>iframe.rChart{ width: 100%; height: 400px;}</style>

</div>
<div style="clear:both;"></div>

## Gene expression reliability



Gene expresssion values are grouped into "reliable expressed genes" and "not so reliable expressed genes" based on a background distribution of <code class="knitr inline">136</code> genes which have a median expression value of 0 in the <code class="knitr inline">1057</code> TCGA reference cohort:

* **reliable expressed** Number of genes reliable expressed in the sample
* **marginal expressed** Number of genes that are marginally (between 0.01 & 0.02) reliable expressed in the sample
* **not reliable expressed** Number of genes that are not reliable expressed in the sample



<iframe src='
figure/reliableGEPPlot.html
' scrolling='no' seamless class='rChart 
highcharts
 '
id=iframe-
chart51775abfb09
></iframe>
<style>iframe.rChart{ width: 100%; height: 400px;}</style>


******

Expression density plot

<div class="chunk" id="reliableGEPDensityPlot"><div class="rcode"><div class="rimage center"><img src="figure/reliableGEPDensityPlot.png" title="plot of chunk reliableGEPDensityPlot" alt="plot of chunk reliableGEPDensityPlot" class="plot" /></div>
</div></div>

******

# Analysis

## Differential Gene Expression

Differential gene expression is defined as having a expression value 3 standard deviations above/below the respective gene in the reference cohort.

<!-- run the differential expression on the patient samples -->


<iframe src='
figure/diffExpPlot.html
' scrolling='no' seamless class='rChart 
highcharts
 '
id=iframe-
chart517f615bf4
></iframe>
<style>iframe.rChart{ width: 100%; height: 400px;}</style>


******

## Gene Expression Table

<!-- create gene expression table including results from diff. expression calling if available -->
* **Gene** HUGO Symbol for the gene 
* **Diff_expressed** [upregulated/downregulated] above/below median expression value within the normal control +/- three standard deviations 
* **Rank** gene rank within differentially expressed genes
* **perRank** percentile rank within the distribution of all genes within the patient sample
* **Patient** Deseq scaled and log2 transformed read count value of the patient sample
* **Normal** Deseq scaled and log2 transformed median read count value of the normal reference cohort (n=<code class="knitr inline">4</code>)
* **Normal_sd** standard deviation for each scaled read count value of the normal reference cohort
* **d_normal** delta between patient sample read count value and median read count value of the normal reference cohort
* **Ref** Deseq scaled and log2 transformed median read count value of the TCGA reference cohort (n=<code class="knitr inline">947</code>)
* **perRankRef** percentile rank within the distribution of all genes within the reference cohort
* **Ref_sd** standard deviation for each scaled read count value of the reference cohort
* **d_ref** delta between patient sample read count value and median read count value of the reference cohort
* **List_Gene** genes within the supplied gene list



<table id="gep_table">
    <thead>
        <tr>
            <th>Gene</th>
            <th>Diff_expressed</th>
            <th>Rank</th>
            <th>perRank</th>
            <th>Patient</th>
            <th>Normal</th>
            <th>Normal_sd</th>
            <th>d_normal</th>
            <th>Ref</th>
            <th>perRankRef</th>
            <th>Ref_sd</th>
            <th>d_ref</th>
            <th>List_Gene</th>
            <th>GeneWiki</th>
        </tr>
    </thead>
    <tbody></tbody>
</table>

<script type="text/javascript" charset="utf-8">
    $(document).ready(function() {
    var table = $('#gep_table').dataTable({
      "sDom": 'T<"clear">lfrtip',
      "oTableTools": {
          "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
          "aButtons": [
                "copy",
                "csv"
            ]
      },
      "aoColumns": [ 
      null,
      null,
      {"bVisible": false},
		  {"bVisible": false},
      null,
      null,
      {"bVisible": false},
      null,
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      null
		], 
    "iDisplayLength": 10,
    "bPaginate": true,
    "bProcessing": true,
    "sAjaxSource": 'json/gepall.txt'
    //"sScrollXInner": "110%",
    });
    });    
</script>

******

## Prediction of Receptor Status



* **Receptor** Receptor type
* **Status** predicted receptor status for each receptor type
* **Prediction_probability** prediction probability for each receptor type

<table id="receptor_table">
 <thead>
  <tr>
   <th align="left"> Receptor </th>
   <th align="left"> Status </th>
   <th align="right"> Prediction_probability </th>
  </tr>
 </thead>
<tbody>
  <tr>
   <td align="left"> ER </td>
   <td align="left"> Negative </td>
   <td align="right"> NA </td>
  </tr>
  <tr>
   <td align="left"> PR </td>
   <td align="left"> Negative </td>
   <td align="right"> NA </td>
  </tr>
  <tr>
   <td align="left"> HER2 </td>
   <td align="left"> Negative </td>
   <td align="right"> NA </td>
  </tr>
</tbody>
</table>


<script type="text/javascript" charset="utf-8">
    $(document).ready( function () {
    $('#receptor_table').dataTable({
          "sDom": 'T<"clear">lfrtip',
          "oTableTools": {
          "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
          "aButtons": [
                "copy",
                "csv"
                ]
          }
    });
    });
</script>

******

## Prediction of molecular subtype

* **Subtype** prediction of one of the subtypes [Luminal A / Luminal B / Basal / Her2]
* **Prediction_probability** prediction probability for each receptor type

<table id="mol_table">
 <thead>
  <tr>
   <th align="left"> Subtype </th>
   <th align="right"> Prediction_probability </th>
  </tr>
 </thead>
<tbody>
  <tr>
   <td align="left"> Basal </td>
   <td align="right"> NA </td>
  </tr>
</tbody>
</table>


<script type="text/javascript" charset="utf-8">
    $(document).ready( function () {
    $('#mol_table').dataTable({
          "sDom": 'T<"clear">lfrtip',
          "oTableTools": {
          "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
          "aButtons": [
                "copy",
                "csv"
                ]
          }
    });
    });
</script>

******

## Pathways





### KEGG

<table id="kegg_table">
 <thead>
  <tr>
   <th align="left"> Name </th>
   <th align="right"> pSize </th>
   <th align="right"> NDE </th>
   <th align="right"> pNDE </th>
   <th align="right"> tA </th>
   <th align="right"> pPERT </th>
   <th align="right"> pG </th>
   <th align="right"> pGFdr </th>
   <th align="right"> pGFWER </th>
   <th align="left"> Status </th>
   <th align="left"> Image </th>
  </tr>
 </thead>
<tbody>
  <tr>
   <td align="left"> Systemic lupus erythematosus </td>
   <td align="right"> 119 </td>
   <td align="right"> 41 </td>
   <td align="right"> 0e+00 </td>
   <td align="right"> -2.007 </td>
   <td align="right"> 0.792 </td>
   <td align="right"> 0 </td>
   <td align="right"> 0 </td>
   <td align="right"> 0 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/hsa05322.SRR1027180.png target="_blank"> <img height=50 width=50 src=figure/hsa05322.SRR1027180.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Taste transduction </td>
   <td align="right"> 48 </td>
   <td align="right"> 12 </td>
   <td align="right"> 2e-04 </td>
   <td align="right"> 42.830 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0 </td>
   <td align="right"> 0 </td>
   <td align="right"> 0 </td>
   <td align="left"> Activated </td>
   <td align="left"> <a href = figure/hsa04742.SRR1027180.png target="_blank"> <img height=50 width=50 src=figure/hsa04742.SRR1027180.png></a> </td>
  </tr>
</tbody>
</table>


<script type="text/javascript" charset="utf-8">
    $(document).ready( function () {
    $('#kegg_table').dataTable({
          "sDom": 'T<"clear">lfrtip',
          "oTableTools": {
          "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
          "aButtons": [
                "copy",
                "csv"
                ]
          },
      "aoColumns": [ 
      null,
			{"bVisible": false},
      {"bVisible": false},
		  {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      null,
      {"bVisible": false},
      null,
      null
		]
    });
    });
</script>

******

### Biocarta

<div class="chunk" id="BiocartaPlots"><div class="rcode"><div class="warning"><pre class="knitr r">## Warning: no DISPLAY variable so Tk is not available
</pre></div>
</div></div>

<table id="biocarta_table">
 <thead>
  <tr>
   <th align="left"> Name </th>
   <th align="right"> pSize </th>
   <th align="right"> NDE </th>
   <th align="right"> pNDE </th>
   <th align="right"> tA </th>
   <th align="right"> pPERT </th>
   <th align="right"> pG </th>
   <th align="right"> pGFdr </th>
   <th align="right"> pGFWER </th>
   <th align="left"> Status </th>
   <th align="left"> Image </th>
  </tr>
 </thead>
<tbody>
  <tr>
   <td align="left"> erk and pi-3 kinase are necessary for collagen binding in corneal epithelia </td>
   <td align="right"> 36 </td>
   <td align="right"> 6 </td>
   <td align="right"> 0.0575 </td>
   <td align="right"> -77.206 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0e+00 </td>
   <td align="right"> 0.0005 </td>
   <td align="right"> 0.0005 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/BiocartaPlots1.png target="_blank"> <img height=50 width=50 src=figure/BiocartaPlots1.png></a> </td>
  </tr>
  <tr>
   <td align="left"> pertussis toxin-insensitive ccr5 signaling in macrophage </td>
   <td align="right"> 9 </td>
   <td align="right"> 2 </td>
   <td align="right"> 0.1516 </td>
   <td align="right"> -12.743 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0e+00 </td>
   <td align="right"> 0.0006 </td>
   <td align="right"> 0.0012 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/BiocartaPlots2.png target="_blank"> <img height=50 width=50 src=figure/BiocartaPlots2.png></a> </td>
  </tr>
  <tr>
   <td align="left"> fosb gene expression and drug abuse </td>
   <td align="right"> 5 </td>
   <td align="right"> 3 </td>
   <td align="right"> 0.0042 </td>
   <td align="right"> -12.904 </td>
   <td align="right"> 0.003 </td>
   <td align="right"> 2e-04 </td>
   <td align="right"> 0.0055 </td>
   <td align="right"> 0.0164 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/BiocartaPlots3.png target="_blank"> <img height=50 width=50 src=figure/BiocartaPlots3.png></a> </td>
  </tr>
  <tr>
   <td align="left"> cadmium induces dna synthesis and proliferation in macrophages </td>
   <td align="right"> 12 </td>
   <td align="right"> 6 </td>
   <td align="right"> 0.0001 </td>
   <td align="right"> -8.147 </td>
   <td align="right"> 0.275 </td>
   <td align="right"> 4e-04 </td>
   <td align="right"> 0.0111 </td>
   <td align="right"> 0.0443 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/BiocartaPlots4.png target="_blank"> <img height=50 width=50 src=figure/BiocartaPlots4.png></a> </td>
  </tr>
</tbody>
</table>


<script type="text/javascript" charset="utf-8">
    $(document).ready( function () {
    $('#biocarta_table').dataTable({
          "sDom": 'T<"clear">lfrtip',
          "oTableTools": {
          "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
          "aButtons": [
                "copy",
                "csv"
                ]
          },
      "aoColumns": [ 
      null,
  		{"bVisible": false},
      {"bVisible": false},
		  {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      null,
      {"bVisible": false},
      null,
      null
		]        
    });
    });
</script>

******

### NCI



<table id="nci_table">
 <thead>
  <tr>
   <th align="left"> Name </th>
   <th align="right"> pSize </th>
   <th align="right"> NDE </th>
   <th align="right"> pNDE </th>
   <th align="right"> tA </th>
   <th align="right"> pPERT </th>
   <th align="right"> pG </th>
   <th align="right"> pGFdr </th>
   <th align="right"> pGFWER </th>
   <th align="left"> Status </th>
   <th align="left"> Image </th>
  </tr>
 </thead>
<tbody>
  <tr>
   <td align="left"> Signaling events mediated by HDAC Class III </td>
   <td align="right"> 36 </td>
   <td align="right"> 13 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> -0.1861 </td>
   <td align="right"> 0.979 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0024 </td>
   <td align="right"> 0.0024 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/NCIPlots1.png target="_blank"> <img height=50 width=50 src=figure/NCIPlots1.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Signaling events mediated by HDAC Class I </td>
   <td align="right"> 109 </td>
   <td align="right"> 21 </td>
   <td align="right"> 0.0001 </td>
   <td align="right"> -4.0857 </td>
   <td align="right"> 0.553 </td>
   <td align="right"> 0.0005 </td>
   <td align="right"> 0.0303 </td>
   <td align="right"> 0.0605 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/NCIPlots2.png target="_blank"> <img height=50 width=50 src=figure/NCIPlots2.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Role of Calcineurin-dependent NFAT signaling in lymphocytes </td>
   <td align="right"> 78 </td>
   <td align="right"> 15 </td>
   <td align="right"> 0.0009 </td>
   <td align="right"> -11.3173 </td>
   <td align="right"> 0.114 </td>
   <td align="right"> 0.0010 </td>
   <td align="right"> 0.0376 </td>
   <td align="right"> 0.1154 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/NCIPlots3.png target="_blank"> <img height=50 width=50 src=figure/NCIPlots3.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Regulation of p38-alpha and p38-beta </td>
   <td align="right"> 130 </td>
   <td align="right"> 19 </td>
   <td align="right"> 0.0057 </td>
   <td align="right"> -20.2857 </td>
   <td align="right"> 0.024 </td>
   <td align="right"> 0.0014 </td>
   <td align="right"> 0.0376 </td>
   <td align="right"> 0.1506 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/NCIPlots4.png target="_blank"> <img height=50 width=50 src=figure/NCIPlots4.png></a> </td>
  </tr>
</tbody>
</table>


<script type="text/javascript" charset="utf-8">
    $(document).ready( function () {
    $('#nci_table').dataTable({
          "sDom": 'T<"clear">lfrtip',
          "oTableTools": {
          "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
          "aButtons": [
                "copy",
                "csv"
                ]
          },
      "aoColumns": [ 
      null,
  		{"bVisible": false},
      {"bVisible": false},
		  {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      null,
      {"bVisible": false},
      null,
      null
		]        
    });
    });
</script>

******

### Reactome



<table id="reactome_table">
 <thead>
  <tr>
   <th align="left"> Name </th>
   <th align="right"> pSize </th>
   <th align="right"> NDE </th>
   <th align="right"> pNDE </th>
   <th align="right"> tA </th>
   <th align="right"> pPERT </th>
   <th align="right"> pG </th>
   <th align="right"> pGFdr </th>
   <th align="right"> pGFWER </th>
   <th align="left"> Status </th>
   <th align="left"> Image </th>
  </tr>
 </thead>
<tbody>
  <tr>
   <td align="left"> RNA Polymerase I Promoter Opening </td>
   <td align="right"> 28 </td>
   <td align="right"> 19 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> -63.562 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots1.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots1.png></a> </td>
  </tr>
  <tr>
   <td align="left"> RNA Polymerase I Promoter Clearance </td>
   <td align="right"> 51 </td>
   <td align="right"> 20 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> -70.655 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots2.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots2.png></a> </td>
  </tr>
  <tr>
   <td align="left"> RNA Polymerase I Transcription </td>
   <td align="right"> 53 </td>
   <td align="right"> 20 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> -71.214 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots3.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots3.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Meiotic Recombination </td>
   <td align="right"> 40 </td>
   <td align="right"> 15 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 38.570 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="left"> Activated </td>
   <td align="left"> <a href = figure/ReactomePlots4.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots4.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Translation </td>
   <td align="right"> 115 </td>
   <td align="right"> 25 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> -55.942 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots5.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots5.png></a> </td>
  </tr>
  <tr>
   <td align="left"> RNA Polymerase I, RNA Polymerase III, and Mitochondrial Transcription </td>
   <td align="right"> 89 </td>
   <td align="right"> 21 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> -75.209 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots6.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots6.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Peptide chain elongation </td>
   <td align="right"> 81 </td>
   <td align="right"> 17 </td>
   <td align="right"> 0.0001 </td>
   <td align="right"> -51.886 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots7.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots7.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Eukaryotic Translation Elongation </td>
   <td align="right"> 84 </td>
   <td align="right"> 17 </td>
   <td align="right"> 0.0002 </td>
   <td align="right"> -51.730 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots8.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots8.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Transcription </td>
   <td align="right"> 173 </td>
   <td align="right"> 25 </td>
   <td align="right"> 0.0020 </td>
   <td align="right"> -84.537 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0001 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots9.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots9.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Gene Expression </td>
   <td align="right"> 364 </td>
   <td align="right"> 41 </td>
   <td align="right"> 0.0110 </td>
   <td align="right"> -54.858 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0003 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots10.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots10.png></a> </td>
  </tr>
  <tr>
   <td align="left"> p75NTR signals via NF-kB </td>
   <td align="right"> 15 </td>
   <td align="right"> 6 </td>
   <td align="right"> 0.0006 </td>
   <td align="right"> -22.430 </td>
   <td align="right"> 0.001 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0002 </td>
   <td align="right"> 0.0029 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots11.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots11.png></a> </td>
  </tr>
  <tr>
   <td align="left"> GTP hydrolysis and joining of the 60S ribosomal subunit </td>
   <td align="right"> 101 </td>
   <td align="right"> 24 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.000 </td>
   <td align="right"> 1.000 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0002 </td>
   <td align="right"> 0.0030 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots12.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots12.png></a> </td>
  </tr>
  <tr>
   <td align="left"> p75 NTR receptor-mediated signalling </td>
   <td align="right"> 31 </td>
   <td align="right"> 9 </td>
   <td align="right"> 0.0004 </td>
   <td align="right"> -49.624 </td>
   <td align="right"> 0.002 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0003 </td>
   <td align="right"> 0.0040 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots13.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots13.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Eukaryotic Translation Initiation </td>
   <td align="right"> 108 </td>
   <td align="right"> 24 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> -2.570 </td>
   <td align="right"> 0.721 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0005 </td>
   <td align="right"> 0.0073 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots14.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots14.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Cap-dependent Translation Initiation </td>
   <td align="right"> 108 </td>
   <td align="right"> 24 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> -2.593 </td>
   <td align="right"> 0.727 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 0.0005 </td>
   <td align="right"> 0.0073 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots15.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots15.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Regulation of beta-cell development </td>
   <td align="right"> 97 </td>
   <td align="right"> 20 </td>
   <td align="right"> 0.0000 </td>
   <td align="right"> 4.831 </td>
   <td align="right"> 0.080 </td>
   <td align="right"> 0.0001 </td>
   <td align="right"> 0.0010 </td>
   <td align="right"> 0.0164 </td>
   <td align="left"> Activated </td>
   <td align="left"> <a href = figure/ReactomePlots16.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots16.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Regulation of gene expression in beta cells </td>
   <td align="right"> 90 </td>
   <td align="right"> 19 </td>
   <td align="right"> 0.0001 </td>
   <td align="right"> 4.831 </td>
   <td align="right"> 0.089 </td>
   <td align="right"> 0.0001 </td>
   <td align="right"> 0.0012 </td>
   <td align="right"> 0.0196 </td>
   <td align="left"> Activated </td>
   <td align="left"> <a href = figure/ReactomePlots17.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots17.png></a> </td>
  </tr>
  <tr>
   <td align="left"> NF-kB is activated and signals survival </td>
   <td align="right"> 12 </td>
   <td align="right"> 6 </td>
   <td align="right"> 0.0001 </td>
   <td align="right"> -7.800 </td>
   <td align="right"> 0.064 </td>
   <td align="right"> 0.0001 </td>
   <td align="right"> 0.0019 </td>
   <td align="right"> 0.0344 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots18.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots18.png></a> </td>
  </tr>
  <tr>
   <td align="left"> p75NTR recruits signalling complexes </td>
   <td align="right"> 12 </td>
   <td align="right"> 5 </td>
   <td align="right"> 0.0014 </td>
   <td align="right"> -7.652 </td>
   <td align="right"> 0.017 </td>
   <td align="right"> 0.0003 </td>
   <td align="right"> 0.0046 </td>
   <td align="right"> 0.0878 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots19.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots19.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Toll Like Receptor 3 (TLR3) Cascade </td>
   <td align="right"> 59 </td>
   <td align="right"> 10 </td>
   <td align="right"> 0.0150 </td>
   <td align="right"> -380.351 </td>
   <td align="right"> 0.002 </td>
   <td align="right"> 0.0003 </td>
   <td align="right"> 0.0054 </td>
   <td align="right"> 0.1071 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots20.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots20.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Insulin Synthesis and Processing </td>
   <td align="right"> 116 </td>
   <td align="right"> 22 </td>
   <td align="right"> 0.0001 </td>
   <td align="right"> 1.531 </td>
   <td align="right"> 0.792 </td>
   <td align="right"> 0.0007 </td>
   <td align="right"> 0.0100 </td>
   <td align="right"> 0.2101 </td>
   <td align="left"> Activated </td>
   <td align="left"> <a href = figure/ReactomePlots21.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots21.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Toll Like Receptor 10 (TLR10) Cascade </td>
   <td align="right"> 62 </td>
   <td align="right"> 9 </td>
   <td align="right"> 0.0498 </td>
   <td align="right"> -147.299 </td>
   <td align="right"> 0.002 </td>
   <td align="right"> 0.0010 </td>
   <td align="right"> 0.0145 </td>
   <td align="right"> 0.3187 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots22.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots22.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Activated TLR4 signalling </td>
   <td align="right"> 74 </td>
   <td align="right"> 10 </td>
   <td align="right"> 0.0604 </td>
   <td align="right"> -1183.209 </td>
   <td align="right"> 0.004 </td>
   <td align="right"> 0.0023 </td>
   <td align="right"> 0.0307 </td>
   <td align="right"> 0.7057 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots23.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots23.png></a> </td>
  </tr>
  <tr>
   <td align="left"> IRAK2 mediated activation of TAK1 complex </td>
   <td align="right"> 10 </td>
   <td align="right"> 3 </td>
   <td align="right"> 0.0374 </td>
   <td align="right"> -6.933 </td>
   <td align="right"> 0.007 </td>
   <td align="right"> 0.0024 </td>
   <td align="right"> 0.0316 </td>
   <td align="right"> 0.7577 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots24.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots24.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Toll Like Receptor 7/8 (TLR7/8) Cascade </td>
   <td align="right"> 64 </td>
   <td align="right"> 10 </td>
   <td align="right"> 0.0255 </td>
   <td align="right"> -159.125 </td>
   <td align="right"> 0.011 </td>
   <td align="right"> 0.0026 </td>
   <td align="right"> 0.0317 </td>
   <td align="right"> 0.8054 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots25.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots25.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Signalling by NGF </td>
   <td align="right"> 123 </td>
   <td align="right"> 14 </td>
   <td align="right"> 0.0975 </td>
   <td align="right"> -117.338 </td>
   <td align="right"> 0.003 </td>
   <td align="right"> 0.0027 </td>
   <td align="right"> 0.0317 </td>
   <td align="right"> 0.8366 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots26.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots26.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Chromosome Maintenance </td>
   <td align="right"> 67 </td>
   <td align="right"> 14 </td>
   <td align="right"> 0.0006 </td>
   <td align="right"> -2.904 </td>
   <td align="right"> 0.543 </td>
   <td align="right"> 0.0027 </td>
   <td align="right"> 0.0317 </td>
   <td align="right"> 0.8566 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots27.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots27.png></a> </td>
  </tr>
  <tr>
   <td align="left"> TRAF6 mediated induction of NFkB and MAP kinases upon TLR7/8 or 9 activation </td>
   <td align="right"> 61 </td>
   <td align="right"> 9 </td>
   <td align="right"> 0.0456 </td>
   <td align="right"> -225.162 </td>
   <td align="right"> 0.007 </td>
   <td align="right"> 0.0029 </td>
   <td align="right"> 0.0323 </td>
   <td align="right"> 0.9046 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots28.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots28.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Smooth Muscle Contraction </td>
   <td align="right"> 24 </td>
   <td align="right"> 7 </td>
   <td align="right"> 0.0018 </td>
   <td align="right"> -10.323 </td>
   <td align="right"> 0.188 </td>
   <td align="right"> 0.0031 </td>
   <td align="right"> 0.0332 </td>
   <td align="right"> 0.9632 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots29.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots29.png></a> </td>
  </tr>
  <tr>
   <td align="left"> MyD88 cascade initiated on plasma membrane </td>
   <td align="right"> 61 </td>
   <td align="right"> 9 </td>
   <td align="right"> 0.0456 </td>
   <td align="right"> -148.453 </td>
   <td align="right"> 0.008 </td>
   <td align="right"> 0.0033 </td>
   <td align="right"> 0.0340 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots30.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots30.png></a> </td>
  </tr>
  <tr>
   <td align="left"> MyD88 dependent cascade initiated on endosome </td>
   <td align="right"> 62 </td>
   <td align="right"> 9 </td>
   <td align="right"> 0.0498 </td>
   <td align="right"> -153.506 </td>
   <td align="right"> 0.008 </td>
   <td align="right"> 0.0035 </td>
   <td align="right"> 0.0349 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots31.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots31.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Telomere Maintenance </td>
   <td align="right"> 47 </td>
   <td align="right"> 11 </td>
   <td align="right"> 0.0008 </td>
   <td align="right"> -3.464 </td>
   <td align="right"> 0.525 </td>
   <td align="right"> 0.0036 </td>
   <td align="right"> 0.0349 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots32.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots32.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Muscle contraction </td>
   <td align="right"> 50 </td>
   <td align="right"> 11 </td>
   <td align="right"> 0.0014 </td>
   <td align="right"> -7.441 </td>
   <td align="right"> 0.314 </td>
   <td align="right"> 0.0037 </td>
   <td align="right"> 0.0349 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots33.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots33.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Toll Receptor Cascades </td>
   <td align="right"> 91 </td>
   <td align="right"> 12 </td>
   <td align="right"> 0.0497 </td>
   <td align="right"> -297.990 </td>
   <td align="right"> 0.009 </td>
   <td align="right"> 0.0039 </td>
   <td align="right"> 0.0349 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots34.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots34.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Toll Like Receptor 9 (TLR9) Cascade </td>
   <td align="right"> 67 </td>
   <td align="right"> 9 </td>
   <td align="right"> 0.0747 </td>
   <td align="right"> -146.704 </td>
   <td align="right"> 0.006 </td>
   <td align="right"> 0.0039 </td>
   <td align="right"> 0.0349 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots35.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots35.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Toll Like Receptor 4 (TLR4) Cascade </td>
   <td align="right"> 78 </td>
   <td align="right"> 10 </td>
   <td align="right"> 0.0804 </td>
   <td align="right"> -1117.458 </td>
   <td align="right"> 0.007 </td>
   <td align="right"> 0.0048 </td>
   <td align="right"> 0.0412 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots36.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots36.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Innate Immunity Signaling </td>
   <td align="right"> 116 </td>
   <td align="right"> 12 </td>
   <td align="right"> 0.1921 </td>
   <td align="right"> -286.327 </td>
   <td align="right"> 0.003 </td>
   <td align="right"> 0.0049 </td>
   <td align="right"> 0.0412 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots37.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots37.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Toll Like Receptor 5 (TLR5) Cascade </td>
   <td align="right"> 62 </td>
   <td align="right"> 9 </td>
   <td align="right"> 0.0498 </td>
   <td align="right"> -148.042 </td>
   <td align="right"> 0.013 </td>
   <td align="right"> 0.0054 </td>
   <td align="right"> 0.0434 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots38.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots38.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Toll Like Receptor TLR6:TLR2 Cascade </td>
   <td align="right"> 66 </td>
   <td align="right"> 10 </td>
   <td align="right"> 0.0309 </td>
   <td align="right"> -137.558 </td>
   <td align="right"> 0.021 </td>
   <td align="right"> 0.0054 </td>
   <td align="right"> 0.0434 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots39.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots39.png></a> </td>
  </tr>
  <tr>
   <td align="left"> Endosomal Sorting Complex Required For Transport (ESCRT) </td>
   <td align="right"> 27 </td>
   <td align="right"> 3 </td>
   <td align="right"> 0.3523 </td>
   <td align="right"> -17.689 </td>
   <td align="right"> 0.002 </td>
   <td align="right"> 0.0058 </td>
   <td align="right"> 0.0455 </td>
   <td align="right"> 1.0000 </td>
   <td align="left"> Inhibited </td>
   <td align="left"> <a href = figure/ReactomePlots40.png target="_blank"> <img height=50 width=50 src=figure/ReactomePlots40.png></a> </td>
  </tr>
</tbody>
</table>


<script type="text/javascript" charset="utf-8">
    $(document).ready( function () {
    $('#reactome_table').dataTable({
          "sDom": 'T<"clear">lfrtip',
          "oTableTools": {
          "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
          "aButtons": [
                "copy",
                "csv"
                ]
          },
      "aoColumns": [ 
      null,
  		{"bVisible": false},
      {"bVisible": false},
		  {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      null,
      {"bVisible": false},
      null,
      null
		]          
    });
    });
</script>

******

## Fusion Gene Candidates

Fusion gene candidated are assessed using [Fusioncatcher](https://code.google.com/p/fusioncatcher/) <code class="knitr inline">(Edgren, Murumagi, Kangaspeska, Nicorici, Hongisto, Kleivi, Rye, Nyberg, Wolf, Borresen-Dale, and Kallioniemi, 2011)</code>. The oncogenicc potential of the fusion candidates is predicted using [OncoFuse](http://www.unav.es/genetica/oncofuse.html) <code class="knitr inline">(Shugay, de
Mendibil, Vizmanos, and Novo, 2013)</code>.

<div class="error"><pre class="knitr r">## Error: cannot open the connection
</pre></div>


<script type="text/javascript" charset="utf-8">
    $(document).ready(function() {
    var stdTable1 = $('#fusion_table').dataTable({
    "sDom": 'T<"clear">lfrtip',
    "oTableTools": {
          "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
          "aButtons": [
                "copy",
                "csv"
                ]
    },
    "aoColumns": [ 
  		null,
			null,
      null,
		  {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      {"bVisible": false},
      null,
      null      
		], 
    //"iDisplayLength": 10,
    //"bPaginate": true,
    //"bProcessing": true,
    //"sScrollXInner": "110%",
    });
    
    //var tableId = 'fusion_table';
    //$('<div style="width: 100%; overflow: auto"></div>').append($('#' + tableId)).insertAfter($('#' + tableId + '_wrapper div').first())
    });
</script>

******

## SNPs/INDELs

### Transcripts effected by the input mutations

This table contains information about the transcripts affected by the input mutations. Results are mainly from the Variant Effect Predictor (VEP) results and TransFIC calculations.

* **CHR** The mutation's chromosome.
* **STRAND** The mutations's strand.
* **START** The mutation's start position.
* **ALLELE** The mutations's affected nucleotides. The reference and changed sequences are seperated by a slash '/'.
* **TRANSCRIPT_ID** The Ensembl identifier of the transcript affected by the mutation.
* **CT** The list of Sequence Ontology terms describing the consequence of the mutation.
* **GENE_ID** The Ensembl identifier of the gene coded by the transcript.
* **SYMBOL** The HUGO symbol of the gene.
* **AA_CHANGE** The aminoacids change seperated by a slash '/'.
* **SIFT_TRANSFIC_CLASS** Classification of this mutation based on the SIFT TransFIC and its separation of highly-recurrent and non-recurrent somatic mutations in COSMIC.
* **PPH2_TRANSFIC_CLASS** Classification of this mutation based on the Polyphen2 TransFIC and its separation of highly-recurrent and non-recurrent somatic mutations in COSMIC.
* **MA_TRANSFIC_CLASS** Classification of this mutation based on the MA TransFIC and its separation of highly-recurrent and non-recurrent somatic mutations in COSMIC.
* **IMPACT** assessment of the functional impact of the mutation on the transcript. The possible values that can take are: (4) mutation that doesn’t affect the protein sequence, (3) non-synonymous mutation with low MA TransFIC, (2) non-synonymous mutation with medium MA TransFIC, (1) non-synonymous mutations with high MA TransFIC, stop mutation or frameshift causing indel.
* **IMPACT_CLASS** Classification label for the impact: (4) none, (3) low, (2) medium, (1) high.


<table id="intogenConsequences_table">
 <thead>
  <tr>
   <th align="left"> CHR </th>
   <th align="left"> STRAND </th>
   <th align="right"> START </th>
   <th align="left"> ALLELE </th>
   <th align="left"> TRANSCRIPT_ID </th>
   <th align="left"> CT </th>
   <th align="left"> GENE_ID </th>
   <th align="left"> SYMBOL </th>
   <th align="left"> AA_CHANGE </th>
   <th align="left"> SIFT_TRANSFIC_CLASS </th>
   <th align="left"> PPH2_TRANSFIC_CLASS </th>
   <th align="left"> MA_TRANSFIC_CLASS </th>
   <th align="left"> IMPACT </th>
   <th align="left"> IMPACT_CLASS </th>
  </tr>
 </thead>
<tbody>
  <tr>
   <td align="left"> 20 </td>
   <td align="left"> + </td>
   <td align="right"> 33834785 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000246186 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000125966 </td>
   <td align="left"> MMP24 </td>
   <td align="left"> T/M </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 20 </td>
   <td align="left"> + </td>
   <td align="right"> 60881715 </td>
   <td align="left"> C/G </td>
   <td align="left"> ENST00000253003 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000130706 </td>
   <td align="left"> ADRM1 </td>
   <td align="left"> L/V </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 22 </td>
   <td align="left"> + </td>
   <td align="right"> 19044664 </td>
   <td align="left"> C/G </td>
   <td align="left"> ENST00000263196 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000070413 </td>
   <td align="left"> DGCR2 </td>
   <td align="left"> V/L </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 22 </td>
   <td align="left"> + </td>
   <td align="right"> 19044664 </td>
   <td align="left"> C/G </td>
   <td align="left"> ENST00000537045 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000070413 </td>
   <td align="left"> DGCR2 </td>
   <td align="left"> V/L </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 22 </td>
   <td align="left"> + </td>
   <td align="right"> 25315892 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000400359 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000167037 </td>
   <td align="left"> SGSM1 </td>
   <td align="left"> V/A </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 22 </td>
   <td align="left"> + </td>
   <td align="right"> 25315892 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000400358 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000167037 </td>
   <td align="left"> SGSM1 </td>
   <td align="left"> V/A </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 36379489 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000373204 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000092847 </td>
   <td align="left"> EIF2C1 </td>
   <td align="left"> Q/H </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 36379489 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000373206 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000092847 </td>
   <td align="left"> EIF2C1 </td>
   <td align="left"> Q/H </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 52498653 </td>
   <td align="left"> G/C </td>
   <td align="left"> ENST00000371614 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000198841 </td>
   <td align="left"> KTI12 </td>
   <td align="left"> Q/E </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000370730 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000335786 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000370717 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000370727 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000370725 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000319517 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000271029 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000370728 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000359929 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000370723 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000402328 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000370721 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000394879 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000449420 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="left"> G/V </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 154522942 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000292211 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000160714 </td>
   <td align="left"> UBE2Q1 </td>
   <td align="left"> W/L </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000441168 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000405523 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000391987 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000361678 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000405002 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000373320 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000403283 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000401804 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000418505 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000272972 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000536462 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000373318 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000418708 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000406958 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="left"> K/E </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 17416151 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000429924 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000131374 </td>
   <td align="left"> TBC1D5 </td>
   <td align="left"> L/S </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 17416151 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000446818 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000131374 </td>
   <td align="left"> TBC1D5 </td>
   <td align="left"> L/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 17416151 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000429383 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000131374 </td>
   <td align="left"> TBC1D5 </td>
   <td align="left"> L/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 17416151 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000253692 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000131374 </td>
   <td align="left"> TBC1D5 </td>
   <td align="left"> L/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 39307162 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000542107 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000168329 </td>
   <td align="left"> CX3CR1 </td>
   <td align="left"> T/M </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 39307162 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000399220 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000168329 </td>
   <td align="left"> CX3CR1 </td>
   <td align="left"> T/M </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 39307162 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000358309 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000168329 </td>
   <td align="left"> CX3CR1 </td>
   <td align="left"> T/M </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 39307162 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000541347 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000168329 </td>
   <td align="left"> CX3CR1 </td>
   <td align="left"> T/M </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 51431060 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000323686 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000179837 </td>
   <td align="left"> RBM15B </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 119150985 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000319172 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000176142 </td>
   <td align="left"> TMEM39A </td>
   <td align="left"> Y/C </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 4 </td>
   <td align="left"> + </td>
   <td align="right"> 187628419 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000441802 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000083857 </td>
   <td align="left"> FAT1 </td>
   <td align="left"> G/R </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 42719239 </td>
   <td align="left"> A/C </td>
   <td align="left"> ENST00000230882 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000112964 </td>
   <td align="left"> GHR </td>
   <td align="left"> I/L </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 42719239 </td>
   <td align="left"> A/C </td>
   <td align="left"> ENST00000537449 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000112964 </td>
   <td align="left"> GHR </td>
   <td align="left"> I/L </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 42719239 </td>
   <td align="left"> A/C </td>
   <td align="left"> ENST00000357703 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000112964 </td>
   <td align="left"> GHR </td>
   <td align="left"> I/L </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 56180551 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000399503 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000095015 </td>
   <td align="left"> MAP3K1 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000514141 </td>
   <td align="left"> NMD_transcript_variant,missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000509126 </td>
   <td align="left"> NMD_transcript_variant,missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> medium </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000352007 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000515295 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> medium </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000504026 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> medium </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000511527 </td>
   <td align="left"> NMD_transcript_variant,missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000241436 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000505774 </td>
   <td align="left"> NMD_transcript_variant,missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000505975 </td>
   <td align="left"> NMD_transcript_variant,missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000514296 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> medium </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000508526 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="left"> E/K </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 112769938 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000390666 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000212122 </td>
   <td align="left"> TSSK1B </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 139930362 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000336283 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000213523 </td>
   <td align="left"> SRA1 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 139930362 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000520427 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000213523 </td>
   <td align="left"> SRA1 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 18323196 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000251900 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000102098 </td>
   <td align="left"> SCML2 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 100748125 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000423738 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000196440 </td>
   <td align="left"> ARMCX4 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 129205072 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000335997 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000102034 </td>
   <td align="left"> ELF4 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 129205072 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000308167 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000102034 </td>
   <td align="left"> ELF4 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000370690 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000539015 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000420362 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000543669 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000370674 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000370683 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000345434 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> medium </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000394155 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> medium </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000452016 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000535737 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000394153 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000456445 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000434885 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="left"> V/L </td>
   <td align="left"> low </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 8 </td>
   <td align="left"> + </td>
   <td align="right"> 144463755 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENST00000289013 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000158106 </td>
   <td align="left"> RHPN1 </td>
   <td align="left"> V/A </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 21970287 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000446906 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000078403 </td>
   <td align="left"> MLLT10 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 21970287 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000420525 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000078403 </td>
   <td align="left"> MLLT10 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 21970287 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000377059 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000078403 </td>
   <td align="left"> MLLT10 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 21970287 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000438473 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000078403 </td>
   <td align="left"> MLLT10 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 21970287 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000307729 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000078403 </td>
   <td align="left"> MLLT10 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 21970287 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000377072 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000078403 </td>
   <td align="left"> MLLT10 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 29747371 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000375398 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000197321 </td>
   <td align="left"> SVIL </td>
   <td align="left"> D/Y </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 29747371 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000355867 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000197321 </td>
   <td align="left"> SVIL </td>
   <td align="left"> D/Y </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 29747371 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000375400 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000197321 </td>
   <td align="left"> SVIL </td>
   <td align="left"> D/Y </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 29747371 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000535393 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000197321 </td>
   <td align="left"> SVIL </td>
   <td align="left"> D/Y </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 124166117 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000392799 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000107679 </td>
   <td align="left"> PLEKHA1 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 124166117 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000368988 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000107679 </td>
   <td align="left"> PLEKHA1 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 124166117 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000409427 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000107679 </td>
   <td align="left"> PLEKHA1 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 124166117 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000538022 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000107679 </td>
   <td align="left"> PLEKHA1 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 124166117 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000368990 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000107679 </td>
   <td align="left"> PLEKHA1 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 124166117 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000433307 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000107679 </td>
   <td align="left"> PLEKHA1 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 124166117 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000368989 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000107679 </td>
   <td align="left"> PLEKHA1 </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 11 </td>
   <td align="left"> + </td>
   <td align="right"> 6644221 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000299441 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000166341 </td>
   <td align="left"> DCHS1 </td>
   <td align="left"> R/W </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 12 </td>
   <td align="left"> + </td>
   <td align="right"> 91502161 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000266718 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000139329 </td>
   <td align="left"> LUM </td>
   <td align="left"> L/P </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 13 </td>
   <td align="left"> + </td>
   <td align="right"> 42875587 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000025301 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000023516 </td>
   <td align="left"> AKAP11 </td>
   <td align="left"> E/G </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 23746093 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000431326 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000260175 </td>
   <td align="left"> NA </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 23746093 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000561013 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000260175 </td>
   <td align="left"> NA </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 23746093 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENST00000357460 </td>
   <td align="left"> stop_gained </td>
   <td align="left"> ENSG00000215271 </td>
   <td align="left"> HOMEZ </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000399390 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000556523 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000555225 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000554698 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000555355 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000555365 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000556249 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000553343 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000538105 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000399395 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENST00000553930 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="left"> P/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 102483555 </td>
   <td align="left"> T/G </td>
   <td align="left"> ENST00000360184 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000197102 </td>
   <td align="left"> DYNC1H1 </td>
   <td align="left"> V/G </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 15 </td>
   <td align="left"> + </td>
   <td align="right"> 63097941 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000494733 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000171914 </td>
   <td align="left"> TLN2 </td>
   <td align="left"> N/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 15 </td>
   <td align="left"> + </td>
   <td align="right"> 63097941 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000561311 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000171914 </td>
   <td align="left"> TLN2 </td>
   <td align="left"> N/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 15 </td>
   <td align="left"> + </td>
   <td align="right"> 63097941 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000306829 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000171914 </td>
   <td align="left"> TLN2 </td>
   <td align="left"> N/S </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 15 </td>
   <td align="left"> + </td>
   <td align="right"> 89424765 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000562281 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000140511 </td>
   <td align="left"> HAPLN3 </td>
   <td align="left"> G/R </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 15 </td>
   <td align="left"> + </td>
   <td align="right"> 89424765 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000558770 </td>
   <td align="left"> NMD_transcript_variant,missense_variant </td>
   <td align="left"> ENSG00000140511 </td>
   <td align="left"> HAPLN3 </td>
   <td align="left"> G/R </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 15 </td>
   <td align="left"> + </td>
   <td align="right"> 89424765 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000359595 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000140511 </td>
   <td align="left"> HAPLN3 </td>
   <td align="left"> G/R </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 15 </td>
   <td align="left"> + </td>
   <td align="right"> 89424765 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000562889 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000140511 </td>
   <td align="left"> HAPLN3 </td>
   <td align="left"> G/R </td>
   <td align="left"> high </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 70902559 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000316490 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000157423 </td>
   <td align="left"> HYDIN </td>
   <td align="left"> V/I </td>
   <td align="left"> medium </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 70902559 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000393567 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000157423 </td>
   <td align="left"> HYDIN </td>
   <td align="left"> V/I </td>
   <td align="left"> medium </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 70902568 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000316490 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000157423 </td>
   <td align="left"> HYDIN </td>
   <td align="left"> A/T </td>
   <td align="left"> medium </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 70902568 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000393567 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000157423 </td>
   <td align="left"> HYDIN </td>
   <td align="left"> A/T </td>
   <td align="left"> medium </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 71061495 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000448691 </td>
   <td align="left"> stop_lost </td>
   <td align="left"> ENSG00000157423 </td>
   <td align="left"> HYDIN </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 71061495 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENST00000321489 </td>
   <td align="left"> stop_lost </td>
   <td align="left"> ENSG00000157423 </td>
   <td align="left"> HYDIN </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> - </td>
   <td align="left"> 1 </td>
   <td align="left"> high </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 75665388 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000319410 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000065427 </td>
   <td align="left"> KARS </td>
   <td align="left"> R/Q </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 75665388 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENST00000302445 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000065427 </td>
   <td align="left"> KARS </td>
   <td align="left"> R/Q </td>
   <td align="left"> high </td>
   <td align="left"> medium </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 85689402 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000253458 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000131149 </td>
   <td align="left"> GSE1 </td>
   <td align="left"> P/T </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 85689402 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000411612 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000131149 </td>
   <td align="left"> GSE1 </td>
   <td align="left"> P/T </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 85689402 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000405402 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000131149 </td>
   <td align="left"> GSE1 </td>
   <td align="left"> P/T </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 85689402 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000412692 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000131149 </td>
   <td align="left"> GSE1 </td>
   <td align="left"> P/T </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 85689402 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENST00000393243 </td>
   <td align="left"> missense_variant </td>
   <td align="left"> ENSG00000131149 </td>
   <td align="left"> GSE1 </td>
   <td align="left"> P/T </td>
   <td align="left"> high </td>
   <td align="left"> low </td>
   <td align="left"> medium </td>
   <td align="left"> 2 </td>
   <td align="left"> medium </td>
  </tr>
</tbody>
</table>


<script type="text/javascript" charset="utf-8">
    $(document).ready(function() {
    var dogtable = $('#intogenConsequences_table').dataTable({
        "sDom": 'T<"clear">lfrtip',
        "oTableTools": {
            "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
            "aButtons": [
                "copy",
                "csv"
            ]
        },
        "aoColumns": [ 
        	null,
    			{"bVisible": false},
          null,
    		  null,
          {"bVisible": false},
          null,
          {"bVisible": false},
          null,
          null,
          {"bVisible": false},
          {"bVisible": false},
          {"bVisible": false},
          {"bVisible": false},
          null     
    		]       
      })
      });
</script>

******

### Mutations affecting genes

* **CHR** The mutation’s chromosome.
* **STRAND** The mutations’s strand.
* **START** The mutation’s start position.
* **ALLELE** The mutation’s affected nucleotides. The reference and changed sequences are separated by a slash ‘/’.
* **GENE_ID** The Ensembl identifier of the gene coded by the transcript.
* **SYMBOL** The HUGO symbol of the gene.
* **VAR_IMPACT** assessment of the functional impact of the mutation on the on the gene. The possible values that can take are: (4) mutation that doesn’t affect the protein sequence, (3) non-synonymous mutation with low MA TransFIC, (2) non-synonymous mutation with medium MA TransFIC, (1) non-synonymous mutations with high MA TransFIC, stop mutation or frameshift causing indel.
* **VAR_IMPACT_CLASS** Classification label for the impact: (4) none, (3) low, (2) medium, (1) high.
* **CODING_REGION** Whether the mutation affects to the coding region of the gene. It will take value 1 when at least one transcript have any of the following consequence terms: missense_variant, stop_gained, stop_lost, frameshift_variant, synonymous_variant, splice_donor_variant, splice_acceptor_variant, splice_region_variant. And 0 otherwise.
* **PROTEIN_CHANGES** 
* **XREFS** The comma separated list of external references. When the mutation is known and have an identifier in an external source (such as dbSNP or COSMIC).

<table id="intogenVarGenes_table">
 <thead>
  <tr>
   <th align="left"> CHR </th>
   <th align="left"> STRAND </th>
   <th align="right"> START </th>
   <th align="left"> ALLELE </th>
   <th align="left"> GENE_ID </th>
   <th align="left"> SYMBOL </th>
   <th align="right"> VAR_IMPACT </th>
   <th align="left"> VAR_IMPACT_DESC </th>
   <th align="right"> CODING_REGION </th>
   <th align="left"> PROTEIN_CHANGES </th>
   <th align="right"> INTOGEN_DRIVER </th>
   <th align="left"> XREFS </th>
  </tr>
 </thead>
<tbody>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 36379489 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENSG00000092847 </td>
   <td align="left"> EIF2C1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> Q468H, Q543H </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 52498653 </td>
   <td align="left"> G/C </td>
   <td align="left"> ENSG00000198841 </td>
   <td align="left"> KTI12 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> Q261E </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 82456165 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENSG00000117114 </td>
   <td align="left"> LPHN2 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> G1211V, G1241V, G1196V, G1131V, G1183V, G1164V, G1239V, G251V, G1254V </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs143448377 </td>
  </tr>
  <tr>
   <td align="left"> 1 </td>
   <td align="left"> + </td>
   <td align="right"> 154522942 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENSG00000160714 </td>
   <td align="left"> UBE2Q1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> W414L </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 21970287 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENSG00000078403 </td>
   <td align="left"> MLLT10 </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> G550*, G193*, G124* </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 29747371 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENSG00000197321 </td>
   <td align="left"> SVIL </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> D2184Y, D1098Y, D1758Y </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 10 </td>
   <td align="left"> + </td>
   <td align="right"> 124166117 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENSG00000107679 </td>
   <td align="left"> PLEKHA1 </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> Y90* </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 11 </td>
   <td align="left"> + </td>
   <td align="right"> 6644221 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENSG00000166341 </td>
   <td align="left"> DCHS1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> R2896W </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 12 </td>
   <td align="left"> + </td>
   <td align="right"> 91502161 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENSG00000139329 </td>
   <td align="left"> LUM </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> L199P </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs147975710 </td>
  </tr>
  <tr>
   <td align="left"> 13 </td>
   <td align="left"> + </td>
   <td align="right"> 42875587 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENSG00000023516 </td>
   <td align="left"> AKAP11 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> E902G </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs61752500 </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 23746093 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENSG00000215271 </td>
   <td align="left"> HOMEZ </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> S115* </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 23746093 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENSG00000260175 </td>
   <td align="left"> NA </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> S117* </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 24909513 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENSG00000100445 </td>
   <td align="left"> SDR39U1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> P53S, P125S, P138S, P114S, P220S, P143S, P112S, P95S </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 14 </td>
   <td align="left"> + </td>
   <td align="right"> 102483555 </td>
   <td align="left"> T/G </td>
   <td align="left"> ENSG00000197102 </td>
   <td align="left"> DYNC1H1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> V2660G </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs201272954 </td>
  </tr>
  <tr>
   <td align="left"> 15 </td>
   <td align="left"> + </td>
   <td align="right"> 63097941 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENSG00000171914 </td>
   <td align="left"> TLN2 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> N1121S, N2207S </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 15 </td>
   <td align="left"> + </td>
   <td align="right"> 89424765 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000140511 </td>
   <td align="left"> HAPLN3 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> G106R, G168R </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs140982817 </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 70902559 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000157423 </td>
   <td align="left"> HYDIN </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> V3742I, V3741I </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs1798413,dbSNP:rs77739958 </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 70902568 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000157423 </td>
   <td align="left"> HYDIN </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> A3739T, A3738T </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs1774504,dbSNP:rs78562971 </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 71061495 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENSG00000157423 </td>
   <td align="left"> HYDIN </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> *1018Q </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs1022220,dbSNP:rs146649547 </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 75665388 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000065427 </td>
   <td align="left"> KARS </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> R421Q, R393Q </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs149772470 </td>
  </tr>
  <tr>
   <td align="left"> 16 </td>
   <td align="left"> + </td>
   <td align="right"> 85689402 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENSG00000131149 </td>
   <td align="left"> GSE1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> P186T, P97T, P290T, P217T </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 2 </td>
   <td align="left"> + </td>
   <td align="right"> 241494321 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENSG00000144504 </td>
   <td align="left"> ANKMY1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> K100E, K53E, K11E, K179E </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 20 </td>
   <td align="left"> + </td>
   <td align="right"> 33834785 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000125966 </td>
   <td align="left"> MMP24 </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> T130M </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs199855518 </td>
  </tr>
  <tr>
   <td align="left"> 20 </td>
   <td align="left"> + </td>
   <td align="right"> 60881715 </td>
   <td align="left"> C/G </td>
   <td align="left"> ENSG00000130706 </td>
   <td align="left"> ADRM1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> L156V </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 22 </td>
   <td align="left"> + </td>
   <td align="right"> 19044664 </td>
   <td align="left"> C/G </td>
   <td align="left"> ENSG00000070413 </td>
   <td align="left"> DGCR2 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> V213L, V172L </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 22 </td>
   <td align="left"> + </td>
   <td align="right"> 25315892 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENSG00000167037 </td>
   <td align="left"> SGSM1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> V1042A, V1097A </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 17416151 </td>
   <td align="left"> A/G </td>
   <td align="left"> ENSG00000131374 </td>
   <td align="left"> TBC1D5 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> L193S, L241S </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 39307162 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENSG00000168329 </td>
   <td align="left"> CX3CR1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> T280M, T312M </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs3732378 </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 51431060 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000179837 </td>
   <td align="left"> RBM15B </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> Q744* </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 3 </td>
   <td align="left"> + </td>
   <td align="right"> 119150985 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENSG00000176142 </td>
   <td align="left"> TMEM39A </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> Y437C </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs193211092 </td>
  </tr>
  <tr>
   <td align="left"> 4 </td>
   <td align="left"> + </td>
   <td align="right"> 187628419 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000083857 </td>
   <td align="left"> FAT1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> G855R </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs180820128 </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 42719239 </td>
   <td align="left"> A/C </td>
   <td align="left"> ENSG00000112964 </td>
   <td align="left"> GHR </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> I357L, I544L, I522L </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs6180 </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 56180551 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENSG00000095015 </td>
   <td align="left"> MAP3K1 </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> E1294* </td>
   <td align="right"> 1 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 74842932 </td>
   <td align="left"> G/A </td>
   <td align="left"> ENSG00000122008 </td>
   <td align="left"> POLK </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> E29K </td>
   <td align="right"> 0 </td>
   <td align="left"> dbSNP:rs148960463 </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 112769938 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000212122 </td>
   <td align="left"> TSSK1B </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> W200* </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 5 </td>
   <td align="left"> + </td>
   <td align="right"> 139930362 </td>
   <td align="left"> C/A </td>
   <td align="left"> ENSG00000213523 </td>
   <td align="left"> SRA1 </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> E138*, E212* </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> 8 </td>
   <td align="left"> + </td>
   <td align="right"> 144463755 </td>
   <td align="left"> T/C </td>
   <td align="left"> ENSG00000158106 </td>
   <td align="left"> RHPN1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> V501A </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 18323196 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000102098 </td>
   <td align="left"> SCML2 </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> W209* </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 100748125 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000196440 </td>
   <td align="left"> ARMCX4 </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> Q1517* </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 129205072 </td>
   <td align="left"> C/T </td>
   <td align="left"> ENSG00000102034 </td>
   <td align="left"> ELF4 </td>
   <td align="right"> 1 </td>
   <td align="left"> high </td>
   <td align="right"> 1 </td>
   <td align="left"> W251* </td>
   <td align="right"> 1 </td>
   <td align="left"> NA </td>
  </tr>
  <tr>
   <td align="left"> X </td>
   <td align="left"> + </td>
   <td align="right"> 135290671 </td>
   <td align="left"> G/T </td>
   <td align="left"> ENSG00000022267 </td>
   <td align="left"> FHL1 </td>
   <td align="right"> 2 </td>
   <td align="left"> medium </td>
   <td align="right"> 1 </td>
   <td align="left"> V203L, V187L, V216L </td>
   <td align="right"> 0 </td>
   <td align="left"> NA </td>
  </tr>
</tbody>
</table>


<script type="text/javascript" charset="utf-8">
    $(document).ready(function() {
    var dogtable = $('#intogenVarGenes_table').dataTable({
        "sDom": 'T<"clear">lfrtip',
        "oTableTools": {
            "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
            "aButtons": [
                "copy",
                "csv"
            ]
        },
        "aoColumns": [ 
          null,
    			{"bVisible": false},
          null,
    		  null,
          {"bVisible": false},
          null,
          {"bVisible": false},
          null,
          {"bVisible": false},
          null,
          null,
          null
    		]         
      })
      });
</script>

****** 

### SNP Annotation

<div class="source"><pre class="knitr r">snpAnnotation <- function(){

  
### Import files
# import vcf
snpVCF <- read.csv(paste(config$SNPIR_RESULT, '/', patientID, '/intogen_input.vcf', sep=''), stringsAsFactors=FALSE, header=F, sep='\t', comment.char="#")

# import Intogen consequences and variant_genes
intogenSNPs <- read.csv2(paste(config$INTOGEN_RESULTS, '/', patientID, '/consequences.tsv', sep=''), stringsAsFactors=FALSE, header=T, sep="\t", na.strings="", as.is=T)
intogenGenes <- read.csv2(paste(config$INTOGEN_RESULTS, '/', patientID, '/variant_genes.tsv', sep=''), stringsAsFactors=FALSE, header=T, sep="\t", na.strings="", as.is=T)

# import COSMIC complete export
CosmicCompleteExport <- read.csv2(config$COSMIC, stringsAsFactors=FALSE, sep='\t')

# import ClinVar variant summary
clinVarSummary <- read.csv2(config$CLINVAR, stringsAsFactors=FALSE, sep='\t')

# import pharmGkb clinical annotations per rsID and info for each SNP
pharmgkbRSID <- read.csv2(config$PHARMGKB_rsID, stringsAsFactors=FALSE, sep=',')
pharmgkbAllele <- read.csv2(config$PHARMGKB_Allele, stringsAsFactors=FALSE, sep='\t')

# import DrugBank stable data file
drugBankTable <- read.csv2(config$DRUGBANK, stringsAsFactors=FALSE, sep='\t')

# import CADD data for all possible SNPs
# cadd <- read.csv2(config$CADD, stringsAsFactors=FALSE, sep='\t')


### Format VCF
# Rename columns
names(snpVCF) <- c("CHROM", "POS", "rsID", "REF", "ALT", "QUAL", "FILTER", "INFO", "FORMAT", "SAMPLE")

# Remove chr from chromosome column
snpVCF$CHROM <- gsub("chr", "", snpVCF$CHROM)

# Create Alternative allele columns for matching
snpVCF$ALT1 <- sapply(strsplit(as.character(snpVCF$ALT), ","), "[", 1)
snpVCF$ALT2 <- sapply(strsplit(as.character(snpVCF$ALT), ","), "[", 2)
snpVCF$ALT3 <- sapply(strsplit(as.character(snpVCF$ALT), ","), "[", 3)

## Create Genotype allele columns for pharmGkb matching
# Split GT values ($SAMPLE) into columns
splitSAMPLE <- unlist(strsplit(snpVCF$SAMPLE, split=':'))
genotype <- splitSAMPLE[seq(1, length(splitSAMPLE), by=5)]
splitGeno <- unlist(strsplit(genotype, split='/'))
snpVCF$allele1value <- splitGeno[seq(1, length(splitGeno), by=2)]
snpVCF$allele2value <- splitGeno[seq(2, length(splitGeno), by=2)]

# Fill Genotype allele columns and Delete allele value columns
snpVCF$allele1 <- ifelse(snpVCF$allele1value == 0, snpVCF$REF,
                           ifelse(snpVCF$allele1value == 1, snpVCF$ALT1, 
                                  ifelse(snpVCF$allele1value == 2, snpVCF$ALT2,
                                         ifelse(snpVCF$allele1value == 3, snpVCF$ALT3, NA))))
snpVCF$allele2 <- ifelse(snpVCF$allele2value == 0, snpVCF$REF,
                           ifelse(snpVCF$allele2value == 1, snpVCF$ALT1,
                                  ifelse(snpVCF$allele2value == 2, snpVCF$ALT2,
                                         ifelse(snpVCF$allele2value == 3, snpVCF$ALT3, NA))))
snpVCF$allele1value <- NULL
snpVCF$allele2value <- NULL


### Label Mutation Type
# Create EFF column in vcf with single EFF for each snp
require(data.table)
snpVCF$EFF <- gsub("EFF=|;.*$", "", regmatches(snpVCF$INFO, regexpr("EFF=.*\\)", snpVCF$INFO)))
dt <- data.table(snpVCF)
snpVCFexpanded <- dt[, list(EFF = unlist(strsplit(EFF, ","))), by = POS]
snpVCF <- merge(snpVCFexpanded, snpVCF, by="POS")
snpVCF$EFF.y <- NULL
setnames(snpVCF, "EFF.x", "EFF")
snpVCF <- as.data.frame(snpVCF)
snpVCF <- snpVCF[,c(3, 1, 4:16, 2)]

# Divide EFF info into separate columns
snpVCF$Effect_type <- gsub("\\(", "", regmatches(snpVCF$EFF, regexpr("^.*\\(", snpVCF$EFF)))
snpVCF$Effect_info <- gsub("\\(|\\)", "", regmatches(snpVCF$EFF, regexpr("\\(.*\\)", snpVCF$EFF)))
snpVCF$Effect_impact <- sapply(strsplit(as.character(snpVCF$Effect_info), "\\|"), "[", 1)
snpVCF$Functional_class <- sapply(strsplit(as.character(snpVCF$Effect_info), "\\|"), "[", 2)
snpVCF$Codon_change <- sapply(strsplit(as.character(snpVCF$Effect_info), "\\|"), "[", 3)
snpVCF$AA_change <- sapply(strsplit(as.character(snpVCF$Effect_info), "\\|"), "[", 4)
snpVCF$Gene <- sapply(strsplit(as.character(snpVCF$Effect_info), "\\|"), "[", 6)
snpVCF$Coding <- sapply(strsplit(as.character(snpVCF$Effect_info), "\\|"), "[", 8)

# Aggregate Codon_change and AA_change and merge back with snpVCF
snpVCFchangesAgged <- aggregate(snpVCF[,c(21,22)], snpVCF[,c(1,2,23)], function(x) paste(unique(x[!is.na(x)]), " ", sep="", collapse=""))
snpVCFchangesAgged <- merge(snpVCF, snpVCFchangesAgged, by=c("CHROM", "POS", "Gene"))

# Format snpVCFchangesAgged and create final Effect column
snpVCFchangesAgged$Codon_change.x <- NULL
snpVCFchangesAgged$AA_change.x <- NULL
setnames(snpVCFchangesAgged, "Codon_change.y", "Codon_change")
setnames(snpVCFchangesAgged, "AA_change.y", "AA_change")
snpVCFchangesAgged$Effect <- paste(snpVCFchangesAgged$Effect_impact, snpVCFchangesAgged$Functional_class, snpVCFchangesAgged$Effect_type, snpVCFchangesAgged$Codon_change, snpVCFchangesAgged$AA_change, sep = " ")
snpVCFchangesAgged$Effect <- gsub("\\>\\s*$", "", snpVCFchangesAgged$Effect)
snpVCFchangesAgged$Effect <- paste(snpVCFchangesAgged$Effect, ";  ", sep="")
snpVCFchangesAgged$Effect <- gsub("\\s+\\<", ", ", snpVCFchangesAgged$Effect)
snpVCFchangesAgged$Effect <- paste(snpVCFchangesAgged$Gene, snpVCFchangesAgged$Effect, sep=": ")

# Aggregate by position to give final VCF
snpVCFchangesAgged <- snpVCFchangesAgged[order(snpVCFchangesAgged$Effect_impact, snpVCFchangesAgged$Coding),]
snpVCFbyPos <- aggregate(snpVCFchangesAgged[,c(4, 3, 25, 5:16)], snpVCFchangesAgged[,c(1,2)], function(x) paste(unique(x[!is.na(x)]), " ", sep="", collapse="")) 

# Create separate gene columns
snpVCFbyPos$GENE1 <- sapply(strsplit(as.character(snpVCFbyPos$Gene), "\\s"), "[", 1)
snpVCFbyPos$GENE2 <- sapply(strsplit(as.character(snpVCFbyPos$Gene), "\\s"), "[", 2)
snpVCFbyPos$GENE3 <- sapply(strsplit(as.character(snpVCFbyPos$Gene), "\\s"), "[", 3)
snpVCFbyPos$GENE4 <- sapply(strsplit(as.character(snpVCFbyPos$Gene), "\\s"), "[", 4)
snpVCFbyPos$GENE5 <- sapply(strsplit(as.character(snpVCFbyPos$Gene), "\\s"), "[", 5)

# Remove hanging spaces created by aggregate function
for(i in (1:ncol(snpVCFbyPos))){
  snpVCFbyPos[,i] <- gsub("\\>\\s+$", "", snpVCFbyPos[,i])
}

# Format gene column and order VCF by chromosome and position
snpVCFbyPos$Gene <- gsub("\\>\\s+\\<", "; ", snpVCFbyPos$Gene)
snpVCFbyPos <- snpVCFbyPos[order(snpVCFbyPos$CHROM, snpVCFbyPos$POS),]


### Intogen Annotation
## Annotate with intogen_consequences.tsv (mainly for gene names and mutation type)
# Format names and ALLELE column for matching
names(intogenSNPs)[2] <- "CHROM"
names(intogenSNPs)[4] <- "POS"
intogenSNPs$Ref <- sapply(strsplit(as.character(intogenSNPs$ALLELE), "/"), "[", 1)
intogenSNPs$Alt <- sapply(strsplit(as.character(intogenSNPs$ALLELE), "/"), "[", 2)


# Merge by Chromosome and Position
intogenSNPsAnno <- merge(snpVCFbyPos, intogenSNPs, by=c("CHROM", "POS"))

# Subset to double check alleles and select only GENE_ID from intogenSNPs
intogenSNPsAnno <- subset(intogenSNPsAnno, ((REF==Ref) & ((ALT1==Alt) | (ALT2==Alt) | (ALT3==Alt))), select = c(CHROM:GENE5, GENE_ID))

## Annotate with intogen_variant_genes.tsv based on Ensembl Gene ID (mainly for driver and impact)
# Remove first five columns
intogenGenes <- intogenGenes[,6:16]

# Merge by Ensembl Gene ID
intogenGenesAnno <- merge(intogenSNPsAnno, intogenGenes, by="GENE_ID")

# Create driver "yes or no" column
intogenGenesAnno$Intogen_driver <- ifelse(intogenGenesAnno$INTOGEN_DRIVER == 0, "No",
                            ifelse(intogenGenesAnno$INTOGEN_DRIVER == 1, "Yes", NA))

# Replace gene names that are NA with Ensembl ID
for(i in (1:nrow(intogenGenesAnno))){
  if(is.na(intogenGenesAnno$SYMBOL[i])){
    intogenGenesAnno$SYMBOL[i] <- intogenGenesAnno$GENE_ID[i]
  }
}

# Paste columns to create "intogen_info" column
intogenGenesAnno$Intogen_info <- paste(intogenGenesAnno$SYMBOL, ": ", "Variant Impact: ", intogenGenesAnno$VAR_IMPACT_DESC, ", Impact Score: ", intogenGenesAnno$VAR_IMPACT, ";", sep="")

# Aggregate by chromosome and position, keeping only intogen_info and driver columns
intogenGenesAnno <- aggregate(intogenGenesAnno[,c(4:23, 34, 35)], intogenGenesAnno[,c(2,3)], function(x) paste(unique(x[!is.na(x)]), " ", sep="", collapse=""))

## Format for future
# Order by chromosome and position
finalIntogenSNPs <- intogenGenesAnno[order(intogenGenesAnno$CHROM, intogenGenesAnno$POS),]
# Remove hanging spaces created by aggregate function
for(i in (1:ncol(finalIntogenSNPs))){
  finalIntogenSNPs[,i] <- gsub("\\>\\s+$", "", finalIntogenSNPs[,i])
}


### COSMIC Annotation
#Create new dataframe with relevant information from Cosmic and trim gene names with _EN...
CosmicVariants <- subset(CosmicCompleteExport, Mutation.GRCh37.genome.position != "", select = c(Mutation.GRCh37.genome.position, Pubmed_PMID, Gene.name, Mutation.CDS, ID_sample, Sample.name, Primary.site, Site.subtype, Primary.histology, Histology.subtype, Sample.source, Comments))
CosmicVariants[,3] <- gsub("_EN.*$", "", CosmicVariants[,3])

#Remove chr from chromosome names in vcf. Convert position format for merge. Merge. Remove extra column used for merging. Double check mutation using subset
snpVCFbyPos$CosmicFormat <- paste(snpVCFbyPos$CHROM, ":", snpVCFbyPos$POS, "-", snpVCFbyPos$POS, sep="")
snpsInCosmic <- merge(snpVCFbyPos, CosmicVariants, by.x = "CosmicFormat", by.y = "Mutation.GRCh37.genome.position")
snpVCFbyPos$CosmicFormat <- NULL
snpsInCosmic$CosmicFormat <- NULL  
snpsInCosmic$allele <- sapply(strsplit(as.character(snpsInCosmic$Mutation.CDS), ">"), "[", 2)
snpsInCosmic$altAllele2 <- ifelse((snpsInCosmic$altAllele1 == "A"), "T",
                                  ifelse((snpsInCosmic$altAllele1 == "T"), "A",
                                         ifelse((snpsInCosmic$altAllele1 == "G"), "C",
                                                ifelse((snpsInCosmic$altAllele1 == "C"), "G", NA))))
snpsInCosmic <- subset(snpsInCosmic, (is.na(snpsInCosmic$altAllele1)) | (snpsInCosmic$ALT1 == snpsInCosmic$altAllele1) | (snpsInCosmic$ALT2 == snpsInCosmic$altAllele1) | (snpsInCosmic$ALT3 == snpsInCosmic$altAllele1) | (snpsInCosmic$ALT1 == snpsInCosmic$altAllele2) | (snpsInCosmic$ALT2 == snpsInCosmic$altAllele2) | (snpsInCosmic$ALT3 == snpsInCosmic$altAllele2))
snpsInCosmic$altAllele1 <- NULL
snpsInCosmic$altAllele2 <- NULL

#Aggregate duplicate positions and Format
snpsInCosmicAgged <- aggregate(snpsInCosmic[,c(3:5,23:33)], snpsInCosmic[,1:2], FUN = function(x) c(count = length(unique(x[!is.na(x)])), paste(rle(sort(x))$values, "(", rle(sort(x))$lengths, "x", ")", "  ", sep="", collapse="")))
snpsInCosmicAgged <- apply(snpsInCosmicAgged, 2, unlist)
if(!is.null(nrow(snpsInCosmicAgged))) {
  snpsInCosmicAgged <- as.data.frame(snpsInCosmicAgged[,c(1,2,4,6,8,10,12,14,15,16,18,20,22,24,26,28,30)])
  totalSamples <- length(unique(CosmicVariants[,5]))
  snpsInCosmicAgged$ID_sample.count <- (as.numeric(snpsInCosmicAgged$ID_sample.count)/totalSamples)*100
  snpsInCosmicAgged <- snpsInCosmicAgged[order(snpsInCosmicAgged$CHROM, snpsInCosmicAgged$POS),]
  snpsInCosmicAgged <- apply(snpsInCosmicAgged, 2, function(x) gsub("\\(1x\\)|\\(x\\)", "", x))
  snpsInCosmicAgged <- apply(snpsInCosmicAgged, 2, function(x) gsub("\\<NS\\>", "", x))
  snpsInCosmicAgged <- as.data.frame(snpsInCosmicAgged)
} else {
  snpsInCosmicAgged <- as.data.frame(t(snpsInCosmicAgged[c(1,2,4,6,8,10,12,14,15,16,18,20,22,24,26,28,30)]))
  snpsInCosmicAgged$ID_sample.count <- (as.numeric(snpsInCosmicAgged$ID_sample.count)/totalSamples)*100
  snpsInCosmicAgged <- snpsInCosmicAgged[order(snpsInCosmicAgged$CHROM, snpsInCosmicAgged$POS),]
  snpsInCosmicAgged <- apply(snpsInCosmicAgged, 2, function(x) gsub("\\(1x\\)|\\(x\\)", "", x))
  snpsInCosmicAgged <- as.data.frame(t(snpsInCosmicAgged))
  snpsInCosmicAgged <- apply(snpsInCosmicAgged, 2, function(x) gsub("\\<NS\\>", "", x))
  snpsInCosmicAgged <- as.data.frame(t(snpsInCosmicAgged))
  snpsInCosmicAgged <- as.data.frame(snpsInCosmicAgged)
}

# Remove repeat numbers from rsID, Gene, and Effect columns
snpsInCosmicAgged$rsID. <- gsub("\\(\\w+\\)", "", snpsInCosmicAgged$rsID.)
snpsInCosmicAgged$Gene. <- gsub("\\(\\w+\\)", "", snpsInCosmicAgged$Gene.)
snpsInCosmicAgged$Effect. <- gsub("\\(\\w+\\)", "", snpsInCosmicAgged$Effect.)

# Remove repeat numbers for spaces
for(i in (1:ncol(snpsInCosmicAgged))){
  snpsInCosmicAgged[,i] <- gsub("\\s+\\(\\w+\\)|^\\(\\w+\\)\\s+", "", snpsInCosmicAgged[,i])
}

# Remove spaces appended by aggregate
for(i in (1:ncol(snpsInCosmicAgged))){
  snpsInCosmicAgged[,i] <- gsub("\\>\\s+$", "", snpsInCosmicAgged[,i])
}

# Format
setnames(snpsInCosmicAgged, "Pubmed_PMID.", "COSMIC_reference")
snpsInCosmicAgged$COSMIC_mutation <- paste(snpsInCosmicAgged$Gene.name, ": ", snpsInCosmicAgged$Mutation.CDS, sep="")
snpsInCosmicAgged$COSMIC_sample <- paste("Sample: ", snpsInCosmicAgged$Sample.name, " ", snpsInCosmicAgged$Sample.source, " ID:", snpsInCosmicAgged$ID_sample., ", frequency in COSMIC: ", snpsInCosmicAgged$ID_sample.count, sep="")
snpsInCosmicAgged$COSMIC_histology <- paste(snpsInCosmicAgged$Primary.site, snpsInCosmicAgged$Site.subtype, snpsInCosmicAgged$Primary.histology, snpsInCosmicAgged$Histology.subtype, snpsInCosmicAgged$Comments, sep=" ")
snpsInCosmicAgged$COSMIC_sample <- gsub("\\s+", " ", snpsInCosmicAgged$COSMIC_sample)
snpsInCosmicAgged$COSMIC_histology <- gsub("\\s+", " ", snpsInCosmicAgged$COSMIC_histology)
setnames(snpsInCosmicAgged, "rsID.", "rsID")
setnames(snpsInCosmicAgged, "Gene.", "Gene")
setnames(snpsInCosmicAgged, "Effect.", "Effect")

finalCosmicSNPs <- snpsInCosmicAgged[,c(1:6, 18:20)]


### ClinVar Annotation
# Format and merge on rsID and Start
vcfForClinvar <- snpVCFbyPos
names(vcfForClinvar)[1] <- "Chromosome"
names(vcfForClinvar)[2] <- "Start"
names(vcfForClinvar)[3] <- "rsID"
names(clinVarSummary)[7] <- "rsID"
vcfForClinvar[,3] <- gsub("rs", "", vcfForClinvar[,3])
clinVarRS <- merge(vcfForClinvar, clinVarSummary, by="rsID")
clinVarStart <- merge(vcfForClinvar, clinVarSummary, by=c("Chromosome", "Start"))

# Format and merge on Stop
names(vcfForClinvar)[2] <- "Stop"
names(clinVarSummary)[7] <- "rsID"
clinVarStop <- merge(vcfForClinvar, clinVarSummary, by=c("Chromosome", "Stop"))

# Remove nonSNPs
clinVarStart <- subset(clinVarStart, Start == Stop)
clinVarStop <- subset(clinVarStop, Start == Stop)

# Format for combining dataframes (columns: rsID, CHROM, POS, Gene, Effect, Type, Name, ClinicalSignificance, PhenotypeIDs, Origin, ReviewStatus, NumberSubmitters, OtherIDs, X.AlleleID, REF:GENE5)
names(clinVarRS)[c(2,3)] <- c("CHROM", "POS")
clinVarRS$Chromosome.y <- NULL
clinVarRS$Start.y <- NULL
clinVarRS$Stop <- NULL
clinVarRS <- clinVarRS[,c(1,2,3,4,5,24,25,28,32,33,36,39,42,23,6:22)]

names(clinVarStart)[c(1,2,3)] <- c("CHROM", "POS", "rsID")
clinVarStart$rsID.y <- NULL
clinVarStart$Stop <- NULL
clinVarStart <- clinVarStart[,c(3,1,2,4,5,24,25,28,32,33,36,39,42,23,6:22)]

names(clinVarStop)[c(1,2,3)] <- c("CHROM", "POS", "rsID")
clinVarStop$rsID.y <- NULL
clinVarStop$Start <- NULL
clinVarStop <- clinVarStop[,c(3,1,2,4,5,24,25,28,32,33,36,39,42,23,6:22)]

# Combine dataframes and Keep unique entries
clinVarAllMethods <- rbind(clinVarRS, clinVarStart, clinVarStop)
clinVarFinal <- unique(clinVarAllMethods)

## Double check correct allele by matching mutation base from vcf and ClinVar's Name field
# Remove rows without base change in Name column
clinVarFinal <- clinVarFinal[-which(regexpr(">.*$", clinVarFinal$Name)==-1),]

# Create clinVarAllele1 and complementary clinVarAllele2
clinVarFinal$clinVarAllele1 <- NA
for(i in 1:ncol(clinVarFinal)){
  if(grepl(">", clinVarFinal$Name[i])){
    clinVarFinal$clinVarAllele1[i] <- gsub(">|\\s.*$", "", regmatches(clinVarFinal$Name[i], regexpr(">.*$", clinVarFinal$Name[i])))
  }
}
clinVarFinal$clinVarAllele2 <- ifelse((clinVarFinal$clinVarAllele1 == "A"), "T",
                                      ifelse((clinVarFinal$clinVarAllele1 == "T"), "A",
                                             ifelse((clinVarFinal$clinVarAllele1 == "G"), "C",
                                                    ifelse((clinVarFinal$clinVarAllele1 == "C"), "G", NA))))

clinVarFinal <- subset(clinVarFinal, (is.na(clinVarFinal$clinVarAllele1)) | (clinVarFinal$ALT1 == clinVarFinal$clinVarAllele1) | (clinVarFinal$ALT2 == clinVarFinal$clinVarAllele1) | (clinVarFinal$ALT3 == clinVarFinal$clinVarAllele1) | (clinVarFinal$ALT1 == clinVarFinal$clinVarAllele2) | (clinVarFinal$ALT2 == clinVarFinal$clinVarAllele2) | (clinVarFinal$ALT3 == clinVarFinal$clinVarAllele2))
clinVarFinal$clinVarAllele1 <- NULL
clinVarFinal$clinVarAllele2 <- NULL

# Create rating column from number of submitters
clinVarFinal$Rating <- ifelse(grepl("not", clinVarFinal$ReviewStatus), 0,
                              ifelse(grepl("conflicting", clinVarFinal$ReviewStatus), 0,
                                     ifelse(grepl("single", clinVarFinal$ReviewStatus), 1,
                                            ifelse(grepl("multiple", clinVarFinal$ReviewStatus), 2,
                                                   ifelse(grepl("expert", clinVarFinal$ReviewStatus), 3,
                                                          ifelse(grepl("professional", clinVarFinal$ReviewStatus), 4, NA  ))))))

# Format (columns: CHROM, POS, rsID, Gene, Effect, Rating, ClinicalSignificance, PhenotypeIDs, Origin, Name, Type, ReviewStatus, NumberSubmitters, X.AlleleID, OtherIDs
finalClinVarSNPs <- clinVarFinal[,c(2,3,1,4,5,32,8,9,10,7,6,11,12,14,13)]
setnames(finalClinVarSNPs, "X.AlleleID", "AlleleID")
finalClinVarSNPs$rsID <- paste("rs", finalClinVarSNPs$rsID, sep="")
finalClinVarSNPs$Mutation <- paste(finalClinVarSNPs$Type, finalClinVarSNPs$Name, sep=" ")
finalClinVarSNPs$Name <- NULL
finalClinVarSNPs$Type <- NULL
names(finalClinVarSNPs)[c(6:14)] <- paste("ClinVar_", names(finalClinVarSNPs)[c(6:14)], sep="")
finalClinVarSNPs <- finalClinVarSNPs[,c(1:9, 14, 10:13)]


### pharmGkb Annotation
# Merge based on rsID
pharmVar <- merge(snpVCFbyPos, pharmgkbRSID, by.x = "rsID", by.y = "Variant")
# Format pharmGkb individual SNP data
names(pharmgkbAllele) <- c("rsID", "genotype", "description", "notes1", "notes2")
pharmgkbAllele$allele1 <- substr(pharmgkbAllele$genotype, 1, 1)
pharmgkbAllele$allele2 <- substr(pharmgkbAllele$genotype, 2, 2)
  
# Add individual SNP annotation from pharmGkb
pharmVar[,28] <- list("")
pharmVar[,29] <- list("")
pharmVar[,30] <- list("")
  
names(pharmVar)[28] <- "description"
names(pharmVar)[29] <- "notes1"
names(pharmVar)[30] <- "notes2"
  
if(nrow(pharmVar)!=0) {
  for(i in 1:(nrow(pharmVar))){
    for(j in 1:(nrow(pharmgkbAllele))){
      if((pharmVar[i,1] == pharmgkbAllele[j,1]) & (((pharmVar[i,16] == pharmgkbAllele[j,6]) & (pharmVar[i,17] == pharmgkbAllele[j,7])) | ((pharmVar[i,16] == pharmgkbAllele[j,7]) & (pharmVar[i,17] == pharmgkbAllele[j,6])))){
        pharmVar[i,28] <- paste(pharmVar[i,28], pharmgkbAllele[j,3], sep = " ")
        pharmVar[i,29] <- paste(pharmVar[i,29], pharmgkbAllele[j,4], sep = " ")
        pharmVar[i,30] <- paste(pharmVar[i,30], pharmgkbAllele[j,5], sep = " ")
      }
    }
  }
}
  
# Format
finalPharmgkbSNPs <- pharmVar[,c(2,3,1,4,5,24,26,25,27,23,28:30)]
setnames(finalPharmgkbSNPs, "Gene.x", "Gene")
setnames(finalPharmgkbSNPs, "Type", "Reaction")
setnames(finalPharmgkbSNPs, "Strength.of.evidence..level.", "Evidence.Level")
names(finalPharmgkbSNPs)[c(6:13)] <- paste("PharmGkb_", names(finalPharmgkbSNPs)[c(6:13)], sep="")
setnames(finalPharmgkbSNPs, "PharmGkb_Gene.y", "PharmGkb_Gene")


### DrugBank Annotation
# Merge on snp rsID
snpsInDrugBank <- merge(snpVCFbyPos, drugBankTable, by.x="rsID", by.y="snp")

# Pull out allele (three possibilities: G>A; A allele; A Allele) and subset on it
snpsInDrugBank$altAllele1 <- sapply(strsplit(as.character(snpsInDrugBank$allele.change), "> "), "[", 2)
snpsInDrugBank$altAllele2 <- sapply(strsplit(as.character(snpsInDrugBank$allele.change), "\\sall|\\sAll"), "[", 1)

# Double check that alternative alleles match
snpsInDrugBank1 <- subset(snpsInDrugBank, (snpsInDrugBank$ALT1 == snpsInDrugBank$altAllele1) | (snpsInDrugBank$ALT2 == snpsInDrugBank$altAllele1) | (snpsInDrugBank$ALT3 == snpsInDrugBank$altAllele1))
snpsInDrugBank2 <- subset(snpsInDrugBank, (snpsInDrugBank$ALT1 == snpsInDrugBank$altAllele2) | (snpsInDrugBank$ALT2 == snpsInDrugBank$altAllele2) | (snpsInDrugBank$ALT3 == snpsInDrugBank$altAllele2))
snpsInDrugBank <- rbind(snpsInDrugBank1, snpsInDrugBank2)

snpsInDrugBank$altAllele1 <- NULL
snpsInDrugBank$altAllele2 <- NULL

# Format final table (column order: CHROM, POS, rsID, Gene, Effect, drug.name, reaction, reference, drug.number, allele.name, allele.change, gene.name, gene.symbol, uniprot)
finalDrugBankSNPs <- snpsInDrugBank[,c(2,3,1,4,5,27,25,26,28,23,24,29:31)]
setnames(finalDrugBankSNPs, "drug.name", "drug")
names(finalDrugBankSNPs)[c(6:14)] <- paste("DrugBank_", names(finalDrugBankSNPs)[c(6:14)], sep="")


### Combine and Format Annotations
require(plyr)

# Cast as data.frames then rbind.fill
finalIntogenSNPs <- as.data.frame(finalIntogenSNPs)
finalCosmicSNPs <- as.data.frame(finalCosmicSNPs)
finalClinVarSNPs <- as.data.frame(finalClinVarSNPs)
finalPharmgkbSNPs <- as.data.frame(finalPharmgkbSNPs)
finalDrugBankSNPs <- as.data.frame(finalDrugBankSNPs)

if(nrow(finalIntogenSNPs)==0){
  for(i in 1:ncol(finalIntogenSNPs)){
    finalIntogenSNPs[1,i] <- "fake"
  }
}

if(nrow(finalCosmicSNPs)==0){
  for(i in 1:ncol(finalCosmicSNPs)){
    finalCosmicSNPs[1,i] <- "fake"
  }
}

if(nrow(finalClinVarSNPs)==0){
  for(i in 1:ncol(finalClinVarSNPs)){
    finalClinVarSNPs[1,i] <- "fake"
  }
}

if(nrow(finalPharmgkbSNPs)==0){
  for(i in 1:ncol(finalPharmgkbSNPs)){
    finalPharmgkbSNPs[1,i] <- "fake"
  }
}

if(nrow(finalDrugBankSNPs)==0){
  for(i in 1:ncol(finalDrugBankSNPs)){
    finalDrugBankSNPs[1,i] <- "fake"
  }
}

allAnnos <- rbind.fill(finalIntogenSNPs, finalCosmicSNPs, finalClinVarSNPs, finalPharmgkbSNPs, finalDrugBankSNPs)

# Aggregate on chromosome and position
allAnnos <- aggregate(allAnnos[,c(3:dim(allAnnos)[2])], allAnnos[,c(1,2)], function(x) paste(unique(x[!is.na(x)]), " ", sep="", collapse=""))
allAnnos <- allAnnos[-which(allAnnos$CHROM=="fake"),]

# Remove spaces appended by aggregate function
for(i in (1:ncol(allAnnos))){
  allAnnos[,i] <- gsub("\\>\\s+$", "", allAnnos[,i])
}


### Label Differentially Expressed (Yes or No)
# Import list of differentially expressed genes
diffGenes <- names(diffExpNBinom$FCdiff)

## Label differentially expressed genes
# Create DIFF column
allAnnos$DIFF <- list("")

# Remove spaces in gene columns
allAnnos$GENE1 <- gsub("\\s+", "", allAnnos$GENE1)
allAnnos$GENE2 <- gsub("\\s+", "", allAnnos$GENE2)
allAnnos$GENE3 <- gsub("\\s+", "", allAnnos$GENE3)
allAnnos$GENE4 <- gsub("\\s+", "", allAnnos$GENE4)
allAnnos$GENE5 <- gsub("\\s+", "", allAnnos$GENE5)

for(i in 1:(nrow(allAnnos))){
  if((allAnnos$GENE1[i] %in% diffGenes)){
    allAnnos$DIFF[i] <- paste(allAnnos$DIFF[i], "Yes", "(", allAnnos$GENE1[i], ")", sep="")
  }else if(allAnnos$GENE2[i] %in% diffGenes){
    allAnnos$DIFF[i] <- paste(allAnnos$DIFF[i], "Yes", "(", allAnnos$GENE2[i], ")", sep="")
  }else if(allAnnos$GENE3[i] %in% diffGenes){
    allAnnos$DIFF[i] <- paste(allAnnos$DIFF[i], "Yes", "(", allAnnos$GENE3[i], ")", sep="")
  }else if(allAnnos$GENE4[i] %in% diffGenes){
    allAnnos$DIFF[i] <- paste(allAnnos$DIFF[i], "Yes", "(", allAnnos$GENE4[i], ")", sep="")
  }else if(allAnnos$GENE5[i] %in% diffGenes){
    allAnnos$DIFF[i] <- paste(allAnnos$DIFF[i], "Yes", "(", allAnnos$GENE5[i], ")", sep="")
  }else{
    allAnnos$DIFF[i] <- "No"
  }
}

allAnnos[,55] <- unlist(allAnnos[,55])
finalSNPs <- data.frame(allAnnos[,c(1:5, 55, 23, 6, 29, 30, 28, 25, 38, 39, 46, 47, 48)])
### CADD Annotation
# Format for Merge
#names(cadd)[c(1:6)] <- c("CHROM", "POS", "REF", "Alt", "CADD_Rawscore", "CADD_PHRED")

# Merge
#finalSNPsWithCADD <- merge(allAnnos, cadd, by=c("CHROM", "POS", "REF"))

# Subset to check allele
#finalSNPsWithCADD <- subset(finalSNPsWithCADD, ((ALT1==Alt) | (ALT2==Alt) | (ALT3==Alt)))
#finalSNPsWithCADD$Alt <- NULL

# Reformat (column order: CHROM, POS, rsID  Gene	DIFF	Intogen_driver	Effect	CADD_Rawscore	CADD_PHRED	ClinVar_Rating	ClinVar_ClinicalSignificance	COSMIC_histology	COSMIC_reference	PharmGkb_Reaction	PharmGkb_Drugs	DrugBank_drug	DrugBank_reaction	DrugBank_reference
#finalSNPs <- finalSNPsWithCADD[,c(1, 2, 4, 5, 55, 23, 6, 56, 57, 29, 30, 28, 25, 38, 39, 46, 47, 48)]
setnames(finalSNPs, "Effect", "SnpEff_Effect")


### Knitr
kable(finalSNPs, format='html', table.attr = 'id=\"SNPs_table\"')

}
snpAnnotation()
</pre></div>
<div class="error"><pre class="knitr r">## Error: replacement has 0 rows, data has 26
</pre></div>


<script type="text/javascript" charset="utf-8">
    $(document).ready(function() {
    var dogtable = $('#SNPs_table').dataTable({
        "sDom": 'T<"clear">lfrtip',
        "oTableTools": {
            "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
            "aButtons": [
                "copy",
                "csv"
            ]
        },
        "aoColumns": [ 
          null,
      		null,
          null,
    		  null,
      	  null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null
    		]         
      })
      });
</script>

******

## Predicted Drugs 

using Drug Pair Seeker (DPS) from [http://www.maayanlab.net/DPS/](http://www.maayanlab.net/DPS/) <code class="knitr inline">(Zhong, Chen, Liu, Chuang, Mallipattu, Tan, Clark, Deng, Klotman, Ma'ayan, and He, 2013)</code>.

[1] "DPS could not be found on the system"


******

# Drug matching based on overexpressed genes

<table id="dog_table">
 <thead>
  <tr>
   <th align="left"> Drug </th>
   <th align="left"> KEGG </th>
   <th align="left"> Drug_Function </th>
   <th align="left"> Target </th>
   <th align="right"> Target_FC </th>
   <th align="left"> Categorie </th>
  </tr>
 </thead>
<tbody>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00786' target="_blank" > Marimastat </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D03795' target="_blank" > D03795 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=MMP11' target="_blank" > MMP11 </a> </td>
   <td align="right"> 4.81 </td>
   <td align="left"> Antineoplastic Agents | Enzyme Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00381' target="_blank" > Amlodipine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00615' target="_blank" > D00615 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CACNA1B' target="_blank" > CACNA1B </a> </td>
   <td align="right"> 3.86 </td>
   <td align="left"> Antihypertensive Agents | Vasodilator Agents | Calcium Channel Blockers | Antianginals </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00661' target="_blank" > Verapamil </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02356' target="_blank" > D02356 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CACNA1B' target="_blank" > CACNA1B </a> </td>
   <td align="right"> 3.86 </td>
   <td align="left"> Vasodilator Agents | Antiarrhythmic Agents | Calcium Channel Blockers | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00996' target="_blank" > Gabapentin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00332' target="_blank" > D00332 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CACNA1B' target="_blank" > CACNA1B </a> </td>
   <td align="right"> 3.86 </td>
   <td align="left"> Anti-anxiety Agents | Anticonvulsants | Antiparkinson Agents | Analgesics | Calcium Channel Blockers | Antimanic Agents | Excitatory Amino Acid Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01202' target="_blank" > Levetiracetam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00709' target="_blank" > D00709 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CACNA1B' target="_blank" > CACNA1B </a> </td>
   <td align="right"> 3.86 </td>
   <td align="left"> Anticonvulsants | Nootropic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00284' target="_blank" > Acarbose </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00216' target="_blank" > D00216 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=MGAM' target="_blank" > MGAM </a> </td>
   <td align="right"> 3.76 </td>
   <td align="left"> Hypoglycemic Agents | Enzyme Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00491' target="_blank" > Miglitol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00625' target="_blank" > D00625 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=MGAM' target="_blank" > MGAM </a> </td>
   <td align="right"> 3.76 </td>
   <td align="left"> Hypoglycemic Agents | Anti-Bacterial Agents | Enzyme Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB04878' target="_blank" > Voglibose </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01665' target="_blank" > D01665 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=MGAM' target="_blank" > MGAM </a> </td>
   <td align="right"> 3.76 </td>
   <td align="left"> Hypoglycemic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00246' target="_blank" > Ziprasidone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01939' target="_blank" > D01939 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antipsychotics | Dopamine Antagonists | Serotonin Antagonists | Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00334' target="_blank" > Olanzapine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00454' target="_blank" > D00454 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antiemetics | Antipsychotics | Antipsychotic Agents | Serotonin Uptake Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00363' target="_blank" > Clozapine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00283' target="_blank" > D00283 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antipsychotics | Serotonin Antagonists | Antipsychotic Agents | GABA Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00477' target="_blank" > Chlorpromazine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00270' target="_blank" > D00270 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antiemetics | Antipsychotics | Dopamine Antagonists | Phenothiazines | Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00540' target="_blank" > Nortriptyline </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00816' target="_blank" > D00816 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antidepressants | Adrenergic Uptake Inhibitors | Antidepressive Agents, Tricyclic | Norepinephrine-Reuptake Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00726' target="_blank" > Trimipramine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00394' target="_blank" > D00394 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antidepressants | Adrenergic Uptake Inhibitors | Antidepressive Agents, Tricyclic | Norepinephrine-Reuptake Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00734' target="_blank" > Risperidone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00426' target="_blank" > D00426 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antipsychotics | Dopamine Antagonists | Serotonin Antagonists | Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00866' target="_blank" > Alprenolol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01182' target="_blank" > D01182 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antihypertensive Agents | Adrenergic beta-Antagonists | Sympatholytics | Antiarrhythmic Agents | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00960' target="_blank" > Pindolol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00513' target="_blank" > D00513 </a> </td>
   <td align="left"> partial agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antihypertensive Agents | Adrenergic beta-Antagonists | Vasodilator Agents | Serotonin Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01142' target="_blank" > Doxepin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07875' target="_blank" > D07875 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antidepressants | Anti-anxiety Agents | Antipruritics | Antidepressive Agents, Tricyclic | Norepinephrine-Reuptake Inhibitors | Histamine Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01149' target="_blank" > Nefazodone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00819' target="_blank" > D00819 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antidepressants | Analgesics | Antidepressive Agents, Second-Generation | Serotonin Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01224' target="_blank" > Quetiapine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00458' target="_blank" > D00458 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antipsychotics | Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01238' target="_blank" > Aripiprazole </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01164' target="_blank" > D01164 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antipsychotics | Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01267' target="_blank" > Paliperidone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D05339' target="_blank" > D05339 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01359' target="_blank" > Penbutolol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00602' target="_blank" > D00602 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antihypertensive Agents | Adrenergic beta-Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01614' target="_blank" > Acepromazine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02604' target="_blank" > D02604 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Dopamine Antagonists | Antipsychotic Agents | Sedatives and Hypnotics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01616' target="_blank" > Alverine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07440' target="_blank" > D07440 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antispasmodics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01618' target="_blank" > Molindone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08226' target="_blank" > D08226 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01621' target="_blank" > Pipotiazine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08385' target="_blank" > D08385 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Phenothiazines | Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01622' target="_blank" > Thioproperazine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08585' target="_blank" > D08585 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Phenothiazines | Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB04946' target="_blank" > Iloperidone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02666' target="_blank" > D02666 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB06216' target="_blank" > Asenapine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02995' target="_blank" > D02995 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antimanic Agents | Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB08815' target="_blank" > Lurasidone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D04820' target="_blank" > D04820 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Antipsychotic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB06148' target="_blank" > Mianserin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08216' target="_blank" > D08216 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=HTR1A' target="_blank" > HTR1A </a> </td>
   <td align="right"> 3.62 </td>
   <td align="left"> Serotonin Antagonists | Histamine H1 Antagonists | Adrenergic alpha-Antagonists | Antidepressive Agents, Second-Generation </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01223' target="_blank" > Aminophylline </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00227' target="_blank" > D00227 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADORA3' target="_blank" > ADORA3 </a> </td>
   <td align="right"> 2.94 </td>
   <td align="left"> Phosphodiesterase Inhibitors | Bronchodilator Agents | Cardiotonic Agents | Respiratory Smooth Muscle Relaxants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00028' target="_blank" > Intravenous Immunoglobulin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:NA' target="_blank" > NA </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=FCGR2C' target="_blank" > FCGR2C </a> </td>
   <td align="right"> 2.79 </td>
   <td align="left"> Immunomodulatory Agents | Anti-Infectives </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00786' target="_blank" > Marimastat </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D03795' target="_blank" > D03795 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=MMP13' target="_blank" > MMP13 </a> </td>
   <td align="right"> 3.32 </td>
   <td align="left"> Antineoplastic Agents | Enzyme Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00028' target="_blank" > Intravenous Immunoglobulin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:NA' target="_blank" > NA </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=FCGR3A' target="_blank" > FCGR3A </a> </td>
   <td align="right"> 2.86 </td>
   <td align="left"> Immunomodulatory Agents | Anti-Infectives </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01611' target="_blank" > Hydroxychloroquine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08050' target="_blank" > D08050 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=TLR7' target="_blank" > TLR7 </a> </td>
   <td align="right"> 3.02 </td>
   <td align="left"> Antirheumatic Agents | Enzyme Inhibitors | Antimalarials | Dermatologic Agents | Antiprotozoal Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00028' target="_blank" > Intravenous Immunoglobulin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:NA' target="_blank" > NA </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=FCGR1A' target="_blank" > FCGR1A </a> </td>
   <td align="right"> 2.44 </td>
   <td align="left"> Immunomodulatory Agents | Anti-Infectives </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00707' target="_blank" > Porfimer </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D03327' target="_blank" > D03327 </a> </td>
   <td align="left"> other/unknown </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=FCGR1A' target="_blank" > FCGR1A </a> </td>
   <td align="right"> 2.44 </td>
   <td align="left"> Antineoplastic Agents | Antiviral Agents | Dermatologic Agents | Photosensitizing Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00992' target="_blank" > Methyl aminolevulinate </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D04988' target="_blank" > D04988 </a> </td>
   <td align="left"> antibody </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=FCGR1A' target="_blank" > FCGR1A </a> </td>
   <td align="right"> 2.44 </td>
   <td align="left"> Antineoplastic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00436' target="_blank" > Bendroflumethiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00650' target="_blank" > D00650 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Diuretics, Thiazide | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00524' target="_blank" > Metolazone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00431' target="_blank" > D00431 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Diuretics, Sulfamyl </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00562' target="_blank" > Benzthiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00651' target="_blank" > D00651 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Antihypertensive Agents | Stimulants | Diuretics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00880' target="_blank" > Chlorothiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00519' target="_blank" > D00519 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Diuretics, Thiazide | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00999' target="_blank" > Hydrochlorothiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00340' target="_blank" > D00340 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01324' target="_blank" > Polythiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00657' target="_blank" > D00657 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01325' target="_blank" > Quinethazone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00461' target="_blank" > D00461 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Antihypertensive Agents | Diuretics, Thiazide </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00232' target="_blank" > Methyclothiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00656' target="_blank" > D00656 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Diuretics | Diuretics, Thiazide | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00310' target="_blank" > Chlorthalidone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00272' target="_blank" > D00272 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00774' target="_blank" > Hydroflumethiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00654' target="_blank" > D00654 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Diuretics, Thiazide | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01021' target="_blank" > Trichlormethiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00658' target="_blank" > D00658 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A3' target="_blank" > SLC12A3 </a> </td>
   <td align="right"> 3.05 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00050' target="_blank" > Cetrorelix </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01685' target="_blank" > D01685 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GNRHR' target="_blank" > GNRHR </a> </td>
   <td align="right"> 2.97 </td>
   <td align="left"> Infertility Agents | Hormone Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00106' target="_blank" > Abarelix </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02738' target="_blank" > D02738 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GNRHR' target="_blank" > GNRHR </a> </td>
   <td align="right"> 2.97 </td>
   <td align="left"> Antineoplastic Agents | Anti-Testosterone Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB06699' target="_blank" > Degarelix </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08901' target="_blank" > D08901 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GNRHR' target="_blank" > GNRHR </a> </td>
   <td align="right"> 2.97 </td>
   <td align="left"> Antineoplastic Agents | Gonadotropin Releasing Hormone Antagonist </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00652' target="_blank" > Pentazocine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00498' target="_blank" > D00498 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=OPRM1' target="_blank" > OPRM1 </a> </td>
   <td align="right"> 2.79 </td>
   <td align="left"> Narcotics | Adjuvants, Anesthesia | Analgesics, Opioid | Narcotic Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00704' target="_blank" > Naltrexone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D05113' target="_blank" > D05113 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=OPRM1' target="_blank" > OPRM1 </a> </td>
   <td align="right"> 2.79 </td>
   <td align="left"> Anti-craving Agents | Narcotic Antagonists | Depressants | Alcohol Antagonists | Opiate Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00844' target="_blank" > Nalbuphine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08246' target="_blank" > D08246 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=OPRM1' target="_blank" > OPRM1 </a> </td>
   <td align="right"> 2.79 </td>
   <td align="left"> Narcotics | Analgesics, Opioid | Narcotic Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01183' target="_blank" > Naloxone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08249' target="_blank" > D08249 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=OPRM1' target="_blank" > OPRM1 </a> </td>
   <td align="right"> 2.79 </td>
   <td align="left"> Antinarcotic Agents | Narcotic Antagonists | Antidotes | Depressants | Opiate Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB06274' target="_blank" > Alvimopan </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02878' target="_blank" > D02878 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=OPRM1' target="_blank" > OPRM1 </a> </td>
   <td align="right"> 2.79 </td>
   <td align="left"> Opiate Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB06800' target="_blank" > Methylnaltrexone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D06618' target="_blank" > D06618 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=OPRM1' target="_blank" > OPRM1 </a> </td>
   <td align="right"> 2.79 </td>
   <td align="left"> Gastrointestinal Agents | Opiate Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00302' target="_blank" > Tranexamic Acid </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01136' target="_blank" > D01136 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=PLG' target="_blank" > PLG </a> </td>
   <td align="right"> 2.91 </td>
   <td align="left"> Antifibrinolytic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00513' target="_blank" > Aminocaproic Acid </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00160' target="_blank" > D00160 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=PLG' target="_blank" > PLG </a> </td>
   <td align="right"> 2.91 </td>
   <td align="left"> Antifibrinolytic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00548' target="_blank" > Azelaic Acid </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D03034' target="_blank" > D03034 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=TYR' target="_blank" > TYR </a> </td>
   <td align="right"> 2.64 </td>
   <td align="left"> Antineoplastic Agents | Dermatologic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00600' target="_blank" > Monobenzone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D05072' target="_blank" > D05072 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=TYR' target="_blank" > TYR </a> </td>
   <td align="right"> 2.64 </td>
   <td align="left"> Dermatologicals </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01055' target="_blank" > Mimosine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:NA' target="_blank" > NA </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=TYR' target="_blank" > TYR </a> </td>
   <td align="right"> 2.64 </td>
   <td align="left"> Antineoplastic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01281' target="_blank" > Abatacept </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D03203' target="_blank" > D03203 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CD80' target="_blank" > CD80 </a> </td>
   <td align="right"> 2.59 </td>
   <td align="left"> Antirheumatic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00887' target="_blank" > Bumetanide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00247' target="_blank" > D00247 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SLC12A5' target="_blank" > SLC12A5 </a> </td>
   <td align="right"> 2.25 </td>
   <td align="left"> Diuretics | Diuretics, Sulfamyl | Sodium Potassium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00421' target="_blank" > Spironolactone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00443' target="_blank" > D00443 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=AR' target="_blank" > AR </a> </td>
   <td align="right"> 2.18 </td>
   <td align="left"> Diuretics | Aldosterone Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00499' target="_blank" > Flutamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00586' target="_blank" > D00586 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=AR' target="_blank" > AR </a> </td>
   <td align="right"> 2.18 </td>
   <td align="left"> Antineoplastic Agents, Hormonal | Androgen Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00665' target="_blank" > Nilutamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00965' target="_blank" > D00965 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=AR' target="_blank" > AR </a> </td>
   <td align="right"> 2.18 </td>
   <td align="left"> Antineoplastic Agents | Androgen Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01128' target="_blank" > Bicalutamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00961' target="_blank" > D00961 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=AR' target="_blank" > AR </a> </td>
   <td align="right"> 2.18 </td>
   <td align="left"> Antineoplastic Agents | Androgen Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01395' target="_blank" > Drospirenone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D03917' target="_blank" > D03917 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=AR' target="_blank" > AR </a> </td>
   <td align="right"> 2.18 </td>
   <td align="left"> Progestins | Aldosterone Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB04839' target="_blank" > Cyproterone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07766' target="_blank" > D07766 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=AR' target="_blank" > AR </a> </td>
   <td align="right"> 2.18 </td>
   <td align="left"> Androgen Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB08899' target="_blank" > Enzalutamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D10218' target="_blank" > D10218 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=AR' target="_blank" > AR </a> </td>
   <td align="right"> 2.18 </td>
   <td align="left"> Antineoplastic </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01011' target="_blank" > Metyrapone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00410' target="_blank" > D00410 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CYP11B1' target="_blank" > CYP11B1 </a> </td>
   <td align="right"> 2.30 </td>
   <td align="left"> Antimetabolites | Enzyme Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00284' target="_blank" > Acarbose </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00216' target="_blank" > D00216 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SI' target="_blank" > SI </a> </td>
   <td align="right"> 2.30 </td>
   <td align="left"> Hypoglycemic Agents | Enzyme Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00747' target="_blank" > Scopolamine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00138' target="_blank" > D00138 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SI' target="_blank" > SI </a> </td>
   <td align="right"> 2.30 </td>
   <td align="left"> Mydriatics | Adjuvants, Anesthesia | Muscarinic Antagonists | Antispasmodics | Cholinergic Antagonists | Antimuscarinics | Adjuvants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00232' target="_blank" > Methyclothiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00656' target="_blank" > D00656 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Diuretics | Diuretics, Thiazide | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00311' target="_blank" > Ethoxzolamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02441' target="_blank" > D02441 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Diuretics | Carbonic Anhydrase Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00381' target="_blank" > Amlodipine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00615' target="_blank" > D00615 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Vasodilator Agents | Calcium Channel Blockers | Antianginals </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00423' target="_blank" > Methocarbamol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00402' target="_blank" > D00402 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Muscle Relaxants, Central </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00436' target="_blank" > Bendroflumethiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00650' target="_blank" > D00650 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Diuretics, Thiazide | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00562' target="_blank" > Benzthiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00651' target="_blank" > D00651 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Stimulants | Diuretics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00606' target="_blank" > Cyclothiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01256' target="_blank" > D01256 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Diuretics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00703' target="_blank" > Methazolamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00655' target="_blank" > D00655 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Diuretics | Carbonic Anhydrase Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00774' target="_blank" > Hydroflumethiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00654' target="_blank" > D00654 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Diuretics, Thiazide | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00819' target="_blank" > Acetazolamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00218' target="_blank" > D00218 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Anticonvulsants | Diuretics | Carbonic Anhydrase Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00869' target="_blank" > Dorzolamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07871' target="_blank" > D07871 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Carbonic Anhydrase Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00880' target="_blank" > Chlorothiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00519' target="_blank" > D00519 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Diuretics, Thiazide | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00909' target="_blank" > Zonisamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00538' target="_blank" > D00538 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antioxidants | Anticonvulsants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00999' target="_blank" > Hydrochlorothiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00340' target="_blank" > D00340 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01021' target="_blank" > Trichlormethiazide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00658' target="_blank" > D00658 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Diuretics | Sodium Chloride Symporter Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01031' target="_blank" > Ethinamate </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00703' target="_blank" > D00703 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Hypnotics and Sedatives </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01119' target="_blank" > Diazoxide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00294' target="_blank" > D00294 </a> </td>
   <td align="left"> inducer </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Vasodilator Agents | Diuretics, Thiazide </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01144' target="_blank" > Dichlorphenamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00518' target="_blank" > D00518 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Carbonic Anhydrase Inhibitors | Antiglaucomic Agents | Ophthalmics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01194' target="_blank" > Brinzolamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00652' target="_blank" > D00652 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Carbonic Anhydrase Inhibitors | Antiglaucomic Agents | Ophthalmics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01325' target="_blank" > Quinethazone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00461' target="_blank" > D00461 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CA1' target="_blank" > CA1 </a> </td>
   <td align="right"> 2.57 </td>
   <td align="left"> Antihypertensive Agents | Diuretics, Thiazide </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00028' target="_blank" > Intravenous Immunoglobulin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:NA' target="_blank" > NA </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=FCGR2A' target="_blank" > FCGR2A </a> </td>
   <td align="right"> 1.98 </td>
   <td align="left"> Immunomodulatory Agents | Anti-Infectives </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB04552' target="_blank" > Niflumic Acid </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08275' target="_blank" > D08275 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CLCA1' target="_blank" > CLCA1 </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Cyclooxygenase Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00281' target="_blank" > Lidocaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00358' target="_blank" > D00358 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Antiarrhythmic Agents | Anesthetics | Anesthetics, Local | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00296' target="_blank" > Ropivacaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D04048' target="_blank" > D04048 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Anesthetics | Local Anesthetics | Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00297' target="_blank" > Bupivacaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01450' target="_blank" > D01450 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00473' target="_blank" > Hexylcaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02454' target="_blank" > D02454 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Anesthetics | Local Anesthetics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00527' target="_blank" > Dibucaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00733' target="_blank" > D00733 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00645' target="_blank" > Dyclonine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00735' target="_blank" > D00735 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Anesthetics, Local | Anesthetics, Mucosal-Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00721' target="_blank" > Procaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00740' target="_blank" > D00740 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Anesthetics | Local Anesthetics | Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00807' target="_blank" > Proparacaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08448' target="_blank" > D08448 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Local Anesthetics | Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00892' target="_blank" > Oxybuprocaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01768' target="_blank" > D01768 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00907' target="_blank" > Cocaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00110' target="_blank" > D00110 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Vasoconstrictor Agents | Dopamine Uptake Inhibitors | Anesthetics | Local Anesthetics | Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00961' target="_blank" > Mepivacaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00738' target="_blank" > D00738 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01002' target="_blank" > Levobupivacaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01287' target="_blank" > D01287 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Anesthetics | Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01086' target="_blank" > Benzocaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00552' target="_blank" > D00552 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Antipruritics | Anesthetics | Local Anesthetics | Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01161' target="_blank" > Chloroprocaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00732' target="_blank" > D00732 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01173' target="_blank" > Orphenadrine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00774' target="_blank" > D00774 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN10A' target="_blank" > SCN10A </a> </td>
   <td align="right"> 2.41 </td>
   <td align="left"> Skeletal Muscle Relaxants | Antiparkinson Agents | Antidyskinetics | Muscarinic Antagonists | Muscle Relaxants, Central | Parasympatholytics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00675' target="_blank" > Tamoxifen </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00966' target="_blank" > D00966 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ESR1' target="_blank" > ESR1 </a> </td>
   <td align="right"> 1.82 </td>
   <td align="left"> Antineoplastic Agents, Hormonal | Selective Estrogen Receptor Modulators | Estrogen Antagonists | Bone Density Conservation Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00882' target="_blank" > Clomifene </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00962' target="_blank" > D00962 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ESR1' target="_blank" > ESR1 </a> </td>
   <td align="right"> 1.82 </td>
   <td align="left"> Selective Estrogen Receptor Modulators | Estrogen Antagonists | Fertility Agents, Female </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00947' target="_blank" > Fulvestrant </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01161' target="_blank" > D01161 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ESR1' target="_blank" > ESR1 </a> </td>
   <td align="right"> 1.82 </td>
   <td align="left"> Antineoplastic Agents | Antineoplastic Agents, Hormonal | Estrogen Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01065' target="_blank" > Melatonin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08170' target="_blank" > D08170 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ESR1' target="_blank" > ESR1 </a> </td>
   <td align="right"> 1.82 </td>
   <td align="left"> Antioxidants | Free Radical Scavengers | Anticonvulsants | Adjuvants, Immunologic | Central Nervous System Depressants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01183' target="_blank" > Naloxone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08249' target="_blank" > D08249 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ESR1' target="_blank" > ESR1 </a> </td>
   <td align="right"> 1.82 </td>
   <td align="left"> Antinarcotic Agents | Narcotic Antagonists | Antidotes | Depressants | Opiate Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01185' target="_blank" > Fluoxymesterone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00327' target="_blank" > D00327 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ESR1' target="_blank" > ESR1 </a> </td>
   <td align="right"> 1.82 </td>
   <td align="left"> Anabolic Agents | Antineoplastic Agents, Hormonal </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB04938' target="_blank" > Ospemifene </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08958' target="_blank" > D08958 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ESR1' target="_blank" > ESR1 </a> </td>
   <td align="right"> 1.82 </td>
   <td align="left"> Estrogen receptor agonist/antagonist </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01016' target="_blank" > Glyburide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00336' target="_blank" > D00336 </a> </td>
   <td align="left"> modulator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ABCB11' target="_blank" > ABCB11 </a> </td>
   <td align="right"> 2.45 </td>
   <td align="left"> Hypoglycemic Agents | Antiarrhythmic Agents | Sulfonylureas </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01016' target="_blank" > Glyburide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00336' target="_blank" > D00336 </a> </td>
   <td align="left"> modulator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=KCNJ5' target="_blank" > KCNJ5 </a> </td>
   <td align="right"> 2.29 </td>
   <td align="left"> Hypoglycemic Agents | Antiarrhythmic Agents | Sulfonylureas </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00192' target="_blank" > Indecainide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D04521' target="_blank" > D04521 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Antidysrhythmic Agents | Sodium channel blockers </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00243' target="_blank" > Ranolazine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D05700' target="_blank" > D05700 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Enzyme Inhibitors </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00252' target="_blank" > Phenytoin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00512' target="_blank" > D00512 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anticonvulsants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00280' target="_blank" > Disopyramide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00303' target="_blank" > D00303 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Antiarrhythmic Agents | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00281' target="_blank" > Lidocaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00358' target="_blank" > D00358 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Antiarrhythmic Agents | Anesthetics | Anesthetics, Local | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00379' target="_blank" > Mexiletine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00639' target="_blank" > D00639 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00473' target="_blank" > Hexylcaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02454' target="_blank" > D02454 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anesthetics | Local Anesthetics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00527' target="_blank" > Dibucaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00733' target="_blank" > D00733 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00532' target="_blank" > Mephenytoin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00375' target="_blank" > D00375 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anticonvulsants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00564' target="_blank" > Carbamazepine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00252' target="_blank" > D00252 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anticonvulsants | Analgesics | Antimanic Agents | Analgesics, Non-Narcotic </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00680' target="_blank" > Moricizine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D05077' target="_blank" > D05077 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00740' target="_blank" > Riluzole </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00775' target="_blank" > D00775 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anticonvulsants | Neuroprotective Agents | Anesthetics | Excitatory Amino Acid Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00750' target="_blank" > Prilocaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00553' target="_blank" > D00553 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anesthetics | Local Anesthetics | Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00754' target="_blank" > Ethotoin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00708' target="_blank" > D00708 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anticonvulsants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00776' target="_blank" > Oxcarbazepine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00533' target="_blank" > D00533 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anticonvulsants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00868' target="_blank" > Benzonatate </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00242' target="_blank" > D00242 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Antitussives </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00907' target="_blank" > Cocaine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00110' target="_blank" > D00110 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Vasoconstrictor Agents | Dopamine Uptake Inhibitors | Anesthetics | Local Anesthetics | Anesthetics, Local </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00908' target="_blank" > Quinidine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00642' target="_blank" > D00642 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Enzyme Inhibitors | Antiarrhythmic Agents | Antimalarials | Muscarinic Antagonists | Adrenergic alpha-Antagonists | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00909' target="_blank" > Zonisamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00538' target="_blank" > D00538 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Antioxidants | Anticonvulsants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01035' target="_blank" > Procainamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00477' target="_blank" > D00477 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Antiarrhythmic Agents | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01056' target="_blank" > Tocainide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D06172' target="_blank" > D06172 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Sodium channel blockers | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01182' target="_blank" > Propafenone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00640' target="_blank" > D00640 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01195' target="_blank" > Flecainide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07962' target="_blank" > D07962 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Antiarrhythmic Agents | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01228' target="_blank" > Encainide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D03991' target="_blank" > D03991 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Sodium channel blockers | Antiarrhythmic Agents | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01320' target="_blank" > Fosphenytoin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07993' target="_blank" > D07993 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anticonvulsants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01346' target="_blank" > Quinidine barbiturate </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:NA' target="_blank" > NA </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left">  </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01426' target="_blank" > Ajmaline </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00199' target="_blank" > D00199 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Antiarrhythmic Agents | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01429' target="_blank" > Aprindine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01326' target="_blank" > D01326 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=SCN5A' target="_blank" > SCN5A </a> </td>
   <td align="right"> 2.16 </td>
   <td align="left"> Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00568' target="_blank" > Cinnarizine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01295' target="_blank" > D01295 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CACNA1I' target="_blank" > CACNA1I </a> </td>
   <td align="right"> 2.20 </td>
   <td align="left"> Calcium Channel Blockers | Anti-Allergic Agents | Histamine H1 Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00617' target="_blank" > Paramethadione </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00495' target="_blank" > D00495 </a> </td>
   <td align="left"> suppressor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CACNA1I' target="_blank" > CACNA1I </a> </td>
   <td align="right"> 2.20 </td>
   <td align="left"> Anticonvulsants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00661' target="_blank" > Verapamil </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02356' target="_blank" > D02356 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CACNA1I' target="_blank" > CACNA1I </a> </td>
   <td align="right"> 2.20 </td>
   <td align="left"> Vasodilator Agents | Antiarrhythmic Agents | Calcium Channel Blockers | Anti-Arrhythmia Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00909' target="_blank" > Zonisamide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00538' target="_blank" > D00538 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CACNA1I' target="_blank" > CACNA1I </a> </td>
   <td align="right"> 2.20 </td>
   <td align="left"> Antioxidants | Anticonvulsants </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB04841' target="_blank" > Flunarizine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01303' target="_blank" > D01303 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=CACNA1I' target="_blank" > CACNA1I </a> </td>
   <td align="right"> 2.20 </td>
   <td align="left"> Anticonvulsants | Vasodilator Agents | Calcium Channel Blockers | Histamine H1 Antagonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00559' target="_blank" > Bosentan </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01227' target="_blank" > D01227 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=EDNRA' target="_blank" > EDNRA </a> </td>
   <td align="right"> 1.87 </td>
   <td align="left"> Antihypertensive Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB06268' target="_blank" > Sitaxentan </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07171' target="_blank" > D07171 </a> </td>
   <td align="left"> antagonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=EDNRA' target="_blank" > EDNRA </a> </td>
   <td align="right"> 1.87 </td>
   <td align="left">  </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00186' target="_blank" > Lorazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00365' target="_blank" > D00365 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | Antiemetics | Anticonvulsants | Benzodiazepines | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00231' target="_blank" > Temazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00370' target="_blank" > D00370 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | Benzodiazepines | Adjuvants, Anesthesia | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00349' target="_blank" > Clobazam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01253' target="_blank" > D01253 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anticonvulsants | Benzodiazepines </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00404' target="_blank" > Alprazolam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00225' target="_blank" > D00225 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | Benzodiazepines | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00475' target="_blank" > Chlordiazepoxide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00267' target="_blank" > D00267 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | Benzodiazepines | Adjuvants, Anesthesia | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00546' target="_blank" > Adinazolam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02770' target="_blank" > D02770 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Antidepressive Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00628' target="_blank" > Clorazepate </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00694' target="_blank" > D00694 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Anticonvulsants | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00683' target="_blank" > Midazolam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00550' target="_blank" > D00550 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | Adjuvants, Anesthesia | GABA Modulators | Anesthetics, Intravenous </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00690' target="_blank" > Flurazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00329' target="_blank" > D00329 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00801' target="_blank" > Halazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00338' target="_blank" > D00338 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Muscle Relaxants | Benzodiazepines | Sedative </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00829' target="_blank" > Diazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00293' target="_blank" > D00293 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | Antiemetics | Anticonvulsants | Adjuvants, Anesthesia | GABA Modulators | Anesthetics, Intravenous | Muscle Relaxants, Central </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00842' target="_blank" > Oxazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00464' target="_blank" > D00464 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00897' target="_blank" > Triazolam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00387' target="_blank" > D00387 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Benzodiazepines | Adjuvants, Anesthesia | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01068' target="_blank" > Clonazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00280' target="_blank" > D00280 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anticonvulsants | Benzodiazepines | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01215' target="_blank" > Estazolam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00311' target="_blank" > D00311 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Anticonvulsants | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01558' target="_blank" > Bromazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01245' target="_blank" > D01245 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | Benzodiazepines | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01559' target="_blank" > Clotiazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:NA' target="_blank" > NA </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | Anticonvulsants | Benzodiazepines </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01567' target="_blank" > Fludiazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01354' target="_blank" > D01354 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Benzodiazepines </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01588' target="_blank" > Prazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00470' target="_blank" > D00470 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01589' target="_blank" > Quazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00457' target="_blank" > D00457 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | Benzodiazepines | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01594' target="_blank" > Cinolazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:NA' target="_blank" > NA </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anticonvulsants | Benzodiazepines | Sedatives and Hypnotics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01595' target="_blank" > Nitrazepam </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00531' target="_blank" > D00531 </a> </td>
   <td align="left"> potentiator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=GABRP' target="_blank" > GABRP </a> </td>
   <td align="right"> -4.56 </td>
   <td align="left"> Anti-anxiety Agents | Hypnotics and Sedatives | Anticonvulsants | GABA Modulators </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00321' target="_blank" > Amitriptyline </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00809' target="_blank" > D00809 </a> </td>
   <td align="left"> inhibitor </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=NTRK2' target="_blank" > NTRK2 </a> </td>
   <td align="right"> -2.40 </td>
   <td align="left"> Adrenergic Uptake Inhibitors | Analgesics, Non-Narcotic | Antidepressive Agents, Tricyclic </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00107' target="_blank" > Oxytocin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00089' target="_blank" > D00089 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=OXTR' target="_blank" > OXTR </a> </td>
   <td align="right"> -2.87 </td>
   <td align="left"> Anti-tocolytic Agents | Labor Induction Agents | Oxytocics </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01282' target="_blank" > Carbetocin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07229' target="_blank" > D07229 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=OXTR' target="_blank" > OXTR </a> </td>
   <td align="right"> -2.87 </td>
   <td align="left"> Anti-tocolytic Agents | Labor Induction Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00288' target="_blank" > Amcinonide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01387' target="_blank" > D01387 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ANXA1' target="_blank" > ANXA1 </a> </td>
   <td align="right"> -1.82 </td>
   <td align="left"> Corticosteroids, topical </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00741' target="_blank" > Hydrocortisone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00088' target="_blank" > D00088 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ANXA1' target="_blank" > ANXA1 </a> </td>
   <td align="right"> -1.82 </td>
   <td align="left"> Anti-inflammatory Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01234' target="_blank" > Dexamethasone </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00292' target="_blank" > D00292 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ANXA1' target="_blank" > ANXA1 </a> </td>
   <td align="right"> -1.82 </td>
   <td align="left"> Anti-inflammatory Agents | Adrenergic Agents | Antiemetics | Antineoplastic Agents, Hormonal | Glucocorticoids </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01278' target="_blank" > Pramlintide </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D05595' target="_blank" > D05595 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=RAMP3' target="_blank" > RAMP3 </a> </td>
   <td align="right"> -1.55 </td>
   <td align="left">  </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00368' target="_blank" > Norepinephrine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00076' target="_blank" > D00076 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Vasoconstrictor Agents | Sympathomimetics | Adrenergic alpha-Agonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00449' target="_blank" > Dipivefrin </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02349' target="_blank" > D02349 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Sympathomimetics | Ophthalmologicals | Adrenergic Agonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00668' target="_blank" > Epinephrine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00095' target="_blank" > D00095 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Vasoconstrictor Agents | Sympathomimetics | Adrenergic alpha-Agonists | Mydriatics | Bronchodilator Agents | Adrenergic beta-Agonists | Adrenergic Agonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00816' target="_blank" > Orciprenaline </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00685' target="_blank" > D00685 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Sympathomimetics | Bronchodilator Agents | Adrenergic beta-Agonists | Tocolytic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00841' target="_blank" > Dobutamine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D03879' target="_blank" > D03879 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Sympathomimetics | Adrenergic beta-Agonists | Cardiotonic Agents | Sympathomimetic </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00867' target="_blank" > Ritodrine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02359' target="_blank" > D02359 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Sympathomimetics | Adrenergic beta-Agonists | Tocolytic Agents | Sympathomimetic </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00871' target="_blank" > Terbutaline </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00688' target="_blank" > D00688 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Sympathomimetics | Bronchodilator Agents | Adrenergic beta-Agonists | Tocolytic Agents | Sympathomimetic </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00938' target="_blank" > Salmeterol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D05792' target="_blank" > D05792 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Bronchodilator Agents | Adrenergic beta-Agonists | Sympathomimetic </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00983' target="_blank" > Formoterol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01373' target="_blank" > D01373 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Bronchodilator Agents | Adrenergic beta-Agonists | Sympathomimetic </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01001' target="_blank" > Salbutamol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02147' target="_blank" > D02147 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Bronchodilator Agents | Adrenergic beta-Agonists | Tocolytic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01064' target="_blank" > Isoproterenol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01390' target="_blank" > D01390 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Sympathomimetics | Bronchodilator Agents | Adrenergic beta-Agonists | Cardiotonic Agents | Sympathomimetic </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01102' target="_blank" > Arbutamine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D02976' target="_blank" > D02976 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Adrenergic beta-Agonists | Cardiotonic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01274' target="_blank" > Arformoterol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07463' target="_blank" > D07463 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Bronchodilator Agents | Adrenergic beta-Agonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01288' target="_blank" > Fenoterol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:NA' target="_blank" > NA </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Sympathomimetics | Bronchodilator Agents | Adrenergic beta-Agonists | Tocolytic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01291' target="_blank" > Pirbuterol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08387' target="_blank" > D08387 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Bronchodilator Agents | Adrenergic beta-Agonists | Cardiotonic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01363' target="_blank" > Ephedra </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:NA' target="_blank" > NA </a> </td>
   <td align="left"> negative modulator </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left">  </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01366' target="_blank" > Procaterol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D08424' target="_blank" > D08424 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Sympathomimetics | Bronchodilator Agents | Adrenergic beta-Agonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01407' target="_blank" > Clenbuterol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07713' target="_blank" > D07713 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Sympathomimetics | Bronchodilator Agents | Adrenergic beta-Agonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01408' target="_blank" > Bambuterol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D07377' target="_blank" > D07377 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Sympathomimetics | Bronchodilator Agents | Adrenergic beta-Agonists | Tocolytic Agents </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB05039' target="_blank" > Indacaterol </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D09318' target="_blank" > D09318 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Anti-Asthmatic Agents | Bronchodilator Agents | Adrenergic beta-Agonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB06262' target="_blank" > Droxidopa </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D01277' target="_blank" > D01277 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Vasoconstrictor Agents | Sympathomimetics | Adrenergic alpha-Agonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB00221' target="_blank" > Isoetharine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D04625' target="_blank" > D04625 </a> </td>
   <td align="left"> agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Bronchodilator Agents | Adrenergic beta-Agonists </td>
  </tr>
  <tr>
   <td align="left"> <a href =  'http://www.drugbank.ca/drugs/DB01364' target="_blank" > Ephedrine </a> </td>
   <td align="left"> <a href =  'http://www.genome.jp/dbget-bin/www_bget?dr:D00124' target="_blank" > D00124 </a> </td>
   <td align="left"> inverse agonist </td>
   <td align="left"> <a href =  'http://www.ncbi.nlm.nih.gov/gene/?term=ADRB2' target="_blank" > ADRB2 </a> </td>
   <td align="right"> -1.91 </td>
   <td align="left"> Vasoconstrictor Agents | Adrenergic Agents | Central Nervous System Stimulants | Sympathomimetics </td>
  </tr>
</tbody>
</table>


<script type="text/javascript" charset="utf-8">
    $(document).ready(function() {
    var dogtable = $('#dog_table').dataTable({
        "sDom": 'T<"clear">lfrtip',
        "oTableTools": {
            "sSwfPath": "../media/swf/copy_csv_xls_pdf.swf",
            "aButtons": [
                "copy",
                "csv"
            ]
        }
      })
      });
</script>

******

# References 

[1] _Babraham Bioinformatics - FastQC A Quality Control tool for
High Throughput Sequence Data_. <URL:
http://www.bioinformatics.babraham.ac.uk/projects/fastqc>. 2014.
<URL: http://www.bioinformatics.babraham.ac.uk/projects/fastqc>.

[2] _HTSeq: Analysing high-throughput sequencing data with Python â
HTSeq v0.5.4p2 documentation_. <URL:
http://www-huber.embl.de/users/anders/HTSeq/doc/overview.html>.
2014. <URL:
http://www-huber.embl.de/users/anders/HTSeq/doc/overview.html>.

[3] _Picard_. <URL: http://picard.sourceforge.net/>. 2014. <URL:
http://picard.sourceforge.net/>.

[4] A. Dobin, C. A. Davis, F. Schlesinger, et al. "STAR: ultrafast
universal RNA-seq aligner". In: _Bioinformatics_ 29.1 (Oct. 2012),
pp. 15-21. DOI: 10.1093/bioinformatics/bts635. <URL:
http://dx.doi.org/10.1093/bioinformatics/bts635>.

[5] H. Edgren, A. Murumagi, S. Kangaspeska, et al. "Identification
of fusion genes in breast cancer by paired-end RNA-sequencing".
In: _Genome Biol_ 12.1 (2011), p. R6. DOI:
10.1186/gb-2011-12-1-r6. <URL:
http://dx.doi.org/10.1186/gb-2011-12-1-r6>.

[6] H. Li, B. Handsaker, A. Wysoker, et al. "The Sequence
Alignment/Map format and SAMtools". In: _Bioinformatics_ 25.16
(Jun. 2009), pp. 2078-2079. DOI: 10.1093/bioinformatics/btp352.
<URL: http://dx.doi.org/10.1093/bioinformatics/btp352>.

[7] M. Shugay, I. O. de Mendibil, J. L. Vizmanos, et al.
"Oncofuse: a computational framework for the prediction of the
oncogenic potential of gene fusions". In: _Bioinformatics_ 29.20
(Aug. 2013), pp. 2539-2546. DOI: 10.1093/bioinformatics/btt445.
<URL: http://dx.doi.org/10.1093/bioinformatics/btt445>.

[8] Y. Zhong, E. Y. Chen, R. Liu, et al. "Renoprotective Effect of
Combined Inhibition of Angiotensin-Converting Enzyme and Histone
Deacetylase". In: _Journal of the American Society of Nephrology_
24.5 (May. 2013), pp. 801-811. DOI: 10.1681/asn.2012060590. <URL:
http://dx.doi.org/10.1681/ASN.2012060590>.



# Session Info

<div class="chunk" id="unnamed-chunk-1"><div class="rcode"><div class="output"><pre class="knitr r">## R version 3.0.1 (2013-05-16)
## Platform: x86_64-unknown-linux-gnu (64-bit)
## 
## locale:
##  [1] LC_CTYPE=en_US.UTF-8       LC_NUMERIC=C              
##  [3] LC_TIME=en_US.UTF-8        LC_COLLATE=en_US.UTF-8    
##  [5] LC_MONETARY=en_US.UTF-8    LC_MESSAGES=en_US.UTF-8   
##  [7] LC_PAPER=C                 LC_NAME=C                 
##  [9] LC_ADDRESS=C               LC_TELEPHONE=C            
## [11] LC_MEASUREMENT=en_US.UTF-8 LC_IDENTIFICATION=C       
## 
## attached base packages:
## [1] splines   parallel  methods   stats     graphics  grDevices utils    
## [8] datasets  base     
## 
## other attached packages:
##  [1] stringr_0.6.2           igraph_0.7.1           
##  [3] ReactomePA_1.6.1        pathview_1.2.4         
##  [5] graphite_1.8.1          SPIA_2.14.0            
##  [7] KEGGgraph_1.20.0        graph_1.40.1           
##  [9] pamr_1.54.1             survival_2.37-7        
## [11] RJSONIO_1.3-0           DESeq2_1.2.10          
## [13] RcppArmadillo_0.4.320.0 Rcpp_0.11.2            
## [15] GenomicRanges_1.14.4    XVector_0.2.0          
## [17] IRanges_1.20.7          cluster_1.15.2         
## [19] RColorBrewer_1.0-5      edgeR_3.4.2            
## [21] limma_3.18.13           knitcitations_1.0-1    
## [23] KEGGREST_1.2.2          pander_0.3.8           
## [25] xtable_1.7-3            XML_3.98-1.1           
## [27] annotate_1.40.1         gdata_2.13.3           
## [29] dplyr_0.1.3.0.99        plyr_1.8.1             
## [31] data.table_1.9.2        org.Hs.eg.db_2.10.1    
## [33] RSQLite_0.11.4          DBI_0.2-7              
## [35] AnnotationDbi_1.24.0    DESeq_1.14.0           
## [37] lattice_0.20-29         locfit_1.5-9.1         
## [39] Biobase_2.22.0          BiocGenerics_0.8.0     
## [41] rCharts_0.4.2           yaml_2.1.13            
## [43] knitrBootstrap_0.9.0    knitr_1.6              
## 
## loaded via a namespace (and not attached):
##  [1] assertthat_0.1     bibtex_0.3-6       Biostrings_2.30.1 
##  [4] colorspace_1.2-4   digest_0.6.4       DO.db_2.7         
##  [7] DOSE_2.0.0         evaluate_0.5.5     formatR_0.10      
## [10] genefilter_1.44.0  geneplotter_1.40.0 ggplot2_1.0.0     
## [13] GO.db_2.10.1       GOSemSim_1.20.3    grid_3.0.1        
## [16] gtable_0.1.2       gtools_3.4.1       httr_0.4          
## [19] lubridate_1.3.3    markdown_0.7.2     MASS_7.3-33       
## [22] memoise_0.2.1      munsell_0.4.2      png_0.1-7         
## [25] proto_0.3-10       qvalue_1.36.0      RCurl_1.95-4.3    
## [28] reactome.db_1.46.1 RefManageR_0.8.3   reshape2_1.4      
## [31] Rgraphviz_2.8.1    scales_0.2.4       stats4_3.0.1      
## [34] tcltk_3.0.1        tools_3.0.1        whisker_0.3-2
</pre></div>
<div class="output"><pre class="knitr r">## [1] "Thu Aug 14 10:59:57 2014"
</pre></div>
</div></div>
