# oolib/plugs/mail.py
#
#

""" slurp and send. """

## oolib imports

from oolib.utils import striphtml, str2stamp, j, emailtime, error, emailstamp
from oolib import cmnds, Base

## generic imports

import email
import email.message
import logging
import time
import os

## Class Email

class Email(Base):

    def get_attr(self, attr):
        for line in self.text.splitlines():
            try: key, val = line.split(":", 1)
            except ValueError: continue
            if key.lower() == attr.lower(): return val

store = Email()

## slurp command

def slurp(event):
    if not event.rest: event.reply("what directory?") ; return
    target = event.rest
    if not os.path.isdir(target): event.reply("%s is not a directory." % target) ; return
    teller = 0
    event.reply("scanning %s" % target)
    for fn in os.listdir(target):
        ff = target + os.sep + fn 
        logging.warn("reading %s" % ff)
        try: data = open(ff, "r").read()
        except: error()
        e = Email()
        message = email.message_from_string(data)
        e.update(message.items())
        e.text = ""
        for load in message.get_payload()[1:]:
            e.text += str(load)
        try:  e.sdate = emailtime(e.Date) ; e.estamp = emailstamp(e.Date)
        except ValueError as ex: logging.warn("date missed %s" % ex) ; continue
        if e.sdate: e.save(e.sdate)
        else: e.save(j("nodate", e.get_stamp()))
        logging.warn("saved at %s" % e.sdate)
        teller += 1
    event.reply("%s emails slurped." % teller)

cmnds.register("slurp", slurp)
