# oolib/drivers.py
#
#

""" drivers package. """

from oolib import NoSuchBotType
from oolib.drivers.xmpp import XMPPBot
from oolib.drivers.irc import IRCBot
from oolib.drivers.line import CLIBot
from oolib.drivers.grep import GrepBot

## get_bot factory function

def get_bot(type, config):
    if type == "IRC": return IRCBot(**config)
    elif type == "XMPP": return XMPPBot(**config)
    elif type == "CLI": return cLIBot(**config)
    elif type == "Grep": return GrepBot(**config)
    else: raise NoSuchBotType(type)
