# shout/plugs/list.py
#
#

""" lists various stuff. """

## oolib imports

from oolib import cmnds, core
from oolib.utils import str2stamp, striphtml

## basic imports

import logging
import time

## list command

def list(event):
    try: p, attrs = event.rest.split(" ", 1) ; attrs = attrs.split()
    except ValueError: p = event.rest ; attrs = []
    plug = core.plugins.get(p)
    if not plug: event.reply("plugins: %s" % core.plugins.attrs()) ; return
    try: store = getattr(plug, "store")
    except AttributeError: event.reply("no store available for %s" % event.rest) ; return
    c = 0
    objs = sorted(store.objects(), key=lambda x: x.estamp or x.ctime)
    whitelist = ["text",]
    blacklist = ["html",]
    for obj in objs:
        nogo = False
        c += 1
        if p in ["mail", ]:
            try: ctype = obj["Content-Type"]
            except KeyError: time.sleep(0.001) ; continue
            logging.debug("scanning #%s" % ctype)
            for white in whitelist:
                if white not in ctype: nogo = True
            for black in blacklist:
                if black in ctype: nogo = True
            if nogo: continue
            res = []
            result = ""
            for attr in attrs:
                if attr == "nr": res.append(str(c)) ; continue
                try: res.append(striphtml(obj[attr]))
                except KeyError: time.sleep(0.001) ; continue
            for r in res: result += "%s - " % r
            result = result[:-3]
        else: result = obj.txt
        event.reply(result)
    logging.warn("%s objects counted" % c)
 
cmnds.register("list", list)
