 # oolib/drivers//console.py
#
#

""" console bot. """


## =======
## IMPORTS
## =======

## shout imports

from oolib import Bot, Event, dispatch, cmnds, tests

## oolib imports

from oolib import colors, cb
from oolib.utils import error
from oolib.log import datefmt

## basic imports

import logging
import time
import sys
import os

## ===========
## CONSOLE BOT
## ===========

## CONSOLE event

class CONSOLE(Event): pass

## Console class

class ConsoleBot(Bot):

    def _raw(self, txt): sys.stdout.write(txt)

    def say(self, *args, **kwargs):
        try: txt = args[1]
        except IndexError: txt = args[0]
        self._raw(txt)
        self._raw("\n")
        
    def close(self): sys.stdout.flush()
        
    def get_one(self): return CONSOLE(txt=input("%s -=- %s%s<%s " % (time.strftime(datefmt), colors.BOLD, colors.YELLOW, colors.ENDC)))
