# shout/plugs/list.py
#
#

""" lists various stuff. """

## oolib imports

from oolib import cmnds, core
from oolib.utils import str2stamp

## list command

def list(event):
    p = core.plugins
    plug = p.get(event.rest)
    if not plug: event.reply("commands: %s" % ", ".join(cmnds.names())) ; return
    try: store = getattr(plug, "store")
    except AttributeError: event.reply("no store available for %s" % event.rest) ; return
    c = 0
    objs = sorted(store.objects(), key=lambda obj: str2stamp(obj._timed))
    for obj in objs: c += 1 ; event.reply("%s) %s (%s)" % (c, obj.txt, obj._timed or "no time"))

cmnds.register("list", list)
