# shout/plugs/list.py
#
#

""" lists various stuff. """

## oolib imports

from oolib import cmnds, core
from oolib.utils import str2stamp

## basic imports

import logging

## list command

def list(event):
    try: p, attrs = event.rest.split(" ", 1) ; attrs = attrs.split()
    except ValueError: p = event.rest ; attrs = []
    plug = core.plugins.get(p)
    if not plug: event.reply("plugins: %s" % core.plugins.attrs()) ; return
    try: store = getattr(plug, "store")
    except AttributeError: event.reply("no store available for %s" % event.rest) ; return
    c = 0
    objs = sorted(store.objects(), key=lambda x: x.estamp or x.ctime)
    for obj in objs:
        c += 1
        res = ""
        for attr in attrs:
            try: res += "%s - " % str(obj[attr])
            except KeyError: continue
        if not res: res = obj.txt
        else: res = res[:-2]
        if res: event.reply("%s) %s" % (c, res))
    logging.warn("%s objects counted" % c)
 
cmnds.register("list", list)
