ROM_form_S3_1K.vhd - Picoblaze Spartan-3 ROM template

Freely available from Opbasm (http://code.google.com/p/opbasm)

Copyright  2014 Kevin Thibedeau
(kevin 'period' thibedeau 'at' gmail 'punto' com)

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

------------------------------------------------------------------------------

This template defines a Spartan-3 block RAM configured as a 1Kx18-bit single port ROM.


This is a VHDL template for the OPBASM assembler for the Picoblaze-3 (KCPSM3) processor.
It is functionally equivalent to the template included with the KCPSM3 assembler but updated
to remove the unneeded INIT_XXX attributes now that XST supports BRAM init from generics.

The assembler will read this template and fill in fields enclosed by curly braces. By default
OBPASM mimics KCPSM3.exe and searches for a template named "ROM_form.vhd". You can copy or
symlink this template to that file name or use the OBPASM -t switch to specify the template
directly.

This template is compatible with KCPSM3.exe except for the "{source file}" field which is only
used in a comment.

The next line establishes the beginning of the template:
{begin template}
-- ROM definition for KCPSM3 assembled from {source file}
-- Generated by OPBASM Assembler {timestamp}.

library ieee;
use ieee.std_logic_1164.all;

package {name}_pkg is
  component {name} is
    port(
      Address     : in std_logic_vector(9 downto 0);
      Instruction : out std_logic_vector(17 downto 0);
      Clk         : in std_logic
    );
  end component;
end package;


library ieee;
use ieee.std_logic_1164.all;
library unisim;
use unisim.vcomponents.all;

entity {name} is
  port(
    Address     : in std_logic_vector(9 downto 0);
    Instruction : out std_logic_vector(17 downto 0);
    Clk         : in std_logic
  );
end entity;

architecture structure of {name} is
begin

  -- Xilinx block RAM used for ROM
  rom_1024_x_18: RAMB16_S18
    generic map ( 
      INIT_00 => X"{INIT_00}",
      INIT_01 => X"{INIT_01}",
      INIT_02 => X"{INIT_02}",
      INIT_03 => X"{INIT_03}",
      INIT_04 => X"{INIT_04}",
      INIT_05 => X"{INIT_05}",
      INIT_06 => X"{INIT_06}",
      INIT_07 => X"{INIT_07}",
      INIT_08 => X"{INIT_08}",
      INIT_09 => X"{INIT_09}",
      INIT_0A => X"{INIT_0A}",
      INIT_0B => X"{INIT_0B}",
      INIT_0C => X"{INIT_0C}",
      INIT_0D => X"{INIT_0D}",
      INIT_0E => X"{INIT_0E}",
      INIT_0F => X"{INIT_0F}",
      INIT_10 => X"{INIT_10}",
      INIT_11 => X"{INIT_11}",
      INIT_12 => X"{INIT_12}",
      INIT_13 => X"{INIT_13}",
      INIT_14 => X"{INIT_14}",
      INIT_15 => X"{INIT_15}",
      INIT_16 => X"{INIT_16}",
      INIT_17 => X"{INIT_17}",
      INIT_18 => X"{INIT_18}",
      INIT_19 => X"{INIT_19}",
      INIT_1A => X"{INIT_1A}",
      INIT_1B => X"{INIT_1B}",
      INIT_1C => X"{INIT_1C}",
      INIT_1D => X"{INIT_1D}",
      INIT_1E => X"{INIT_1E}",
      INIT_1F => X"{INIT_1F}",
      INIT_20 => X"{INIT_20}",
      INIT_21 => X"{INIT_21}",
      INIT_22 => X"{INIT_22}",
      INIT_23 => X"{INIT_23}",
      INIT_24 => X"{INIT_24}",
      INIT_25 => X"{INIT_25}",
      INIT_26 => X"{INIT_26}",
      INIT_27 => X"{INIT_27}",
      INIT_28 => X"{INIT_28}",
      INIT_29 => X"{INIT_29}",
      INIT_2A => X"{INIT_2A}",
      INIT_2B => X"{INIT_2B}",
      INIT_2C => X"{INIT_2C}",
      INIT_2D => X"{INIT_2D}",
      INIT_2E => X"{INIT_2E}",
      INIT_2F => X"{INIT_2F}",
      INIT_30 => X"{INIT_30}",
      INIT_31 => X"{INIT_31}",
      INIT_32 => X"{INIT_32}",
      INIT_33 => X"{INIT_33}",
      INIT_34 => X"{INIT_34}",
      INIT_35 => X"{INIT_35}",
      INIT_36 => X"{INIT_36}",
      INIT_37 => X"{INIT_37}",
      INIT_38 => X"{INIT_38}",
      INIT_39 => X"{INIT_39}",
      INIT_3A => X"{INIT_3A}",
      INIT_3B => X"{INIT_3B}",
      INIT_3C => X"{INIT_3C}",
      INIT_3D => X"{INIT_3D}",
      INIT_3E => X"{INIT_3E}",
      INIT_3F => X"{INIT_3F}",    
      INITP_00 => X"{INITP_00}",
      INITP_01 => X"{INITP_01}",
      INITP_02 => X"{INITP_02}",
      INITP_03 => X"{INITP_03}",
      INITP_04 => X"{INITP_04}",
      INITP_05 => X"{INITP_05}",
      INITP_06 => X"{INITP_06}",
      INITP_07 => X"{INITP_07}"
    )
    port map(
     DI   => "0000000000000000",
     DIP  => "00",
     EN   => '1',
     WE   => '0',
     SSR  => '0',
     CLK  => clk,
     ADDR => address,
     DO   => instruction(15 downto 0),
     DOP  => instruction(17 downto 16)
    ); 

end architecture;

