"""
Copyright 2013 Rackspace

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

'''
@summary: Responses directly from the command line
'''
from cafe.engine.models.base import BaseModel


class CommandLineResponse(BaseModel):
    '''Bare bones object for any Command Line Connector response
    @ivar Command: The full original command string for this response
    @type Command: C{str}
    @ivar StandardOut: The Standard Out generated by this command
    @type StandardOut: C{list} of C{str}
    @ivar StandardError: The Standard Error generated by this command
    @type StandardError: C{list} of C{str}
    @ivar ReturnCode: The command's return code
    @type ReturnCode: C{int}
    '''
    def __init__(self):
        super(CommandLineResponse, self).__init__()
        self.command = ""
        self.standard_out = []
        self.standard_error = []
        self.return_code = None
        self.process = None
