#
# Generated by dumpDCWorkflow.py written by Sebastien Bigaret
# Original workflow id/title: openplans_member_workflow/Open Member Workflow : Email Confirmation
# Date: 2007/05/16 15:55:18.526 GMT-4
#
# WARNING: this dumps does NOT contain any scripts you might have added to
# the workflow, IT IS YOUR RESPONSABILITY TO MAKE BACKUPS FOR THESE SCRIPTS.
#
# The following scripts have been detected and should be backed up:
# - enable (External Method)
# - disable (External Method)
# - register (External Method)
#
"""
Programmatically create a workflow type.
"""
__version__ = "$Id: dumpDCWorkflow.py 25723 2006-07-04 08:41:22Z b_mathieu $"

from Products.CMFCore.WorkflowTool import addWorkflowFactory
from Products.DCWorkflow.DCWorkflow import DCWorkflowDefinition
from Products.PythonScripts.PythonScript import PythonScript
from Products.ExternalMethod.ExternalMethod import ExternalMethod

def setup_openplans_member_workflow(wf):
    """Setup the workflow
    """
    wf.setProperties(title='OpenPlans Member Workflow')

    for s in ('disabled', 'new', 'pending', 'private', 'public'):
        wf.states.addState(s)
    for t in ('auto_pending',
              'disable',
              'enable_pending',
              'enable_private',
              'enable_public',
              'make_private',
              'make_public',
              'register_private',
              'register_public',
              'trigger'):
        wf.transitions.addTransition(t)
    for v in ('action', 'actor', 'comments', 'review_history', 'time'):
        wf.variables.addVariable(v)
    for l in ('reviewer_queue',):
        wf.worklists.addWorklist(l)
    for p in ('Copy or Move',
              'Mail forgotten password',
              'Manage users',
              'Modify portal content',
              'Set own password',
              'Set own properties',
              'View',
              'membrane: Edit member id',
              'membrane: Register member'):
        wf.addManagedPermission(p)

    # Initial State
    wf.states.setInitialState('new')

    # State Initialization
    sdef = wf.states['disabled']
    sdef.setProperties(title='Disabled',
                       description='',
                       transitions=('enable_pending', 'enable_private', 'enable_public'))
    sdef.setPermission('Copy or Move', 0,
                       ['Manager'])
    sdef.setPermission('Mail forgotten password', 0,
                       ['Manager'])
    sdef.setPermission('Manage users', 0,
                       ['Manager'])
    sdef.setPermission('Modify portal content', 0,
                       ['Manager'])
    sdef.setPermission('Set own password', 0,
                       ['Manager'])
    sdef.setPermission('Set own properties', 0,
                       ['Manager'])
    sdef.setPermission('View', 0,
                       ['Manager'])
    sdef.setPermission('membrane: Edit member id', 0,
                       ['Manager'])
    sdef.setPermission('membrane: Register member', 0,
                       ['Manager'])

    sdef = wf.states['new']
    sdef.setProperties(title='Newly created member',
                       description='',
                       transitions=('auto_pending', 'trigger'))
    sdef.setPermission('Copy or Move', 0,
                       ['Manager'])
    sdef.setPermission('Mail forgotten password', 0,
                       ['Manager'])
    sdef.setPermission('Manage users', 0,
                       ['Manager'])
    sdef.setPermission('Modify portal content', 0,
                       ['Anonymous', 'Manager'])
    sdef.setPermission('Set own password', 0,
                       ['Anonymous', 'Manager'])
    sdef.setPermission('Set own properties', 0,
                       ['Anonymous', 'Manager'])
    sdef.setPermission('View', 0,
                       ['Anonymous', 'Manager'])
    sdef.setPermission('membrane: Edit member id', 0,
                       ['Anonymous', 'Manager'])
    sdef.setPermission('membrane: Register member', 0,
                       ['Manager'])

    sdef = wf.states['pending']
    sdef.setProperties(title='Awaiting registration',
                       description='',
                       transitions=('disable', 'register_private', 'register_public'))
    sdef.setPermission('Copy or Move', 0,
                       ['Manager'])
    sdef.setPermission('Mail forgotten password', 0,
                       ['Manager'])
    sdef.setPermission('Manage users', 0,
                       ['Manager'])
    sdef.setPermission('Modify portal content', 0,
                       ['Manager'])
    sdef.setPermission('Set own password', 0,
                       ['Manager'])
    sdef.setPermission('Set own properties', 0,
                       ['Manager'])
    sdef.setPermission('View', 0,
                       ['Manager'])
    sdef.setPermission('membrane: Edit member id', 0,
                       ['Manager'])
    sdef.setPermission('membrane: Register member', 0,
                       ['Manager'])

    sdef = wf.states['private']
    sdef.setProperties(title='Registered user, private profile',
                       description='',
                       transitions=('make_public', 'disable'))
    sdef.setPermission('Copy or Move', 0,
                       ['Manager'])
    sdef.setPermission('Mail forgotten password', 0,
                       ['Anonymous', 'Manager', 'Owner'])
    sdef.setPermission('Manage users', 0,
                       ['Manager'])
    sdef.setPermission('Modify portal content', 0,
                       ['Manager', 'Owner'])
    sdef.setPermission('Set own password', 0,
                       ['Manager', 'Owner'])
    sdef.setPermission('Set own properties', 0,
                       ['Manager', 'Owner'])
    sdef.setPermission('View', 0,
                       ['Manager', 'Owner'])
    sdef.setPermission('membrane: Edit member id', 0,
                       ['Manager'])
    sdef.setPermission('membrane: Register member', 0,
                       ['Manager'])

    sdef = wf.states['public']
    sdef.setProperties(title='Registered user, public profile',
                       description='',
                       transitions=('make_private', 'disable'))
    sdef.setPermission('Copy or Move', 0,
                       ['Manager'])
    sdef.setPermission('Mail forgotten password', 0,
                       ['Anonymous', 'Manager', 'Owner'])
    sdef.setPermission('Manage users', 0,
                       ['Manager'])
    sdef.setPermission('Modify portal content', 0,
                       ['Manager', 'Owner'])
    sdef.setPermission('Set own password', 0,
                       ['Manager', 'Owner'])
    sdef.setPermission('Set own properties', 0,
                       ['Manager', 'Owner'])
    sdef.setPermission('View', 0,
                       ['Anonymous', 'Authenticated', 'Manager', 'Member', 'Owner'])
    sdef.setPermission('membrane: Edit member id', 0,
                       ['Manager'])
    sdef.setPermission('membrane: Register member', 0,
                       ['Manager'])

    # Transition Initialization
    tdef = wf.transitions['auto_pending']
    tdef.setProperties(title='Make pending , send out email',
                       description='',
                       new_state_id='pending',
                       trigger_type=0,
                       script_name='',
                       after_script_name='',
                       actbox_name='',
                       actbox_url='',
                       actbox_category='',
                       props={'guard_expr': 'here/isValid', 'guard_permissions': 'Add portal member'},
                       )

    tdef = wf.transitions['disable']
    tdef.setProperties(title='Disable member',
                       description='',
                       new_state_id='disabled',
                       trigger_type=1,
                       script_name='disable',
                       after_script_name='',
                       actbox_name='Disable member',
                       actbox_url='',
                       actbox_category='workflow',
                       props={'guard_permissions': 'Manage users'},
                       )

    tdef = wf.transitions['enable_pending']
    tdef.setProperties(title='Re-enable member',
                       description='',
                       new_state_id='pending',
                       trigger_type=1,
                       script_name='',
                       after_script_name='enable',
                       actbox_name='Re-enable member',
                       actbox_url='',
                       actbox_category='workflow',
                       props={'guard_expr': "python:getattr(here,'old_state',None) == 'pending'",
                              'guard_permissions': 'Manage users'},
                       )

    tdef = wf.transitions['enable_private']
    tdef.setProperties(title='Re-enable member',
                       description='',
                       new_state_id='private',
                       trigger_type=1,
                       script_name='',
                       after_script_name='enable',
                       actbox_name='Re-enable member',
                       actbox_url='',
                       actbox_category='workflow',
                       props={'guard_expr': "python:getattr(here,'old_state',None) == 'private'",
                              'guard_permissions': 'Manage users'},
                       )

    tdef = wf.transitions['enable_public']
    tdef.setProperties(title='Re-enable member',
                       description='',
                       new_state_id='public',
                       trigger_type=1,
                       script_name='',
                       after_script_name='',
                       actbox_name='Re-enable member',
                       actbox_url='',
                       actbox_category='workflow',
                       props={'guard_expr': "python:getattr(here,'old_state',None) == 'public'",
                              'guard_permissions': 'Manage users'},
                       )

    tdef = wf.transitions['make_private']
    tdef.setProperties(title='Make member profile private',
                       description='',
                       new_state_id='private',
                       trigger_type=1,
                       script_name='',
                       after_script_name='',
                       actbox_name='Make member profile private',
                       actbox_url='',
                       actbox_category='workflow',
                       props={'guard_roles': 'Owner; Manager'},
                       )

    tdef = wf.transitions['make_public']
    tdef.setProperties(title='Make member profile public',
                       description='',
                       new_state_id='public',
                       trigger_type=1,
                       script_name='',
                       after_script_name='',
                       actbox_name='Make member profile public',
                       actbox_url='',
                       actbox_category='workflow',
                       props={'guard_roles': 'Owner; Manager'},
                       )

    tdef = wf.transitions['register_private']
    tdef.setProperties(title='Approve member, make profile private',
                       description='',
                       new_state_id='private',
                       trigger_type=1,
                       script_name='',
                       after_script_name='register',
                       actbox_name='Register member and make profile private',
                       actbox_url='',
                       actbox_category='workflow',
                       props={'guard_expr': 'here/isValid',
                              'guard_permissions': 'remember: Register member'},
                       )

    tdef = wf.transitions['register_public']
    tdef.setProperties(title='Approve member, make profile public',
                       description='',
                       new_state_id='public',
                       trigger_type=1,
                       script_name='',
                       after_script_name='register',
                       actbox_name='Register member and make profile public',
                       actbox_url='',
                       actbox_category='workflow',
                       props={'guard_expr': 'here/isConfirmable | nothing'},
                       )

    tdef = wf.transitions['trigger']
    tdef.setProperties(title='Trigger automatic transitions',
                       description='',
                       new_state_id='',
                       trigger_type=1,
                       script_name='',
                       after_script_name='',
                       actbox_name='Trigger automatic transitions',
                       actbox_url='',
                       actbox_category='workflow',
                       props=None,
                       )

    # State Variable
    wf.variables.setStateVar('review_state')

    # Variable Initialization
    vdef = wf.variables['action']
    vdef.setProperties(description='The last transition',
                       default_value='',
                       default_expr='transition/getId|nothing',
                       for_catalog=0,
                       for_status=1,
                       update_always=1,
                       props=None)

    vdef = wf.variables['actor']
    vdef.setProperties(description='The ID of the user who performed the last transition',
                       default_value='',
                       default_expr='user/getId',
                       for_catalog=0,
                       for_status=1,
                       update_always=1,
                       props=None)

    vdef = wf.variables['comments']
    vdef.setProperties(description='Comments about the last transition',
                       default_value='',
                       default_expr="python:state_change.kwargs.get('comment', '')",
                       for_catalog=0,
                       for_status=1,
                       update_always=1,
                       props=None)

    vdef = wf.variables['review_history']
    vdef.setProperties(description='Provides access to workflow history',
                       default_value='',
                       default_expr='state_change/getHistory',
                       for_catalog=0,
                       for_status=0,
                       update_always=0,
                       props={'guard_permissions': 'Request review; Review portal content'})

    vdef = wf.variables['time']
    vdef.setProperties(description='Time of the last transition',
                       default_value='',
                       default_expr='state_change/getDateTime',
                       for_catalog=0,
                       for_status=1,
                       update_always=1,
                       props=None)

    # Worklist Initialization
    ldef = wf.worklists['reviewer_queue']
    ldef.setProperties(description='Reviewer tasks',
                       actbox_name='Pending (%(count)d)',
                       actbox_url='%(portal_url)s/search?review_state=pending',
                       actbox_category='global',
                       props={'guard_permissions': 'Review portal content',
                              'var_match_review_state': 'pending'})

    # Script Initialization
    wf.scripts._setObject('disable',
                          ExternalMethod('disable', '',
                                         'remember.workflow', 'disable'))
    
    wf.scripts._setObject('enable',
                          ExternalMethod('enable', '',
                                         'remember.workflow', 'enable'))
   
    wf.scripts._setObject('register',
                          ExternalMethod('register', '',
                                         'remember.workflow', 'register'))
    
def create_openplans_member_workflow(id):
    """Create, setup and return the workflow.
    """
    ob = DCWorkflowDefinition(id)
    setup_openplans_member_workflow(ob)
    return ob

addWorkflowFactory(create_openplans_member_workflow,
                   id='openplans_member_workflow',
                   title='OpenPlans Member Workflow')
