import tempfile
import os
from urllib import urlopen
from collections import namedtuple

from path_helpers import path

from silence import Silence
from safe_cv import cv


CodecInfo = namedtuple('CodecInfo', 'fourcc name owner description')


# Cached list of codecs from http://www.fourcc.org/codecs.php as of:
#    Tue Dec 20 13:58:03 EST 2011
ALL_CODECS = [
    CodecInfo(fourcc=u'3IV1', name=u'3ivx', owner=u'3IVX', description=u'MPEG4-based codec. Used by 3ivx Delta 1.0-3.5. FOURCC &quot;3IV0&quot; was also used for a while but never publicly released.'),
    CodecInfo(fourcc=u'3IV2', name=u'3ivx', owner=u'3IVX', description=u'MPEG4-based codec. To be used for &quot;3ivx Delta 4.0.&quot;'),
    CodecInfo(fourcc=u'8BPS', name=u'Planar RGB Codec', owner=u'Apple?', description=u'RLE codec storing RGB image in planar format under Quicktime.'),
    CodecInfo(fourcc=u'AASC', name=u'Autodesk Animator codec', owner=u'Autodesk', description=u"This codec is part of Autodesk's discontinued Animator Studio for Windows.&nbsp;"),
    CodecInfo(fourcc=u'ABYR', name=u'?', owner=u'Kensington?', description=u'Apparently a low resolution, low frame rate (6fps)  codec similar toAJPGwhich is used in implementing movie capture in some digital cameras.'),
    CodecInfo(fourcc=u'ADV1', name=u'WaveCodec', owner=u'Loronix', description=u'Apparently used in various CCTV products.'),
    CodecInfo(fourcc=u'ADVJ', name=u'Avid M-JPEG', owner=u'Avid Technology', description=u'Also known as AVRn'),
    CodecInfo(fourcc=u'AEMI', name=u'Array VideoONE MPEG1-I Capture', owner=u'Array Microsystems', description=u"Array's codec used for I frame only MPEG1 AVI files"),
    CodecInfo(fourcc=u'AFLI', name=u'Autodesk Animator codec', owner=u'Autodesk', description=u"AVI equivalent of Autodesk's native FLI file format (presumably)."),
    CodecInfo(fourcc=u'AFLC', name=u'Autodesk Animator codec', owner=u'Autodesk', description=u'AVI equivalent of the FLC native file format.'),
    CodecInfo(fourcc=u'AJPG', name=u'?', owner=u'?', description=u'22fps JPEG-based codec used for movie capture by some digital cameras.'),
    CodecInfo(fourcc=u'AMPG', name=u'Array VideoONE MPEG', owner=u'Array Microsystems', description=u'Codec for Array VideoONE hardware-based MPEG compression system.'),
    CodecInfo(fourcc=u'ANIM', name=u'RDX', owner=u'Intel', description=u'?'),
    CodecInfo(fourcc=u'AP41', name=u'AngelPotion Definitive', owner=u'AngelPotion', description=u"Another hacked version of Microsoft's MP43 codec. One source recommends against installing this codec &quot;due to its occasional tendency to modify client structures&quot;. Apparently this means that it can destroy or otherwise mess up the&nbsp; HKEY_CLASSES_ROOT\\avifile section of your registry leaving some tools incapable of playing video any more."),
    CodecInfo(fourcc=u'ASLC', name=u'Alparysoft Lossless Codec', owner=u'Alparysoft', description=u'Codec offering approximately 5x compression in mathematically lossless mode or 5-15x compression in &quot;visually lossless&quot; operation.'),
    CodecInfo(fourcc=u'ASV1', name=u'Asus Video', owner=u'Asus', description=u'Codec supplied with the Asus TNT Video Capture adapter. Supposedly a very simple, DCT-based codec. Complete technical details can be foundhere.'),
    CodecInfo(fourcc=u'ASV2', name=u'Asus Video (2)', owner=u'Asus', description=u'New codec from Asus. Supposedly a very simple DCT codec. Complete technical details can be foundhere.'),
    CodecInfo(fourcc=u'ASVX', name=u'Asus Video 2.0', owner=u'Asus', description=u'Unusual codec which stores audio in the .avi file but puts the video in a companion .asv file.Click herefor information on how to play back these files on Windows 2000 PCs.'),
    CodecInfo(fourcc=u'AUR2', name=u'Aura 2 Codec - YUV 422', owner=u'Auravision', description=u'?'),
    CodecInfo(fourcc=u'AURA', name=u'Aura 1 Codec - YUV 411', owner=u'Auravision', description=u'?'),
    CodecInfo(fourcc=u'avc1', name=u'H.264', owner=u'Apple', description=u"Apple's version of the MPEG4 part 10/H.264 standard apparently."),
    CodecInfo(fourcc=u'AVRn', name=u'Avid M-JPEG', owner=u'Avid Technology', description=u'Also known as ADVJ in Quicktime files.'),
    CodecInfo(fourcc=u'BA81', name=u'Raw 8bit RGB Bayer', owner=u'?', description=u'This format stores raw 8bit Bayer samples. The Bayer color filter array is describedhere. I wonder if this is a duplicate ofBYR1?'),
    CodecInfo(fourcc=u'BINK', name=u'Bink Video', owner=u'RAD Game Tools', description=u"Pretty popular codec in Windows games. I'm not sure if this is available as a standard Windows codec but the web site makes it sound interesting enough to list here even if it does require non-standard tools to use."),
    CodecInfo(fourcc=u'BLZ0', name=u'?', owner=u'Blizzard', description=u'MPEG-4 codec used in WarCraft 3 movies.'),
    CodecInfo(fourcc=u'BT20', name=u'Prosumer Video', owner=u'Conexant', description=u'Codec optimised for realtime compression of YUV images. Download the ZIP and add VIDC.BT20=btvvc32.drv and VIDC.Y41P=btvvc32.drv to the [drivers32] section of your SYSTEM.INI to enable the codec'),
    CodecInfo(fourcc=u'BTCV', name=u'Composite Video Codec', owner=u'Conexant', description=u'This, now obsolete, format supported a special data format used by the Brooktree Bt2115 chipset which could perform &quot;software encoded video output&quot; - a kind of software TV-out capability.'),
    CodecInfo(fourcc=u'BW10', name=u'Broadway MPEG Capture/Compression', owner=u'Data Translation', description=u'Codec for Broadway hardware-based MPEG compression system.'),
    CodecInfo(fourcc=u'BYR1', name=u'Raw 8bit RGB Bayer', owner=u'?', description=u'This format stores raw 8bit Bayer samples. The Bayer color filter array is describedhere.'),
    CodecInfo(fourcc=u'BYR2', name=u'Raw 16bit RGB Bayer', owner=u'?', description=u'This format stores packed 16bit Bayer samples with 12bit precision. The Bayer color filter array is describedhere.'),
    CodecInfo(fourcc=u'CC12', name=u'YUV12 Codec', owner=u'Intel', description=u'?'),
    CodecInfo(fourcc=u'CDVC', name=u'Canopus DV Codec', owner=u'Canopus', description=u'Allegedly used with digital video cameras. TheCanopus download pagehas a free software-only version of this codec which will install on machines which are not equipped with their capture hardware.&nbsp;Apparently if you edit the AVI and change the FOURCC to dvsd, it will play with these codecs too.'),
    CodecInfo(fourcc=u'CFCC', name=u'DPS Perception', owner=u'Digital Processing Systems', description=u'Native format used when capturing AVIs using a DPS Perception adapter.'),
    CodecInfo(fourcc=u'CGDI', name=u'Camcorder Video', owner=u'Microsoft', description=u'AVI format used byOffice 97 camcorder application.'),
    CodecInfo(fourcc=u'CHAM', name=u'Caviara Champagne', owner=u'Winnov', description=u'?'),
    CodecInfo(fourcc=u'CMYK', name=u'Uncompressed CMYK', owner=u'Colorgraph', description=u'Uncompressed 32bpp CMYK as used in printing processes.'),
    CodecInfo(fourcc=u'CJPG', name=u'WebCam JPEG', owner=u'Creative Labs', description=u'Used by Creative Video Blaster Webcam Go control. Seeherefor info on how to download and install this codec.'),
    CodecInfo(fourcc=u'CPLA', name=u'YUV 4:2:0', owner=u'Weitek', description=u'This sounds like an uncompressed format to me. Anyone know?'),
    CodecInfo(fourcc=u'CRAM', name=u'Microsoft Video 1', owner=u'Microsoft', description=u'Allegedly identical to MSVC.'),
    CodecInfo(fourcc=u'CSCD', name=u'CamStudio&nbsp;Codec', owner=u'RenderSoftSoftware', description=u'Open source (GPL license) codec optimised for screen capture applications. Source download is available.'),
    CodecInfo(fourcc=u'CTRX', name=u'Citrix Scalable Video Codec', owner=u'Citrix?', description=u'?'),
    CodecInfo(fourcc=u'CVID', name=u'Cinepak', owner=u'Providenza &amp; Boekelheide', description=u'Originally owned by Supermac then Radius, nowP &amp; B. Complete technical details can be foundhere.'),
    CodecInfo(fourcc=u'CWLT', name=u'Color WLT DIB', owner=u'Microsoft', description=u'Apparently WLT is &quot;with lookup table&quot;. Presumably, therefore, this is similar to a standard DIB using FOURCC 0?'),
    CodecInfo(fourcc=u'CXY1', name=u'Conexant YUV 4:1:1', owner=u'Conexant', description=u'Uncompressed, planar 4:1:1&nbsp;YUV format.'),
    CodecInfo(fourcc=u'CXY2', name=u'Conexant YUV 4:2:2', owner=u'Conexant', description=u'Uncompressed, planar 4:2:2&nbsp;YUV format.'),
    CodecInfo(fourcc=u'CYUV', name=u'Creative YUV', owner=u'Creative Labs', description=u'Proprietary YUV compression algorithm'),
    CodecInfo(fourcc=u'CYUY', name=u'?', owner=u'ATI Technologies', description=u'Proprietary YUV compression algorithm'),
    CodecInfo(fourcc=u'D261', name=u'H.261', owner=u'DEC', description=u'Presumably now owned by Intel.'),
    CodecInfo(fourcc=u'D263', name=u'H.263', owner=u'DEC', description=u'Presumably now owned by Intel.'),
    CodecInfo(fourcc=u'davc', name=u'MPEG-4/H.264', owner=u'Dicas', description=u'H.264/MPEG-4 AVC base profile codec. Dicas tell me that this codec will be available for free download from their site some time in June 2004. I am waiting to hear the exact URL for the download.'),
    CodecInfo(fourcc=u'DCL1', name=u'Data Connection Conferencing Codec', owner=u'Data Connection Ltd.', description=u"Format used in Data Connection Ltd's conferencing services."),
    CodecInfo(fourcc=u'DCL2', name=u'Data Connection Multimedia Conferencing Codec', owner=u'Data Connection Ltd.', description=u"Format used in Data Connection Ltd's conferencing services."),
    CodecInfo(fourcc=u'DCL3', name=u'Data Connection Enhanced Conferencing Codec', owner=u'Data Connection Ltd.', description=u"Format used in Data Connection Ltd's conferencing services."),
    CodecInfo(fourcc=u'DCL4', name=u'Data Connection Extended Conferencing Codec', owner=u'Data Connection Ltd.', description=u"Format used in Data Connection Ltd's conferencing services."),
    CodecInfo(fourcc=u'DCL5', name=u'Data Connection Media  Conferencing Codec', owner=u'Data Connection Ltd.', description=u"Format used in Data Connection Ltd's conferencing services."),
    CodecInfo(fourcc=u'DIV3', name=u'DivX MPEG-4', owner=u'DivX', description=u'Low motion codec (optimised for low motion source material?). Several sources tell me that this is an old and illegal codec that should not be used to encode new material.'),
    CodecInfo(fourcc=u'DIV4', name=u'DivX MPEG-4', owner=u'DivX', description=u'Fast motion codec.Several sources tell me that this is an old and illegal codec that should not be used to encode new material.'),
    CodecInfo(fourcc=u'DIV5', name=u'?', owner=u'?', description=u"Apparently almost as old as DIV3 and DIV4. Changing DIV5 AVI's FOURCC to DIV3 or DIV4 seems to allow them to play just fine."),
    CodecInfo(fourcc=u'DIVX', name=u'DivX', owner=u'OpenDivX', description=u"This FOURCC code is used for versions 4.0 and later of the DivX codec. DivX, &quot;the MP3 of video,&quot;&nbsp; is the popular and market-leading MPEG-4 video codec that is emerging as the standard for full screen, full motion, DVD-quality video over IP-based networks.Apparently version 5 also encodes using FOURCCDX50.The Microsoft codec pack availablehereapparently supports Divx 6.This FOURCC is supported byLEAD's MCMP Codec."),
    CodecInfo(fourcc=u'divx', name=u'DivX', owner=u'?', description=u"Apparently used interchangeably with &quot;DIVX&quot;. This FOURCC is supported byLEAD's MCMP Codec."),
    CodecInfo(fourcc=u'DM4V', name=u'MPEG-4', owner=u'Dicas', description=u'MPEG4 codec compatible with DivX4 and 5.'),
    CodecInfo(fourcc=u'dmb1', name=u'Rainbow Runner hardware compression', owner=u'Matrox', description=u"Hardware codec used by Matrox Rainbow Runner video capture product. Apparently a form of Motion JPEG).LEAD's MCMP codecsupports this format."),
    CodecInfo(fourcc=u'DMB2', name=u'?', owner=u'?', description=u'MJPEG codec used by Paradigm.'),
    CodecInfo(fourcc=u'DMK2', name=u'?', owner=u'?', description=u'Movies generated by a ViewSonic V36 PDA appear to be AVI files using this video codec. Oddly enough, they are named .mpg - go figure.'),
    CodecInfo(fourcc=u'DSVD', name=u'DV Codec', owner=u'?', description=u"The DSVD codec is a VFW-based compressor that firewire- and DV-based capture cards use. It is supported by Graphedit (fromdivx-digest.com), Adobe Premier and StudioDV. VirtualDub doesn't support the format.I suspect that this and DVSD are one and the same - perhaps one of my informants typed the FOURCC wrongly?"),
    CodecInfo(fourcc=u'DUCK', name=u'TrueMotion S', owner=u'Duck Corporation', description=u'Rather nice RGB codec which, strangely enough, appears to have two distinct FOURCCs.'),
    CodecInfo(fourcc=u'dv25', name=u'DVCPRO', owner=u'Matrox', description=u'SMPTE 314M 25Mb/s compressed video. A professional variant of DVC (dvsd). Unlike dvsd, it uses 4:1:1 sampling structure for both NTSC and PAL.'),
    CodecInfo(fourcc=u'dv50', name=u'DVCPRO50', owner=u'Matrox', description=u'SMPTE 314M 50Mb/s compressed video. Has twice the data rate (50Mbits/sec) of dv25 and uses 4:2:2 sampling structure.'),
    CodecInfo(fourcc=u'DVAN', name=u'?', owner=u'?', description=u'?'),
    CodecInfo(fourcc=u'DVCS', name=u'DV Video', owner=u'Microsoft?', description=u'A generic DV codec along the same lines asDVSD. Microsoft indicatesherethat this codec should be considered obsolete now that standard FOURCCs for the various DV flavours have been defined.'),
    CodecInfo(fourcc=u'DVE2', name=u'DVE-2 Videoconferencing Codec', owner=u'InSoft', description=u'?'),
    CodecInfo(fourcc=u'dvh1', name=u'SMPTE 370M', owner=u'Panasonic?', description=u'SMPTE 370M - data structure for DV based audio, data and compressed video at 100 Mb/s - 1080/60i, 1080/50i, and 720/60p. This is basically a  high definition variant of dv25 and dv50.'),
    CodecInfo(fourcc=u'dvhd', name=u'50Mbps Consumer DV', owner=u'Microsoft?', description=u'SD-DVCR 1125-60 or SD-DVCR 1250-50. See alsodvslanddvsd.'),
    CodecInfo(fourcc=u'dvsd', name=u'25Mbps Consumer DV', owner=u'Pinnacle Systems?', description=u'SD-DVCR 525-60 or SD-DVCR 625-50. See alsodvslanddvhd.Implemented in the miroVideo DV300 SW only codec which requires the presence of the 1394 (Firewire) interface card with which it shipped.'),
    CodecInfo(fourcc=u'DVSD', name=u'DV Video', owner=u'Microsoft?', description=u'Used by Adobe After Effects, Uleads Mediastudio 6 (and probably VideoStudio) as a generic DV FOURCC. Probably the same as &quot;dvsd&quot;. Sources indicate that these FOURCCs were used interchangeably in early versions.&nbsp;Microsoft indicatesherethat this codec should be considered obsolete now that standard FOURCCs for the various DV flavours have been defined.'),
    CodecInfo(fourcc=u'dvsl', name=u'12.5Mbps Consumer DV', owner=u'Microsoft?', description=u'SD-DVCR 525-60 or SD-DVCR 625-50. See alsodvsdanddvhd.'),
    CodecInfo(fourcc=u'DVX1', name=u'DVX1000SP Video Decoder', owner=u'Lucent', description=u'?'),
    CodecInfo(fourcc=u'DVX2', name=u'DVX2000S Video Decoder', owner=u'Lucent', description=u'?'),
    CodecInfo(fourcc=u'DVX3', name=u'DVX3000S Video Decoder', owner=u'Lucent', description=u'?'),
    CodecInfo(fourcc=u'DX50', name=u'DivX MPEG-4version 5', owner=u'DivX', description=u'Apparently this is used interchangeably with the DIVX FOURCC when using version 5 of the codec. An alternative download site can be foundhere.'),
    CodecInfo(fourcc=u'DXGM', name=u'?', owner=u'Electronic Arts?', description=u'The movies in the game &quot;Lord of the Rings: Return of the King&quot; are encoded in this format. Also used in movies from &quot;Robin Hood&quot; byCinemaWare.'),
    CodecInfo(fourcc=u'DXTn', name=u'DirectX Compressed Texture', owner=u'Microsoft', description=u"5 different versions (DXT1 - DXT5) of compressed texture formats exist. Full documentation is to be found in the DirectX SDK. More info can also be found onS3's Texture Compression web site."),
    CodecInfo(fourcc=u'DXTC', name=u'DirectX Texture Compression', owner=u'Microsoft', description=u'Another of the DXTn set, I suppose.'),
    CodecInfo(fourcc=u'ELK0', name=u'?', owner=u'Elsa', description=u'Codec used by some Elsa graphics cards. May be a YUV format with reduced colour resolution.'),
    CodecInfo(fourcc=u'EKQ0', name=u'Elsa Quick Codec', owner=u'Elsa', description=u'?'),
    CodecInfo(fourcc=u'EM2V', name=u'Etymonix MPEG-2 Video', owner=u'Etymonix', description=u'HIgh quality, MPEG-2 I picture codec with user selectable YUV 4:2:0, 4:2:2 or 4:4:4 compression. Suitable for use in video editing applications. Free trial version available.'),
    CodecInfo(fourcc=u'ES07', name=u'Eyestream 7 Codec', owner=u'Eyeball&nbsp;Chat', description=u''),
    CodecInfo(fourcc=u'ESCP', name=u'Escape', owner=u'Eidos Technologies', description=u'Codec used by Eidos Technologies ESCAPE VideoStudio.'),
    CodecInfo(fourcc=u'ETV1', name=u'eTreppid Video Codec', owner=u'eTreppid Technologies', description=u'?'),
    CodecInfo(fourcc=u'ETV2', name=u'eTreppid Video Codec', owner=u'eTreppid Technologies', description=u'?'),
    CodecInfo(fourcc=u'ETVC', name=u'eTreppid Video Codec', owner=u'eTreppid Technologies', description=u'?'),
    CodecInfo(fourcc=u'FFV1', name=u'FFMPEG Codec', owner=u'Michael Niedermayer', description=u'A lossless video codec based on arithmetic coding developed in the open sourceffmpeg project.'),
    CodecInfo(fourcc=u'FLJP', name=u'Field Encoded Motion JPEG', owner=u'D-Vision', description=u'Field encoded motion JPEG with LSI bitstream format. Morgan Multimedia offers acodec supporting this format.'),
    CodecInfo(fourcc=u'FMP4', name=u'FFMpeg', owner=u'?', description=u'The default MPEG4 format used by tool mencoder.&nbsp;DirectShow filters supporting the codec are availablehere.'),
    CodecInfo(fourcc=u'FMVC', name=u'FM&nbsp;Screen Capture Codec', owner=u'Fox Magic Software?', description=u'A codec intended for use in screen capture applications.'),
    CodecInfo(fourcc=u'FPS1', name=u'Fraps Codec', owner=u'Fraps', description=u'Codec used by Fraps screen video capture application.'),
    CodecInfo(fourcc=u'FRWA', name=u'Forward Motion JPEG with alpha channel', owner=u'SoftLab-Nsk', description=u'A version of motion JPEG as used in the Forward project from SoftLab-Nsk. This format also includes an 8-bit alpha channel per image.'),
    CodecInfo(fourcc=u'FRWD', name=u'Forward Motion JPEG', owner=u'SoftLab-Nsk', description=u'A version of motion JPEG as used in the Forward project from SoftLab-Nsk. Similar to FRWD but without the alpha information.'),
    CodecInfo(fourcc=u'FVF1', name=u'Fractal Video Frame', owner=u'Iterated Systems', description=u'&nbsp;'),
    CodecInfo(fourcc=u'GEOX', name=u'GEOMPEG4', owner=u'GeoVision', description=u"MPEG shipped as part of GeoVision's CCTV surveillance systems."),
    CodecInfo(fourcc=u'GJPG', name=u'GT891x Codec', owner=u'Grand Tech', description=u'Shipped as part of the driver package with some dgital cameras from Fuji.'),
    CodecInfo(fourcc=u'GLZW', name=u'Motion LZW', owner=u'gabest@freemail.hu', description=u'GIF-like codec written bygabest@freemail.hu.'),
    CodecInfo(fourcc=u'GPEG', name=u'Motion JPEG', owner=u'gabest@freemail.hu', description=u'Motion JPEG codec written as a learning exercise bygabest@freemail.hu.'),
    CodecInfo(fourcc=u'GWLT', name=u'Greyscale WLT DIB', owner=u'Microsoft', description=u'8bpp greyscale image. WLT apparently means &quot;with lookup table&quot; so it is a palettized format.'),
    CodecInfo(fourcc=u'H260 throughH269', name=u'ITU H.26n', owner=u'Intel', description=u'Conferencing codecsH.263 format video is for POTS-based videoconferencing. Used, for example, in someOspreyproducts.Supposedly, the Vanguard SoftwareH.264codec,available in beta form here, is pretty good.'),
    CodecInfo(fourcc=u'HDYC', name=u'Raw YUV 4:2:2', owner=u'?', description=u'This is apparently identical toUYVYexcept that the samples use BT709 color space (as used in HD video) rather than BT470 (used for SD).'),
    CodecInfo(fourcc=u'HFYU', name=u'Huffman Lossless Codec', owner=u'?', description=u'Huffman codec for YUV and RGB formats. Available in source and DLL forms. Full technical information can be foundhere. I am told that further information can also be foundhere.'),
    CodecInfo(fourcc=u'HMCR', name=u'Rendition Motion Compensation Format', owner=u'Rendition', description=u'Proprietary motion compensation surface format used by Rendition V2x00 DirectDraw driver.'),
    CodecInfo(fourcc=u'HMRR', name=u'Rendition Motion Compensation Format', owner=u'Rendition', description=u'Newer, proprietary motion compensation surface format used by Rendition drivers.'),
    CodecInfo(fourcc=u'i263', name=u'ITU H.263', owner=u'Intel', description=u"PictureWorks NetCard Player - another H.263 implementation from Intel. There's a FAQ on this codechereand it can also be downloaded fromhere."),
    CodecInfo(fourcc=u'IAN', name=u'Indeo 4 Codec', owner=u'Intel', description=u'One of a collection of FOURCCs used in Indeo 4.'),
    CodecInfo(fourcc=u'ICLB', name=u'CellB Videoconferencing Codec', owner=u'InSoft', description=u'?'),
    CodecInfo(fourcc=u'IGOR', name=u'Power DVD', owner=u'?', description=u'?'),
    CodecInfo(fourcc=u'IJPG', name=u'Intergraph JPEG', owner=u'Intergraph', description=u"Intergraph's version of a JPEG codec (don't you hate it when I just state the obvious ?)"),
    CodecInfo(fourcc=u'ILVC', name=u'Layered Video', owner=u'Intel', description=u'?'),
    CodecInfo(fourcc=u'ILVR', name=u'ITU H.263+ Codec', owner=u'?', description=u'?'),
    CodecInfo(fourcc=u'IPDV', name=u'Giga AVI DV Codec', owner=u'I-O Data Device, Inc.', description=u"Codec used with I-O Data Device's IEEE1394 Digital Video Control &amp; Capture Board. This codec implements I-O DATA's original indexed AVI architecture."),
    CodecInfo(fourcc=u'IR21', name=u'Indeo 2.1', owner=u'Intel', description=u'Old Indeo codec'),
    CodecInfo(fourcc=u'IRAW', name=u'Intel Uncompressed UYUV', owner=u'Intel', description=u'No indication of the pixel format - sorry.'),
    CodecInfo(fourcc=u'ISME', name=u'?', owner=u'?', description=u'May be installed byRoxioDVD Creator 6?'),
    CodecInfo(fourcc=u'IV30 throughIV39', name=u'Indeo 3', owner=u'Ligos', description=u'The family of Indeo Video 3 codecs originally developed by Intel but now handled by Ligos.'),
    CodecInfo(fourcc=u'IV32', name=u'Indeo 3.2', owner=u'Ligos', description=u'Fairly widespread Indeo 3 codec'),
    CodecInfo(fourcc=u'IV40 throughIV49', name=u'Indeo Interactive', owner=u'Ligos', description=u'Indeo 4.1 improves image quality and introduces transparency masks. Ligos also offer a downloadherebut apparently it will cost you.'),
    CodecInfo(fourcc=u'IV50', name=u'Indeo Interactive', owner=u'Ligos', description=u'Version 5.0 of the Indeo codec series designed for internet video delivery. Ligos also offer a downloadherebut apparently it will cost you.'),
    CodecInfo(fourcc=u'JBYR', name=u'?', owner=u'Kensington?', description=u'?'),
    CodecInfo(fourcc=u'jpeg', name=u'JPEG Still Image', owner=u'Microsoft?', description=u"This is presumably exactly the same as &quot;JPEG&quot;.LEAD's MCMP codecsupports both these formats."),
    CodecInfo(fourcc=u'JPEG', name=u'JPEG Still Image', owner=u'Microsoft', description=u"This is presumably exactly the same as &quot;jpeg&quot;.LEAD's MCMP codecsupports both these formats."),
    CodecInfo(fourcc=u'JPGL', name=u'JPEG Light?', owner=u'?', description=u"Proprietary format used by many WebCams which are built around the DIVIO NW 801/802 chip such as the Logitec QuickCam Pro, VideoLogic HomeC@m and other cameras from Askey, Mustek, Microtek, and Tekom.LEAD's MCMP codecsupports this format."),
    CodecInfo(fourcc=u'KMVC', name=u"Karl Morton's Video Codec (presumably)", owner=u'?', description=u'Shipped as part of the game &quot;Worms&quot; by Team17 Software. Info is allegedly obtainable frominfo@beamaim.demon.co.uk.'),
    CodecInfo(fourcc=u'L261', name=u'LEAD H.261', owner=u'LEAD Technologies', description=u'?'),
    CodecInfo(fourcc=u'L263', name=u'LEAD H.263', owner=u'LEAD Technologies', description=u'LEAD tell me that &quot;The LEAD H.263 codec is a high quality lossy interframe DirectShow and Video for Windows (VfW) codec with a quality and compression ratio comparable to MPEG-4. It can be used for a range of applications including video-conferencing, Internet video or surveillance and monitoring. Existing video software, such as Windows&reg; Media Player&reg; and Ulead Media Studio&reg; can utilize this codec to play, create, convert and edit.&quot;'),
    CodecInfo(fourcc=u'LBYR', name=u'?', owner=u'?', description=u'Based on the naming, I would hazard a guess that this describes some Bayer image format and may have been registered by LEAD Technologies. Can anyone confirm or deny?'),
    CodecInfo(fourcc=u'LCMW', name=u'LEAD&nbsp;MCMW Video Codec', owner=u'LEAD Technologies', description=u'This is a wavelet-based codec. LEAD tell me &quot;The MCMW Codec is designed to create high-quality video using low bandwidth (dial-up) delivery. This is achieved by using a state of the art intraframe wavelet based compression technique that provides superior compression performance, while still ensuring optimal quality at any compression level.&quot;'),
    CodecInfo(fourcc=u'LCW2', name=u'LEAD MJPEG2000', owner=u'LEAD Technologies', description=u'Codec saving standard JPEG2000 streams. LEAD has more info about ithere.'),
    CodecInfo(fourcc=u'LEAD', name=u'LEAD Video Codec', owner=u'LEAD Technologies', description=u"LEAD tell me that this codec is now obsolete yet it seems that their &quot;MCMP Codec&quot; supports it so&nbsp;I guess it's not as obsolete as all that."),
    CodecInfo(fourcc=u'LGRY', name=u'Grayscale Image', owner=u'LEAD Technologies', description=u'Supports 12 and 16bpp grayscale images with additional low and high range information required for medical images. Format public but not finalised when this update was made.'),
    CodecInfo(fourcc=u'LJ11', name=u'LEAD JPEG 4:1:1', owner=u'LEAD Technologies', description=u"Presumably a JPEG codec which encodes YUV in 4:1:1 format. This is supported byLEAD's MCMP Codec."),
    CodecInfo(fourcc=u'LJ22', name=u'LEAD JPEG 4:2:2', owner=u'LEAD Technologies', description=u"Presumably a JPEG codec which encodes YUV in 4:2:2 format. This is supported byLEAD's MCMP Codec."),
    CodecInfo(fourcc=u'LJ2K', name=u'LEAD MJPEG 2000', owner=u'LEAD Technologies', description=u'LEAD&nbsp;tell me &quot;the LEAD MJPEG2000 Video codec saves standard JPEG2000 streams. This codec is perfect when high compression and interoperability are necessary.&quot;'),
    CodecInfo(fourcc=u'LJ44', name=u'LEAD JPEG 4:4:4', owner=u'LEAD Technologies', description=u"Presumably a JPEG codec which encodes YUV in 4:4:4 format. This is supported byLEAD's MCMP Codec."),
    CodecInfo(fourcc=u'Ljpg', name=u'LEAD MJPEG Codec', owner=u'LEAD Technologies', description=u'Supports color JPEG 4:1:1, 4:2:2, 4:4:4, grayscale JPEG 4:0:0) FOURCCs supported: MJPG, JPEG, dmb1 Lossless JPEG support including 24-bit color and 8,12 and 16-bit grayscale. Link offers download of a time-expiring version of the codec. This format is supported by theLEAD MCMP and MJPEG2000 codecs.'),
    CodecInfo(fourcc=u'LMP2', name=u'LEAD MPEG-2 Video Codec', owner=u'LEAD Technologies', description=u"LEAD's implementation of the MPEG-2 video compression standard. The codec linked here also supports several other standard MPEG2 FOURCCs. Supports High, Main and Simple profiles,  Low, Main, High1440 and&nbsp;High levels."),
    CodecInfo(fourcc=u'LMP4', name=u'LEAD MPEG-4 Video Codec', owner=u'LEAD Technologies', description=u'An H.264 codec suporting Main and Base Profles and levels up to 3.2. LEAD offer two versions of this codec,  a normal version and a professional version which offers more options and higher compression ratios.'),
    CodecInfo(fourcc=u'LSVC', name=u'Lightning Strike Video&nbsp;Codec', owner=u'ESPRE Solutions', description=u'Old version of the codec now identified asLSVX.'),
    CodecInfo(fourcc=u'LSVM', name=u'Lightning Strike Video&nbsp;Codec', owner=u'ESPRE Solutions', description=u'Another old version of the codec now identified asLSVX.'),
    CodecInfo(fourcc=u'LSVX', name=u'Lightning Strike Video&nbsp;Codec', owner=u'ESPRE Solutions', description=u'Multi-bitrate decoder used in the eViewStreamX product.'),
    CodecInfo(fourcc=u'LZO1', name=u'Lempel-Ziv-Oberhumer Codec', owner=u'Markus Oberhumer', description=u'A fast, lossless codec available in source code format.'),
    CodecInfo(fourcc=u'M263', name=u'H.263', owner=u'Microsoft', description=u"Redmond's codec implementing the H.263 compression standard."),
    CodecInfo(fourcc=u'M261', name=u'H.261', owner=u'Microsoft', description=u"Redmond's codec implementing the H.261 compression standard."),
    CodecInfo(fourcc=u'M4CCm4cc', name=u'MPEG-4', owner=u'Divio', description=u''),
    CodecInfo(fourcc=u'M4S2', name=u'MPEG-4(automatic WMP download)', owner=u'Microsoft', description=u'Final fully-compliant ISO MPEG4 decoder, compliant to MPEG-4 version 2 simple profile. An alternative download site can be foundhere.'),
    CodecInfo(fourcc=u'MC12', name=u'Motion Compensation Format', owner=u'ATI Technologies', description=u'Proprietary format used by ATI in MPEG decoding.'),
    CodecInfo(fourcc=u'MCAM', name=u'Motion Compensation Format', owner=u'ATI Technologies', description=u'Proprietary format used by ATI in MPEG decoding.'),
    CodecInfo(fourcc=u'MJ2C', name=u'Motion JPEG 2000', owner=u'Morgan Multimedia', description=u'Motion JPEG 2000'),
    CodecInfo(fourcc=u'mJPG', name=u'Motion JPEG including Huffman Tables', owner=u'IBM', description=u'A version of Motion JPEG which includes Huffman tables with each AVI frame. Developed by IBM before the MJPEG standard was finalised.'),
    CodecInfo(fourcc=u'MJPG', name=u'Motion JPEG', owner=u'?', description=u"Motion JPEG video. Codecs implementing MJPEG are (or have been) available fromhttp://www.jpg.com/imagetech_video.htmhttp://www.pmatrix.comPegasus ImagingMorgan Multimedia(long trial period)The format is also used byMatroxin their Rainbow Runner add-on video capture / MPEG playback board for various of their display adapters and by Canon who's cameras generate AVIs using this codec."),
    CodecInfo(fourcc=u'MMES', name=u'MPEG-2 ES', owner=u'Matrox', description=u'Matrox MPEG-2 video elementary stream.MPEG-2 main profile or 4:2:2 profile closed GOP IBP or I-frame only decoder.'),
    CodecInfo(fourcc=u'MP2A', name=u'Eval download', owner=u'Media Excel', description=u'MPEG-2 Audio'),
    CodecInfo(fourcc=u'MP2T', name=u'Eval download', owner=u'Media Excel', description=u'MPEG-2 Transport Stream'),
    CodecInfo(fourcc=u'MP2V', name=u'Eval download', owner=u'Media Excel', description=u'MPEG-2 Video'),
    CodecInfo(fourcc=u'MP42', name=u'MPEG-4(automatic WMP download)', owner=u'Microsoft', description=u'Apparently one of several different and incompatible MPEG-4 codecs. Rumour has it that this codec is downloadable from the Microsoft site somewhere. This codec is distributed as part of Microsoft Windows Media Tools 4. Includes quality improvements over the earlier MPG4.Download as part of &quot;Windows Media Codecs 8.0 for IT Professionals.&quot;'),
    CodecInfo(fourcc=u'MP43', name=u'MPEG-4(automatic WMP download)', owner=u'Microsoft', description=u"Yet another MPEG-4 variation from Microsoft. This FOURCC is not, however, listed on Microsoft's codecs site.&nbsp;This codec is distributed as part of Microsoft Windows Media Tools 4. Includes further quality improvements over the earlier MPG4."),
    CodecInfo(fourcc=u'MP4A', name=u'Eval download', owner=u'Media Excel', description=u'MPEG-4 Audio'),
    CodecInfo(fourcc=u'MP4S', name=u'MPEG-4(automatic WMP download)', owner=u'Microsoft ?', description=u'The first ISO standard codec for use with the Sharp digital camera implementing a restricted feature set of MPEG4.'),
    CodecInfo(fourcc=u'MP4T', name=u'Eval download', owner=u'Media Excel', description=u'MPEG-4 Transport Stream'),
    CodecInfo(fourcc=u'mp4v', name=u'MPEG-4', owner=u'?', description=u"Presumably a duplicate of MP4V. LEAD's MCMP codec supports this format and you can download an evaluation versionhere."),
    CodecInfo(fourcc=u'MP4V', name=u'Eval download', owner=u'Media Excel', description=u"MPEG-4 Video.LEAD's&nbsp;MCMP codecalso supports this format."),
    CodecInfo(fourcc=u'MPEG', name=u'MPEG', owner=u'?', description=u'MPEG video - presumably MPEG I ?'),
    CodecInfo(fourcc=u'MPG4', name=u'MPEG-4(automatic WMP download)', owner=u'Microsoft', description=u'MPEG-4 Video High Speed Compressor.Downloadable here, I am told. This codec was shipped with some versions of the Microsoft Netshow encoder (probably 3.0). This codec was based on early drafts of the MPEG-4 spec.'),
    CodecInfo(fourcc=u'MPGI', name=u'MPEG', owner=u'Sigma Designs', description=u'Editable MPEG codec'),
    CodecInfo(fourcc=u'MR16', name=u'?', owner=u'?', description=u'?'),
    CodecInfo(fourcc=u'MRCA', name=u'Mrcodec', owner=u'FAST Multimedia', description=u'And I thought it stood for &quot;Multi Role Combat Aircraft&quot;.'),
    CodecInfo(fourcc=u'MRLE', name=u'Microsoft RLE', owner=u'Microsoft', description=u"Run length encoded RGB format from Microsoft. Basically the same as the BI_RLE formats butMichael Knappclarifies:&quot;MRLE is just *nearly* the same compression as the existing 4 and 8bit RLE formats but the 'copy bytes-chunk' always has an even byte-length. That means that an empty byte is added if the 'copy chunk' contains an odd number of bytes&quot;"),
    CodecInfo(fourcc=u'MSVC', name=u'Microsoft Video 1', owner=u'Microsoft', description=u'Original codec shipped with Video For Windows. Deals with 8bpp and 16bpp images. Quality leaves a lot to be desired (IMHO). Full technical details are availablehere.'),
    CodecInfo(fourcc=u'MSZH', name=u'AVImszh', owner=u'Kenji Oshima', description=u'Kenji Oshima also developed a multi-threaded M3JPEG codec based on one by Morgan Multimedia. You candownload this here.Algorithm information can be foundhere. This is supposedly the same thing asZLIB.'),
    CodecInfo(fourcc=u'MTX1throughMTX9', name=u'?', owner=u'Matrox', description=u'Apparently these are MJPG variations registered by Matrox consumer products group.'),
    CodecInfo(fourcc=u'MVI1', name=u'Motion Pixels MVI1 Codec', owner=u'?', description=u'Part of the Motion Pixels player. Install the player and the codec will become available to other multimedia applications. Read moreat this site (look for Treasure Quest).'),
    CodecInfo(fourcc=u'MVI2', name=u'Motion Pixels MVI2 Codec', owner=u'?', description=u'As for MVI1, this is part of the Motion Pixels player. Read moreat this site.'),
    CodecInfo(fourcc=u'MWV1', name=u'Aware Motion Wavelets', owner=u'Aware Inc.', description=u'Wavelet compression-based codec optimised for Intel MMX platforms. Allegedly downloadable fromhere. Codec filename is icmw_32.dll.'),
    CodecInfo(fourcc=u'nAVI', name=u'Download here', owner=u'?', description=u'?'),
    CodecInfo(fourcc=u'NDSC', name=u'Nero&nbsp;Digital&nbsp;Cinema', owner=u'Nero Digital', description=u'Nero registered this with me recently but provided no information other than the name - sorry.'),
    CodecInfo(fourcc=u'ndsm', name=u'Nero MPEG4?', owner=u'Nero Digital', description=u'A contributor suggests that this codec is owned by Nero&nbsp;Digital and refer sto their flavour of MPEG4 but I have not been able to confirm this.'),
    CodecInfo(fourcc=u'ndsp', name=u'Nero Digital Portable', owner=u'Nero Digital', description=u'Nero have registered NDSP so my assumption is that they get the lower case version for free.'),
    CodecInfo(fourcc=u'NDSP', name=u'Nero Digital Portable', owner=u'Nero Digital', description=u'Apparently an MPEG4 implementation of some description.'),
    CodecInfo(fourcc=u'ndss', name=u'Nero Digital Standard', owner=u'Nero Digital', description=u'A contributor suggests that this codec is owned by Nero&nbsp;Digital and refers to their flavour of MPEG4 but I have not been able to confirm this.'),
    CodecInfo(fourcc=u'NDSS', name=u'Nero Digital Standard', owner=u'Nero Digital', description=u'Presumably the same as ndss.'),
    CodecInfo(fourcc=u'NDXC', name=u'Nero Digital AVC Cinema', owner=u'Nero Digital', description=u'Presumably a variation of MPEG4 part 10/AVC.'),
    CodecInfo(fourcc=u'NDXH', name=u'Nero Digital AVC HDTV', owner=u'Nero Digital', description=u'Presumably a variation of MPEG4 part 10/AVC.'),
    CodecInfo(fourcc=u'NDXP', name=u'Nero Digital AVC Portable', owner=u'Nero Digital', description=u'Presumably a variation of MPEG4 part 10/AVC.'),
    CodecInfo(fourcc=u'NDXS', name=u'Nero Digital AVC Standard', owner=u'Nero Digital', description=u'Presumably a variation of MPEG4 part 10/AVC.'),
    CodecInfo(fourcc=u'NTN1', name=u'Video Compression 1', owner=u'Nogatech/Zoran', description=u'?'),
    CodecInfo(fourcc=u'NTN2', name=u'Video Compression 2', owner=u'Nogatech/Zoran', description=u'An evolution of NTN1.'),
    CodecInfo(fourcc=u'NVDS', name=u'NVidia Texture Format', owner=u'NVidia', description=u'?'),
    CodecInfo(fourcc=u'NVHS', name=u'NVidia Texture Format', owner=u'NVidia', description=u'Apparently a texture format introduced for GEForce 3.'),
    CodecInfo(fourcc=u'NHVU', name=u'NVidia Texture Format', owner=u'NVidia', description=u'Apparently a texture format introduced for GEForce 3.'),
    CodecInfo(fourcc=u'NVS0-NVS5', name=u'?', owner=u'NVidia?', description=u'Supported by GEForce 2 GTS Pro / 64Mb DDR. Possibly a texture format.'),
    CodecInfo(fourcc=u'NVT0-NVT5', name=u'?', owner=u'NVidia?', description=u'Supported by GEForce 2 GTS Pro / 64Mb DDR. Possibly a texture format.'),
    CodecInfo(fourcc=u'PDVC', name=u'DVC codec', owner=u'I-O Data Device, Inc.', description=u'DV codec for I-O DATA Digital Video Capture products.'),
    CodecInfo(fourcc=u'PGVV', name=u'Radius Video Vision', owner=u'Radius', description=u'?'),
    CodecInfo(fourcc=u'PHMO', name=u'Photomotion', owner=u'IBM', description=u'?'),
    CodecInfo(fourcc=u'PIM1', name=u'Download here', owner=u'Pinnacle Systems', description=u'MPEG-1 based codec'),
    CodecInfo(fourcc=u'PIM2', name=u'?', owner=u'Pinnacle Systems', description=u'Pinnacle DC1000 firewire video editing card supports this format.'),
    CodecInfo(fourcc=u'pimj', name=u'Pegasus Lossless JPEG', owner=u'Pegasus Imaging', description=u'High speed compression and decompression of 24-bit RGB and 8-bit grayscale using Predictor 1 Lossless JPEG. Well suited for medical video. You may find additional informationhere.'),
    CodecInfo(fourcc=u'PIXL', name=u'Video XL', owner=u'Pinnacle Systems', description=u'This is apparently an alias forVIXL. You can find more information about ithere.'),
    CodecInfo(fourcc=u'PJPG', name=u'PA MJPEG', owner=u'Pierre Albou', description=u'Non-standard codec based on MJPEG.'),
    CodecInfo(fourcc=u'PVEZ', name=u'PowerEZ', owner=u'Horizons Technology', description=u"TrueMotion based codec (?) It appears that Horizons Technology has now been acquired by Raytheon and is no longer in the codec business (can someone confirm this - their URL is now redirected). Allegedly, you can download this codec from support.private.com but I'm not going to add a link since this is an adult video company and I don't want to get this site associated with porn."),
    CodecInfo(fourcc=u'PVMM', name=u'PacketVideo Corporation MPEG-4', owner=u'PacketVideo Corporation', description=u'Software MPEG4 codec that supports multiple bitrate encoding/decoding. It is also error resilient allowing transmission over wired/wireless networks.'),
    CodecInfo(fourcc=u'PVW2', name=u'Pegasus Wavelet 2000 Compression', owner=u'Pegasus Imaging', description=u"High speed compression and decompression of 24-bit RGB and 8-bit grayscale using  Pegasus' proprietary Wavelet2000 wavelet technology. Well suited for low motion, low bandwidth applications. More information is availablehere."),
    CodecInfo(fourcc=u'qpeq', name=u'QPEG 1.1', owner=u'Q-Team', description=u'?'),
    CodecInfo(fourcc=u'QPEG', name=u'QPEG', owner=u'Q-Team', description=u"Q-Team Dr.Knabe's 8-bit output codec with automatic palette switching for seamless edits."),
    CodecInfo(fourcc=u'raw', name=u'Raw RGB', owner=u'?', description=u'Apparently this contains &quot;raw, uncompressed RGB bitmaps&quot;.'),
    CodecInfo(fourcc=u'RGBT', name=u'32 bit support', owner=u'Computer Concepts', description=u"That's odd. I registered RGBT at the same time as a bunch of other FOURCCs and it was granted. The format I registered is for 16- and 32-bit uncompressed RBG images with a transparency plane. Microsoft's codec site, however, lists Computer Concepts rather than Brooktree (Conexant) as the owner. Hmm..."),
    CodecInfo(fourcc=u'rle', name=u'Apple Animation', owner=u'Apple', description=u'Yes this really is lower case. This format is used to compress Quicktime files. Available in 1, 2, 4, 8, 16, 24 and 32bit flavors.'),
    CodecInfo(fourcc=u'RLE', name=u'Run Length Encoder', owner=u'Microsoft?', description=u'I expect this is an equivalent to one of the the BI_RLEx FOURCCs (see theRGB page). The Win2K clock.avi sample uses this format. Final character in the FOURCC is a space.'),
    CodecInfo(fourcc=u'RLE4', name=u'4bpp Run Length Encoder', owner=u'Microsoft', description=u'Equivalent to BI_RLE4. SeeRGBpage for more details.'),
    CodecInfo(fourcc=u'RLE8', name=u'8bpp Run Length Encoder', owner=u'Microsoft', description=u'Equivalent to BI_RLE8. SeeRGBpage for more details.'),
    CodecInfo(fourcc=u'RMP4', name=u'MPEG-4 AS Profile Codec', owner=u'Sigma Designs', description=u'Press releaseheredescribes this codec.'),
    CodecInfo(fourcc=u'RPZA', name=u'Apple Video', owner=u'Apple', description=u'RGB555 block-based codec used in Quicktime files.'),
    CodecInfo(fourcc=u'RT21', name=u'Real Time Video 2.1', owner=u'Intel', description=u"What Indeo was called before the marketing guys got their hands on it. RTV or Real Time Video was the format produced by Intel's ActionMedia II adapter back in the late 80s. When the 80486 came along, this migrated to the software-decodable Indeo formats used today."),
    CodecInfo(fourcc=u'rv20', name=u'RealVideo G2', owner=u'Real', description=u'RealVideo G2 (6.0 and greater versions of the player and encoder)'),
    CodecInfo(fourcc=u'rv30', name=u'RealVideo 8', owner=u'Real', description=u''),
    CodecInfo(fourcc=u'RV40', name=u'RealVideo 10?', owner=u'Real', description=u'Apparently you need to install&nbsp;RealPlayer 10 to enable playback of any AVI encoded with RV40.'),
    CodecInfo(fourcc=u'RVX', name=u'RDX', owner=u'Intel', description=u'?'),
    CodecInfo(fourcc=u's422', name=u'VideoCap C210YUV Codec', owner=u'Tekram International', description=u"YUV422 codec shipped as part of the driver package for Tekram's C210 product."),
    CodecInfo(fourcc=u'SAN3', name=u'DivX 3', owner=u'?', description=u'A direct copy of DivX 3.11a, apparently. If you use a FOURCC changer tool on these AVIs they will play with the standard DivX codecs.'),
    CodecInfo(fourcc=u'SDCC', name=u'Digital Camera Codec', owner=u'Sun Communications', description=u'?'),
    CodecInfo(fourcc=u'SEDG', name=u'Samsung MPEG-4', owner=u'Samsung', description=u'MPEG-4 hardware and software codec used in Samsung digital video products.'),
    CodecInfo(fourcc=u'SFMC', name=u'Surface Fitting Method', owner=u'CrystalNet', description=u'CrystalGram video email codec.'),
    CodecInfo(fourcc=u'SMC', name=u'Apple Graphics', owner=u'Apple', description=u'8-bit, block-based codec used in Quicktime files.'),
    CodecInfo(fourcc=u'SMP4', name=u'?', owner=u'?', description=u'Codec used by Samsung VP-ms15 Digicam. This appears to be a DIVX clone since apparently SMP4 files play fine if you change the FOURCC to DIVX.'),
    CodecInfo(fourcc=u'SMSC', name=u'Proprietary codec', owner=u'Radius', description=u'?'),
    CodecInfo(fourcc=u'SMSD', name=u'Proprietary codec', owner=u'Radius', description=u'?'),
    CodecInfo(fourcc=u'smsv', name=u'Wavelet Video', owner=u'WorldConnect(corporate site)', description=u'Windows 95 codec installed automatically (and without warning) whenever you receive and play back a file sent fromVisualMail. Very low bandwidth format.'),
    CodecInfo(fourcc=u'SP40', name=u'?', owner=u'SunPlus', description=u'Appears to be an uncompressed YUV format of some kind but I&nbsp;have no information on this other than that.'),
    CodecInfo(fourcc=u'SP44', name=u'?', owner=u'SunPlus', description=u'Presumably a precursor to SP54?'),
    CodecInfo(fourcc=u'SP54', name=u'?', owner=u'SunPlus', description=u"Apparently a form of MJPEG but with some header or other missing. Software shipped with a number of low end digital cameras and webcams such asAiptek's Pocketcam digital still camera, Logitech's ClickSmart and Mustek's gSmart mini 2 use this format. These use SunPlus chipsets so presumably this explains the &quot;SP&quot;.You can download a tool that will convert this to MJPEGhere."),
    CodecInfo(fourcc=u'SPIG', name=u'Spigot', owner=u'Radius', description=u'?'),
    CodecInfo(fourcc=u'SQZ2', name=u'VXTreme Video Codec V2', owner=u'Microsoft', description=u'?'),
    CodecInfo(fourcc=u'SV10', name=u'Video R1', owner=u'Sorenson Media', description=u'Allegedly popular as a Quicktime codec. Used for trailer videos on Star Wars Episode 1 and other games.'),
    CodecInfo(fourcc=u'STVA', name=u'ST CMOS Imager Data (Bayer)', owner=u'ST Microelectronics', description=u'Data from ST CMOS Imagers that is passed to a codec external to the driver for processing to a displayable format. More info may be available at theST Vision and Imaging Unitweb site.'),
    CodecInfo(fourcc=u'STVB', name=u'ST CMOS Imager Data (Nudged Bayer)', owner=u'ST Microelectronics', description=u'Data from ST CMOS Imagers that is passed to a codec external to the driver&nbsp;for processing to a displayable format. More info may be available at theST Vision and Imaging Unitweb site.'),
    CodecInfo(fourcc=u'STVC', name=u'ST CMOS Imager Data (Bunched)', owner=u'ST Microelectronics', description=u'Data from ST CMOS Imagers that is passed to a codec external to the driver\t\t\t\t\t\t\t\t\nfor processing to a displayable format. More info may be available at theST Vision and Imaging Unitweb site.'),
    CodecInfo(fourcc=u'STVX', name=u'ST CMOS Imager Data (Extended CODEC Data Format)', owner=u'ST Microelectronics', description=u'Data from ST CMOS Imagers that is passed to a codec external to the driver\n\nfor processing to a displayable format. More info may be available at theST Vision and Imaging Unitweb site.'),
    CodecInfo(fourcc=u'STVY', name=u'ST CMOS Imager Data (Extended CODEC Data Format with Correction Data)', owner=u'ST Microelectronics', description=u'Data from ST CMOS Imagers that is passed to a codec external to the driver for processing to a displayable format. More info may be available at theST Vision and Imaging Unitweb site.'),
    CodecInfo(fourcc=u'SVQ1', name=u'Sorenson Video 1', owner=u'Sorenson Media', description=u'Hierarchicial adaptive multistage vector quantizer with mean removal and interframe motion compensation. Used in Quicktime. Complete technical details can be foundhere.'),
    CodecInfo(fourcc=u'SVQ3', name=u'Sorenson Video 3', owner=u'Sorenson Media', description=u'Video codec used in Quicktime files. A variant of H.264'),
    CodecInfo(fourcc=u'TLMS', name=u'Motion Intraframe Codec', owner=u'TeraLogic', description=u'?'),
    CodecInfo(fourcc=u'TLST', name=u'Motion Intraframe Codec', owner=u'TeraLogic', description=u'?'),
    CodecInfo(fourcc=u'TM20', name=u'TrueMotion 2.0', owner=u'Duck Corporation', description=u"Version 2.0 of Duck Corp's Truemotion codec. I'm told this codec is available as part of a pack that can be downloadedhere."),
    CodecInfo(fourcc=u'TM2X', name=u'TrueMotion 2X', owner=u'Duck Corporation', description=u"Duck Corp's follow-on codec after TM20."),
    CodecInfo(fourcc=u'TMIC', name=u'Motion Intraframe Codec', owner=u'TeraLogic', description=u'?'),
    CodecInfo(fourcc=u'TMOT', name=u'TrueMotion S', owner=u'Horizons Technology', description=u'Another FOURCC for TrueMotion S. This relates to the version of the codec licensed by Horizons Technology and is not compatible with DUCK.'),
    CodecInfo(fourcc=u'TR20', name=u'TrueMotion RT 2.0', owner=u'Duck Corporation', description=u'Realtime version of TrueMotion.'),
    CodecInfo(fourcc=u'TSCC', name=u'TechSmith Screen Capture Codec', owner=u'Techsmith Corp.', description=u'Codec used by theCamtasiaScreen &quot;camcorder&quot; application.'),
    CodecInfo(fourcc=u'TV10', name=u'Tecomac Low-Bit Rate Codec', owner=u'Tecomac, Inc.', description=u'?'),
    CodecInfo(fourcc=u'TVJP', name=u'?', owner=u'Pinnacle/Truevision', description=u'Used by the Targa 2000 board.'),
    CodecInfo(fourcc=u'TVMJ', name=u'?', owner=u'Pinnacle/Truevision', description=u'Used by the Targa 2000 board. Morgan Multimedia offers acodec supporting this format.'),
    CodecInfo(fourcc=u'TY2C', name=u'Trident Decompression Driver', owner=u'Trident Microsystems', description=u'?'),
    CodecInfo(fourcc=u'TY2N', name=u'?', owner=u'Trident Microsystems', description=u'?'),
    CodecInfo(fourcc=u'TY0N', name=u'?', owner=u'Trident Microsystems', description=u'?'),
    CodecInfo(fourcc=u'UCOD', name=u'ClearVideo', owner=u'eMajix.com', description=u'Fractal compression-based video codec available as a Video for Windows codec and in the ClearFusion Netscape plugin package.'),
    CodecInfo(fourcc=u'ULTI', name=u'Ultimotion', owner=u'IBM Corp.', description=u'Shipped with OS/2 but also available for Video for Windows. Link is to a very old version of the codec for Windows.'),
    CodecInfo(fourcc=u'v210', name=u'10-bit 4:2:2 Component YCbCr', owner=u'AJA&nbsp;Video Systems', description=u'Uncompressed format supported byAJA&nbsp;Video Systems Xenaadapter.'),
    CodecInfo(fourcc=u'V261', name=u'Lucent VX2000S', owner=u'Lucent', description=u'?'),
    CodecInfo(fourcc=u'V655', name=u'YUV 4:2:2', owner=u'Vitec Multimedia', description=u'Component ordering and packing unknown. Can you help?'),
    CodecInfo(fourcc=u'VCR1', name=u'ATI Video Codec 1', owner=u'ATI Technologies', description=u'Codec used by some ATI TV-PC products.'),
    CodecInfo(fourcc=u'VCR2', name=u'ATI Video Codec 2', owner=u'ATI Technologies', description=u'Codec used by some ATI TV-PC products.'),
    CodecInfo(fourcc=u'VCR3-9', name=u'ATI Video Codecs', owner=u'ATI Technologies', description=u"Registered for ATI Video Codecs version 3-9. I'm not sure these actually exist but the registrations are valid."),
    CodecInfo(fourcc=u'VDCT', name=u'VideoMaker Pro DIB', owner=u'Vitec Multimedia', description=u'16bpp format - no information on colour space, packing or component ordering.'),
    CodecInfo(fourcc=u'VDOM', name=u'VDOWave', owner=u'VDONet', description=u'Another streaming video format from VDONet.'),
    CodecInfo(fourcc=u'VDOW', name=u'VDOLive', owner=u'VDONet', description=u"H.263 internet streaming video format. Allegedly to be used (being used ?) by Microsoft in it's NetShow offering."),
    CodecInfo(fourcc=u'VDTZ', name=u'VideoTizer YUV Codec', owner=u'Darim Vision Co.', description=u"Codec used to store YUV AVIs captured with Darim Vision's VideoTizer product."),
    CodecInfo(fourcc=u'VGPX', name=u'VideoGramPix', owner=u'Alaris', description=u"Alaris VGPixel 32-bit AVI compression driver. It seems that this codec is installed along with the software for the &quot;Alaris Wee Cam.&quot;&nbsp; The codec doesn't appear to be available separately but, allegedly, works fine if you install theWee Cam softwareeven without the camera.&nbsp;You may also find some information athttp://www.alaris.com/vg_tech/vg_tchtx.htmandhttp://www.videogram.com."),
    CodecInfo(fourcc=u'VIFP', name=u'VFAPI Codec', owner=u'?', description=u'Take a look athttp://www.doom9.orgwhere you may find more information.'),
    CodecInfo(fourcc=u'VIDS', name=u'?', owner=u'Vitec Multimedia', description=u"YUV 4:2:2 CCIR 601 for V422 (no, I don't understand this either)"),
    CodecInfo(fourcc=u'VIVO', name=u'Vivo H.263', owner=u'Vivo Software', description=u"Vivo's version of the videoconferencing &quot;standard&quot; H.263 compression format (version 2.0.0)."),
    CodecInfo(fourcc=u'VIXL', name=u'Video XL', owner=u'Miro(now part of Pinnacle Systems)', description=u'Used my MiroVideo products such as the DC10, DC20, DC30, etc. A motion JPEG format that is accelerated in hardware with the Zoran chipset. You can find more information about ithere.'),
    CodecInfo(fourcc=u'VLV1', name=u'?', owner=u'VideoLogic', description=u"Codec probably used in VideoLogic's Captivator product line"),
    CodecInfo(fourcc=u'VP30', name=u'VP3', owner=u'On2', description=u"On2 tell me &quot;On2's VP3 codec will encode video into a VP3 file in multiple bit rates (roughly 220 Kbps, 330 Kbps, and 440 Kbps) and at optimum frame rates (usually 29.97 fps). This multiple bit rate file allows the TrueCast server to scale dynamically and smoothly as bandwidth congestion increases and decreases, providing the viewer with a consistent and reliable experience, without choppiness or interruption.&quot;"),
    CodecInfo(fourcc=u'VP31', name=u'VP31', owner=u'On2', description=u'The successor to VP30. This algorithm was open sourced by On2 in 2001-2002 and is the basis for theTheora Video Codec. Technical details are availablehere.'),
    CodecInfo(fourcc=u'VP40', name=u'VP40', owner=u'On2', description=u"Another in On2/Duck's line of video codecs."),
    CodecInfo(fourcc=u'VP50', name=u'VP50', owner=u'On2', description=u'..and another'),
    CodecInfo(fourcc=u'VP60', name=u'VP60', owner=u'On2', description=u'..and another'),
    CodecInfo(fourcc=u'VP61', name=u'VP61', owner=u'On2', description=u'..I can feel a pattern developing.'),
    CodecInfo(fourcc=u'VP62', name=u'VP62', owner=u'On2', description=u'..I wonder which one will be next?'),
    CodecInfo(fourcc=u'VQC1', name=u'VideoQuest Codec 1', owner=u'ViewQuest', description=u'Digital video camera codec.  ViewQuest offer lots of driver downloads on their site so you may find this in one of those packages.'),
    CodecInfo(fourcc=u'VQC2', name=u'VideoQuest Codec 2', owner=u'ViewQuest', description=u'Codec apparently used in Kodak DVC325 digital camera. Check the ViewQuest site download page - you may find the codec there somewhere.'),
    CodecInfo(fourcc=u'VQJC', name=u'?', owner=u'?', description=u'?'),
    CodecInfo(fourcc=u'vssv', name=u'VSS Video', owner=u'Vanguard Software Solutions', description=u'Real-time or near-real-time encoding with high compression ratios and good image quality.'),
    CodecInfo(fourcc=u'VUUU', name=u'?', owner=u'?', description=u'?'),
    CodecInfo(fourcc=u'VX1K', name=u'VX1000S Video Codec', owner=u'Lucent', description=u'?'),
    CodecInfo(fourcc=u'VX2K', name=u'VX2000S Video Codec', owner=u'Lucent', description=u'?'),
    CodecInfo(fourcc=u'VXSP', name=u'VX1000SP Video Codec', owner=u'Lucent', description=u'?'),
    CodecInfo(fourcc=u'VYU9', name=u'ATI YUV', owner=u'ATI Technologies', description=u'Planar YUV format supported by some ATI capture systems?'),
    CodecInfo(fourcc=u'VYUY', name=u'ATI YUV', owner=u'ATI Technologies', description=u'Packed YUV format supported by some ATI capture systems?'),
    CodecInfo(fourcc=u'WBVC', name=u'W9960', owner=u'Winbond Electronics', description=u'?'),
    CodecInfo(fourcc=u'WHAM', name=u'Microsoft Video 1', owner=u'Microsoft', description=u"Yet another FOURCC describing Microsoft's MSVC/CRAM codec."),
    CodecInfo(fourcc=u'WINX', name=u'Winnov Software Compression', owner=u'Winnov', description=u'Software codec used by some Winnov Videum products.'),
    CodecInfo(fourcc=u'WJPG', name=u'Winbond JPEG', owner=u'?', description=u'Format supported byAverMediaUSB TV-tuner/capture device.'),
    CodecInfo(fourcc=u'WMV1', name=u'Windows Media Video 7', owner=u'Microsoft', description=u''),
    CodecInfo(fourcc=u'WMV2', name=u'Windows Media Video 8', owner=u'Microsoft', description=u''),
    CodecInfo(fourcc=u'WMV3', name=u'Windows Media Video 9', owner=u'Microsoft', description=u'You may find other useful informationhere.'),
    CodecInfo(fourcc=u'WMVA', name=u'Windows Media Video 9 Advanced Profile', owner=u'Microsoft', description=u'The codec originally submitted for consideration as SMPTE VC1. This is not VC1 compliant and is no longer supported by Microsoft.'),
    CodecInfo(fourcc=u'WNV1', name=u'Winnov Hardware Compression', owner=u'Winnov', description=u'Hardware codec used by Winnov Videum products.'),
    CodecInfo(fourcc=u'WVC1', name=u'SMPTE VC1', owner=u'Microsoft', description=u"Microsoft's implementation of the SMPTE VC1 codec."),
    CodecInfo(fourcc=u'x263', name=u'Download here', owner=u'Xirlink', description=u'Another H.263 codec. This one is apparently used by an IBM-branded webcam.'),
    CodecInfo(fourcc=u'X264', name=u'H.264', owner=u'?', description=u'This FOURCC was originally registered by a company called&nbsp;XiWave but their web presence has disappeared. I am now informed that it is used by a popular open source H.264 implementation.'),
    CodecInfo(fourcc=u'XVID', name=u'XVID MPEG-4', owner=u'XVID', description=u"Codec is available in source form from XVID web site. Can also be downloaded as part of theGordian Knot Codec Pack.This FOURCC is also supported byLEAD's MCMP Codec."),
    CodecInfo(fourcc=u'XLV0', name=u'XL Video Decoder', owner=u'NetXL Inc.', description=u'?'),
    CodecInfo(fourcc=u'XMPG', name=u'XING MPEG', owner=u'XING Corporation', description=u'Editable (I frame only) MPEG codec'),
    CodecInfo(fourcc=u'XWV0-XWV9', name=u'XiWave Video Codec', owner=u'XiWave', description=u'XWV3 is currently used to describe Xi-3 Video. Others are unused.'),
    CodecInfo(fourcc=u'XXAN', name=u'?', owner=u'Origin?', description=u'Codec useing Huffman and RLE encoding paired with basic interframing. This format is used in Wing Commander 3 and 4 movies.The codec filename is xanlib.dll and a player, xanmovie, is available on the the Kilrathi Saga and Crusader game CDs.'),
    CodecInfo(fourcc=u'Y16', name=u'16bpp Grayscale Video', owner=u'Thermoteknix Systems Ltd.', description=u'A simple, uncompressed format for recording 16bpp grayscale images.'),
    CodecInfo(fourcc=u'Y411', name=u'YUV 4:1:1', owner=u'Microsoft', description=u'Supposedly 16bpp packed but 4:1:1 is usually 12bpp - odd. This is an uncompressed YUV format.'),
    CodecInfo(fourcc=u'Y41P', name=u'Brooktree YUV 4:1:1', owner=u'Conexant', description=u"This is an uncompressed YUV 411 format I registered about 7 years ago. I've stumbled on a few AVIs that use it, though, so I am listing it here. Download the ZIP and add VIDC.BT20=btvvc32.drv and VIDC.Y41P=btvvc32.drv to the [drivers32] section of your SYSTEM.INI to enable the codec"),
    CodecInfo(fourcc=u'Y444', name=u'?', owner=u'?', description=u'Format provided by the Windows 2000 drivers for the iRez&nbsp;Stealth Fire camera. Seems to be a copy of  IYU2.'),
    CodecInfo(fourcc=u'Y8', name=u'Grayscale video', owner=u'?', description=u'Probably a duplicate of the uncompressedY800format. The 2 last characters are spaces. See alsoGREYwhich appears to be another duplicate'),
    CodecInfo(fourcc=u'YC12', name=u'YUV 12 codec', owner=u'Intel', description=u'?'),
    CodecInfo(fourcc=u'YUV8', name=u'Caviar YUV8', owner=u'Winnov', description=u'?'),
    CodecInfo(fourcc=u'YUV9', name=u'YUV9 Raw Format', owner=u'Intel', description=u'An uncompressed YUV format used by Intel Indeo video products.'),
    CodecInfo(fourcc=u'YUVP', name=u'?', owner=u'?', description=u'An uncompressed YCrCb 4:2:2 format using 10-bit precision components ordered Y0 U0 Y1 V0. I have no idea how the 10 bit samples are packed - sorry.'),
    CodecInfo(fourcc=u'YUY2', name=u'Raw, uncompressed YUV 4:2:2', owner=u'Microsoft (probably)', description=u"Yes, I know this isn't a compressed format but I get so many questions about where to find a codec for YUY2 AVIs that it's here to allow people to findthe answereasily. I'm told &quot;VirtualDub has been able to decode YUY2 internally since V1.3a. Newer versions of Ben Rudiak-Gould's Huffyuv codec will also convert YUY2 or UYVY data to RGB&quot;"),
    CodecInfo(fourcc=u'YUYV', name=u'?', owner=u'Canopus', description=u"Compressed YUV format. Some of the software on theCanopus download pagemay include this codec (I'm guessing - please tell me if this is true)."),
    CodecInfo(fourcc=u'YV12', name=u'YUV 4:2:0 Planar', owner=u'MicrosoftorApple?', description=u'Uncompressed format commonly used in MPEG video processing. You can find more informatio on theYUV formats page.'),
    CodecInfo(fourcc=u'YV16', name=u'YUV 4:2:2 Planar', owner=u'Elecard', description=u'Uncompressed format similar to YV12 but with twice the chroma resolution.'),
    CodecInfo(fourcc=u'YV92', name=u'?', owner=u'Intel', description=u"Codec used by Intel's Smart Video Recorder product. Apparently a  compresssed YVU9  format."),
    CodecInfo(fourcc=u'ZLIB', name=u'?', owner=u'?', description=u'A generic lossless codec that you candownload from here. Apparently also contains theMSZHcodec. Algorithm info can be foundhere. May be the same algorithm used in compressing PNG images.'),
    CodecInfo(fourcc=u'ZMBV', name=u'The DoxBox Project', owner=u'DoxBox&nbsp;Capture Codec', description=u'A codec using ZLIB compression which is used to capture screen information.'),
    CodecInfo(fourcc=u'ZPEG', name=u'Video Zipper', owner=u'Metheus', description=u'?'),
    CodecInfo(fourcc=u'ZyGo', name=u'ZyGoVideo', owner=u'ZyGo Digital', description=u'Video codec usually packaged in Quicktime files. Investigations suggest that it may be a variant of H.263.'),
    CodecInfo(fourcc=u'ZYYY', name=u'?', owner=u'?', description=u'?')]


class CodecTest(object):
    @classmethod
    def test_codec(self, codec):
        with Silence():
            f_handle, output_path = tempfile.mkstemp(suffix='.avi') 
            output_path = path(output_path)
            writer = None
            try:
                dimensions = (640, 480)
                frame = cv.CreateImage(dimensions, cv.IPL_DEPTH_8U, 3)
                fourcc = cv.CV_FOURCC(*str(codec))
                writer = cv.CreateVideoWriter(output_path, fourcc, 24,
                                                    dimensions, True)
                result = cv.WriteFrame(writer, frame)
            except:
                result = 0
            finally:
                if writer:
                    del writer
                os.close(f_handle)
                output_path.remove()
        return not(result == 0)


def get_supported_codecs():
    return set([c for c in ALL_CODECS if CodecTest.test_codec(c.fourcc)])


def get_codec_list(url='http://www.fourcc.org/codecs.php'):
    from BeautifulSoup import BeautifulSoup

    data = urlopen(url).read()
    soup = BeautifulSoup(data)

    table = soup.find('table', {'class': 'jqdt display'})

    table_body = table.findChild('tbody')
    rows = table_body.findChildren('tr')


    return [CodecInfo(*[getattr(c, 'text') for c in row.findChildren('td')]) for row in rows]


