#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `account_analytic_plans` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-account-analytic-plans",
    version = "7.0.355",
    description = "Multiple Analytic Plans",
    long_description = 
"""

This module allows to use several analytic plans according to the general journal.
==================================================================================

Here multiple analytic lines are created when the invoice or the entries
are confirmed.

For example, you can define the following analytic structure:
-------------------------------------------------------------
  * **Projects**
      * Project 1
          + SubProj 1.1
          
          + SubProj 1.2

      * Project 2
      
  * **Salesman**
      * Eric
      
      * Fabien

Here, we have two plans: Projects and Salesman. An invoice line must be able to write analytic entries in the 2 plans: SubProj 1.1 and Fabien. The amount can also be split.
 
The following example is for an invoice that touches the two subprojects and assigned to one salesman:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
**Plan1:**

    * SubProject 1.1 : 50%
    
    * SubProject 1.2 : 50%
    
**Plan2:**
    Eric: 100%

So when this line of invoice will be confirmed, it will generate 3 analytic lines,for one account entry.

The analytic plan validates the minimum and maximum percentage at the time of creation of distribution models.
        
""",
    url = "http://www.openerp.com",
    author = "OpenERP SA",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.account_analytic_plans': ".",
    },
    packages = ["openerp.addons.account_analytic_plans","openerp.addons.account_analytic_plans.report","openerp.addons.account_analytic_plans.wizard"],
    package_data = {
        'openerp.addons.account_analytic_plans': ["i18n/*.po*","account_analytic_plans_view.xml","account_analytic_plans_report.xml","images/analytic_plan.jpeg","i18n/fa.po","i18n/id.po","i18n/hr.po","i18n/da.po","i18n/sl.po","i18n/es_MX.po","i18n/ru.po","i18n/zh_TW.po","i18n/en_GB.po","i18n/cs.po","i18n/sq.po","i18n/fi.po","i18n/pt_BR.po","i18n/ko.po","i18n/gu.po","i18n/bg.po","i18n/es_VE.po","i18n/tlh.po","i18n/es_PY.po","i18n/ja.po","i18n/ro.po","i18n/es_AR.po","i18n/sr@latin.po","i18n/es.po","i18n/mn.po","i18n/it.po","i18n/nl.po","i18n/sv.po","i18n/es_EC.po","i18n/oc.po","i18n/uk.po","i18n/bs.po","i18n/tr.po","i18n/de.po","i18n/et.po","i18n/sr.po","i18n/lt.po","i18n/hu.po","i18n/vi.po","i18n/el.po","i18n/gl.po","i18n/lv.po","i18n/mk.po","i18n/ca.po","i18n/fr.po","i18n/zh_CN.po","i18n/pl.po","i18n/nl_BE.po","i18n/nb.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","test/acount_analytic_plans_report.yml","security/ir.model.access.csv","security/account_analytic_plan_security.xml","report/crossovered_analytic.sxw","report/crossovered_analytic.rml","wizard/analytic_plan_create_model_view.xml","wizard/account_crossovered_analytic_view.xml","security/account_analytic_plan_security.xml","security/ir.model.access.csv","account_analytic_plans_view.xml","account_analytic_plans_report.xml","wizard/analytic_plan_create_model_view.xml","wizard/account_crossovered_analytic_view.xml"],
    },
    install_requires = ["openerp-account","openerp-account-analytic-default"],
    tests_require = ["unittest2"],
)
