#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `account_payment` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-account-payment",
    version = "7.0.406",
    description = "Suppliers Payment Management",
    long_description = 
"""

Module to manage the payment of your supplier invoices.
=======================================================

This module allows you to create and manage your payment orders, with purposes to
--------------------------------------------------------------------------------- 
    * serve as base for an easy plug-in of various automated payment mechanisms.
    * provide a more efficient way to manage invoice payment.

Warning:
~~~~~~~~
The confirmation of a payment order does _not_ create accounting entries, it just 
records the fact that you gave your payment order to your bank. The booking of 
your order must be encoded as usual through a bank statement. Indeed, it's only 
when you get the confirmation from your bank that your order has been accepted 
that you can book it in your accounting. To help you with that operation, you 
have a new option to import payment orders as bank statement lines.
    
""",
    url = "",
    author = "OpenERP SA",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.account_payment': ".",
    },
    packages = ["openerp.addons.account_payment","openerp.addons.account_payment.report","openerp.addons.account_payment.wizard"],
    package_data = {
        'openerp.addons.account_payment': ["i18n/*.po*","account_invoice_view.xml","account_payment_workflow.xml","account_payment_view.xml","account_payment_report.xml","account_payment_sequence.xml","account_payment_demo.xml","images/payment_order.jpeg","images/payment_mode.jpeg","i18n/fa.po","i18n/id.po","i18n/hr.po","i18n/da.po","i18n/sl.po","i18n/es_MX.po","i18n/ru.po","i18n/zh_TW.po","i18n/en_GB.po","i18n/cs.po","i18n/sq.po","i18n/fi.po","i18n/pt_BR.po","i18n/ko.po","i18n/bg.po","i18n/es_VE.po","i18n/tlh.po","i18n/es_PY.po","i18n/ja.po","i18n/ro.po","i18n/es_AR.po","i18n/hi.po","i18n/sr@latin.po","i18n/es.po","i18n/mn.po","i18n/es_CL.po","i18n/it.po","i18n/am.po","i18n/nl.po","i18n/sv.po","i18n/es_EC.po","i18n/oc.po","i18n/uk.po","i18n/bs.po","i18n/tr.po","i18n/de.po","i18n/et.po","i18n/sr.po","i18n/lt.po","i18n/hu.po","i18n/vi.po","i18n/el.po","i18n/gl.po","i18n/lv.po","i18n/mk.po","i18n/ca.po","i18n/fr.po","i18n/zh_CN.po","i18n/pl.po","i18n/nl_BE.po","i18n/nb.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","test/cancel_payment_order.yml","test/account_payment_report.yml","test/account_payment_demo.yml","test/payment_order_process.yml","security/ir.model.access.csv","security/account_payment_security.xml","report/order.rml","report/order.sxw","wizard/account_payment_create_order_view.xml","wizard/account_payment_populate_statement_view.xml","wizard/account_payment_pay_view.xml","security/account_payment_security.xml","security/ir.model.access.csv","wizard/account_payment_pay_view.xml","wizard/account_payment_populate_statement_view.xml","wizard/account_payment_create_order_view.xml","account_payment_view.xml","account_payment_workflow.xml","account_payment_sequence.xml","account_invoice_view.xml","account_payment_report.xml","account_payment_demo.xml"],
    },
    install_requires = ["openerp-account","openerp-account-voucher"],
    tests_require = ["unittest2"],
)
