#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `account_report_company` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-account-report-company",
    version = "7.0.355",
    description = "Invoice Analysis per Company",
    long_description = 
"""

Add an extra Company dimension on Invoices for consolidated Invoice Analysis
============================================================================

By default Customer and Supplier invoices can be linked to a contact within
a company, but the company is not a direct reference in the database structure for
invoices. Journal Entries are however always linked to the company and not to
contacts, so that Accounts Payable and Receivable are always correct and consolidated
at company level.

When many different contacts/departments need to be invoiced within the same parent company,
this can make reporting by Company more difficult: reports are directly based on the
database structure and would not provide an aggregated company dimension.

This modules solves the problem by adding an explicit company reference on invoices,
automatically computed from the invoice contact, and use this new dimension
when grouping the list of Invoices or the Invoice Analysis report by Partner. 

Note: this module will likely be removed for the next major OpenERP version and
directly integrated in the core accounting. 
""",
    url = "http://www.openerp.com",
    author = "OpenERP SA",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.account_report_company': ".",
    },
    packages = ["openerp.addons.account_report_company","openerp.addons.account_report_company.report"],
    package_data = {
        'openerp.addons.account_report_company': ["i18n/*.po*","account_invoice_view.xml","res_partner_view.xml","i18n/hr.po","i18n/da.po","i18n/sl.po","i18n/ru.po","i18n/en_GB.po","i18n/cs.po","i18n/pt_BR.po","i18n/ro.po","i18n/es.po","i18n/it.po","i18n/nl.po","i18n/bs.po","i18n/tr.po","i18n/de.po","i18n/hu.po","i18n/vi.po","i18n/zh_CN.po","i18n/pl.po","i18n/pt.po","report/account_invoice_report_view.xml","account_invoice_view.xml","res_partner_view.xml","report/account_invoice_report_view.xml"],
    },
    install_requires = ["openerp-account"],
    tests_require = ["unittest2"],
)
