#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `auth_ldap` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-auth-ldap",
    version = "7.0.355",
    description = "Authentication via LDAP",
    long_description = 
"""

Adds support for authentication by LDAP server.
===============================================
This module allows users to login with their LDAP username and password, and
will automatically create OpenERP users for them on the fly.

**Note:** This module only work on servers who have Python's ``ldap`` module installed.

Configuration:
--------------
After installing this module, you need to configure the LDAP parameters in the
Configuration tab of the Company details. Different companies may have different
LDAP servers, as long as they have unique usernames (usernames need to be unique
in OpenERP, even across multiple companies).

Anonymous LDAP binding is also supported (for LDAP servers that allow it), by
simply keeping the LDAP user and password empty in the LDAP configuration.
This does not allow anonymous authentication for users, it is only for the master
LDAP account that is used to verify if a user exists before attempting to
authenticate it.

Securing the connection with STARTTLS is available for LDAP servers supporting
it, by enabling the TLS option in the LDAP configuration.

For further options configuring the LDAP settings, refer to the ldap.conf
manpage: manpage:`ldap.conf(5)`.

Security Considerations:
------------------------
Users' LDAP passwords are never stored in the OpenERP database, the LDAP server
is queried whenever a user needs to be authenticated. No duplication of the
password occurs, and passwords are managed in one place only.

OpenERP does not manage password changes in the LDAP, so any change of password
should be conducted by other means in the LDAP directory directly (for LDAP users).

It is also possible to have local OpenERP users in the database along with
LDAP-authenticated users (the Administrator account is one obvious example).

Here is how it works:
---------------------
    * The system first attempts to authenticate users against the local OpenERP
      database;
    * if this authentication fails (for example because the user has no local
      password), the system then attempts to authenticate against LDAP;

As LDAP users have blank passwords by default in the local OpenERP database
(which means no access), the first step always fails and the LDAP server is
queried to do the authentication.

Enabling STARTTLS ensures that the authentication query to the LDAP server is
encrypted.

User Template:
--------------
In the LDAP configuration on the Company form, it is possible to select a *User
Template*. If set, this user will be used as template to create the local users
whenever someone authenticates for the first time via LDAP authentication. This
allows pre-setting the default groups and menus of the first-time users.

**Warning:** if you set a password for the user template, this password will be
         assigned as local password for each new LDAP user, effectively setting
         a *master password* for these users (until manually changed). You
         usually do not want this. One easy way to setup a template user is to
         login once with a valid LDAP user, let OpenERP create a blank local
         user with the same login (and a blank password), then rename this new
         user to a username that does not exist in LDAP, and setup its groups
         the way you want.
    
""",
    url = "http://www.openerp.com",
    author = "OpenERP SA",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.auth_ldap': ".",
    },
    packages = ["openerp.addons.auth_ldap"],
    package_data = {
        'openerp.addons.auth_ldap': ["i18n/*.po*","users_ldap_view.xml","user_ldap_installer.xml","images/ldap_configuration.jpeg","i18n/hr.po","i18n/da.po","i18n/sl.po","i18n/es_MX.po","i18n/ru.po","i18n/en_GB.po","i18n/cs.po","i18n/fi.po","i18n/pt_BR.po","i18n/bg.po","i18n/es_VE.po","i18n/ja.po","i18n/ro.po","i18n/es.po","i18n/mn.po","i18n/it.po","i18n/nl.po","i18n/sv.po","i18n/tr.po","i18n/de.po","i18n/hu.po","i18n/gl.po","i18n/mk.po","i18n/ca.po","i18n/fr.po","i18n/zh_CN.po","i18n/pl.po","i18n/nb.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","security/ir.model.access.csv","users_ldap_view.xml","user_ldap_installer.xml","security/ir.model.access.csv"],
    },
    install_requires = ["openerp-core","python-ldap"],
    tests_require = ["unittest2"],
)
