#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `l10n_be_coda` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-l10n-be-coda",
    version = "7.0.355",
    description = "Belgium - Import Bank CODA Statements",
    long_description = 
"""

Module to import CODA bank statements.
======================================

Supported are CODA flat files in V2 format from Belgian bank accounts.
----------------------------------------------------------------------
    * CODA v1 support.
    * CODA v2.2 support.
    * Foreign Currency support.
    * Support for all data record types (0, 1, 2, 3, 4, 8, 9).
    * Parsing & logging of all Transaction Codes and Structured Format 
      Communications.
    * Automatic Financial Journal assignment via CODA configuration parameters.
    * Support for multiple Journals per Bank Account Number.
    * Support for multiple statements from different bank accounts in a single 
      CODA file.
    * Support for 'parsing only' CODA Bank Accounts (defined as type='info' in 
      the CODA Bank Account configuration records).
    * Multi-language CODA parsing, parsing configuration data provided for EN, 
      NL, FR.

The machine readable CODA Files are parsed and stored in human readable format in 
CODA Bank Statements. Also Bank Statements are generated containing a subset of 
the CODA information (only those transaction lines that are required for the 
creation of the Financial Accounting records). The CODA Bank Statement is a 
'read-only' object, hence remaining a reliable representation of the original
CODA file whereas the Bank Statement will get modified as required by accounting 
business processes.

CODA Bank Accounts configured as type 'Info' will only generate CODA Bank Statements.

A removal of one object in the CODA processing results in the removal of the 
associated objects. The removal of a CODA File containing multiple Bank 
Statements will also remove those associated statements.

The following reconciliation logic has been implemented in the CODA processing:
-------------------------------------------------------------------------------
    1) The Company's Bank Account Number of the CODA statement is compared against 
       the Bank Account Number field of the Company's CODA Bank Account 
       configuration records (whereby bank accounts defined in type='info' 
       configuration records are ignored). If this is the case an 'internal transfer'
       transaction is generated using the 'Internal Transfer Account' field of the 
       CODA File Import wizard.
    2) As a second step the 'Structured Communication' field of the CODA transaction
       line is matched against the reference field of in- and outgoing invoices 
       (supported : Belgian Structured Communication Type).
    3) When the previous step doesn't find a match, the transaction counterparty is 
       located via the Bank Account Number configured on the OpenERP Customer and 
       Supplier records.
    4) In case the previous steps are not successful, the transaction is generated 
       by using the 'Default Account for Unrecognized Movement' field of the CODA 
       File Import wizard in order to allow further manual processing.

In stead of a manual adjustment of the generated Bank Statements, you can also 
re-import the CODA after updating the OpenERP database with the information that 
was missing to allow automatic reconciliation.

Remark on CODA V1 support:
~~~~~~~~~~~~~~~~~~~~~~~~~~
In some cases a transaction code, transaction category or structured 
communication code has been given a new or clearer description in CODA V2.The
description provided by the CODA configuration tables is based upon the CODA 
V2.2 specifications.
If required, you can manually adjust the descriptions via the CODA configuration menu.
""",
    url = "",
    author = "Noviat",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.l10n_be_coda': ".",
    },
    packages = ["openerp.addons.l10n_be_coda","openerp.addons.l10n_be_coda.wizard"],
    package_data = {
        'openerp.addons.l10n_be_coda': ["i18n/*.po*","l10n_be_coda_wizard.xml","l10n_be_coda_view.xml","images/coda_logs.jpeg","images/import_coda_logs.jpeg","i18n/fa.po","i18n/hr.po","i18n/da.po","i18n/sl.po","i18n/es_MX.po","i18n/ru.po","i18n/zh_TW.po","i18n/en_GB.po","i18n/sq.po","i18n/fi.po","i18n/pt_BR.po","i18n/bg.po","i18n/es_VE.po","i18n/es_PY.po","i18n/ja.po","i18n/ro.po","i18n/sr@latin.po","i18n/es.po","i18n/mn.po","i18n/it.po","i18n/nl.po","i18n/sv.po","i18n/es_EC.po","i18n/tr.po","i18n/en_AU.po","i18n/de.po","i18n/et.po","i18n/sr.po","i18n/hu.po","i18n/vi.po","i18n/el.po","i18n/gl.po","i18n/lv.po","i18n/mk.po","i18n/ca.po","i18n/fr.po","i18n/zh_CN.po","i18n/pl.po","i18n/nl_BE.po","i18n/nb.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","l10n_be_coda_wizard.xml","l10n_be_coda_view.xml"],
    },
    install_requires = ["openerp-account-voucher","openerp-base-iban","openerp-l10n-be-invoice-bba"],
    tests_require = ["unittest2"],
)
