#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `l10n_br` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-l10n-br",
    version = "7.0.355",
    description = "Brazilian - Accounting",
    long_description = 
"""

Base module for the Brazilian localization
==========================================

This module consists in:

 - Generic Brazilian chart of accounts
 - Brazilian taxes such as:

        - IPI
        - ICMS
        - PIS
        - COFINS
        - ISS
        - IR
        - IRPJ
        - CSLL

The field tax_discount has also been added in the account.tax.template and 
account.tax objects to allow the proper computation of some Brazilian VATs 
such as ICMS. The chart of account creation wizard has been extended to 
propagate those new data properly.

It's important to note however that this module lack many implementations to 
use OpenERP properly in Brazil. Those implementations (such as the electronic 
fiscal Invoicing which is already operational) are brought by more than 15 
additional modules of the Brazilian Launchpad localization project 
https://launchpad.net/openerp.pt-br-localiz and their dependencies in the 
extra addons branch. Those modules aim at not breaking with the remarkable 
OpenERP modularity, this is why they are numerous but small. One of the 
reasons for maintaining those modules apart is that Brazilian Localization 
leaders need commit rights agility to complete the localization as companies 
fund the remaining legal requirements (such as soon fiscal ledgers, 
accounting SPED, fiscal SPED and PAF ECF that are still missing as September 
2011). Those modules are also strictly licensed under AGPL V3 and today don't 
come with any additional paid permission for online use of 'private modules'.
""",
    url = "http://openerpbrasil.org",
    author = "Akretion, OpenERP Brasil",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.l10n_br': ".",
    },
    packages = ["openerp.addons.l10n_br"],
    package_data = {
        'openerp.addons.l10n_br': ["i18n/*.po*","l10n_br_wizard.xml","account_view.xml","data/account_tax_code_template.xml","data/account_chart_template.xml","data/account.account.type.csv","data/account_tax_template.xml","data/account.account.template.csv","images/1_config_chart_l10n_br.jpeg","images/2_l10n_br_chart.jpeg","static/src/img/icon.png","i18n/da.po","i18n/sl.po","i18n/es_MX.po","i18n/ru.po","i18n/en_GB.po","i18n/sq.po","i18n/pt_BR.po","i18n/bg.po","i18n/es_VE.po","i18n/es_PY.po","i18n/hi.po","i18n/sr@latin.po","i18n/es.po","i18n/it.po","i18n/nl.po","i18n/oc.po","i18n/tr.po","i18n/gl.po","i18n/ca.po","i18n/fr.po","i18n/nb.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","data/account.account.type.csv","data/account.account.template.csv","data/account_tax_code_template.xml","data/account_chart_template.xml","data/account_tax_template.xml","account_view.xml","l10n_br_wizard.xml"],
    },
    install_requires = ["openerp-account","openerp-account-chart"],
    tests_require = ["unittest2"],
)
