#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `l10n_fr_rib` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-l10n-fr-rib",
    version = "7.0.355",
    description = "French RIB Bank Details",
    long_description = 
"""

This module lets users enter the banking details of Partners in the RIB format (French standard for bank accounts details).
===========================================================================================================================

RIB Bank Accounts can be entered in the "Accounting" tab of the Partner form by specifying the account type "RIB". 

The four standard RIB fields will then become mandatory:
--------------------------------------------------------    
    - Bank Code
    - Office Code
    - Account number
    - RIB key
    
As a safety measure, OpenERP will check the RIB key whenever a RIB is saved, and
will refuse to record the data if the key is incorrect. Please bear in mind that
this can only happen when the user presses the 'save' button, for example on the
Partner Form. Since each bank account may relate to a Bank, users may enter the
RIB Bank Code in the Bank form - it will the pre-fill the Bank Code on the RIB
when they select the Bank. To make this easier, this module will also let users
find Banks using their RIB code.

The module base_iban can be a useful addition to this module, because French banks
are now progressively adopting the international IBAN format instead of the RIB format.
The RIB and IBAN codes for a single account can be entered by recording two Bank
Accounts in OpenERP: the first with the type 'RIB', the second with the type 'IBAN'. 
""",
    url = "",
    author = "",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.l10n_fr_rib': ".",
    },
    packages = ["openerp.addons.l10n_fr_rib"],
    package_data = {
        'openerp.addons.l10n_fr_rib': ["i18n/*.po*","bank_data.xml","bank_view.xml","i18n/sl.po","i18n/pt_BR.po","i18n/es.po","i18n/nl.po","i18n/tr.po","i18n/fr.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","bank_data.xml","bank_view.xml"],
    },
    install_requires = ["openerp-account","openerp-base-iban"],
    tests_require = ["unittest2"],
)
