#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `l10n_fr` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-l10n-fr",
    version = "7.0.355",
    description = "France - Accounting",
    long_description = 
"""

This is the module to manage the accounting chart for France in OpenERP.
========================================================================

This module applies to companies based in France mainland. It doesn't apply to
companies based in the DOM-TOMs (Guadeloupe, Martinique, Guyane, Réunion, Mayotte).

This localisation module creates the VAT taxes of type 'tax included' for purchases
(it is notably required when you use the module 'hr_expense'). Beware that these
'tax included' VAT taxes are not managed by the fiscal positions provided by this
module (because it is complex to manage both 'tax excluded' and 'tax included'
scenarios in fiscal positions).

This localisation module doesn't properly handle the scenario when a France-mainland
company sells services to a company based in the DOMs. We could manage it in the
fiscal positions, but it would require to differentiate between 'product' VAT taxes
and 'service' VAT taxes. We consider that it is too 'heavy' to have this by default
in l10n_fr; companies that sell services to DOM-based companies should update the
configuration of their taxes and fiscal positions manually.

**Credits:** Sistheo, Zeekom, CrysaLEAD, Akretion and Camptocamp.
""",
    url = "http://www.openerp.com",
    author = "OpenERP SA",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.l10n_fr': ".",
    },
    packages = ["openerp.addons.l10n_fr","openerp.addons.l10n_fr.report","openerp.addons.l10n_fr.wizard"],
    package_data = {
        'openerp.addons.l10n_fr': ["i18n/*.po*","plan_comptable_general.xml","fr_pcg_taxes.xml","fr_tax.xml","fr_fiscal_templates.xml","l10n_fr_view.xml","l10n_fr_wizard.xml","fr_report.xml","images/config_chart_l10n_fr.jpeg","images/l10n_fr_chart.jpeg","static/src/img/icon.png","i18n/ko_KO.po","i18n/id.po","i18n/hr.po","i18n/da.po","i18n/sl.po","i18n/es_MX.po","i18n/ru.po","i18n/zh_TW.po","i18n/cs.po","i18n/sq.po","i18n/pt_BR.po","i18n/ko.po","i18n/bg.po","i18n/es_VE.po","i18n/tlh.po","i18n/es_PY.po","i18n/ro.po","i18n/es_AR.po","i18n/sr@latin.po","i18n/es.po","i18n/it.po","i18n/nl.po","i18n/sv.po","i18n/oc.po","i18n/uk.po","i18n/bs.po","i18n/tr.po","i18n/de.po","i18n/et.po","i18n/lt.po","i18n/hu.po","i18n/vi.po","i18n/gl.po","i18n/ca.po","i18n/fr.po","i18n/zh_CN.po","i18n/pl.po","i18n/nl_BE.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","test/l10n_fr_report.yml","security/ir.model.access.csv","report/compute_resultant_report.sxw","report/bilan_report.sxw","report/bilan_report.rml","report/compute_resultant_report.rml","wizard/fr_report_bilan_view.xml","wizard/fr_report_compute_resultant_view.xml","fr_report.xml","plan_comptable_general.xml","l10n_fr_view.xml","l10n_fr_wizard.xml","fr_pcg_taxes.xml","fr_tax.xml","fr_fiscal_templates.xml","security/ir.model.access.csv","wizard/fr_report_bilan_view.xml","wizard/fr_report_compute_resultant_view.xml"],
    },
    install_requires = ["openerp-base-iban","openerp-account","openerp-account-chart","openerp-base-vat","openerp-l10n-fr-rib"],
    tests_require = ["unittest2"],
)
