#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `mrp` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-mrp",
    version = "7.0.406",
    description = "MRP",
    long_description = 
"""

Manage the Manufacturing process in OpenERP
===========================================

The manufacturing module allows you to cover planning, ordering, stocks and the manufacturing or assembly of products from raw materials and components. It handles the consumption and production of products according to a bill of materials and the necessary operations on machinery, tools or human resources according to routings.

It supports complete integration and planification of stockable goods, consumables or services. Services are completely integrated with the rest of the software. For instance, you can set up a sub-contracting service in a bill of materials to automatically purchase on order the assembly of your production.

Key Features
------------
* Make to Stock/Make to Order
* Multi-level bill of materials, no limit
* Multi-level routing, no limit
* Routing and work center integrated with analytic accounting
* Periodical scheduler computation 
* Allows to browse bills of materials in a complete structure that includes child and phantom bills of materials

Dashboard / Reports for MRP will include:
-----------------------------------------
* Procurements in Exception (Graph)
* Stock Value Variation (Graph)
* Work Order Analysis
    
""",
    url = "http://www.openerp.com",
    author = "OpenERP SA",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.mrp': ".",
    },
    packages = ["openerp.addons.mrp","openerp.addons.mrp.tests","openerp.addons.mrp.report","openerp.addons.mrp.wizard"],
    package_data = {
        'openerp.addons.mrp': ["i18n/*.po*","mrp_workflow.xml","res_config_view.xml","mrp_data.xml","board_manufacturing_view.xml","mrp_demo.xml","company_view.xml","mrp_report.xml","mrp_view.xml","images/planning_manufacturing_order.jpeg","images/production_dashboard.jpeg","images/bill_of_materials.jpeg","images/routings.jpeg","images/manufacturing_order.jpeg","images/work_centers.jpeg","images/manufacturing.png","images/manufacturing-hover.png","images/manufacturing_analysis.jpeg","static/src/img/icon.png","i18n/sk.po","i18n/id.po","i18n/hr.po","i18n/da.po","i18n/sl.po","i18n/es_BO.po","i18n/es_MX.po","i18n/ru.po","i18n/zh_TW.po","i18n/cs.po","i18n/sq.po","i18n/fi.po","i18n/pt_BR.po","i18n/ko.po","i18n/bg.po","i18n/es_VE.po","i18n/tlh.po","i18n/zh_HK.po","i18n/ja.po","i18n/ro.po","i18n/es_AR.po","i18n/hi.po","i18n/sr@latin.po","i18n/es.po","i18n/mn.po","i18n/es_CL.po","i18n/it.po","i18n/nl.po","i18n/sv.po","i18n/es_EC.po","i18n/uk.po","i18n/bs.po","i18n/tr.po","i18n/de.po","i18n/et.po","i18n/lt.po","i18n/hu.po","i18n/vi.po","i18n/el.po","i18n/gl.po","i18n/lv.po","i18n/mk.po","i18n/ca.po","i18n/fr.po","i18n/zh_CN.po","i18n/pl.po","i18n/nl_BE.po","i18n/nb.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","test/order_demo.yml","test/bom_with_service_type_product.yml","test/cancel_order.yml","test/order_process.yml","security/ir.model.access.csv","security/mrp_security.xml","report/mrp_report_view.xml","report/price.xsl","report/order.rml","report/bom_structure.sxw","report/order.sxw","report/custom_rml.xsl","report/bom_structure.rml","report/mrp_production_order_view.xml","report/custom_default.xsl","wizard/mrp_product_produce_view.xml","wizard/change_production_qty_view.xml","wizard/mrp_price_view.xml","wizard/mrp_workcenter_load_view.xml","process/stockable_product_process.xml","process/procurement_process.xml","process/service_product_process.xml","security/mrp_security.xml","security/ir.model.access.csv","mrp_workflow.xml","mrp_data.xml","wizard/mrp_product_produce_view.xml","wizard/change_production_qty_view.xml","wizard/mrp_price_view.xml","wizard/mrp_workcenter_load_view.xml","mrp_view.xml","mrp_report.xml","company_view.xml","process/stockable_product_process.xml","process/service_product_process.xml","process/procurement_process.xml","report/mrp_report_view.xml","report/mrp_production_order_view.xml","board_manufacturing_view.xml","res_config_view.xml","mrp_demo.xml"],
    },
    install_requires = ["openerp-product","openerp-procurement","openerp-stock","openerp-resource","openerp-purchase","openerp-process"],
    tests_require = ["unittest2"],
)
