#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `report_webkit` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-report-webkit",
    version = "7.0.406",
    description = "Webkit Report Engine",
    long_description = 
"""

This module adds a new Report Engine based on WebKit library (wkhtmltopdf) to support reports designed in HTML + CSS.
=====================================================================================================================

The module structure and some code is inspired by the report_openoffice module.

The module allows:
------------------
    - HTML report definition
    - Multi header support
    - Multi logo
    - Multi company support
    - HTML and CSS-3 support (In the limit of the actual WebKIT version)
    - JavaScript support
    - Raw HTML debugger
    - Book printing capabilities
    - Margins definition
    - Paper size definition

Multiple headers and logos can be defined per company. CSS style, header and
footer body are defined per company.

For a sample report see also the webkit_report_sample module, and this video:
    http://files.me.com/nbessi/06n92k.mov

Requirements and Installation:
------------------------------
This module requires the ``wkthtmltopdf`` library to render HTML documents as
PDF. Version 0.9.9 or later is necessary, and can be found at
http://code.google.com/p/wkhtmltopdf/ for Linux, Mac OS X (i386) and Windows (32bits).

After installing the library on the OpenERP Server machine, you may need to set
the path to the ``wkthtmltopdf`` executable file in a system parameter named
``webkit_path`` in Settings -> Customization -> Parameters -> System Parameters

If you are experiencing missing header/footer problems on Linux, be sure to
install a 'static' version of the library. The default ``wkhtmltopdf`` on
Ubuntu is known to have this issue.


TODO:
-----
    * JavaScript support activation deactivation
    * Collated and book format support
    * Zip return for separated PDF
    * Web client WYSIWYG
""",
    url = "",
    author = "Camptocamp",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.report_webkit': ".",
    },
    packages = ["openerp.addons.report_webkit","openerp.addons.report_webkit.wizard"],
    package_data = {
        'openerp.addons.report_webkit': ["i18n/*.po*","ir_report_view.xml","default_header.html","data.xml","company_view.xml","header_view.xml","images/header_html.jpeg","images/companies_webkit.jpeg","images/header_img.jpeg","i18n/hr.po","i18n/da.po","i18n/sl.po","i18n/es_MX.po","i18n/ru.po","i18n/cs.po","i18n/fi.po","i18n/pt_BR.po","i18n/bg.po","i18n/es_VE.po","i18n/ja.po","i18n/ro.po","i18n/es.po","i18n/mn.po","i18n/it.po","i18n/nl.po","i18n/sv.po","i18n/tr.po","i18n/de.po","i18n/hu.po","i18n/mk.po","i18n/ca.po","i18n/fr.po","i18n/zh_CN.po","i18n/pl.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","security/ir.model.access.csv","wizard/report_webkit_actions_view.xml","security/ir.model.access.csv","data.xml","wizard/report_webkit_actions_view.xml","company_view.xml","header_view.xml","ir_report_view.xml"],
    },
    install_requires = ["openerp-core","Jinja2"],
    tests_require = ["unittest2"],
)
