#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `sale` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-sale",
    version = "7.0.355",
    description = "Sales Management",
    long_description = 
"""

Manage sales quotations and orders
==================================

This application allows you to manage your sales goals in an effective and efficient manner by keeping track of all sales orders and history.

It handles the full sales workflow:

* **Quotation** -> **Sales order** -> **Invoice**

Preferences (only with Warehouse Management installed)
------------------------------------------------------

If you also installed the Warehouse Management, you can deal with the following preferences:

* Shipping: Choice of delivery at once or partial delivery
* Invoicing: choose how invoices will be paid
* Incoterms: International Commercial terms

You can choose flexible invoicing methods:

* *On Demand*: Invoices are created manually from Sales Orders when needed
* *On Delivery Order*: Invoices are generated from picking (delivery)
* *Before Delivery*: A Draft invoice is created and must be paid before delivery


The Dashboard for the Sales Manager will include
------------------------------------------------
* My Quotations
* Monthly Turnover (Graph)
    
""",
    url = "http://www.openerp.com",
    author = "OpenERP SA",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.sale': ".",
    },
    packages = ["openerp.addons.sale","openerp.addons.sale.edi","openerp.addons.sale.report","openerp.addons.sale.wizard"],
    package_data = {
        'openerp.addons.sale': ["i18n/*.po*","sale_view.xml","sale_demo.xml","res_config_view.xml","sale_sequence.xml","board_sale_view.xml","res_partner_view.xml","sale_data.xml","sale_unit_test.xml","sale_workflow.xml","sale_report.xml","edi/sale_order_action_data.xml","images/sale_order.jpeg","images/sale_dashboard.jpeg","images/sales_analysis.jpeg","images/Sale_order_line_to_invoice.jpeg","static/src/img/icon.png","i18n/sk.po","i18n/id.po","i18n/hr.po","i18n/da.po","i18n/sl.po","i18n/es_BO.po","i18n/es_MX.po","i18n/ru.po","i18n/zh_TW.po","i18n/cs.po","i18n/sq.po","i18n/fi.po","i18n/pt_BR.po","i18n/ko.po","i18n/bg.po","i18n/es_VE.po","i18n/tlh.po","i18n/es_PE.po","i18n/ja.po","i18n/ro.po","i18n/es_AR.po","i18n/hi.po","i18n/sr@latin.po","i18n/es.po","i18n/mn.po","i18n/es_CL.po","i18n/it.po","i18n/nl.po","i18n/sv.po","i18n/es_EC.po","i18n/oc.po","i18n/uk.po","i18n/bs.po","i18n/tr.po","i18n/de.po","i18n/et.po","i18n/lo.po","i18n/is.po","i18n/sr.po","i18n/lt.po","i18n/hu.po","i18n/vi.po","i18n/eu.po","i18n/el.po","i18n/gl.po","i18n/lv.po","i18n/mk.po","i18n/ca.po","i18n/fr.po","i18n/zh_CN.po","i18n/pl.po","i18n/th.po","i18n/nl_BE.po","i18n/nb.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","test/delete_order.yml","test/sale_order_demo.yml","test/cancel_order.yml","test/edi_sale_order.yml","test/manual_order_policy.yml","security/ir.model.access.csv","security/sale_security.xml","report/sale_order.rml","report/sale_report_view.xml","report/sale_order.sxw","wizard/sale_line_invoice.xml","wizard/sale_make_invoice_advance.xml","wizard/sale_make_invoice.xml","process/sale_process.xml","wizard/sale_make_invoice_advance.xml","wizard/sale_line_invoice.xml","wizard/sale_make_invoice.xml","security/sale_security.xml","security/ir.model.access.csv","sale_workflow.xml","sale_sequence.xml","sale_report.xml","sale_data.xml","sale_view.xml","res_partner_view.xml","report/sale_report_view.xml","process/sale_process.xml","board_sale_view.xml","edi/sale_order_action_data.xml","res_config_view.xml","sale_demo.xml"],
    },
    install_requires = ["openerp-account-voucher"],
    tests_require = ["unittest2"],
)
