#! /usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Replacement (unofficial) `setup.py` for the `stock` module.
Automatically generated by `openerpdist`. See http://noteed.com/openerpdist/.
"""

import setuptools

setuptools.setup(
    name = "openerp-stock",
    version = "7.0.406",
    description = "Warehouse Management",
    long_description = 
"""

Manage multi-warehouses, multi- and structured stock locations
==============================================================

The warehouse and inventory management is based on a hierarchical location structure, from warehouses to storage bins. 
The double entry inventory system allows you to manage customers, suppliers as well as manufacturing inventories. 

OpenERP has the capacity to manage lots and serial numbers ensuring compliance with the traceability requirements imposed by the majority of industries.

Key Features
------------
* Moves history and planning,
* Stock valuation (standard or average price, ...)
* Robustness faced with Inventory differences
* Automatic reordering rules
* Support for barcodes
* Rapid detection of mistakes through double entry system
* Traceability (Upstream / Downstream, Serial numbers, ...)

Dashboard / Reports for Warehouse Management will include:
----------------------------------------------------------
* Incoming Products (Graph)
* Outgoing Products (Graph)
* Procurement in Exception
* Inventory Analysis
* Last Product Inventories
* Moves Analysis
    
""",
    url = "http://www.openerp.com",
    author = "OpenERP SA",
    author_email = "TODO",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Plugins",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Natural Language :: English",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: Implementation :: CPython",
    ],
    license = "AGPL-3",
    package_dir = {
        'openerp.addons.stock': ".",
    },
    packages = ["openerp.addons.stock","openerp.addons.stock.tests","openerp.addons.stock.report","openerp.addons.stock.wizard"],
    package_data = {
        'openerp.addons.stock': ["i18n/*.po*","stock_data.xml","res_config_view.xml","partner_view.xml","board_warehouse_view.xml","stock_report.xml","product_view.xml","stock_incoterms.xml","stock_sequence.xml","stock_view.xml","product_data.xml","stock_demo.xml","stock_demo.yml","stock_workflow.xml","images/location.jpeg","images/stock_forecast_report.png","images/warehouse_dashboard.jpeg","images/inventory_analysis.jpeg","images/physical_inventories.jpeg","images/moves_analysis.jpeg","images/delivery_orders.jpeg","images/warehouse.png","images/warehouse-hover.png","static/src/img/icon.png","i18n/th_TH.po","i18n/id.po","i18n/hr.po","i18n/da.po","i18n/sl.po","i18n/es_BO.po","i18n/es_MX.po","i18n/ru.po","i18n/zh_TW.po","i18n/cs.po","i18n/sq.po","i18n/fi.po","i18n/pt_BR.po","i18n/ko.po","i18n/bg.po","i18n/es_VE.po","i18n/tlh.po","i18n/es_PE.po","i18n/ja.po","i18n/ro.po","i18n/es_AR.po","i18n/sr@latin.po","i18n/es.po","i18n/mn.po","i18n/es_CL.po","i18n/it.po","i18n/nl.po","i18n/sv.po","i18n/es_EC.po","i18n/uk.po","i18n/bs.po","i18n/tr.po","i18n/de.po","i18n/et.po","i18n/sr.po","i18n/lt.po","i18n/hu.po","i18n/vi.po","i18n/el.po","i18n/gl.po","i18n/lv.po","i18n/mk.po","i18n/ca.po","i18n/fr.po","i18n/zh_CN.po","i18n/pl.po","i18n/th.po","i18n/nl_BE.po","i18n/es_DO.po","i18n/nb.po","i18n/ar.po","i18n/pt.po","i18n/es_CR.po","test/opening_stock.yml","test/shipment.yml","test/stock_report.yml","security/ir.model.access.csv","security/stock_security.xml","report/report_stock_move_view.xml","report/report_stock_view.xml","report/lot_overview.sxw","report/lot_move_label.xsl","report/stock_inventory_move.rml","report/lot_overview.rml","report/lot_overview_all.rml","report/stock_inventory_move.sxw","report/stock_by_location.xsl","report/picking.rml","report/picking.sxw","report/lot_overview_all.sxw","report/lot_move_label.xml","wizard/stock_return_picking_view.xml","wizard/stock_change_product_qty_view.xml","wizard/stock_move_view.xml","wizard/stock_location_product_view.xml","wizard/stock_inventory_line_split_view.xml","wizard/stock_change_standard_price_view.xml","wizard/stock_inventory_merge_view.xml","wizard/stock_fill_inventory_view.xml","wizard/stock_splitinto_view.xml","wizard/stock_invoice_onshipping_view.xml","wizard/stock_partial_picking_view.xml","wizard/stock_partial_move_view.xml","security/stock_security.xml","security/ir.model.access.csv","stock_data.xml","wizard/stock_move_view.xml","wizard/stock_change_product_qty_view.xml","wizard/stock_partial_picking_view.xml","wizard/stock_partial_move_view.xml","wizard/stock_fill_inventory_view.xml","wizard/stock_invoice_onshipping_view.xml","wizard/stock_inventory_merge_view.xml","wizard/stock_location_product_view.xml","wizard/stock_splitinto_view.xml","wizard/stock_inventory_line_split_view.xml","wizard/stock_change_standard_price_view.xml","wizard/stock_return_picking_view.xml","stock_workflow.xml","stock_incoterms.xml","stock_report.xml","stock_view.xml","stock_sequence.xml","product_data.xml","product_view.xml","partner_view.xml","report/report_stock_move_view.xml","report/report_stock_view.xml","board_warehouse_view.xml","res_config_view.xml","stock_demo.xml","static/src/css/stock.css"],
    },
    install_requires = ["openerp-product","openerp-account"],
    tests_require = ["unittest2"],
)
