# Copyright (c) 2010-2014 openpyxl
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# @license: http://www.opensource.org/licenses/mit-license.php
# @author: see AUTHORS file

try:
    from hashlib import md5
except ImportError:
    from md5 import md5

from copy import deepcopy

class HashableObject(object):
    """Define how to hash property classes."""
    __fields__ = None
    __leaf__ = False

    def __repr__(self):
        return str(self.__key)

    @property
    def __key(self):
        """Use a tuple of fields as the basis for a key"""
        return [getattr(self, x) for x in self.__fields__]

    def __hash__(self):
        return hash(str(self.__key))

    def __eq__(self, other):
        if isinstance(other, self.__class__):
            return self.__key == other.__key
        return self.__key == other

    def __ne__(self, other):
        return not self == other
