# The Hazard Library
# Copyright (C) 2012 GEM Foundation
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
from openquake.hazardlib.geo import Point


TEST_2_CORNERS = [
    Point(-0.0288945127134, -0.0068657114195, 2.0),
    Point(0.00686571229256, 0.028894512506, 2.0),
    Point(0.0378349744035, -0.00207474995049, 4.81170662595),
    Point(0.00207475040284, -0.0378349743787, 4.81170662595)
]
TEST_2_MESH = [
    [(-0.0288945127134, -0.0068657114195, 2.0),
     (-0.022535345861, -0.000506544146365, 2.0),
     (-0.0161761789757, 0.0058526230876, 2.0),
     (-0.00981701197912, 0.0122117902824, 2.0),
     (-0.00345784479293, 0.018570957438, 2.0),
     (0.00290132266119, 0.0249301245545, 2.0),
     (0.00926049046157, 0.0312892916318, 2.0)],
    [(-0.0233873130974, -0.0123729122266, 2.50000001211),
     (-0.0170281458954, -0.00601374469105, 2.49999999088),
     (-0.0106689786767, 0.000345422753668, 2.49999997406),
     (-0.004309811364, 0.00670459010865, 2.49999996195),
     (0.00204935612154, 0.0130637573734, 2.4999999544),
     (0.00840852385776, 0.0194229245483, 2.49999995155),
     (0.0147676919235, 0.025782091633, 2.49999995326)],
    [(-0.0178801133416, -0.0178801130082, 3.00000002422),
     (-0.0115209458487, -0.0115209452103, 2.99999998175),
     (-0.00516177835544, -0.00516177755483, 2.99999994812),
     (0.00119738921461, 0.00119738996033, 2.9999999239),
     (0.00755655694076, 0.00755655733413, 2.99999990879),
     (0.0139157249003, 0.0139157245676, 2.99999990309),
     (0.0202748931727, 0.0202748916597, 2.99999990651)],
    [(-0.0123729133951, -0.0233873137644, 3.50000003633),
     (-0.00601374567022, -0.0170281457041, 3.49999997263),
     (0.000345422038954, -0.0106689778379, 3.49999992218),
     (0.0067045898076, -0.00430981016254, 3.49999988585),
     (0.0130637577156, 0.00204935732033, 3.49999986319),
     (0.0194229258398, 0.00840852461232, 3.49999985464),
     (0.02578209426, 0.0147676917118, 3.49999985977)],
    [(-0.00686571320718, -0.0288945144951, 4.00000004844),
     (-0.000506545308939, -0.0225353461725, 3.99999996351),
     (0.00585262255735, -0.0161761780955, 3.99999989625),
     (0.0122117904658, -0.00981701025998, 3.9999998478),
     (0.018570958497, -0.00345784266802, 3.99999981758),
     (0.024930126727, 0.00290132468247, 3.99999980618),
     (0.0312892952362, 0.0092604917894, 3.99999981302)],
    [(-0.00135851272684, -0.0344017152004, 4.50000006055),
     (0.00500065528598, -0.0280425466154, 4.49999995439),
     (0.0113598232506, -0.0216833783277, 4.49999987031),
     (0.0177189912402, -0.015324210332, 4.49999980974),
     (0.0240781593357, -0.00896504263094, 4.49999977198),
     (0.0304373276128, -0.00260587522194, 4.49999975773),
     (0.0367964961524, 0.0037532918924, 4.49999976628)],
    [(0.00414868809677, -0.0399089158803, 5.00000007266),
     (0.0105078561654, -0.0335497470329, 4.99999994526),
     (0.0168670241697, -0.0271905785344, 4.99999984437),
     (0.0232261921816, -0.0208314103785, 4.99999977169),
     (0.0295853602827, -0.0144722425684, 4.99999972638),
     (0.0359445285481, -0.00811307510091, 4.99999970928),
     (0.0423036970594, -0.00175390797916, 4.99999971954)]
]

TEST_3_CORNERS = [
    Point(-0.0378349744035, 0.00207474995049, 13.188293374),
    Point(-0.00207475040284, 0.0378349743787, 13.188293374),
    Point(0.0288945127134, 0.0068657114195, 16.0),
    Point(-0.00686571229256, -0.028894512506, 16.0)
]
TEST_3_MESH = [
    [(-0.0378349744035, 0.00207474995049, 13.188293374),
     (-0.0314758080603, 0.00843391774639, 13.188293374),
     (-0.025116641574, 0.0147930855031, 13.188293374),
     (-0.0187574748663, 0.0211522532207, 13.188293374),
     (-0.0123983078589, 0.0275114208991, 13.188293374),
     (-0.00603914047346, 0.0338705885383, 13.188293374),
     (0.000320027368406, 0.0402297561384, 13.188293374)],
    [(-0.0323277745843, -0.00343245057624, 13.6882933862),
     (-0.0259686078915, 0.00292671738666, 13.6882933649),
     (-0.0196094410719, 0.00928588525877, 13.6882933481),
     (-0.0132502740481, 0.0156450530411, 13.688293336),
     (-0.00689110674133, 0.0220042207332, 13.6882933284),
     (-0.000531939073776, 0.0283633883356, 13.6882933256),
     (0.00582722903344, 0.0347225558477, 13.6882933273)],
    [(-0.026820574708, -0.00893965107753, 14.1882933983),
     (-0.0204614077243, -0.00258048294763, 14.1882933558),
     (-0.0141022406301, 0.00377868503986, 14.1882933222),
     (-0.00774307334897, 0.010137852887, 14.1882932979),
     (-0.0013839058016, 0.0164970205928, 14.1882932828),
     (0.0049752620893, 0.0228561881583, 14.1882932771),
     (0.0113344304031, 0.0292153555825, 14.1882932806)],
    [(-0.0213133747236, -0.0144468515534, 14.6882934104),
     (-0.0149542075079, -0.00808768325648, 14.6882933467),
     (-0.00859504019779, -0.00172851515362, 14.6882932962),
     (-0.00223587271807, 0.00463065275836, 14.6882932599),
     (0.00412329501116, 0.0109898204779, 14.6882932372),
     (0.0104824630666, 0.0173489880065, 14.6882932287),
     (0.0168416315283, 0.0237081553426, 14.6882932338)],
    [(-0.0158061745804, -0.0199540520038, 15.1882934225),
     (-0.00944700719132, -0.0135948835399, 15.1882933376),
     (-0.00308783972408, -0.00723571532165, 15.1882932703),
     (0.00327132789549, -0.000876547344875, 15.1882932218),
     (0.00963049574782, 0.00548262038834, 15.1882931916),
     (0.0159896639092, 0.0118417878801, 15.1882931802),
     (0.0223488324599, 0.0182009551283, 15.1882931871)],
    [(-0.0102989742273, -0.0254612524287, 15.6882934346),
     (-0.00393980672368, -0.0191020837979, 15.6882933284),
     (0.00241936084192, -0.0127429154642, 15.6882932444),
     (0.00877852854259, -0.00638374742267, 15.6882931838),
     (0.0151376964593, -2.45796757484e-05, 15.688293146),
     (0.0214968646677, 0.00633458777913, 15.6882931318),
     (0.0278560332488, 0.0126937549394, 15.6882931403)],
    [(-0.00479177361359, -0.0309684528283, 16.1882934467),
     (0.00156739394587, -0.0246092840304, 16.1882933193),
     (0.00792656155109, -0.0182501155814, 16.1882932184),
     (0.0142857292741, -0.011890947475, 16.1882931457),
     (0.0206448971964, -0.0055317797144, 16.1882931004),
     (0.0270040653932, 0.00082738770361, 16.1882930833),
     (0.0333632339459, 0.00718655477586, 16.1882930936)]
]

TEST_4_CORNERS = [
    Point(-0.436201680751, -0.281993828512, 2.0),
    Point(0.282002000777, 0.43619639753, 2.0),
    Point(0.436201680751, 0.281993828512, 16.0),
    Point(-0.282002000777, -0.43619639753, 16.0)
]
TEST_4_MESH = [
    [(-0.436201680751, -0.281993828512, 2.0),
     (-0.429842374617, -0.275634725239, 2.0),
     (-0.42348307184, -0.269275622005, 2.0),
     (-0.417123772341, -0.262916518811, 2.0),
     (-0.410764476041, -0.256557415655, 2.0),
     (-0.404405182863, -0.250198312539, 2.0),
     (-0.398045892727, -0.243839209462, 2.0),
     (-0.391686605557, -0.237480106424, 2.0),
     (-0.385327321272, -0.231121003426, 2.0),
     (-0.378968039795, -0.224761900466, 2.0),
     (-0.372608761048, -0.218402797546, 2.0),
     (-0.366249484952, -0.212043694665, 2.0),
     (-0.359890211429, -0.205684591823, 2.0),
     (-0.353530940401, -0.19932548902, 2.0),
     (-0.347171671789, -0.192966386257, 2.0),
     (-0.340812405515, -0.186607283532, 2.0),
     (-0.3344531415, -0.180248180847, 2.0),
     (-0.328093879666, -0.173889078201, 2.0),
     (-0.321734619936, -0.167529975594, 2.0),
     (-0.31537536223, -0.161170873026, 2.0),
     (-0.30901610647, -0.154811770497, 2.0),
     (-0.302656852578, -0.148452668008, 2.0),
     (-0.296297600476, -0.142093565558, 2.0),
     (-0.289938350084, -0.135734463147, 2.0),
     (-0.283579101326, -0.129375360775, 2.0),
     (-0.277219854122, -0.123016258442, 2.0),
     (-0.270860608395, -0.116657156148, 2.0),
     (-0.264501364065, -0.110298053894, 2.0),
     (-0.258142121055, -0.103938951678, 2.0),
     (-0.251782879286, -0.0975798495024, 2.0),
     (-0.24542363868, -0.0912207473655, 2.0),
     (-0.239064399158, -0.0848616452677, 2.0),
     (-0.232705160643, -0.0785025432091, 2.0),
     (-0.226345923055, -0.0721434411897, 2.0),
     (-0.219986686317, -0.0657843392094, 2.0),
     (-0.213627450351, -0.0594252372683, 2.0),
     (-0.207268215077, -0.0530661353664, 2.0),
     (-0.200908980417, -0.0467070335037, 2.0),
     (-0.194549746294, -0.0403479316801, 2.0),
     (-0.188190512629, -0.0339888298957, 2.0),
     (-0.181831279343, -0.0276297281504, 2.0),
     (-0.175472046358, -0.0212706264443, 2.0),
     (-0.169112813597, -0.0149115247774, 2.0),
     (-0.162753580979, -0.00855242314966, 2.0),
     (-0.156394348428, -0.00219332156108, 2.0),
     (-0.150035115865, 0.00416577998833, 2.0),
     (-0.143675883211, 0.0105248814986, 2.0),
     (-0.137316650389, 0.0168839829696, 2.0),
     (-0.130957417319, 0.0232430844016, 2.0),
     (-0.124598183924, 0.0296021857943, 2.0),
     (-0.118238950125, 0.0359612871479, 2.0),
     (-0.111879715844, 0.0423203884623, 2.0),
     (-0.105520481002, 0.0486794897375, 2.0),
     (-0.0991612455217, 0.0550385909736, 2.0),
     (-0.0928020093241, 0.0613976921705, 2.0),
     (-0.086442772331, 0.0677567933282, 2.0),
     (-0.0800835344641, 0.0741158944468, 2.0),
     (-0.073724295645, 0.0804749955262, 2.0),
     (-0.0673650557954, 0.0868340965664, 2.0),
     (-0.061005814837, 0.0931931975675, 2.0),
     (-0.0546465726914, 0.0995522985294, 2.0),
     (-0.0482873292804, 0.105911399452, 2.0),
     (-0.0419280845255, 0.112270500336, 2.0),
     (-0.0355688383484, 0.11862960118, 2.0),
     (-0.0292095906708, 0.124988701985, 2.0),
     (-0.0228503414144, 0.131347802751, 2.0),
     (-0.0164910905009, 0.137706903478, 2.0),
     (-0.0101318378518, 0.144066004166, 2.0),
     (-0.00377258338885, 0.150425104814, 2.0),
     (0.00258667296626, 0.156784205424, 2.0),
     (0.00894593129188, 0.163143305994, 2.0),
     (0.0153051916664, 0.169502406525, 2.0),
     (0.021664454168, 0.175861507017, 2.0),
     (0.0280237188752, 0.18222060747, 2.0),
     (0.0343829858662, 0.188579707883, 2.0),
     (0.0407422552195, 0.194938808258, 2.0),
     (0.0471015270132, 0.201297908593, 2.0),
     (0.0534608013258, 0.207657008889, 2.0),
     (0.0598200782357, 0.214016109146, 2.0),
     (0.066179357821, 0.220375209363, 2.0),
     (0.0725386401603, 0.226734309542, 2.0),
     (0.0788979253317, 0.233093409681, 2.0),
     (0.0852572134138, 0.239452509781, 2.0),
     (0.0916165044847, 0.245811609842, 2.0),
     (0.0979757986228, 0.252170709864, 2.0),
     (0.104335095906, 0.258529809847, 2.0),
     (0.110694396414, 0.264888909791, 2.0),
     (0.117053700224, 0.271248009695, 2.0),
     (0.123413007414, 0.27760710956, 2.0),
     (0.129772318064, 0.283966209386, 2.0),
     (0.13613163225, 0.290325309173, 2.0),
     (0.142490950052, 0.296684408921, 2.0),
     (0.148850271549, 0.303043508629, 2.0),
     (0.155209596817, 0.309402608298, 2.0),
     (0.161568925936, 0.315761707929, 2.0),
     (0.167928258984, 0.32212080752, 2.0),
     (0.174287596039, 0.328479907071, 2.0),
     (0.18064693718, 0.334839006584, 2.0),
     (0.187006282485, 0.341198106058, 2.0),
     (0.193365632032, 0.347557205492, 2.0),
     (0.1997249859, 0.353916304887, 2.0),
     (0.206084344167, 0.360275404243, 2.0),
     (0.212443706911, 0.36663450356, 2.0),
     (0.218803074211, 0.372993602837, 2.0),
     (0.225162446145, 0.379352702076, 2.0),
     (0.231521822791, 0.385711801275, 2.0),
     (0.237881204228, 0.392070900435, 2.0),
     (0.244240590534, 0.398429999556, 2.0),
     (0.250599981787, 0.404789098638, 2.0),
     (0.256959378067, 0.411148197681, 2.0),
     (0.26331877945, 0.417507296684, 2.0),
     (0.269678186016, 0.423866395649, 2.0),
     (0.276037597842, 0.430225494574, 2.0),
     (0.282397015008, 0.43658459346, 2.0)],
    [(-0.430694578866, -0.287501159011, 2.50000491011),
     (-0.424335269247, -0.281142053047, 2.50000439301),
     (-0.417975963002, -0.274782947173, 2.50000388053),
     (-0.411616660052, -0.268423841389, 2.50000337266),
     (-0.405257360318, -0.262064735694, 2.50000286941),
     (-0.398898063722, -0.25570563009, 2.50000237079),
     (-0.392538770187, -0.249346524577, 2.50000187678),
     (-0.386179479632, -0.242987419153, 2.50000138739),
     (-0.379820191982, -0.236628313819, 2.50000090263),
     (-0.373460907156, -0.230269208575, 2.50000042248),
     (-0.367101625076, -0.223910103421, 2.49999994696),
     (-0.360742345665, -0.217550998357, 2.49999947605),
     (-0.354383068844, -0.211191893384, 2.49999900976),
     (-0.348023794534, -0.2048327885, 2.49999854809),
     (-0.341664522657, -0.198473683706, 2.49999809104),
     (-0.335305253136, -0.192114579003, 2.49999763862),
     (-0.328945985891, -0.185755474389, 2.49999719081),
     (-0.322586720844, -0.179396369865, 2.49999674762),
     (-0.316227457916, -0.173037265432, 2.49999630905),
     (-0.309868197031, -0.166678161089, 2.4999958751),
     (-0.303508938109, -0.160319056835, 2.49999544577),
     (-0.297149681071, -0.153959952672, 2.49999502106),
     (-0.29079042584, -0.147600848598, 2.49999460097),
     (-0.284431172337, -0.141241744615, 2.4999941855),
     (-0.278071920484, -0.134882640722, 2.49999377465),
     (-0.271712670203, -0.128523536919, 2.49999336842),
     (-0.265353421414, -0.122164433206, 2.4999929668),
     (-0.258994174041, -0.115805329583, 2.49999256981),
     (-0.252634928004, -0.109446226049, 2.49999217744),
     (-0.246275683225, -0.103087122606, 2.49999178969),
     (-0.239916439626, -0.0967280192535, 2.49999140655),
     (-0.233557197128, -0.0903689159906, 2.49999102804),
     (-0.227197955654, -0.0840098128177, 2.49999065415),
     (-0.220838715124, -0.0776507097348, 2.49999028488),
     (-0.214479475461, -0.071291606742, 2.49998992022),
     (-0.208120236587, -0.0649325038392, 2.49998956018),
     (-0.201760998421, -0.0585734010265, 2.49998920477),
     (-0.195401760888, -0.0522142983038, 2.49998885397),
     (-0.189042523907, -0.0458551956712, 2.4999885078),
     (-0.182683287402, -0.0394960931286, 2.49998816624),
     (-0.176324051293, -0.0331369906761, 2.49998782931),
     (-0.169964815502, -0.0267778883136, 2.49998749699),
     (-0.163605579951, -0.0204187860411, 2.49998716929),
     (-0.157246344561, -0.0140596838587, 2.49998684621),
     (-0.150887109254, -0.00770058176632, 2.49998652775),
     (-0.144527873953, -0.001341479764, 2.49998621391),
     (-0.138168638578, 0.00501762214829, 2.49998590469),
     (-0.13180940305, 0.0113767239705, 2.49998560009),
     (-0.125450167293, 0.0177358257027, 2.49998530011),
     (-0.119090931227, 0.0240949273449, 2.49998500475),
     (-0.112731694775, 0.030454028897, 2.49998471401),
     (-0.106372457857, 0.036813130359, 2.49998442789),
     (-0.100013220395, 0.043172231731, 2.49998414639),
     (-0.0936539823122, 0.049531333013, 2.4999838695),
     (-0.0872947435287, 0.0558904342049, 2.49998359725),
     (-0.0809355039668, 0.0622495353068, 2.4999833296),
     (-0.0745762635479, 0.0686086363186, 2.49998306658),
     (-0.0682170221939, 0.0749677372404, 2.49998280817),
     (-0.0618577798263, 0.0813268380722, 2.49998255439),
     (-0.0554985363668, 0.0876859388138, 2.49998230522),
     (-0.0491392917372, 0.0940450394655, 2.49998206068),
     (-0.042780045859, 0.100404140027, 2.49998182075),
     (-0.0364207986539, 0.106763240499, 2.49998158544),
     (-0.0300615500436, 0.11312234088, 2.49998135476),
     (-0.0237022999498, 0.119481441172, 2.49998112869),
     (-0.017343048294, 0.125840541373, 2.49998090723),
     (-0.0109837949981, 0.132199641484, 2.49998069041),
     (-0.00462453998365, 0.138558741506, 2.4999804782),
     (0.00173471682771, 0.144917841437, 2.49998027061),
     (0.00809397551429, 0.151276941278, 2.49998006764),
     (0.0144532361544, 0.157636041029, 2.49997986928),
     (0.0208124988265, 0.163995140691, 2.49997967555),
     (0.0271717636087, 0.170354240262, 2.49997948644),
     (0.0335310305795, 0.176713339743, 2.49997930195),
     (0.0398902998173, 0.183072439134, 2.49997912207),
     (0.0462495714002, 0.189431538435, 2.49997894682),
     (0.0526088454068, 0.195790637645, 2.49997877618),
     (0.0589681219152, 0.202149736766, 2.49997861017),
     (0.0653274010039, 0.208508835797, 2.49997844877),
     (0.0716866827512, 0.214867934738, 2.499978292),
     (0.0780459672353, 0.221227033589, 2.49997813984),
     (0.0844052545348, 0.227586132349, 2.4999779923),
     (0.0907645447278, 0.23394523102, 2.49997784938),
     (0.0971238378928, 0.2403043296, 2.49997771108),
     (0.103483134108, 0.246663428091, 2.4999775774),
     (0.109842433452, 0.253022526491, 2.49997744834),
     (0.116201736003, 0.259381624802, 2.4999773239),
     (0.122561041839, 0.265740723022, 2.49997720408),
     (0.128920351038, 0.272099821152, 2.49997708888),
     (0.13527966368, 0.278458919192, 2.49997697829),
     (0.141638979842, 0.284818017143, 2.49997687233),
     (0.147998299603, 0.291177115003, 2.49997677098),
     (0.15435762304, 0.297536212773, 2.49997667426),
     (0.160716950233, 0.303895310453, 2.49997658215),
     (0.16707628126, 0.310254408043, 2.49997649467),
     (0.173435616198, 0.316613505543, 2.4999764118),
     (0.179794955127, 0.322972602953, 2.49997633355),
     (0.186154298125, 0.329331700273, 2.49997625992),
     (0.192513645269, 0.335690797502, 2.49997619091),
     (0.198872996639, 0.342049894642, 2.49997612652),
     (0.205232352313, 0.348408991692, 2.49997606675),
     (0.211591712368, 0.354768088651, 2.4999760116),
     (0.217951076884, 0.361127185521, 2.49997596107),
     (0.224310445939, 0.367486282301, 2.49997591515),
     (0.230669819611, 0.37384537899, 2.49997587386),
     (0.237029197978, 0.380204475589, 2.49997583718),
     (0.243388581119, 0.386563572099, 2.49997580513),
     (0.249747969112, 0.392922668518, 2.49997577769),
     (0.256107362036, 0.399281764847, 2.49997575487),
     (0.262466759968, 0.405640861087, 2.49997573667),
     (0.268826162987, 0.411999957236, 2.4999757231),
     (0.275185571172, 0.418359053295, 2.49997571414),
     (0.281544984601, 0.424718149264, 2.49997570979),
     (0.287904403352, 0.431077245143, 2.49997571007)],
    [(-0.425187474299, -0.293008489485, 3.00000982023),
     (-0.418828161254, -0.286649380829, 3.00000878602),
     (-0.412468851599, -0.280290272315, 3.00000776105),
     (-0.406109545257, -0.273931163941, 3.00000674532),
     (-0.399750242147, -0.267572055708, 3.00000573883),
     (-0.393390942194, -0.261212947616, 3.00000474157),
     (-0.387031645316, -0.254853839665, 3.00000375357),
     (-0.380672351438, -0.248494731855, 3.00000277479),
     (-0.37431306048, -0.242135624186, 3.00000180526),
     (-0.367953772363, -0.235776516658, 3.00000084496),
     (-0.36159448701, -0.229417409271, 2.99999989391),
     (-0.355235204342, -0.223058302024, 2.9999989521),
     (-0.348875924282, -0.216699194919, 2.99999801953),
     (-0.342516646749, -0.210340087954, 2.99999709619),
     (-0.336157371667, -0.20398098113, 2.99999618208),
     (-0.329798098957, -0.197621874448, 2.99999527724),
     (-0.32343882854, -0.191262767906, 2.99999438161),
     (-0.317079560338, -0.184903661505, 2.99999349524),
     (-0.310720294273, -0.178544555245, 2.99999261809),
     (-0.304361030267, -0.172185449126, 2.9999917502),
     (-0.29800176824, -0.165826343148, 2.99999089155),
     (-0.291642508116, -0.15946723731, 2.99999004212),
     (-0.285283249815, -0.153108131614, 2.99998920194),
     (-0.278923993259, -0.146749026059, 2.99998837099),
     (-0.27256473837, -0.140389920644, 2.9999875493),
     (-0.26620548507, -0.13403081537, 2.99998673683),
     (-0.259846233279, -0.127671710238, 2.9999859336),
     (-0.253486982921, -0.121312605246, 2.99998513962),
     (-0.247127733916, -0.114953500395, 2.99998435488),
     (-0.240768486186, -0.108594395685, 2.99998357938),
     (-0.234409239653, -0.102235291116, 2.99998281311),
     (-0.228049994238, -0.095876186688, 2.99998205608),
     (-0.221690749863, -0.0895170824008, 2.99998130829),
     (-0.215331506451, -0.0831579782545, 2.99998056975),
     (-0.208972263921, -0.0767988742491, 2.99997984044),
     (-0.202613022197, -0.0704397703847, 2.99997912037),
     (-0.1962537812, -0.0640806666611, 2.99997840954),
     (-0.189894540851, -0.0577215630786, 2.99997770794),
     (-0.183535301072, -0.0513624596369, 2.9999770156),
     (-0.177176061785, -0.0450033563361, 2.99997633248),
     (-0.170816822911, -0.0386442531763, 2.99997565861),
     (-0.164457584372, -0.0322851501574, 2.99997499397),
     (-0.158098346091, -0.0259260472794, 2.99997433858),
     (-0.151739107987, -0.0195669445423, 2.99997369242),
     (-0.145379869984, -0.0132078419461, 2.9999730555),
     (-0.139020632003, -0.00684873949088, 2.99997242782),
     (-0.132661393965, -0.000489637176549, 2.99997180939),
     (-0.126302155792, 0.00586946499684, 2.99997120019),
     (-0.119942917406, 0.0122285670293, 2.99997060022),
     (-0.113583678728, 0.0185876689209, 2.99997000951),
     (-0.10722443968, 0.0249467706715, 2.99996942802),
     (-0.100865200185, 0.0313058722812, 2.99996885578),
     (-0.0945059601622, 0.03766497375, 2.99996829278),
     (-0.0881467195348, 0.0440240750779, 2.99996773901),
     (-0.0817874782243, 0.0503831762648, 2.99996719449),
     (-0.0754282361522, 0.0567422773108, 2.9999666592),
     (-0.0690689932402, 0.0631013782159, 2.99996613315),
     (-0.0627097494099, 0.0694604789801, 2.99996561634),
     (-0.0563505045831, 0.0758195796034, 2.99996510878),
     (-0.0499912586813, 0.0821786800857, 2.99996461044),
     (-0.0436320116263, 0.0885377804271, 2.99996412135),
     (-0.0372727633397, 0.0948968806276, 2.9999636415),
     (-0.0309135137432, 0.101255980687, 2.99996317088),
     (-0.0245542627585, 0.107615080606, 2.99996270951),
     (-0.0181950103071, 0.113974180383, 2.99996225737),
     (-0.0118357563109, 0.12033328002, 2.99996181447),
     (-0.00547650069135, 0.126692379516, 2.99996138082),
     (0.000882756629771, 0.133051478871, 2.99996095639),
     (0.00724201573081, 0.139410578085, 2.99996054121),
     (0.0136012766901, 0.145769677158, 2.99996013527),
     (0.019960539586, 0.15212877609, 2.99995973857),
     (0.0263198044969, 0.158487874881, 2.9999593511),
     (0.032679071501, 0.164846973532, 2.99995897288),
     (0.0390383406767, 0.171206072041, 2.9999586039),
     (0.0453976121023, 0.177565170409, 2.99995824414),
     (0.0517568858563, 0.183924268637, 2.99995789364),
     (0.0581161620168, 0.190283366724, 2.99995755237),
     (0.0644754406623, 0.196642464669, 2.99995722034),
     (0.0708347218711, 0.203001562474, 2.99995689755),
     (0.0771940057215, 0.209360660138, 2.99995658399),
     (0.0835532922919, 0.215719757661, 2.99995627968),
     (0.0899125816606, 0.222078855042, 2.9999559846),
     (0.0962718739059, 0.228437952283, 2.99995569876),
     (0.102631169106, 0.234797049384, 2.99995542216),
     (0.10899046734, 0.241156146343, 2.9999551548),
     (0.115349768685, 0.247515243161, 2.99995489669),
     (0.12170907322, 0.253874339838, 2.9999546478),
     (0.128068381024, 0.260233436374, 2.99995440816),
     (0.134427692174, 0.26659253277, 2.99995417776),
     (0.140787006749, 0.272951629024, 2.99995395658),
     (0.147146324828, 0.279310725138, 2.99995374465),
     (0.153505646488, 0.28566982111, 2.99995354196),
     (0.159864971808, 0.292028916942, 2.99995334852),
     (0.166224300867, 0.298388012633, 2.9999531643),
     (0.172583633742, 0.304747108183, 2.99995298933),
     (0.178942970512, 0.311106203592, 2.9999528236),
     (0.185302311256, 0.31746529886, 2.99995266709),
     (0.191661656052, 0.323824393987, 2.99995251984),
     (0.198021004977, 0.330183488973, 2.99995238182),
     (0.204380358111, 0.336542583818, 2.99995225304),
     (0.210739715532, 0.342901678522, 2.9999521335),
     (0.217099077317, 0.349260773085, 2.99995202319),
     (0.223458443546, 0.355619867508, 2.99995192213),
     (0.229817814297, 0.361978961789, 2.99995183031),
     (0.236177189648, 0.368338055929, 2.99995174771),
     (0.242536569678, 0.374697149929, 2.99995167437),
     (0.248895954464, 0.381056243788, 2.99995161025),
     (0.255255344085, 0.387415337505, 2.99995155538),
     (0.26161473862, 0.393774431082, 2.99995150975),
     (0.267974138147, 0.400133524518, 2.99995147334),
     (0.274333542743, 0.406492617813, 2.9999514462),
     (0.280692952489, 0.412851710966, 2.99995142828),
     (0.287052367461, 0.419210803979, 2.99995141959),
     (0.293411787738, 0.425569896851, 2.99995142015)],
    [(-0.419680367, -0.298515819933, 3.50001473034),
     (-0.413321050587, -0.292156708587, 3.50001317904),
     (-0.406961737582, -0.285797597431, 3.50001164158),
     (-0.400602427906, -0.279438486468, 3.50001011798),
     (-0.39424312148, -0.273079375697, 3.50000860824),
     (-0.387883818226, -0.266720265117, 3.50000711236),
     (-0.381524518066, -0.260361154729, 3.50000563035),
     (-0.375165220922, -0.254002044533, 3.50000416218),
     (-0.368805926715, -0.247642934528, 3.50000270789),
     (-0.362446635367, -0.241283824716, 3.50000126745),
     (-0.356087346799, -0.234924715095, 3.49999984087),
     (-0.349728060933, -0.228565605666, 3.49999842815),
     (-0.343368777692, -0.222206496428, 3.49999702929),
     (-0.337009496996, -0.215847387383, 3.49999564428),
     (-0.330650218766, -0.209488278529, 3.49999427313),
     (-0.324290942926, -0.203129169867, 3.49999291586),
     (-0.317931669396, -0.196770061397, 3.49999157242),
     (-0.311572398099, -0.190410953119, 3.49999024286),
     (-0.305213128955, -0.184051845032, 3.49998892714),
     (-0.298853861886, -0.177692737137, 3.49998762531),
     (-0.292494596815, -0.171333629435, 3.49998633732),
     (-0.286135333662, -0.164974521923, 3.49998506318),
     (-0.27977607235, -0.158615414604, 3.49998380291),
     (-0.2734168128, -0.152256307476, 3.49998255649),
     (-0.267057554934, -0.14589720054, 3.49998132395),
     (-0.260698298673, -0.139538093796, 3.49998010525),
     (-0.25433904394, -0.133178987244, 3.49997890041),
     (-0.247979790655, -0.126819880884, 3.49997770943),
     (-0.24162053874, -0.120460774715, 3.49997653233),
     (-0.235261288118, -0.114101668738, 3.49997536907),
     (-0.22890203871, -0.107742562953, 3.49997421966),
     (-0.222542790436, -0.10138345736, 3.49997308412),
     (-0.21618354322, -0.0950243519584, 3.49997196244),
     (-0.209824296983, -0.0886652467487, 3.49997085463),
     (-0.203465051646, -0.0823061417308, 3.49996976066),
     (-0.197105807131, -0.0759470369047, 3.49996868055),
     (-0.19074656336, -0.0695879322703, 3.49996761432),
     (-0.184387320255, -0.0632288278279, 3.49996656191),
     (-0.178028077736, -0.0568697235771, 3.49996552339),
     (-0.171668835726, -0.0505106195182, 3.49996449872),
     (-0.165309594147, -0.044151515651, 3.49996348792),
     (-0.158950352919, -0.0377924119757, 3.49996249096),
     (-0.152591111966, -0.0314333084922, 3.49996150786),
     (-0.146231871208, -0.0250742052004, 3.49996053863),
     (-0.139872630566, -0.0187151021005, 3.49995958325),
     (-0.133513389964, -0.0123559991923, 3.49995864174),
     (-0.127154149322, -0.00599689647595, 3.49995771408),
     (-0.120794908562, 0.00036220604859, 3.49995680028),
     (-0.114435667606, 0.00672130838135, 3.49995590034),
     (-0.108076426375, 0.0130804105223, 3.49995501426),
     (-0.101717184791, 0.0194395124715, 3.49995414203),
     (-0.0953579427761, 0.0257986142288, 3.49995328367),
     (-0.0889987002514, 0.0321577157944, 3.49995243916),
     (-0.0826394571388, 0.0385168171682, 3.49995160851),
     (-0.07628021336, 0.0448759183502, 3.49995079174),
     (-0.0699209688364, 0.0512350193403, 3.49994998879),
     (-0.06356172349, 0.0575941201387, 3.49994919973),
     (-0.0572024772423, 0.0639532207452, 3.49994842451),
     (-0.0508432300149, 0.07031232116, 3.49994766316),
     (-0.0444839817296, 0.0766714213829, 3.49994691566),
     (-0.0381247323081, 0.0830305214141, 3.49994618203),
     (-0.0317654816718, 0.0893896212535, 3.49994546225),
     (-0.0254062297426, 0.095748720901, 3.49994475632),
     (-0.0190469764422, 0.102107820357, 3.49994406427),
     (-0.0126877216921, 0.108466919621, 3.49994338606),
     (-0.00632846541399, 0.114826018693, 3.4999427217),
     (3.07924703418e-05, 0.121185117573, 3.49994207122),
     (0.00639005203935, 0.127544216262, 3.49994143459),
     (0.0127493133713, 0.133903314758, 3.49994081182),
     (0.0191085765446, 0.140262413063, 3.49994020291),
     (0.0254678416375, 0.146621511176, 3.49993960785),
     (0.0318271087284, 0.152980609098, 3.49993902665),
     (0.0381863778956, 0.159339706827, 3.49993845932),
     (0.0445456492174, 0.165698804365, 3.49993790584),
     (0.0509049227723, 0.172057901711, 3.49993736622),
     (0.0572641986384, 0.178416998865, 3.49993684045),
     (0.0636234768942, 0.184776095827, 3.49993632855),
     (0.069982757618, 0.191135192598, 3.49993583051),
     (0.0763420408882, 0.197494289176, 3.49993534632),
     (0.082701326783, 0.203853385563, 3.49993487599),
     (0.0890606153808, 0.210212481758, 3.49993441952),
     (0.09541990676, 0.216571577761, 3.4999339769),
     (0.101779200999, 0.222930673573, 3.49993354814),
     (0.108138498176, 0.229289769192, 3.49993313324),
     (0.114497798369, 0.23564886462, 3.4999327322),
     (0.120857101657, 0.242007959856, 3.49993234503),
     (0.127216408118, 0.2483670549, 3.4999319717),
     (0.13357571783, 0.254726149752, 3.49993161224),
     (0.139935030872, 0.261085244413, 3.49993126663),
     (0.146294347322, 0.267444338882, 3.49993093488),
     (0.152653667258, 0.273803433159, 3.49993061698),
     (0.159012990759, 0.280162527244, 3.49993031295),
     (0.165372317904, 0.286521621137, 3.49993002278),
     (0.171731648769, 0.292880714838, 3.49992974645),
     (0.178090983434, 0.299239808348, 3.499929484),
     (0.184450321978, 0.305598901666, 3.4999292354),
     (0.190809664478, 0.311957994792, 3.49992900064),
     (0.197169011012, 0.318317087726, 3.49992877976),
     (0.20352836166, 0.324676180468, 3.49992857273),
     (0.209887716499, 0.331035273019, 3.49992837956),
     (0.216247075608, 0.337394365378, 3.49992820025),
     (0.222606439065, 0.343753457545, 3.49992803479),
     (0.228965806948, 0.35011254952, 3.4999278832),
     (0.235325179337, 0.356471641303, 3.49992774546),
     (0.241684556308, 0.362830732894, 3.49992762157),
     (0.248043937941, 0.369189824294, 3.49992751155),
     (0.254403324313, 0.375548915502, 3.49992741538),
     (0.260762715504, 0.381908006518, 3.49992733307),
     (0.267122111592, 0.388267097342, 3.49992726462),
     (0.273481512654, 0.394626187974, 3.49992721002),
     (0.279840918769, 0.400985278415, 3.49992716929),
     (0.286200330016, 0.407344368664, 3.49992714241),
     (0.292559746473, 0.41370345872, 3.49992712938),
     (0.298919168218, 0.420062548586, 3.49992713022)],
    [(-0.414173256917, -0.304023150357, 4.00001964046),
     (-0.407813937196, -0.297664036318, 4.00001757205),
     (-0.401454620898, -0.291304922523, 4.00001552211),
     (-0.395095307947, -0.28494580897, 4.00001349064),
     (-0.388735998264, -0.278586695659, 4.00001147766),
     (-0.382376691769, -0.272227582592, 4.00000948315),
     (-0.376017388385, -0.265868469767, 4.00000750713),
     (-0.369658088034, -0.259509357185, 4.00000554958),
     (-0.363298790637, -0.253150244845, 4.00000361052),
     (-0.356939496116, -0.246791132748, 4.00000168993),
     (-0.350580204392, -0.240432020893, 3.99999978783),
     (-0.344220915387, -0.234072909282, 3.9999979042),
     (-0.337861629024, -0.227713797913, 3.99999603905),
     (-0.331502345222, -0.221354686786, 3.99999419238),
     (-0.325143063905, -0.214995575903, 3.99999236417),
     (-0.318783784994, -0.208636465261, 3.99999055447),
     (-0.312424508409, -0.202277354863, 3.99998876322),
     (-0.306065234075, -0.195918244707, 3.99998699048),
     (-0.29970596191, -0.189559134794, 3.99998523619),
     (-0.293346691839, -0.183200025124, 3.99998350041),
     (-0.286987423781, -0.176840915696, 3.99998178309),
     (-0.280628157659, -0.170481806511, 3.99998008424),
     (-0.274268893395, -0.164122697569, 3.99997840388),
     (-0.267909630909, -0.157763588869, 3.99997674199),
     (-0.261550370125, -0.151404480412, 3.9999750986),
     (-0.255191110962, -0.145045372197, 3.99997347366),
     (-0.248831853344, -0.138686264225, 3.99997186721),
     (-0.242472597192, -0.132327156496, 3.99997027925),
     (-0.236113342427, -0.12596804901, 3.99996870977),
     (-0.229754088971, -0.119608941766, 3.99996715876),
     (-0.223394836746, -0.113249834765, 3.99996562621),
     (-0.217035585673, -0.106890728006, 3.99996411216),
     (-0.210676335674, -0.100531621491, 3.99996261659),
     (-0.204317086671, -0.0941725152175, 3.9999611395),
     (-0.197957838585, -0.087813409187, 3.99995968088),
     (-0.191598591338, -0.0814543033993, 3.99995824073),
     (-0.185239344853, -0.0750951978541, 3.99995681909),
     (-0.178880099049, -0.0687360925517, 3.99995541588),
     (-0.172520853849, -0.0623769874919, 3.99995403119),
     (-0.166161609176, -0.0560178826748, 3.99995266496),
     (-0.159802364949, -0.0496587781004, 3.99995131722),
     (-0.153443121092, -0.0432996737686, 3.99994998794),
     (-0.147083877525, -0.0369405696796, 3.99994867715),
     (-0.140724634171, -0.0305814658331, 3.99994738485),
     (-0.13436539095, -0.0242223622294, 3.999946111),
     (-0.128006147786, -0.0178632588683, 3.99994485565),
     (-0.121646904598, -0.0115041557499, 3.99994361878),
     (-0.11528766131, -0.00514505287422, 3.99994240037),
     (-0.108928417842, 0.00121404975883, 3.99994120045),
     (-0.102569174117, 0.00757315214923, 3.99994001901),
     (-0.096209930056, 0.0139322542969, 3.99993885604),
     (-0.0898506855805, 0.0202913562019, 3.99993771155),
     (-0.0834914406124, 0.0266504578643, 3.99993658555),
     (-0.0771321950732, 0.0330095592839, 3.99993547801),
     (-0.0707729488848, 0.039368660461, 3.99993438898),
     (-0.0644137019686, 0.0457277613952, 3.99993331839),
     (-0.0580544542465, 0.0520868620869, 3.99993226631),
     (-0.0516952056401, 0.0584459625358, 3.99993123269),
     (-0.045335956071, 0.0648050627421, 3.99993021755),
     (-0.0389767054608, 0.0711641627056, 3.99992922088),
     (-0.0326174537315, 0.0775232624266, 3.99992824271),
     (-0.0262582008044, 0.0838823619048, 3.999927283),
     (-0.0198989466012, 0.0902414611403, 3.99992634176),
     (-0.0135396910439, 0.0966005601332, 3.99992541902),
     (-0.00718043405375, 0.102959658883, 3.99992451475),
     (-0.000821175552572, 0.109318757391, 3.99992362894),
     (0.00553808453784, 0.115677855656, 3.99992276163),
     (0.011897346296, 0.122036953678, 3.99992191279),
     (0.0182566098001, 0.128396051457, 3.99992108243),
     (0.0246158751286, 0.134755148994, 3.99992027055),
     (0.0309751423598, 0.141114246288, 3.99991947713),
     (0.037334411572, 0.147473343339, 3.9999187022),
     (0.0436936828435, 0.153832440148, 3.99991794576),
     (0.0500529562527, 0.160191536714, 3.99991720779),
     (0.056412231878, 0.166550633037, 3.99991648829),
     (0.0627715097976, 0.172909729118, 3.99991578727),
     (0.0691307900899, 0.179268824956, 3.99991510474),
     (0.0754900728333, 0.185627920551, 3.99991444068),
     (0.081849358106, 0.191987015904, 3.99991379509),
     (0.0882086459865, 0.198346111014, 3.99991316798),
     (0.0945679365529, 0.204705205881, 3.99991255936),
     (0.100927229884, 0.211064300505, 3.9999119692),
     (0.107286526057, 0.217423394887, 3.99991139752),
     (0.113645825152, 0.223782489026, 3.99991084432),
     (0.120005127246, 0.230141582923, 3.99991030961),
     (0.126364432418, 0.236500676576, 3.99990979337),
     (0.132723740746, 0.242859769987, 3.9999092956),
     (0.139083052308, 0.249218863156, 3.99990881632),
     (0.145442367183, 0.255577956081, 3.99990835551),
     (0.151801685449, 0.261937048764, 3.99990791317),
     (0.158161007185, 0.268296141205, 3.99990748931),
     (0.164520332468, 0.274655233402, 3.99990708393),
     (0.170879661377, 0.281014325357, 3.99990669703),
     (0.177238993991, 0.287373417069, 3.9999063286),
     (0.183598330387, 0.293732508539, 3.99990597867),
     (0.189957670645, 0.300091599765, 3.9999056472),
     (0.196317014842, 0.306450690749, 3.99990533419),
     (0.202676363057, 0.312809781491, 3.99990503968),
     (0.209035715368, 0.319168871989, 3.99990476364),
     (0.215395071854, 0.325527962245, 3.99990450608),
     (0.221754432592, 0.331887052259, 3.999904267),
     (0.228113797662, 0.338246142029, 3.99990404638),
     (0.234473167141, 0.344605231557, 3.99990384427),
     (0.240832541108, 0.350964320842, 3.99990366061),
     (0.247191919641, 0.357323409885, 3.99990349542),
     (0.253551302818, 0.363682498684, 3.99990334873),
     (0.259910690719, 0.370041587241, 3.9999032205),
     (0.26627008342, 0.376400675556, 3.99990311076),
     (0.272629481001, 0.382759763627, 3.99990301949),
     (0.27898888354, 0.389118851456, 3.99990294669),
     (0.285348291116, 0.395477939043, 3.99990289239),
     (0.291707703806, 0.401837026386, 3.99990285655),
     (0.298067121688, 0.408196113487, 3.99990283917),
     (0.304426544842, 0.414555200345, 3.9999028403)],
    [(-0.408666144, -0.309530480754, 4.50002455057),
     (-0.402306821028, -0.303171364025, 4.50002196506),
     (-0.395947501498, -0.296812247588, 4.50001940264),
     (-0.389588185331, -0.290453131446, 4.5000168633),
     (-0.383228872448, -0.284094015597, 4.50001434707),
     (-0.376869562771, -0.277734900041, 4.50001185394),
     (-0.370510256223, -0.271375784779, 4.50000938391),
     (-0.364150952723, -0.265016669811, 4.50000693697),
     (-0.357791652195, -0.258657555136, 4.50000451315),
     (-0.351432354559, -0.252298440755, 4.50000211241),
     (-0.345073059738, -0.245939326667, 4.49999973479),
     (-0.338713767653, -0.239580212872, 4.49999738024),
     (-0.332354478226, -0.233221099371, 4.49999504882),
     (-0.325995191378, -0.226861986164, 4.49999274047),
     (-0.319635907032, -0.220502873251, 4.49999045521),
     (-0.313276625108, -0.21414376063, 4.49998819309),
     (-0.306917345528, -0.207784648304, 4.49998595403),
     (-0.300558068215, -0.20142553627, 4.49998373811),
     (-0.294198793089, -0.195066424531, 4.49998154524),
     (-0.287839520073, -0.188707313085, 4.49997937551),
     (-0.281480249088, -0.182348201932, 4.49997722886),
     (-0.275120980055, -0.175989091073, 4.4999751053),
     (-0.268761712897, -0.169629980508, 4.49997300485),
     (-0.262402447535, -0.163270870236, 4.49997092748),
     (-0.256043183891, -0.156911760257, 4.49996887325),
     (-0.249683921886, -0.150552650572, 4.49996684208),
     (-0.243324661442, -0.144193541181, 4.49996483401),
     (-0.236965402481, -0.137834432083, 4.49996284906),
     (-0.230606144924, -0.131475323279, 4.49996088721),
     (-0.224246888693, -0.125116214768, 4.49995894845),
     (-0.21788763371, -0.118757106551, 4.49995703277),
     (-0.211528379896, -0.112397998628, 4.49995514019),
     (-0.205169127173, -0.106038890997, 4.49995327073),
     (-0.198809875463, -0.0996797836608, 4.49995142438),
     (-0.192450624687, -0.0933206766178, 4.49994960111),
     (-0.186091374768, -0.0869615698684, 4.49994780091),
     (-0.179732125626, -0.0806024634124, 4.49994602386),
     (-0.173372877183, -0.0742433572502, 4.49994426986),
     (-0.167013629361, -0.0678842513813, 4.49994253899),
     (-0.160654382082, -0.061525145806, 4.4999408312),
     (-0.154295135267, -0.0551660405243, 4.49993914653),
     (-0.147935888838, -0.0488069355361, 4.49993748493),
     (-0.141576642717, -0.0424478308415, 4.49993584644),
     (-0.135217396826, -0.0360887264404, 4.49993423106),
     (-0.128858151085, -0.0297296223329, 4.49993263875),
     (-0.122498905417, -0.0233705185189, 4.49993106956),
     (-0.116139659743, -0.0170114149984, 4.49992952347),
     (-0.109780413985, -0.0106523117716, 4.49992800046),
     (-0.103421168065, -0.00429320883825, 4.49992650056),
     (-0.0970619219041, 0.00206589380156, 4.49992502377),
     (-0.0907026754242, 0.00842499614775, 4.49992357005),
     (-0.084343428547, 0.0147840982004, 4.49992213944),
     (-0.0779841811941, 0.0211431999596, 4.49992073194),
     (-0.0716249332871, 0.0275023014251, 4.49991934752),
     (-0.0652656847479, 0.0338614025972, 4.49991798623),
     (-0.0589064354978, 0.0402205034756, 4.49991664799),
     (-0.0525471854588, 0.0465796040605, 4.49991533289),
     (-0.0461879345524, 0.0529387043518, 4.49991404086),
     (-0.0398286827003, 0.0592978043496, 4.49991277194),
     (-0.0334694298241, 0.0656569040538, 4.49991152609),
     (-0.0271101758457, 0.0720160034645, 4.49991030339),
     (-0.0207509206865, 0.0783751025816, 4.49990910375),
     (-0.0143916642681, 0.0847342014051, 4.4999079272),
     (-0.00803240651257, 0.0910932999352, 4.49990677378),
     (-0.0016731473412, 0.0974523981716, 4.49990564344),
     (0.00468611332428, 0.103811496114, 4.49990453617),
     (0.011045375562, 0.110170593764, 4.49990345204),
     (0.0174046394505, 0.116529691119, 4.49990239098),
     (0.0237639050681, 0.122888788182, 4.49990135303),
     (0.030123172493, 0.12924788495, 4.49990033819),
     (0.0364824418037, 0.135606981425, 4.49989934642),
     (0.0428417130785, 0.141966077607, 4.49989837775),
     (0.0492009863956, 0.148325173495, 4.49989743219),
     (0.0555602618334, 0.154684269089, 4.49989650974),
     (0.0619195394704, 0.16104336439, 4.49989561036),
     (0.0682788193847, 0.167402459397, 4.49989473409),
     (0.0746381016548, 0.17376155411, 4.49989388092),
     (0.0809973863589, 0.180120648531, 4.49989305085),
     (0.0873566735755, 0.186479742657, 4.49989224387),
     (0.0937159633828, 0.19283883649, 4.49989145998),
     (0.100075255859, 0.199197930029, 4.4998906992),
     (0.106434551083, 0.205557023275, 4.4998899615),
     (0.112793849133, 0.211916116227, 4.4998892469),
     (0.119153150086, 0.218275208886, 4.4998885554),
     (0.125512454023, 0.224634301251, 4.49988788701),
     (0.131871761019, 0.230993393322, 4.49988724172),
     (0.138231071155, 0.2373524851, 4.49988661951),
     (0.144590384509, 0.243711576585, 4.4998860204),
     (0.150949701158, 0.250070667775, 4.49988544439),
     (0.157309021182, 0.256429758673, 4.49988489146),
     (0.163668344657, 0.262788849276, 4.49988436163),
     (0.170027671664, 0.269147939586, 4.49988385491),
     (0.17638700228, 0.275507029603, 4.49988337129),
     (0.182746336583, 0.281866119325, 4.49988291075),
     (0.189105674652, 0.288225208755, 4.49988247334),
     (0.195465016565, 0.29458429789, 4.499882059),
     (0.201824362401, 0.300943386733, 4.49988166774),
     (0.208183712238, 0.307302475281, 4.49988129961),
     (0.214543066153, 0.313661563536, 4.49988095455),
     (0.220902424227, 0.320020651497, 4.4998806326),
     (0.227261786536, 0.326379739165, 4.49988033375),
     (0.233621153159, 0.332738826539, 4.49988005798),
     (0.239980524175, 0.33909791362, 4.49987980533),
     (0.246339899661, 0.345457000407, 4.49987957577),
     (0.252699279697, 0.3518160869, 4.49987936928),
     (0.259058664361, 0.3581751731, 4.49987918591),
     (0.26541805373, 0.364534259007, 4.49987902563),
     (0.271777447884, 0.370893344619, 4.49987888845),
     (0.2781368469, 0.377252429938, 4.49987877437),
     (0.284496250857, 0.383611514964, 4.49987868336),
     (0.290855659833, 0.389970599696, 4.49987861549),
     (0.297215073907, 0.396329684134, 4.49987857069),
     (0.303574493158, 0.402688768279, 4.49987854897),
     (0.309933917662, 0.40904785213, 4.49987855037)],
    [(-0.403159028197, -0.315037811126, 5.00002946069),
     (-0.396799702035, -0.308678691705, 5.00002635807),
     (-0.39044037933, -0.302319572629, 5.00002328316),
     (-0.384081060006, -0.295960453897, 5.00002023596),
     (-0.377721743982, -0.289601335509, 5.00001721649),
     (-0.371362431182, -0.283242217466, 5.00001422472),
     (-0.365003121527, -0.276883099766, 5.0000112607),
     (-0.358643814938, -0.270523982412, 5.00000832437),
     (-0.352284511337, -0.264164865402, 5.00000541578),
     (-0.345925210646, -0.257805748736, 5.00000253489),
     (-0.339565912787, -0.251446632414, 4.99999968174),
     (-0.33320661768, -0.245087516438, 4.99999685629),
     (-0.326847325249, -0.238728400805, 4.99999405858),
     (-0.320488035413, -0.232369285517, 4.99999128857),
     (-0.314128748096, -0.226010170573, 4.99998854625),
     (-0.307769463218, -0.219651055974, 4.99998583171),
     (-0.301410180702, -0.213291941719, 4.99998314483),
     (-0.295050900469, -0.206932827808, 4.99998048573),
     (-0.288691622441, -0.200573714242, 4.99997785428),
     (-0.282332346539, -0.19421460102, 4.99997525061),
     (-0.275973072685, -0.187855488143, 4.99997267464),
     (-0.2696138008, -0.18149637561, 4.99997012636),
     (-0.263254530807, -0.175137263421, 4.99996760582),
     (-0.256895262627, -0.168778151577, 4.99996511298),
     (-0.250535996182, -0.162419040077, 4.9999626479),
     (-0.244176731393, -0.156059928922, 4.99996021049),
     (-0.237817468182, -0.149700818111, 4.99995780081),
     (-0.231458206471, -0.143341707645, 4.99995541887),
     (-0.225098946181, -0.136982597523, 4.99995306465),
     (-0.218739687234, -0.130623487745, 4.99995073814),
     (-0.212380429551, -0.124264378312, 4.99994843932),
     (-0.206021173055, -0.117905269223, 4.99994616823),
     (-0.199661917667, -0.111546160479, 4.99994392488),
     (-0.193302663309, -0.105187052079, 4.99994170925),
     (-0.186943409902, -0.0988279440232, 4.99993952133),
     (-0.180584157368, -0.0924688363121, 4.9999373611),
     (-0.174224905628, -0.0861097289453, 4.99993522863),
     (-0.167865654605, -0.0797506219231, 4.99993312383),
     (-0.16150640422, -0.0733915152452, 4.99993104679),
     (-0.155147154394, -0.0670324089118, 4.99992899745),
     (-0.14878790505, -0.0606733029227, 4.99992697583),
     (-0.142428656109, -0.0543141972782, 4.99992498191),
     (-0.136069407492, -0.047955091978, 4.99992301573),
     (-0.129710159122, -0.0415959870222, 4.99992107727),
     (-0.123350910919, -0.0352368824109, 4.99991916651),
     (-0.116991662806, -0.028877778144, 4.99991728347),
     (-0.110632414705, -0.0225186742215, 4.99991542817),
     (-0.104273166536, -0.0161595706435, 4.99991360056),
     (-0.0979139182223, -0.00980046740989, 4.99991180067),
     (-0.0915546696846, -0.00344136452066, 4.99991002852),
     (-0.0851954208448, 0.00291773802405, 4.99990828406),
     (-0.0788361716246, 0.00927684022437, 4.99990656733),
     (-0.0724769219457, 0.0156359420803, 4.99990487833),
     (-0.0661176717297, 0.0219950435917, 4.99990321702),
     (-0.0597584208984, 0.0283541447589, 4.99990158347),
     (-0.0533991693732, 0.0347132455814, 4.99989997759),
     (-0.047039917076, 0.0410723460596, 4.99989839946),
     (-0.0406806639284, 0.0474314461933, 4.99989684903),
     (-0.0343214098521, 0.0537905459826, 4.99989532633),
     (-0.0279621547686, 0.0601496454274, 4.99989383131),
     (-0.0216028985998, 0.0665087445279, 4.99989236406),
     (-0.0152436412672, 0.0728678432839, 4.99989092451),
     (-0.00888438269247, 0.0792269416953, 4.99988951264),
     (-0.00252512279745, 0.0855860397625, 4.99988812854),
     (0.00383413849641, 0.0919451374851, 4.99988677212),
     (0.0101934012675, 0.0983042348633, 4.9998854434),
     (0.0165526655938, 0.104663331897, 4.99988414245),
     (0.0229119315539, 0.111022428586, 4.99988286918),
     (0.0292711992261, 0.117381524931, 4.99988162364),
     (0.0356304686887, 0.123740620932, 4.99988040582),
     (0.0419897400202, 0.130099716588, 4.9998792157),
     (0.0483490132988, 0.136458811899, 4.9998780533),
     (0.0547082886027, 0.142817906866, 4.99987691863),
     (0.0610675660104, 0.149177001489, 4.99987581169),
     (0.0674268456003, 0.155536095767, 4.99987473243),
     (0.0737861274506, 0.161895189701, 4.99987368091),
     (0.0801454116397, 0.16825428329, 4.9998726571),
     (0.0865046982458, 0.174613376535, 4.99987166103),
     (0.0928639873475, 0.180972469436, 4.99987069264),
     (0.099223279023, 0.187331561992, 4.99986975198),
     (0.105582573351, 0.193690654203, 4.99986883904),
     (0.111941870409, 0.20004974607, 4.9998679538),
     (0.118301170276, 0.206408837593, 4.99986709627),
     (0.124660473029, 0.212767928771, 4.99986626648),
     (0.131019778749, 0.219127019605, 4.99986546441),
     (0.137379087512, 0.225486110094, 4.99986469006),
     (0.143738399398, 0.231845200239, 4.99986394341),
     (0.150097714484, 0.238204290039, 4.99986322448),
     (0.156457032848, 0.244563379495, 4.99986253327),
     (0.16281635457, 0.250922468606, 4.99986186975),
     (0.169175679728, 0.257281557373, 4.99986123396),
     (0.175535008399, 0.263640645796, 4.99986062589),
     (0.181894340662, 0.269999733874, 4.99986004555),
     (0.188253676596, 0.276358821607, 4.9998594929),
     (0.194613016279, 0.282717908996, 4.999858968),
     (0.200972359789, 0.289076996041, 4.9998584708),
     (0.207331707205, 0.295436082741, 4.99985800128),
     (0.213691058604, 0.301795169097, 4.99985755953),
     (0.220050414066, 0.308154255108, 4.99985714546),
     (0.226409773668, 0.314513340775, 4.99985675912),
     (0.232769137489, 0.320872426097, 4.9998564005),
     (0.239128505607, 0.327231511075, 4.99985606957),
     (0.245487878101, 0.333590595708, 4.9998557664),
     (0.251847255049, 0.339949679997, 4.99985549092),
     (0.258206636529, 0.346308763942, 4.99985524313),
     (0.26456602262, 0.352667847542, 4.9998550231),
     (0.270925413399, 0.359026930797, 4.99985483075),
     (0.277284808946, 0.365386013708, 4.99985466614),
     (0.283644209338, 0.371745096275, 4.99985452924),
     (0.290003614655, 0.378104178497, 4.99985442003),
     (0.296363024974, 0.384463260375, 4.99985433859),
     (0.302722440373, 0.390822341908, 4.99985428483),
     (0.309081860931, 0.397181423096, 4.99985425876),
     (0.315441286727, 0.40354050394, 4.99985426045)],
    [(-0.397651909459, -0.320545141473, 5.5000343708),
     (-0.391292580164, -0.314186019361, 5.50003075109),
     (-0.384933254344, -0.307826897644, 5.50002716369),
     (-0.37857393192, -0.301467776322, 5.50002360862),
     (-0.372214612816, -0.295108655395, 5.5000200859),
     (-0.365855296951, -0.288749534864, 5.50001659551),
     (-0.359495984248, -0.282390414728, 5.50001313748),
     (-0.353136674628, -0.276031294987, 5.50000971176),
     (-0.346777368014, -0.269672175642, 5.50000631841),
     (-0.340418064326, -0.263313056692, 5.50000295738),
     (-0.334058763487, -0.256953938137, 5.4999996287),
     (-0.327699465418, -0.250594819977, 5.49999633234),
     (-0.32134017004, -0.244235702213, 5.49999306834),
     (-0.314980877276, -0.237876584844, 5.49998983666),
     (-0.308621587046, -0.23151746787, 5.4999866373),
     (-0.302262299274, -0.225158351291, 5.49998347033),
     (-0.29590301388, -0.218799235108, 5.49998033564),
     (-0.289543730786, -0.21244011932, 5.49997723335),
     (-0.283184449913, -0.206081003928, 5.49997416333),
     (-0.276825171184, -0.19972188893, 5.49997112571),
     (-0.27046589452, -0.193362774328, 5.49996812041),
     (-0.264106619843, -0.187003660121, 5.49996514742),
     (-0.257747347074, -0.18064454631, 5.49996220679),
     (-0.251388076134, -0.174285432893, 5.49995929847),
     (-0.245028806947, -0.167926319872, 5.49995642255),
     (-0.238669539433, -0.161567207247, 5.49995357891),
     (-0.232310273513, -0.155208095016, 5.49995076762),
     (-0.225951009111, -0.148848983181, 5.49994798868),
     (-0.219591746147, -0.142489871741, 5.4999452421),
     (-0.213232484542, -0.136130760697, 5.49994252783),
     (-0.206873224219, -0.129771650047, 5.49993984587),
     (-0.2005139651, -0.123412539793, 5.49993719627),
     (-0.194154707106, -0.117053429935, 5.49993457902),
     (-0.187795450158, -0.110694320471, 5.49993199413),
     (-0.181436194178, -0.104335211403, 5.49992944155),
     (-0.175076939088, -0.0979761027304, 5.49992692128),
     (-0.16871768481, -0.0916169944528, 5.4999244334),
     (-0.162358431265, -0.0852578865707, 5.4999219778),
     (-0.155999178376, -0.0788987790837, 5.49991955459),
     (-0.149639926062, -0.0725396719921, 5.49991716369),
     (-0.143280674247, -0.0661805652957, 5.49991480514),
     (-0.136921422852, -0.0598214589948, 5.4999124789),
     (-0.130562171799, -0.053462353089, 5.49991018501),
     (-0.124202921008, -0.0471032475786, 5.49990792348),
     (-0.117843670403, -0.0407441424635, 5.49990569426),
     (-0.111484419904, -0.0343850377437, 5.49990349738),
     (-0.105125169433, -0.0280259334191, 5.49990133286),
     (-0.0987659189128, -0.02166682949, 5.49989920065),
     (-0.0924066682637, -0.0153077259561, 5.49989710079),
     (-0.0860474174079, -0.00894862281744, 5.49989503327),
     (-0.0796881662669, -0.00258952007421, 5.49989299807),
     (-0.0733289147625, 0.00376958227377, 5.49989099522),
     (-0.0669696628163, 0.0101286842265, 5.49988902472),
     (-0.06061041035, 0.0164877857838, 5.49988708652),
     (-0.0542511572854, 0.022846886946, 5.49988518072),
     (-0.0478919035438, 0.0292059877126, 5.49988330719),
     (-0.0415326490473, 0.0355650880841, 5.49988146604),
     (-0.0351733937172, 0.0419241880602, 5.4998796572),
     (-0.0288141374753, 0.048283287641, 5.49987788071),
     (-0.0224548802433, 0.0546423868264, 5.49987613653),
     (-0.016095621943, 0.0610014856167, 5.49987442474),
     (-0.00973636249578, 0.0673605840115, 5.49987274526),
     (-0.00337710182334, 0.073719682011, 5.49987109808),
     (0.00298216015237, 0.0800787796153, 5.49986948329),
     (0.00934142350997, 0.0864378768242, 5.49986790081),
     (0.0157006883278, 0.0927969736376, 5.49986635064),
     (0.0220599546839, 0.099156070056, 5.49986483285),
     (0.028419222657, 0.105515166079, 5.49986334738),
     (0.0347784923251, 0.111874261706, 5.49986189425),
     (0.0411377637667, 0.118233356939, 5.49986047346),
     (0.0474970370602, 0.124592451776, 5.49985908498),
     (0.0538563122837, 0.130951546217, 5.49985772886),
     (0.0602155895158, 0.137310640264, 5.49985640507),
     (0.0665748688346, 0.143669733915, 5.49985511364),
     (0.0729341503186, 0.15002882717, 5.49985385451),
     (0.0792934340462, 0.156387920031, 5.49985262772),
     (0.0856527200955, 0.162747012496, 5.49985143329),
     (0.0920120085449, 0.169106104565, 5.4998502712),
     (0.0983712994729, 0.17546519624, 5.49984914141),
     (0.104730592958, 0.181824287519, 5.49984804397),
     (0.111089889078, 0.188183378402, 5.49984697888),
     (0.117449187911, 0.194542468891, 5.49984594609),
     (0.123808489537, 0.200901558984, 5.49984494565),
     (0.130167794032, 0.207260648681, 5.49984397756),
     (0.136527101476, 0.213619737984, 5.49984304181),
     (0.142886411947, 0.219978826891, 5.49984213841),
     (0.149245725523, 0.226337915402, 5.49984126731),
     (0.155605042283, 0.232697003519, 5.49984042855),
     (0.161964362304, 0.23905609124, 5.49983962215),
     (0.168323685666, 0.245415178565, 5.49983884804),
     (0.174683012446, 0.251774265496, 5.49983810629),
     (0.181042342723, 0.25813335203, 5.49983739688),
     (0.187401676576, 0.26449243817, 5.49983671981),
     (0.193761014082, 0.270851523914, 5.49983607505),
     (0.200120355319, 0.277210609263, 5.49983546267),
     (0.206479700367, 0.283569694217, 5.4998348826),
     (0.212839049304, 0.289928778775, 5.49983433483),
     (0.219198402208, 0.296287862938, 5.49983381945),
     (0.225557759156, 0.302646946706, 5.49983333637),
     (0.231917120229, 0.309006030078, 5.49983288564),
     (0.238276485503, 0.315365113055, 5.49983246725),
     (0.244635855058, 0.321724195636, 5.49983208117),
     (0.250995228971, 0.328083277822, 5.49983172747),
     (0.257354607321, 0.334442359613, 5.49983140607),
     (0.263713990186, 0.340801441008, 5.49983111699),
     (0.270073377645, 0.347160522009, 5.49983086028),
     (0.276432769776, 0.353519602613, 5.49983063588),
     (0.282792166658, 0.359878682823, 5.49983044382),
     (0.289151568368, 0.366237762637, 5.49983028411),
     (0.295510974985, 0.372596842055, 5.49983015671),
     (0.301870386587, 0.378955921079, 5.49983006168),
     (0.308229803253, 0.385314999707, 5.49982999897),
     (0.314589225061, 0.391674077939, 5.49982996855),
     (0.320948652089, 0.398033155776, 5.49982997052)],
    [(-0.392144787734, -0.326052471795, 6.00003928092),
     (-0.385785455365, -0.319693346991, 6.0000351441),
     (-0.379426126488, -0.313334222633, 6.00003104422),
     (-0.373066801025, -0.306975098722, 6.00002698128),
     (-0.366707478897, -0.300615975257, 6.00002295532),
     (-0.360348160026, -0.294256852237, 6.0000189663),
     (-0.353988844335, -0.287897729664, 6.00001501426),
     (-0.347629531743, -0.281538607538, 6.00001109916),
     (-0.341270222174, -0.275179485857, 6.00000722104),
     (-0.334910915548, -0.268820364622, 6.00000337986),
     (-0.328551611787, -0.262461243834, 5.99999957566),
     (-0.322192310814, -0.256102123492, 5.99999580839),
     (-0.315833012549, -0.249743003595, 5.9999920781),
     (-0.309473716915, -0.243383884145, 5.99998838475),
     (-0.303114423833, -0.237024765142, 5.99998472834),
     (-0.296755133224, -0.230665646584, 5.99998110895),
     (-0.290395845011, -0.224306528472, 5.99997752645),
     (-0.284036559114, -0.217947410807, 5.99997398097),
     (-0.277677275457, -0.211588293588, 5.99997047238),
     (-0.271317993959, -0.205229176815, 5.99996700081),
     (-0.264958714544, -0.198870060488, 5.99996356618),
     (-0.258599437132, -0.192510944607, 5.99996016848),
     (-0.252240161646, -0.186151829172, 5.99995680776),
     (-0.245880888006, -0.179792714184, 5.99995348397),
     (-0.239521616135, -0.173433599642, 5.9999501972),
     (-0.233162345954, -0.167074485546, 5.99994694732),
     (-0.226803077386, -0.160715371896, 5.99994373442),
     (-0.22044381035, -0.154356258692, 5.99994055849),
     (-0.214084544771, -0.147997145934, 5.99993741954),
     (-0.207725280568, -0.141638033623, 5.99993431752),
     (-0.201366017663, -0.135278921757, 5.99993125243),
     (-0.195006755979, -0.128919810338, 5.99992822431),
     (-0.188647495437, -0.122560699365, 5.99992523317),
     (-0.182288235958, -0.116201588838, 5.99992227901),
     (-0.175928977465, -0.109842478758, 5.99991936177),
     (-0.169569719878, -0.103483369123, 5.99991648146),
     (-0.16321046312, -0.0971242599348, 5.99991363817),
     (-0.156851207112, -0.0907651511928, 5.99991083177),
     (-0.150491951777, -0.0844060428967, 5.99990806238),
     (-0.144132697034, -0.0780469350469, 5.99990532993),
     (-0.137773442807, -0.0716878276433, 5.99990263444),
     (-0.131414189017, -0.0653287206859, 5.99989997589),
     (-0.125054935585, -0.0589696141747, 5.9998973543),
     (-0.118695682434, -0.0526105081095, 5.99989476969),
     (-0.112336429484, -0.0462514024907, 5.99989222201),
     (-0.105977176658, -0.0398922973179, 5.99988971129),
     (-0.0996179238777, -0.0335331925913, 5.99988723755),
     (-0.0932586710636, -0.027174088311, 5.99988480074),
     (-0.0868994181382, -0.0208149844768, 5.9998824009),
     (-0.080540165023, -0.0144558810888, 5.99988003803),
     (-0.0741809116396, -0.00809677814703, 5.99987771208),
     (-0.0678216579097, -0.0017376756514, 5.99987542311),
     (-0.0614624037551, 0.0046214263981, 5.99987317111),
     (-0.0551031490972, 0.0109805280013, 5.99987095603),
     (-0.0487438938581, 0.0173396291585, 5.99986877797),
     (-0.0423846379588, 0.0236987298693, 5.99986663678),
     (-0.0360253813216, 0.0300578301341, 5.99986453262),
     (-0.0296661238678, 0.0364169299525, 5.99986246537),
     (-0.0233068655193, 0.0427760293249, 5.9998604351),
     (-0.0169476061974, 0.0491351282509, 5.99985844175),
     (-0.0105883458243, 0.0554942267309, 5.99985648542),
     (-0.00422908432123, 0.0618533247647, 5.99985456601),
     (0.00213017839013, 0.0682124223521, 5.99985268352),
     (0.00848944238777, 0.0745715194935, 5.99985083805),
     (0.0148487077504, 0.0809306161886, 5.9998490295),
     (0.0212079745563, 0.0872897124374, 5.99984725787),
     (0.0275672428835, 0.0936488082403, 5.99984552326),
     (0.0339265128106, 0.100007903597, 5.99984382557),
     (0.0402857844159, 0.106366998507, 5.99984216485),
     (0.0466450577777, 0.112726092971, 5.9998405411),
     (0.0530043329744, 0.119085186989, 5.99983895427),
     (0.0593636100843, 0.125444280561, 5.99983740441),
     (0.0657228891856, 0.131803373686, 5.99983589151),
     (0.0720821703568, 0.138162466366, 5.99983441558),
     (0.0784414536763, 0.144521558599, 5.99983297658),
     (0.0848007392223, 0.150880650386, 5.99983157454),
     (0.091160027073, 0.157239741726, 5.99983020947),
     (0.097519317307, 0.163598832621, 5.99982888137),
     (0.103878610003, 0.169957923069, 5.99982759018),
     (0.110237905238, 0.176317013071, 5.99982633597),
     (0.116597203092, 0.182676102627, 5.99982511872),
     (0.122956503642, 0.189035191737, 5.99982393839),
     (0.129315806967, 0.1953942804, 5.99982279503),
     (0.135675113145, 0.201753368617, 5.99982168864),
     (0.142034422255, 0.208112456388, 5.99982061921),
     (0.148393734375, 0.214471543713, 5.99981958675),
     (0.154753049583, 0.220830630592, 5.99981859121),
     (0.161112367958, 0.227189717024, 5.99981763263),
     (0.167471689577, 0.23354880301, 5.99981671102),
     (0.17383101452, 0.23990788855, 5.99981582634),
     (0.180190342864, 0.246266973643, 5.99981497861),
     (0.186549674688, 0.252626058291, 5.99981416786),
     (0.192909010071, 0.258985142492, 5.99981339407),
     (0.19926834909, 0.265344226247, 5.9998126572),
     (0.205627691824, 0.271703309556, 5.99981195734),
     (0.211987038351, 0.278062392418, 5.9998112944),
     (0.21834638875, 0.284421474835, 5.99981066838),
     (0.224705743099, 0.290780556805, 5.99981007937),
     (0.231065101476, 0.297139638328, 5.99980952728),
     (0.23742446396, 0.303498719406, 5.99980901216),
     (0.243783830629, 0.309857800037, 5.999808534),
     (0.250143201561, 0.316216880222, 5.99980809276),
     (0.256502576834, 0.322575959962, 5.99980768854),
     (0.262861956528, 0.328935039254, 5.99980732123),
     (0.26922134072, 0.3352941181, 5.99980699084),
     (0.275580729489, 0.341653196501, 5.99980669746),
     (0.281940122913, 0.348012274455, 5.99980644101),
     (0.28829952107, 0.354371351962, 5.99980622151),
     (0.294658924038, 0.360730429024, 5.99980603899),
     (0.301018331897, 0.367089505639, 5.99980589338),
     (0.307377744724, 0.373448581808, 5.99980578478),
     (0.313737162598, 0.379807657531, 5.9998057131),
     (0.320096585597, 0.386166732807, 5.99980567835),
     (0.3264560138, 0.392525807638, 5.9998056806)],
    [(-0.38663766297, -0.33155980209, 6.50004419103),
     (-0.380278327587, -0.325200674595, 6.50003953711),
     (-0.373918995712, -0.318841547597, 6.50003492475),
     (-0.367559667267, -0.312482421096, 6.50003035394),
     (-0.361200342176, -0.306123295092, 6.50002582473),
     (-0.354841020358, -0.299764169585, 6.50002133709),
     (-0.348481701736, -0.293405044575, 6.50001689104),
     (-0.342122386231, -0.287045920062, 6.50001248655),
     (-0.335763073765, -0.280686796046, 6.50000812367),
     (-0.32940376426, -0.274327672527, 6.50000380234),
     (-0.323044457638, -0.267968549505, 6.49999952261),
     (-0.316685153819, -0.26160942698, 6.49999528444),
     (-0.310325852726, -0.255250304952, 6.49999108787),
     (-0.30396655428, -0.248891183422, 6.49998693285),
     (-0.297607258404, -0.242532062388, 6.49998281938),
     (-0.291247965018, -0.236172941851, 6.49997874757),
     (-0.284888674044, -0.229813821811, 6.49997471725),
     (-0.278529385404, -0.223454702268, 6.49997072859),
     (-0.27217009902, -0.217095583223, 6.49996678143),
     (-0.265810814813, -0.210736464674, 6.49996287592),
     (-0.259451532705, -0.204377346622, 6.49995901196),
     (-0.253092252617, -0.198018229067, 6.49995518954),
     (-0.246732974472, -0.19165911201, 6.49995140873),
     (-0.240373698191, -0.185299995449, 6.49994766947),
     (-0.234014423695, -0.178940879385, 6.49994397186),
     (-0.227655150907, -0.172581763819, 6.49994031574),
     (-0.221295879747, -0.16622264875, 6.49993670122),
     (-0.214936610138, -0.159863534177, 6.4999331283),
     (-0.208577342002, -0.153504420101, 6.49992959698),
     (-0.202218075259, -0.147145306523, 6.49992610721),
     (-0.195858809832, -0.140786193442, 6.49992265898),
     (-0.189499545641, -0.134427080857, 6.49991925235),
     (-0.18314028261, -0.12806796877, 6.49991588732),
     (-0.17678102066, -0.12170885718, 6.49991256388),
     (-0.170421759711, -0.115349746087, 6.49990928199),
     (-0.164062499687, -0.108990635491, 6.49990604164),
     (-0.157703240508, -0.102631525391, 6.49990284295),
     (-0.151343982096, -0.0962724157894, 6.49989968574),
     (-0.144984724373, -0.0899133066843, 6.49989657018),
     (-0.13862546726, -0.0835541980764, 6.49989349617),
     (-0.13226621068, -0.0771950899654, 6.49989046375),
     (-0.125906954553, -0.0708359823516, 6.49988747287),
     (-0.119547698802, -0.0644768752348, 6.49988452359),
     (-0.113188443348, -0.058117768615, 6.4998816159),
     (-0.106829188113, -0.0517586624924, 6.49987874976),
     (-0.100469933019, -0.0453995568667, 6.49987592521),
     (-0.0941106779866, -0.0390404517381, 6.49987314225),
     (-0.087751422938, -0.0326813471066, 6.49987040083),
     (-0.081392167795, -0.0263222429722, 6.49986770101),
     (-0.0750329124792, -0.0199631393347, 6.49986504278),
     (-0.0686736569121, -0.0136040361944, 6.49986242609),
     (-0.0623144010155, -0.00724493355112, 6.499859851),
     (-0.0559551447111, -0.000885831404846, 6.49985731749),
     (-0.0495958879205, 0.00547327024424, 6.49985482553),
     (-0.0432366305655, 0.0118323713965, 6.49985237521),
     (-0.0368773725674, 0.0181914720514, 6.49984996638),
     (-0.0305181138483, 0.0245505722094, 6.49984759919),
     (-0.0241588543295, 0.0309096718703, 6.49984527354),
     (-0.017799593933, 0.0372687710342, 6.49984298949),
     (-0.0114403325801, 0.0436278697008, 6.49984074697),
     (-0.0050810701929, 0.0499869678706, 6.49983854609),
     (0.00127819330729, 0.0563460655432, 6.49983638676),
     (0.00763745799882, 0.0627051627186, 6.49983426896),
     (0.0139967239596, 0.0690642593972, 6.4998321928),
     (0.0203559912685, 0.0754233555785, 6.49983015819),
     (0.0267152600037, 0.0817824512627, 6.49982816511),
     (0.0330745302432, 0.08814154645, 6.49982621367),
     (0.0394338020657, 0.0945006411401, 6.49982430377),
     (0.0457930755494, 0.100859735333, 6.49982243546),
     (0.0521523507726, 0.107218829029, 6.49982060874),
     (0.0585116278139, 0.113577922228, 6.49981882355),
     (0.0648709067513, 0.11993701493, 6.49981707996),
     (0.0712301876632, 0.126296107135, 6.49981537795),
     (0.077589470628, 0.132655198842, 6.49981371753),
     (0.0839487557241, 0.139014290053, 6.49981209865),
     (0.0903080430298, 0.145373380766, 6.49981052136),
     (0.0966673326233, 0.151732470983, 6.49980898565),
     (0.103026624583, 0.158091560702, 6.49980749154),
     (0.109385918987, 0.164450649924, 6.49980603896),
     (0.115745215915, 0.170809738649, 6.49980462797),
     (0.122104515443, 0.177168826877, 6.49980325856),
     (0.128463817652, 0.183527914608, 6.49980193069),
     (0.134823122618, 0.189887001842, 6.49980064441),
     (0.14118243042, 0.196246088578, 6.49979939972),
     (0.147541741137, 0.202605174818, 6.49979819661),
     (0.153901054847, 0.208964260561, 6.49979703509),
     (0.160260371628, 0.215323345806, 6.49979591511),
     (0.166619691559, 0.221682430554, 6.49979483671),
     (0.172979014717, 0.228041514806, 6.4997937999),
     (0.179338341182, 0.23440059856, 6.49979280463),
     (0.185697671032, 0.240759681817, 6.49979185094),
     (0.192057004345, 0.247118764577, 6.49979093884),
     (0.198416341199, 0.253477846839, 6.49979006833),
     (0.204775681672, 0.259836928605, 6.49978923935),
     (0.211135025844, 0.266196009874, 6.499788452),
     (0.217494373791, 0.272555090645, 6.4997877062),
     (0.223853725594, 0.278914170919, 6.49978700193),
     (0.230213081329, 0.285273250697, 6.49978633929),
     (0.236572441076, 0.291632329977, 6.49978571819),
     (0.242931804913, 0.29799140876, 6.49978513868),
     (0.249291172917, 0.304350487046, 6.49978460075),
     (0.255650545168, 0.310709564834, 6.49978410436),
     (0.262009921743, 0.317068642126, 6.4997836496),
     (0.268369302722, 0.323427718921, 6.49978323638),
     (0.274728688182, 0.329786795218, 6.4997828647),
     (0.281088078201, 0.336145871018, 6.49978253465),
     (0.287447472859, 0.342504946322, 6.49978224613),
     (0.293806872233, 0.348864021128, 6.4997819992),
     (0.300166276402, 0.355223095437, 6.49978179386),
     (0.306525685444, 0.361582169248, 6.49978163005),
     (0.312885099437, 0.367941242563, 6.49978150788),
     (0.31924451846, 0.374300315381, 6.49978142724),
     (0.325603942591, 0.380659387701, 6.49978138814),
     (0.331963371908, 0.387018459524, 6.49978139067)],
    [(-0.381130535119, -0.337067132361, 7.00004910115),
     (-0.374771196778, -0.330708002174, 7.00004393012),
     (-0.368411861964, -0.324348872536, 7.00003880527),
     (-0.362052530597, -0.317989743445, 7.0000337266),
     (-0.3556932026, -0.311630614902, 7.00002869415),
     (-0.349333877894, -0.305271486908, 7.00002370787),
     (-0.342974556401, -0.298912359461, 7.00001876783),
     (-0.336615238041, -0.292553232561, 7.00001387395),
     (-0.330255922738, -0.28619410621, 7.0000090263),
     (-0.323896610413, -0.279834980407, 7.00000422482),
     (-0.317537300987, -0.273475855151, 6.99999946957),
     (-0.311177994382, -0.267116730444, 6.99999476049),
     (-0.304818690519, -0.260757606284, 6.99999009763),
     (-0.298459389321, -0.254398482672, 6.99998548094),
     (-0.292100090708, -0.248039359609, 6.99998091042),
     (-0.285740794604, -0.241680237092, 6.99997638619),
     (-0.279381500928, -0.235321115124, 6.99997190806),
     (-0.273022209604, -0.228961993704, 6.99996747621),
     (-0.266662920552, -0.222602872832, 6.99996309047),
     (-0.260303633694, -0.216243752507, 6.99995875102),
     (-0.253944348952, -0.209884632731, 6.99995445773),
     (-0.247585066248, -0.203525513502, 6.9999502106),
     (-0.241225785503, -0.197166394822, 6.9999460097),
     (-0.234866506639, -0.190807276689, 6.99994185496),
     (-0.228507229577, -0.184448159104, 6.99993774651),
     (-0.22214795424, -0.178089042067, 6.99993368415),
     (-0.215788680548, -0.171729925578, 6.99992966802),
     (-0.209429408424, -0.165370809637, 6.99992569811),
     (-0.203070137789, -0.159011694243, 6.99992177442),
     (-0.196710868565, -0.152652579398, 6.9999178969),
     (-0.190351600674, -0.146293465101, 6.99991406553),
     (-0.183992334037, -0.139934351351, 6.99991028039),
     (-0.177633068575, -0.13357523815, 6.99990654146),
     (-0.171273804211, -0.127216125496, 6.99990284876),
     (-0.164914540867, -0.12085701339, 6.99989920221),
     (-0.158555278462, -0.114497901833, 6.99989560183),
     (-0.152196016921, -0.108138790822, 6.99989204772),
     (-0.145836756164, -0.101779680361, 6.99988853971),
     (-0.139477496112, -0.0954205704465, 6.99988507798),
     (-0.133118236688, -0.0890614610804, 6.99988166241),
     (-0.126758977813, -0.0827023522621, 6.99987829305),
     (-0.120399719409, -0.0763432439919, 6.99987496986),
     (-0.114040461398, -0.0699841362696, 6.99987169288),
     (-0.1076812037, -0.0636250290951, 6.99986846211),
     (-0.101321946239, -0.0572659224687, 6.99986527751),
     (-0.0949626889344, -0.0509068163901, 6.99986213912),
     (-0.0886034317093, -0.0445477108594, 6.99985904694),
     (-0.082244174485, -0.0381886058768, 6.99985600093),
     (-0.0758849171831, -0.031829501442, 6.99985300112),
     (-0.0695256597254, -0.0254703975551, 6.99985004754),
     (-0.0631664020334, -0.0191112942163, 6.9998471401),
     (-0.0568071440289, -0.0127521914254, 6.99984427889),
     (-0.0504478856335, -0.00639308918235, 6.99984146388),
     (-0.0440886267688, -3.39874873727e-05, 6.99983869503),
     (-0.0377293673568, 0.00632511365994, 6.99983597246),
     (-0.0313701073185, 0.0126842142589, 6.99983329598),
     (-0.0250108465763, 0.0190433143103, 6.99983066577),
     (-0.0186515850514, 0.0254024138135, 6.99982808172),
     (-0.0122923226656, 0.0317615127689, 6.99982554388),
     (-0.00593305934038, 0.0381206111761, 6.99982305219),
     (0.000426205002109, 0.0444797090357, 6.99982060677),
     (0.00678547044066, 0.0508388063472, 6.99981820751),
     (0.0131447370536, 0.0571979031106, 6.9998158544),
     (0.0195040049189, 0.0635569993263, 6.99981354756),
     (0.0258632741152, 0.0699160949939, 6.99981128687),
     (0.032222544721, 0.0762751901134, 6.99980907234),
     (0.038581816814, 0.0826342846852, 6.99980690408),
     (0.0449410904732, 0.0889933787089, 6.99980478197),
     (0.0513003657765, 0.0953524721847, 6.99980270606),
     (0.0576596428024, 0.101711565113, 6.99980067637),
     (0.0640189216294, 0.108070657492, 6.99979869284),
     (0.0703782023356, 0.114429749324, 6.99979675551),
     (0.0767374849993, 0.120788840608, 6.99979486439),
     (0.083096769699, 0.127147931344, 6.99979301948),
     (0.089456056513, 0.133507021532, 6.99979122072),
     (0.0958153455196, 0.139866111172, 6.99978946818),
     (0.102174636797, 0.146225200264, 6.99978776184),
     (0.108533930424, 0.152584288808, 6.99978610171),
     (0.114893226478, 0.158943376804, 6.99978448773),
     (0.121252525039, 0.165302464253, 6.99978291996),
     (0.127611826184, 0.171661551153, 6.9997813984),
     (0.133971129991, 0.178020637505, 6.99977992299),
     (0.140330436539, 0.184379723309, 6.99977849379),
     (0.146689745907, 0.190738808565, 6.9997771108),
     (0.153049058172, 0.197097893274, 6.99977577401),
     (0.159408373413, 0.203456977434, 6.99977448344),
     (0.165767691709, 0.209816061046, 6.99977323901),
     (0.172127013137, 0.21617514411, 6.99977204079),
     (0.178486337776, 0.222534226627, 6.99977088878),
     (0.184845665705, 0.228893308595, 6.99976978292),
     (0.191204997001, 0.235252390015, 6.99976872327),
     (0.197564331743, 0.241611470888, 6.99976770982),
     (0.20392367001, 0.247970551212, 6.99976674258),
     (0.210283011879, 0.254329630988, 6.9997658215),
     (0.216642357429, 0.260688710217, 6.99976494667),
     (0.223001706739, 0.267047788897, 6.999764118),
     (0.229361059886, 0.27340686703, 6.99976333547),
     (0.235720416949, 0.279765944614, 6.99976259921),
     (0.242079778007, 0.286125021651, 6.9997619091),
     (0.248439143137, 0.292484098139, 6.9997612652),
     (0.254798512419, 0.298843174079, 6.9997606675),
     (0.26115788593, 0.305202249472, 6.99976011595),
     (0.267517263748, 0.311561324316, 6.99975961067),
     (0.273876645953, 0.317920398613, 6.99975915154),
     (0.280236032622, 0.324279472361, 6.99975873855),
     (0.286595423833, 0.330638545562, 6.99975837183),
     (0.292954819666, 0.336997618214, 6.99975805126),
     (0.299314220199, 0.343356690318, 6.99975777689),
     (0.305673625508, 0.349715761875, 6.99975754873),
     (0.312033035675, 0.356074832883, 6.99975736672),
     (0.318392450775, 0.362433903344, 6.99975723098),
     (0.324751870888, 0.368792973256, 6.99975714138),
     (0.331111296093, 0.37515204262, 6.99975709793),
     (0.337470726467, 0.381511111437, 6.99975710075)],
    [(-0.375623404127, -0.342574462606, 7.50005401126),
     (-0.369264062889, -0.336215329728, 7.50004832314),
     (-0.362904725195, -0.329856197449, 7.5000426858),
     (-0.356545390964, -0.323497065769, 7.50003709926),
     (-0.350186060121, -0.317137934687, 7.50003156356),
     (-0.343826732585, -0.310778804205, 7.50002607866),
     (-0.337467408279, -0.30441967432, 7.50002064461),
     (-0.331108087124, -0.298060545035, 7.50001526134),
     (-0.324748769042, -0.291701416349, 7.50000992893),
     (-0.318389453955, -0.285342288261, 7.5000046473),
     (-0.312030141784, -0.278983160772, 7.49999941653),
     (-0.305670832451, -0.272624033882, 7.49999423654),
     (-0.299311525877, -0.26626490759, 7.49998910739),
     (-0.292952221985, -0.259905781898, 7.49998402904),
     (-0.286592920696, -0.253546656804, 7.49997900147),
     (-0.280233621931, -0.247187532308, 7.4999740248),
     (-0.273874325613, -0.240828408412, 7.49996909886),
     (-0.267515031662, -0.234469285114, 7.49996422383),
     (-0.261155740001, -0.228110162416, 7.49995939952),
     (-0.254796450552, -0.221751040316, 7.49995462612),
     (-0.248437163235, -0.215391918814, 7.4999499035),
     (-0.242077877972, -0.209032797912, 7.49994523166),
     (-0.235718594686, -0.202673677608, 7.49994061067),
     (-0.229359313298, -0.196314557903, 7.49993604046),
     (-0.223000033729, -0.189955438797, 7.49993152116),
     (-0.216640755901, -0.18359632029, 7.49992705257),
     (-0.210281479737, -0.177237202381, 7.49992263483),
     (-0.203922205156, -0.170878085071, 7.49991826793),
     (-0.197562932082, -0.16451896836, 7.49991395187),
     (-0.191203660436, -0.158159852248, 7.49990968659),
     (-0.184844390139, -0.151800736734, 7.49990547209),
     (-0.178485121113, -0.14544162182, 7.49990130843),
     (-0.17212585328, -0.139082507504, 7.49989719561),
     (-0.165766586562, -0.132723393787, 7.49989313363),
     (-0.15940732088, -0.126364280668, 7.49988912243),
     (-0.153048056155, -0.120005168149, 7.49988516201),
     (-0.14668879231, -0.113646056228, 7.49988125249),
     (-0.140329529266, -0.107286944906, 7.49987739368),
     (-0.133970266945, -0.100927834183, 7.49987358578),
     (-0.127611005268, -0.0945687240589, 7.49986982865),
     (-0.121251744158, -0.0882096145333, 7.49986612236),
     (-0.114892483535, -0.0818505056067, 7.49986246684),
     (-0.108533223321, -0.0754913972789, 7.49985886217),
     (-0.102173963439, -0.0691322895497, 7.49985530833),
     (-0.0958147038093, -0.0627731824195, 7.49985180526),
     (-0.0894554443541, -0.056414075888, 7.49984835303),
     (-0.0830961849951, -0.0500549699553, 7.49984495164),
     (-0.0767369256537, -0.0436958646215, 7.49984160102),
     (-0.0703776662517, -0.0373367598865, 7.49983830124),
     (-0.064018406711, -0.0309776557502, 7.49983505229),
     (-0.0576591469527, -0.0246185522128, 7.49983185411),
     (-0.051299886899, -0.0182594492743, 7.49982870678),
     (-0.0449406264714, -0.0119003469344, 7.49982561027),
     (-0.0385813655914, -0.00554124519354, 7.49982256454),
     (-0.0322221041811, 0.000817855948806, 7.4998195697),
     (-0.0258628421615, 0.00717695649194, 7.49981662558),
     (-0.0195035794548, 0.0135360564366, 7.49981373235),
     (-0.0131443159824, 0.0198951557822, 7.49981088989),
     (-0.00678505166615, 0.0262542545291, 7.49980809826),
     (-0.000425786427431, 0.0326133526769, 7.49980535741),
     (0.00593347981161, 0.0389724502263, 7.49980266745),
     (0.0122927471298, 0.0453315471767, 7.49980002826),
     (0.0186520156054, 0.051690643528, 7.49979743984),
     (0.0250112853163, 0.0580497392809, 7.49979490232),
     (0.0313705563414, 0.0644088344347, 7.49979241556),
     (0.037729828759, 0.0707679289895, 7.49978997958),
     (0.0440891026468, 0.0771270229458, 7.49978759448),
     (0.0504483780838, 0.0834861163031, 7.49978526016),
     (0.0568076551481, 0.0898452090616, 7.49978297667),
     (0.0631669339179, 0.0962043012213, 7.49978074401),
     (0.0695262144719, 0.102563392782, 7.49977856212),
     (0.0758854968881, 0.108922483744, 7.49977643106),
     (0.0822447812449, 0.115281574107, 7.49977435083),
     (0.0886040676207, 0.121640663872, 7.49977232143),
     (0.0949633560939, 0.127999753037, 7.4997703428),
     (0.101322646743, 0.134358841603, 7.49976841499),
     (0.107681939645, 0.140717929571, 7.49976653802),
     (0.11404123488, 0.14707701694, 7.49976471188),
     (0.120400532526, 0.15343610371, 7.4997629365),
     (0.126759832661, 0.159795189881, 7.49976121196),
     (0.133119135363, 0.166154275454, 7.49975953824),
     (0.139478440711, 0.172513360427, 7.49975791529),
     (0.145837748783, 0.178872444802, 7.49975634317),
     (0.152197059657, 0.185231528577, 7.49975482188),
     (0.158556373412, 0.191590611754, 7.49975335141),
     (0.164915690126, 0.197949694333, 7.49975193178),
     (0.171275009877, 0.204308776312, 7.49975056291),
     (0.177634332744, 0.210667857692, 7.49974924487),
     (0.183993658805, 0.217026938473, 7.49974797766),
     (0.190352988138, 0.223386018656, 7.49974676121),
     (0.196712320822, 0.22974509824, 7.49974559559),
     (0.203071656935, 0.236104177224, 7.4997444808),
     (0.209430996555, 0.24246325561, 7.49974341684),
     (0.215790339762, 0.248822333397, 7.49974240364),
     (0.222149686632, 0.255181410586, 7.49974144134),
     (0.228509037244, 0.261540487175, 7.4997405298),
     (0.234868391678, 0.267899563165, 7.49973966902),
     (0.24122775001, 0.274258638557, 7.49973885913),
     (0.24758711232, 0.28061771335, 7.49973810001),
     (0.253946478685, 0.286976787544, 7.49973739172),
     (0.260305849185, 0.293335861139, 7.49973673425),
     (0.266665223897, 0.299694934135, 7.49973612755),
     (0.2730246029, 0.306054006532, 7.49973557174),
     (0.279383986271, 0.31241307833, 7.49973506669),
     (0.285743374091, 0.318772149529, 7.49973461241),
     (0.292102766436, 0.32513122013, 7.49973420901),
     (0.298462163385, 0.331490290132, 7.49973385638),
     (0.304821565017, 0.337849359534, 7.49973355458),
     (0.311180971409, 0.344208428338, 7.49973330361),
     (0.317540382641, 0.350567496543, 7.4997331034),
     (0.32389979879, 0.356926564149, 7.49973295408),
     (0.330259219935, 0.363285631157, 7.49973285552),
     (0.336618646154, 0.369644697565, 7.49973280773),
     (0.342978077526, 0.376003763374, 7.49973281082)],
    [(-0.370116269945, -0.348081792826, 8.00005892138),
     (-0.363756925869, -0.341722657256, 8.00005271615),
     (-0.357397585352, -0.335363522337, 8.00004656633),
     (-0.351038248317, -0.329004388067, 8.00004047192),
     (-0.344678914685, -0.322645254447, 8.00003443298),
     (-0.338319584378, -0.316286121476, 8.00002844945),
     (-0.331960257318, -0.309926989155, 8.00002252139),
     (-0.325600933427, -0.303567857484, 8.00001664874),
     (-0.319241612625, -0.297208726462, 8.00001083156),
     (-0.312882294835, -0.29084959609, 8.00000506979),
     (-0.306522979978, -0.284490466367, 7.99999936348),
     (-0.300163667976, -0.278131337294, 7.99999371259),
     (-0.29380435875, -0.271772208871, 7.99998811716),
     (-0.287445052223, -0.265413081097, 7.99998257713),
     (-0.281085748316, -0.259053953974, 7.99997709251),
     (-0.27472644695, -0.252694827499, 7.99997166342),
     (-0.268367148047, -0.246335701675, 7.99996628967),
     (-0.26200785153, -0.239976576499, 7.99996097145),
     (-0.255648557318, -0.233617451974, 7.99995570857),
     (-0.249289265335, -0.227258328098, 7.99995050122),
     (-0.242929975502, -0.220899204872, 7.99994534927),
     (-0.23657068774, -0.214540082296, 7.99994025272),
     (-0.230211401972, -0.208180960369, 7.99993521164),
     (-0.223852118118, -0.201821839092, 7.99993022596),
     (-0.217492836101, -0.195462718464, 7.99992529581),
     (-0.211133555842, -0.189103598487, 7.99992042099),
     (-0.204774277262, -0.182744479159, 7.99991560163),
     (-0.198415000284, -0.17638536048, 7.99991083774),
     (-0.19205572483, -0.170026242451, 7.99990612931),
     (-0.18569645082, -0.163667125072, 7.99990147628),
     (-0.179337178176, -0.157308008343, 7.99989687864),
     (-0.172977906821, -0.150948892263, 7.99989233647),
     (-0.166618636675, -0.144589776833, 7.99988784976),
     (-0.160259367661, -0.138230662052, 7.99988341851),
     (-0.1539000997, -0.131871547921, 7.99987904265),
     (-0.147540832714, -0.12551243444, 7.99987472219),
     (-0.141181566624, -0.119153321608, 7.99987045726),
     (-0.134822301352, -0.112794209427, 7.99986624765),
     (-0.12846303682, -0.106435097894, 7.99986209358),
     (-0.122103772949, -0.100075987012, 7.99985799489),
     (-0.115744509661, -0.0937168767792, 7.99985395166),
     (-0.109385246878, -0.0873577671961, 7.99984996383),
     (-0.103025984522, -0.0809986582627, 7.99984603145),
     (-0.0966667225135, -0.0746395499789, 7.99984215454),
     (-0.0903074607746, -0.0682804423449, 7.99983833301),
     (-0.0839481992272, -0.0619213353605, 7.99983456694),
     (-0.077588937793, -0.0555622290257, 7.99983085633),
     (-0.0712296763932, -0.0492031233408, 7.99982720111),
     (-0.06487041495, -0.0428440183055, 7.99982360135),
     (-0.0585111533848, -0.0364849139197, 7.99982005704),
     (-0.0521518916192, -0.0301258101839, 7.99981656812),
     (-0.045792629575, -0.0237667070977, 7.99981313466),
     (-0.0394333671739, -0.017407604661, 7.99980975666),
     (-0.0330741043374, -0.0110485028743, 7.99980643404),
     (-0.0267148409875, -0.00468940173688, 7.99980316695),
     (-0.0203555770452, 0.00166969875038, 7.99979995517),
     (-0.013996312433, 0.00802879858827, 7.99979679892),
     (-0.00763704707188, 0.0143878977763, 7.99979369806),
     (-0.00127778088387, 0.0207469963147, 7.99979065265),
     (0.00508148620964, 0.0271060942032, 7.99978766263),
     (0.0114407542865, 0.0334651914423, 7.99978472813),
     (0.0178000234255, 0.0398242880315, 7.99978184901),
     (0.024159293705, 0.0461833839709, 7.99977902528),
     (0.0305185652029, 0.0525424792608, 7.99977625707),
     (0.036877837998, 0.0589015739009, 7.99977354425),
     (0.0432371121686, 0.0652606678911, 7.99977088681),
     (0.0495963877925, 0.0716197612319, 7.99976828489),
     (0.0559556649486, 0.0779788539228, 7.99976573836),
     (0.062314943715, 0.084337945964, 7.99976324728),
     (0.06867422417, 0.0906970373556, 7.99976081165),
     (0.0750335063923, 0.0970561280973, 7.9997584314),
     (0.0813927904598, 0.103415218189, 7.99975610661),
     (0.0877520764509, 0.109774307632, 7.99975383727),
     (0.094111364444, 0.116133396424, 7.99975162338),
     (0.100470654518, 0.122492484567, 7.99974946487),
     (0.10682994675, 0.12885157206, 7.99974736181),
     (0.113189241219, 0.135210658904, 7.99974531421),
     (0.119548538004, 0.141569745098, 7.99974332205),
     (0.125907837182, 0.147928830641, 7.99974138528),
     (0.132267138832, 0.154287915536, 7.99973950395),
     (0.138626443033, 0.16064699978, 7.99973767808),
     (0.144985749863, 0.167006083375, 7.99973590759),
     (0.151345059399, 0.17336516632, 7.99973419255),
     (0.157704371721, 0.179724248615, 7.99973253296),
     (0.164063686907, 0.186083330261, 7.99973092882),
     (0.170423005034, 0.192442411257, 7.99972938012),
     (0.176782326182, 0.198801491603, 7.99972788681),
     (0.183141650429, 0.205160571299, 7.99972644895),
     (0.189500977853, 0.211519650346, 7.99972506654),
     (0.195860308533, 0.217878728742, 7.9997237395),
     (0.202219642546, 0.224237806489, 7.99972246792),
     (0.208578979971, 0.230596883587, 7.99972125179),
     (0.214938320886, 0.236955960034, 7.9997200911),
     (0.221297665371, 0.243315035832, 7.99971898579),
     (0.227657013502, 0.24967411098, 7.99971793601),
     (0.234016365359, 0.256033185478, 7.9997169416),
     (0.240375721019, 0.262392259327, 7.99971600257),
     (0.246735080562, 0.268751332526, 7.99971511905),
     (0.253094444065, 0.275110405074, 7.99971429092),
     (0.259453811607, 0.281469476974, 7.99971351824),
     (0.265813183266, 0.287828548223, 7.999712801),
     (0.272172559121, 0.294187618823, 7.99971213914),
     (0.278531939249, 0.300546688773, 7.9997115328),
     (0.284891323729, 0.306905758073, 7.99971098184),
     (0.29125071264, 0.313264826723, 7.99971048626),
     (0.29761010606, 0.319623894724, 7.9997100462),
     (0.303969504067, 0.325982962075, 7.99970966151),
     (0.310328906739, 0.332342028776, 7.99970933227),
     (0.316688314156, 0.338701094827, 7.99970905848),
     (0.323047726394, 0.345060160229, 7.99970884007),
     (0.329407143533, 0.351419224981, 7.99970867717),
     (0.335766565651, 0.357778289083, 7.99970856966),
     (0.342125992826, 0.364137352535, 7.99970851752),
     (0.348485425136, 0.370496415337, 7.9997085209)],
    [(-0.364609132522, -0.35358912302, 8.50006383149),
     (-0.358249785665, -0.347229984759, 8.50005710916),
     (-0.351890442385, -0.340870847199, 8.50005044686),
     (-0.345531102604, -0.33451171034, 8.50004384458),
     (-0.339171766244, -0.328152574181, 8.50003730239),
     (-0.332812433225, -0.321793438722, 8.50003082024),
     (-0.32645310347, -0.315434303964, 8.50002439817),
     (-0.3200937769, -0.309075169907, 8.50001803613),
     (-0.313734453437, -0.302716036549, 8.50001173419),
     (-0.307375133002, -0.296356903893, 8.50000549227),
     (-0.301015815518, -0.289997771937, 8.49999931044),
     (-0.294656500906, -0.283638640681, 8.49999318863),
     (-0.288297189087, -0.277279510126, 8.49998712692),
     (-0.281937879983, -0.270920380272, 8.49998112523),
     (-0.275578573516, -0.264561251118, 8.49997518355),
     (-0.269219269608, -0.258202122664, 8.49996930204),
     (-0.26285996818, -0.251842994912, 8.49996348047),
     (-0.256500669154, -0.245483867859, 8.49995771908),
     (-0.250141372451, -0.239124741507, 8.49995201762),
     (-0.243782077994, -0.232765615856, 8.49994637632),
     (-0.237422785703, -0.226406490905, 8.49994079505),
     (-0.231063495501, -0.220047366655, 8.49993527378),
     (-0.224704207308, -0.213688243105, 8.49992981261),
     (-0.218344921048, -0.207329120256, 8.49992441145),
     (-0.211985636641, -0.200969998107, 8.49991907046),
     (-0.205626354009, -0.194610876659, 8.4999137894),
     (-0.199267073074, -0.188251755911, 8.49990856843),
     (-0.192907793758, -0.181892635864, 8.49990340755),
     (-0.186548515981, -0.175533516517, 8.49989830675),
     (-0.180189239666, -0.169174397871, 8.49989326597),
     (-0.173829964735, -0.162815279925, 8.49988828519),
     (-0.167470691108, -0.15645616268, 8.49988336451),
     (-0.161111418709, -0.150097046136, 8.4998785039),
     (-0.154752147458, -0.143737930292, 8.49987370338),
     (-0.148392877277, -0.137378815148, 8.49986896288),
     (-0.142033608087, -0.131019700706, 8.49986428238),
     (-0.135674339811, -0.124660586963, 8.49985966203),
     (-0.12931507237, -0.118301473922, 8.49985510163),
     (-0.122955805686, -0.11194236158, 8.49985060137),
     (-0.11659653968, -0.10558324994, 8.49984616113),
     (-0.110237274274, -0.0992241389995, 8.49984178097),
     (-0.10387800939, -0.0928650287601, 8.49983746081),
     (-0.0975187449487, -0.0865059192211, 8.49983320074),
     (-0.0911594808729, -0.0801468103826, 8.49982900075),
     (-0.0848002170836, -0.0737877022448, 8.49982486076),
     (-0.0784409535028, -0.0674285948075, 8.49982078085),
     (-0.072081690052, -0.0610694880707, 8.49981676103),
     (-0.0657224266528, -0.0547103820346, 8.4998128012),
     (-0.0593631632269, -0.048351276699, 8.49980890146),
     (-0.0530038996962, -0.0419921720639, 8.4998050618),
     (-0.0466446359819, -0.0356330681295, 8.49980128214),
     (-0.040285372006, -0.0292739648956, 8.49979756255),
     (-0.0339261076902, -0.0229148623622, 8.49979390305),
     (-0.0275668429558, -0.0165557605296, 8.49979030355),
     (-0.0212075777252, -0.0101966593971, 8.4997867642),
     (-0.014848311919, -0.00383755896574, 8.49978328477),
     (-0.00848904545986, 0.00252154076543, 8.4997798655),
     (-0.00212977826882, 0.00888063979583, 8.49977650623),
     (0.00422948973217, 0.0152397381257, 8.49977320704),
     (0.0105887586217, 0.0215988357549, 8.49976996785),
     (0.0169480284776, 0.0279579326837, 8.4997667888),
     (0.0233072993787, 0.0343170289119, 8.49976366976),
     (0.0296665714034, 0.0406761244392, 8.49976061072),
     (0.0360258446295, 0.0470352192663, 8.49975761183),
     (0.0423851191358, 0.0533943133926, 8.49975467294),
     (0.0487443950007, 0.0597534068181, 8.49975179404),
     (0.0551036723019, 0.0661124995434, 8.4997489753),
     (0.0614629511184, 0.0724715915679, 8.49974621655),
     (0.0678222315282, 0.0788306828918, 8.49974351788),
     (0.0741815136096, 0.0851897735153, 8.49974087929),
     (0.0805407974413, 0.0915488634379, 8.49973830069),
     (0.0869000831014, 0.09790795266, 8.49973578216),
     (0.093259370668, 0.104267041182, 8.49973332371),
     (0.0996186602197, 0.110626129003, 8.49973092532),
     (0.105977951835, 0.116985216123, 8.49972858694),
     (0.112337245592, 0.123344302543, 8.49972630863),
     (0.118696541569, 0.129703388262, 8.49972409039),
     (0.125055839844, 0.13606247328, 8.49972193222),
     (0.131415140496, 0.142421557598, 8.49971983405),
     (0.137774443604, 0.148780641215, 8.49971779595),
     (0.144133749244, 0.155139724132, 8.49971581792),
     (0.150493057497, 0.161498806348, 8.49971389989),
     (0.156852368439, 0.167857887863, 8.49971204193),
     (0.16321168215, 0.174216968678, 8.49971024404),
     (0.169570998708, 0.180576048792, 8.49970850622),
     (0.175930318191, 0.186935128206, 8.49970682847),
     (0.182289640677, 0.193294206919, 8.49970521071),
     (0.188648966245, 0.199653284931, 8.49970365303),
     (0.195008294973, 0.206012362243, 8.49970215542),
     (0.20136762694, 0.212371438854, 8.4997007178),
     (0.207726962223, 0.218730514764, 8.49969934025),
     (0.214086300901, 0.225089589974, 8.49969802277),
     (0.220445643053, 0.231448664483, 8.49969676536),
     (0.226804988757, 0.237807738292, 8.49969556794),
     (0.233164338091, 0.2441668114, 8.49969443067),
     (0.239523691133, 0.250525883807, 8.4996933534),
     (0.245883047962, 0.256884955513, 8.49969233611),
     (0.252242408657, 0.263244026519, 8.49969137898),
     (0.258601773294, 0.269603096825, 8.49969048183),
     (0.264961141954, 0.275962166429, 8.49968964476),
     (0.271320514714, 0.282321235333, 8.49968886775),
     (0.277679891652, 0.288680303537, 8.49968815074),
     (0.284039272847, 0.295039371039, 8.49968749387),
     (0.290398658377, 0.301398437841, 8.499686897),
     (0.296758048321, 0.307757503943, 8.49968636012),
     (0.303117442756, 0.314116569344, 8.49968588338),
     (0.309476841762, 0.320475634044, 8.49968546663),
     (0.315836245417, 0.326834698043, 8.49968510996),
     (0.322195653798, 0.333193761342, 8.49968481335),
     (0.328555066984, 0.33955282394, 8.49968457674),
     (0.334914485054, 0.345911885837, 8.49968440027),
     (0.341273908086, 0.352270947034, 8.49968428379),
     (0.347633336158, 0.35863000753, 8.49968422731),
     (0.353992769349, 0.364989067326, 8.49968423097)],
    [(-0.359101991806, -0.359096453188, 9.0000687416),
     (-0.352742642228, -0.352737312236, 9.00006150217),
     (-0.346383296244, -0.346378172036, 9.00005432738),
     (-0.340023953776, -0.340019032587, 9.00004721724),
     (-0.333664614745, -0.333659893889, 9.00004017181),
     (-0.327305279072, -0.327300755943, 9.00003319102),
     (-0.320945946681, -0.320941618748, 9.00002627496),
     (-0.314586617491, -0.314582482304, 9.00001942353),
     (-0.308227291426, -0.308223346612, 9.00001263682),
     (-0.301867968406, -0.301864211671, 9.00000591475),
     (-0.295508648353, -0.295505077481, 8.9999992574),
     (-0.289149331189, -0.289145944043, 8.99999266468),
     (-0.282790016836, -0.282786811356, 8.99998613668),
     (-0.276430705215, -0.276427679421, 8.99997967332),
     (-0.270071396247, -0.270068548237, 8.99997327459),
     (-0.263712089856, -0.263709417804, 8.99996694066),
     (-0.257352785961, -0.257350288123, 8.99996067128),
     (-0.250993484485, -0.250991159193, 8.9999544667),
     (-0.244634185349, -0.244632031015, 8.99994832666),
     (-0.238274888476, -0.238272903588, 8.99994225143),
     (-0.231915593787, -0.231913776912, 8.99993624082),
     (-0.225556301203, -0.225554650988, 8.99993029485),
     (-0.219197010645, -0.219195525815, 8.99992441358),
     (-0.212837722037, -0.212836401394, 8.99991859695),
     (-0.206478435299, -0.206477277723, 8.99991284511),
     (-0.200119150353, -0.200118154805, 8.99990715782),
     (-0.193759867121, -0.193759032638, 8.99990153523),
     (-0.187400585525, -0.187399911222, 8.99989597736),
     (-0.181041305485, -0.181040790557, 8.99989048419),
     (-0.174682026924, -0.174681670644, 8.99988505566),
     (-0.168322749764, -0.168322551483, 8.99987969175),
     (-0.161963473925, -0.161963433073, 8.99987439255),
     (-0.15560419933, -0.155604315414, 8.99986915805),
     (-0.149244925901, -0.149245198506, 8.99986398826),
     (-0.142885653559, -0.14288608235, 8.9998588831),
     (-0.136526382225, -0.136526966946, 8.99985384256),
     (-0.130167111821, -0.130167852293, 8.99984886681),
     (-0.12380784227, -0.123808738391, 8.9998439556),
     (-0.117448573492, -0.117449625241, 8.99983910917),
     (-0.11108930541, -0.111090512842, 8.99983432737),
     (-0.104730037944, -0.104731401194, 8.99982961027),
     (-0.0983707710174, -0.0983722902986, 8.9998249578),
     (-0.0920115045509, -0.0920131801541, 8.99982037003),
     (-0.0856522384665, -0.0856540707609, 8.99981584696),
     (-0.0792929726855, -0.0792949621194, 8.99981138851),
     (-0.07293370713, -0.0729358542291, 8.99980699477),
     (-0.0665744417215, -0.0665767470903, 8.99980266572),
     (-0.0602151763814, -0.060217640703, 8.9997984013),
     (-0.0538559110317, -0.0538585350671, 8.99979420157),
     (-0.0474966455941, -0.0474994301826, 8.99979006655),
     (-0.0411373799899, -0.0411403260497, 8.99978599615),
     (-0.0347781141411, -0.0347812226681, 8.99978199044),
     (-0.0284188479693, -0.0284221200379, 8.99977804944),
     (-0.0220595813959, -0.0220630181594, 8.99977417305),
     (-0.0157003143432, -0.0157039170319, 8.99977036144),
     (-0.00934104673189, -0.00934481665642, 8.99976661437),
     (-0.0029817784846, -0.00298571703197, 8.99976293208),
     (0.00337749047764, 0.00337338184081, 8.9997593144),
     (0.00973676023286, 0.00973247996223, 8.99975576143),
     (0.0160960308597, 0.016091577332, 8.99975227306),
     (0.0224553024359, 0.0224506739506, 8.99974884948),
     (0.0288145750404, 0.0288097698176, 8.99974549051),
     (0.0351738487515, 0.0351688649329, 8.99974219616),
     (0.041533123647, 0.0415279592972, 8.99973896658),
     (0.0478923998057, 0.0478870529097, 8.99973580162),
     (0.0542516773061, 0.0542461457706, 8.99973270128),
     (0.0606109562259, 0.0606052378803, 8.99972966571),
     (0.066970236644, 0.0669643292384, 8.99972669475),
     (0.0733295186385, 0.0733234198451, 8.99972378849),
     (0.0796888022876, 0.0796825097004, 8.99972094692),
     (0.08604808767, 0.086041598804, 8.99971816997),
     (0.0924073748638, 0.0924006871562, 8.99971545771),
     (0.0987666639473, 0.0987597747569, 8.99971281014),
     (0.105125954999, 0.105118861606, 8.99971022727),
     (0.111485248097, 0.111477947704, 8.99970770901),
     (0.11784454332, 0.11783703305, 8.99970525545),
     (0.124203840746, 0.124196117645, 8.99970286657),
     (0.130563140453, 0.130555201489, 8.99970054239),
     (0.13692244252, 0.13691428458, 8.99969828282),
     (0.143281747026, 0.143273366921, 8.99969608795),
     (0.149641054047, 0.149632448509, 8.99969395776),
     (0.156000363664, 0.155991529347, 8.99969189219),
     (0.162359675954, 0.162350609432, 8.99968989131),
     (0.168718990995, 0.168709688767, 8.99968795512),
     (0.175078308866, 0.17506876735, 8.99968608362),
     (0.181437629645, 0.181427845181, 8.99968427681),
     (0.187796953411, 0.187786922261, 8.99968253461),
     (0.194156280241, 0.194145998589, 8.99968085711),
     (0.200515610215, 0.200505074166, 8.99967924429),
     (0.20687494341, 0.206864148991, 8.99967769609),
     (0.213234279905, 0.213223223065, 8.99967621257),
     (0.219593619778, 0.219582296387, 8.99967479375),
     (0.225952963107, 0.225941368958, 8.99967343962),
     (0.232312309972, 0.232300440777, 8.99967215009),
     (0.238671660449, 0.238659511845, 8.99967092534),
     (0.245031014618, 0.245018582161, 8.9996697652),
     (0.251390372557, 0.251377651725, 8.99966866966),
     (0.257749734344, 0.257736720539, 8.9996676389),
     (0.264109100058, 0.2640957886, 8.99966667274),
     (0.270468469776, 0.27045485591, 8.99966577128),
     (0.276827843578, 0.276813922469, 8.9996649345),
     (0.283187221541, 0.283172988276, 8.99966416233),
     (0.289546603744, 0.289532053331, 8.99966345494),
     (0.295905990265, 0.295891117635, 8.99966281215),
     (0.302265381183, 0.302250181187, 8.99966223397),
     (0.308624776576, 0.308609243988, 8.99966172056),
     (0.314984176522, 0.314968306038, 8.99966127176),
     (0.3213435811, 0.321327367335, 8.99966088765),
     (0.327702990387, 0.327686427882, 8.99966056823),
     (0.334062404463, 0.334045487676, 8.99966031341),
     (0.340421823405, 0.34040454672, 8.99966012337),
     (0.346781247292, 0.346763605011, 8.99965999793),
     (0.353140676203, 0.353122662551, 8.99965993711),
     (0.359500110214, 0.35948171934, 8.99965994105)],
    [(-0.353594847747, -0.364603783332, 9.50007365172),
     (-0.347235495507, -0.358244639688, 9.50006589519),
     (-0.340876146877, -0.351885496847, 9.50005820791),
     (-0.33451680178, -0.345526354809, 9.5000505899),
     (-0.328157460138, -0.339167213572, 9.50004304122),
     (-0.321798121871, -0.332808073138, 9.50003556181),
     (-0.315438786901, -0.326448933506, 9.50002815174),
     (-0.309079455151, -0.320089794676, 9.50002081092),
     (-0.302720126542, -0.313730656648, 9.50001353945),
     (-0.296360800996, -0.307371519423, 9.50000633723),
     (-0.290001478433, -0.301012383, 9.49999920436),
     (-0.283642158776, -0.294653247379, 9.49999214073),
     (-0.277282841947, -0.288294112561, 9.49998514645),
     (-0.270923527867, -0.281934978544, 9.49997822141),
     (-0.264564216458, -0.275575845331, 9.49997136563),
     (-0.258204907641, -0.269216712919, 9.49996457928),
     (-0.251845601338, -0.262857581309, 9.49995786209),
     (-0.245486297472, -0.256498450502, 9.49995121432),
     (-0.239126995962, -0.250139320497, 9.49994463571),
     (-0.232767696732, -0.243780191294, 9.49993812653),
     (-0.226408399702, -0.237421062894, 9.49993168659),
     (-0.220049104795, -0.231061935296, 9.49992531591),
     (-0.213689811932, -0.2247028085, 9.49991901455),
     (-0.207330521034, -0.218343682506, 9.49991278245),
     (-0.200971232025, -0.211984557315, 9.49990661976),
     (-0.194611944823, -0.205625432926, 9.49990052623),
     (-0.188252659353, -0.199266309339, 9.49989450204),
     (-0.181893375535, -0.192907186554, 9.49988854717),
     (-0.175534093291, -0.186548064572, 9.49988266164),
     (-0.169174812543, -0.180188943392, 9.49987684535),
     (-0.162815533212, -0.173829823015, 9.4998710983),
     (-0.15645625522, -0.167470703439, 9.49986542058),
     (-0.150096978489, -0.161111584666, 9.4998598122),
     (-0.14373770294, -0.154752466695, 9.49985427314),
     (-0.137378428495, -0.148393349527, 9.49984880332),
     (-0.131019155075, -0.142034233161, 9.49984340274),
     (-0.124659882604, -0.135675117596, 9.49983807158),
     (-0.118300611, -0.129316002835, 9.49983280957),
     (-0.111941340188, -0.122956888876, 9.49982761697),
     (-0.105582070088, -0.116597775719, 9.49982249361),
     (-0.0992228006216, -0.110238663364, 9.49981743958),
     (-0.0928635317108, -0.103879551812, 9.49981245479),
     (-0.0865042632775, -0.0975204410616, 9.49980753932),
     (-0.0801449952432, -0.0911613311138, 9.49980269317),
     (-0.0737857275293, -0.0848022219684, 9.49979791626),
     (-0.0674264600578, -0.0784431136253, 9.49979320868),
     (-0.0610671927503, -0.0720840060844, 9.49978857042),
     (-0.0547079255282, -0.065724899346, 9.49978400139),
     (-0.0483486583135, -0.0593657934098, 9.49977950169),
     (-0.0419893910277, -0.0530066882758, 9.4997750713),
     (-0.0356301235924, -0.0466475839444, 9.49977071016),
     (-0.0292708559293, -0.0402884804152, 9.49976641833),
     (-0.0229115879603, -0.0339293776882, 9.49976219582),
     (-0.0165523196067, -0.0275702757638, 9.49975804255),
     (-0.0101930507906, -0.0212111746413, 9.49975395869),
     (-0.00383378143299, -0.0148520743217, 9.49974994397),
     (0.00252548854369, -0.00849297480393, 9.49974599866),
     (0.00888475921837, -0.00213387608876, 9.49974212257),
     (0.0152440306691, 0.00422522182416, 9.49973831581),
     (0.0216033029744, 0.0105843189345, 9.49973457828),
     (0.0279625762122, 0.016943415243, 9.49973091016),
     (0.0343218504613, 0.0233025107488, 9.49972731126),
     (0.0406811258, 0.0296616054521, 9.4997237816),
     (0.0470404023062, 0.0360206993535, 9.49972032134),
     (0.0533996800587, 0.0423797924523, 9.49971693031),
     (0.0597589591359, 0.0487388847485, 9.49971360851),
     (0.0661182396155, 0.0550979762427, 9.49971035611),
     (0.0724775215764, 0.0614570669344, 9.49970717295),
     (0.0788368050967, 0.0678161568238, 9.4997040591),
     (0.0851960902548, 0.0741752459109, 9.49970101456),
     (0.0915553771292, 0.0805343341955, 9.49969803925),
     (0.097914665798, 0.0868934216778, 9.49969513326),
     (0.10427395634, 0.0932525083578, 9.49969229658),
     (0.110633248832, 0.0996115942355, 9.49968952922),
     (0.116992543355, 0.105970679311, 9.49968683109),
     (0.123351839985, 0.112329763583, 9.49968420226),
     (0.129711138801, 0.118688847054, 9.49968164276),
     (0.136070439881, 0.125047929722, 9.49967915256),
     (0.142429743305, 0.131407011588, 9.4996767316),
     (0.14878904915, 0.137766092651, 9.49967437994),
     (0.155148357494, 0.144125172912, 9.4996720976),
     (0.161507668416, 0.150484252371, 9.49966988449),
     (0.167866981994, 0.156843331027, 9.49966774069),
     (0.174226298307, 0.163202408881, 9.4996656662),
     (0.180585617432, 0.169561485932, 9.49966366102),
     (0.186944939449, 0.175920562181, 9.49966172515),
     (0.193304264435, 0.182279637628, 9.49965985852),
     (0.199663592469, 0.188638712272, 9.49965806119),
     (0.206022923629, 0.194997786114, 9.49965633317),
     (0.212382257994, 0.201356859154, 9.49965467438),
     (0.218741595642, 0.207715931391, 9.4996530849),
     (0.225100936651, 0.214075002825, 9.49965156473),
     (0.231460281099, 0.220434073458, 9.49965011388),
     (0.237819629066, 0.226793143288, 9.49964873224),
     (0.244178980628, 0.233152212315, 9.49964742001),
     (0.250538335865, 0.23951128054, 9.499646177),
     (0.256897694855, 0.245870347963, 9.49964500321),
     (0.263257057676, 0.252229414583, 9.49964389882),
     (0.269616424407, 0.258588480401, 9.49964286365),
     (0.275975795125, 0.264947545417, 9.4996418978),
     (0.28233516991, 0.27130660963, 9.49964100125),
     (0.28869454884, 0.27766567304, 9.49964017393),
     (0.295053931992, 0.284024735649, 9.499639416),
     (0.301413319445, 0.290383797454, 9.4996387273),
     (0.307772711279, 0.296742858458, 9.49963810783),
     (0.31413210757, 0.303101918659, 9.49963755774),
     (0.320491508397, 0.309460978057, 9.49963707689),
     (0.326850913839, 0.315820036653, 9.49963666534),
     (0.333210323974, 0.322179094447, 9.4996363231),
     (0.33956973888, 0.328538151438, 9.49963605008),
     (0.345929158636, 0.334897207627, 9.49963584647),
     (0.352288583319, 0.341256263014, 9.49963571207),
     (0.35864801301, 0.347615317597, 9.4996356469),
     (0.365007447784, 0.353974371379, 9.49963565112)],
    [(-0.348087700294, -0.370111113449, 10.0000785618),
     (-0.34172834545, -0.363751967115, 10.0000702882),
     (-0.335368994234, -0.357392821633, 10.0000620884),
     (-0.329009646567, -0.351033677005, 10.0000539626),
     (-0.322650302371, -0.34467453323, 10.0000459106),
     (-0.316290961569, -0.338315390308, 10.0000379326),
     (-0.309931624081, -0.331956248238, 10.0000300285),
     (-0.303572289829, -0.325597107023, 10.0000221983),
     (-0.297212958735, -0.31923796666, 10.0000144421),
     (-0.29085363072, -0.31287882715, 10.0000067597),
     (-0.284494305706, -0.306519688493, 9.99999915131),
     (-0.278134983616, -0.30016055069, 9.99999161678),
     (-0.27177566437, -0.29380141374, 9.99998415621),
     (-0.265416347889, -0.287442277642, 9.99997676951),
     (-0.259057034097, -0.281083142399, 9.99996945668),
     (-0.252697722914, -0.274724008007, 9.9999622179),
     (-0.246338414262, -0.26836487447, 9.99995505289),
     (-0.239979108063, -0.262005741785, 9.99994796194),
     (-0.233619804238, -0.255646609954, 9.99994094476),
     (-0.22726050271, -0.249287478975, 9.99993400163),
     (-0.220901203399, -0.24292834885, 9.99992713237),
     (-0.214541906227, -0.236569219578, 9.99992033697),
     (-0.208182611117, -0.230210091159, 9.99991361552),
     (-0.201823317989, -0.223850963593, 9.99990696794),
     (-0.195464026766, -0.21749183688, 9.99990039441),
     (-0.189104737368, -0.211132711021, 9.99989389465),
     (-0.182745449718, -0.204773586015, 9.99988746884),
     (-0.176386163738, -0.198414461862, 9.99988111698),
     (-0.170026879348, -0.192055338561, 9.99987483908),
     (-0.163667596471, -0.185696216114, 9.99986863504),
     (-0.157308315029, -0.179337094521, 9.99986250485),
     (-0.150949034942, -0.17297797378, 9.99985644862),
     (-0.144589756133, -0.166618853893, 9.99985046634),
     (-0.138230478523, -0.160259734859, 9.99984455801),
     (-0.131871202035, -0.153900616678, 9.99983872354),
     (-0.125511926588, -0.14754149935, 9.99983296292),
     (-0.119152652107, -0.141182382875, 9.99982727635),
     (-0.11279337851, -0.134823267254, 9.99982166354),
     (-0.106434105722, -0.128464152485, 9.99981612477),
     (-0.100074833663, -0.12210503857, 9.99981065985),
     (-0.0937155622549, -0.115745925508, 9.99980526889),
     (-0.0873562914191, -0.109386813299, 9.99979995177),
     (-0.0809970210777, -0.103027701944, 9.9997947086),
     (-0.0746377511523, -0.0966685914412, 9.99978953938),
     (-0.0682784815642, -0.0903094817921, 9.99978444401),
     (-0.0619192122355, -0.083950372996, 9.99977942259),
     (-0.0555599430878, -0.077591265053, 9.99977447511),
     (-0.0492006740424, -0.0712321579635, 9.99976960148),
     (-0.0428414050213, -0.064873051727, 9.9997648018),
     (-0.0364821359462, -0.0585139463437, 9.99976007606),
     (-0.0301228667384, -0.0521548418137, 9.99975542417),
     (-0.02376359732, -0.0457957381369, 9.99975084622),
     (-0.0174043276125, -0.0394366353131, 9.99974634221),
     (-0.0110450575373, -0.0330775333428, 9.99974191206),
     (-0.00468578701671, -0.0267184322252, 9.99973755593),
     (0.00167348402857, -0.0203593319615, 9.99973327357),
     (0.00803275567588, -0.0140002325505, 9.99972906523),
     (0.0143920280043, -0.0076411339929, 9.99972493075),
     (0.0207513010917, -0.00128203628846, 9.9997208702),
     (0.0271105750168, 0.00507706056253, 9.9997168835),
     (0.0334698498574, 0.0114361565607, 9.99971297083),
     (0.0398291256923, 0.0177952517055, 9.99970913201),
     (0.0461884026, 0.0241543459967, 9.99970536704),
     (0.052547680658, 0.0305134394352, 9.9997016761),
     (0.0589069599455, 0.0368725320203, 9.999698059),
     (0.0652662405407, 0.0432316237518, 9.99969451575),
     (0.0716255225214, 0.0495907146306, 9.99969104652),
     (0.0779848059664, 0.0559498046558, 9.99968765114),
     (0.0843440909539, 0.062308893828, 9.9996843297),
     (0.0907033775621, 0.0686679821469, 9.9996810822),
     (0.0970626658698, 0.0750270696124, 9.99967790854),
     (0.103421955955, 0.0813861562248, 9.99967480881),
     (0.109781247896, 0.087745241984, 9.99967178302),
     (0.116140541771, 0.09410432689, 9.99966883117),
     (0.122499837658, 0.100463410943, 9.99966595316),
     (0.128859135637, 0.106822494142, 9.99966314908),
     (0.135218435784, 0.113181576488, 9.99966041894),
     (0.14157773818, 0.119540657981, 9.99965776273),
     (0.147937042901, 0.125899738621, 9.99965518037),
     (0.154296350026, 0.132258818407, 9.99965267194),
     (0.160655659634, 0.13861789734, 9.99965023744),
     (0.167014971803, 0.14497697542, 9.99964787679),
     (0.173374286611, 0.151336052647, 9.99964559007),
     (0.179733604136, 0.15769512902, 9.99964337728),
     (0.186092924457, 0.16405420454, 9.99964123842),
     (0.192452247653, 0.170413279207, 9.9996391735),
     (0.198811573801, 0.176772353021, 9.99963718242),
     (0.20517090298, 0.183131425981, 9.99963526527),
     (0.211530235268, 0.189490498088, 9.99963342205),
     (0.217889570744, 0.195849569342, 9.99963165267),
     (0.224248909486, 0.202208639742, 9.99962995723),
     (0.230608251572, 0.208567709289, 9.99962833571),
     (0.23696759708, 0.214926777983, 9.99962678813),
     (0.24332694609, 0.221285845824, 9.99962531439),
     (0.249686298678, 0.227644912811, 9.99962391467),
     (0.256045654924, 0.234003978945, 9.9996225888),
     (0.262405014907, 0.240363044226, 9.99962133676),
     (0.268764378703, 0.246722108653, 9.99962015874),
     (0.275123746392, 0.253081172228, 9.99961905456),
     (0.281483118052, 0.259440234948, 9.99961802432),
     (0.287842493761, 0.265799296816, 9.999617068),
     (0.294201873598, 0.27215835783, 9.99961618553),
     (0.300561257641, 0.278517417991, 9.99961537707),
     (0.306920645968, 0.284876477299, 9.99961464246),
     (0.313280038658, 0.291235535753, 9.99961398168),
     (0.319639435788, 0.297594593355, 9.99961339493),
     (0.325998837438, 0.303953650102, 9.99961288201),
     (0.332358243686, 0.310312705997, 9.99961244303),
     (0.33871765461, 0.316671761038, 9.99961207797),
     (0.345077070288, 0.323030815226, 9.99961178676),
     (0.351436490798, 0.32938986856, 9.99961156956),
     (0.357795916219, 0.335748921042, 9.99961142621),
     (0.364155346631, 0.342107972669, 9.99961135669),
     (0.370514782109, 0.348467023444, 9.9996113612)],
    [(-0.342580549397, -0.375618443542, 10.5000834719),
     (-0.336221192007, -0.369259294516, 10.5000746812),
     (-0.329861838263, -0.362900146394, 10.500065969),
     (-0.323502488085, -0.356540999176, 10.5000573352),
     (-0.317143141395, -0.350181852862, 10.5000487801),
     (-0.310783798116, -0.343822707452, 10.5000403034),
     (-0.304424458167, -0.337463562946, 10.5000319053),
     (-0.298065121472, -0.331104419344, 10.5000235857),
     (-0.291705787952, -0.324745276646, 10.5000153447),
     (-0.285346457528, -0.318386134852, 10.5000071822),
     (-0.278987130122, -0.312026993961, 10.4999990983),
     (-0.272627805656, -0.305667853975, 10.4999910928),
     (-0.266268484052, -0.299308714893, 10.499983166),
     (-0.25990916523, -0.292949576715, 10.4999753176),
     (-0.253549849113, -0.286590439441, 10.4999675477),
     (-0.247190535623, -0.280231303071, 10.4999598565),
     (-0.240831224681, -0.273872167605, 10.4999522437),
     (-0.234471916209, -0.267513033043, 10.4999447096),
     (-0.228112610127, -0.261153899385, 10.4999372538),
     (-0.221753306359, -0.254794766631, 10.4999298767),
     (-0.215394004826, -0.248435634781, 10.4999225781),
     (-0.209034705449, -0.242076503835, 10.499915358),
     (-0.202675408149, -0.235717373793, 10.4999082165),
     (-0.19631611285, -0.229358244655, 10.4999011534),
     (-0.189956819472, -0.222999116421, 10.4998941691),
     (-0.183597527936, -0.216639989091, 10.4998872631),
     (-0.177238238166, -0.210280862665, 10.4998804356),
     (-0.170878950082, -0.203921737143, 10.4998736868),
     (-0.164519663605, -0.197562612525, 10.4998670165),
     (-0.158160378659, -0.191203488811, 10.4998604247),
     (-0.151801095163, -0.184844366002, 10.4998539114),
     (-0.14544181304, -0.178485244096, 10.4998474767),
     (-0.139082532213, -0.172126123094, 10.4998411205),
     (-0.132723252601, -0.165767002997, 10.4998348429),
     (-0.126363974127, -0.159407883803, 10.4998286438),
     (-0.120004696713, -0.153048765514, 10.4998225231),
     (-0.11364542028, -0.146689648128, 10.4998164811),
     (-0.10728614475, -0.140330531647, 10.4998105175),
     (-0.100926870044, -0.133971416069, 10.4998046326),
     (-0.0945675960848, -0.127612301396, 10.4997988261),
     (-0.0882083227934, -0.121253187627, 10.4997930982),
     (-0.0818490500913, -0.114894074761, 10.4997874488),
     (-0.0754897779006, -0.1085349628, 10.4997818779),
     (-0.0691305061428, -0.102175851743, 10.4997763856),
     (-0.0627712347393, -0.0958167415902, 10.4997709718),
     (-0.0564119636121, -0.0894576323413, 10.4997656365),
     (-0.0500526926829, -0.0830985239963, 10.4997603798),
     (-0.043693421873, -0.0767394165556, 10.4997552016),
     (-0.0373341511043, -0.0703803100188, 10.4997501019),
     (-0.0309748802986, -0.064021204386, 10.4997450808),
     (-0.0246156093772, -0.0576620996576, 10.4997401382),
     (-0.018256338262, -0.0513029958331, 10.4997352741),
     (-0.0118970668748, -0.0449438929125, 10.4997304886),
     (-0.00553779513684, -0.0385847908963, 10.4997257816),
     (0.000821477029519, -0.0322256897837, 10.4997211532),
     (0.00718074970367, -0.0258665895758, 10.4997166032),
     (0.0135400229629, -0.0195074902715, 10.4997121318),
     (0.0198992968862, -0.0131483918716, 10.4997077389),
     (0.0262585715516, -0.00678929437564, 10.4997034246),
     (0.0326178470377, -0.000430197784035, 10.4996991887),
     (0.0389771234223, 0.00592889790394, 10.4996950315),
     (0.0453364007844, 0.0122879926876, 10.4996909528),
     (0.0516956792022, 0.0186470865668, 10.4996869525),
     (0.0580549587534, 0.0250061795424, 10.4996830309),
     (0.0644142395171, 0.0313652716137, 10.4996791877),
     (0.0707735215716, 0.0377243627806, 10.499675423),
     (0.0771328049946, 0.0440834530438, 10.4996717369),
     (0.083492089865, 0.0504425424027, 10.4996681293),
     (0.0898513762608, 0.0568016308576, 10.4996646003),
     (0.0962106642605, 0.0631607184084, 10.4996611498),
     (0.102569953943, 0.0695198050548, 10.4996577778),
     (0.108929245385, 0.0758788907973, 10.4996544844),
     (0.115288538667, 0.0822379756357, 10.4996512695),
     (0.121647833865, 0.0885970595701, 10.4996481331),
     (0.12800713106, 0.0949561426001, 10.4996450752),
     (0.134366430328, 0.101315224726, 10.4996420959),
     (0.140725731748, 0.107674305948, 10.4996391951),
     (0.147085035399, 0.114033386266, 10.4996363729),
     (0.153444341359, 0.120392465679, 10.4996336291),
     (0.159803649706, 0.126751544189, 10.4996309639),
     (0.166162960518, 0.133110621794, 10.4996283773),
     (0.172522273875, 0.139469698495, 10.4996258691),
     (0.178881589854, 0.145828774292, 10.4996234394),
     (0.185240908534, 0.152187849185, 10.4996210884),
     (0.191600229992, 0.158546923174, 10.4996188158),
     (0.197959554307, 0.164905996259, 10.4996166218),
     (0.204318881559, 0.171265068439, 10.4996145063),
     (0.210678211824, 0.177624139715, 10.4996124693),
     (0.217037545181, 0.183983210087, 10.4996105109),
     (0.223396881709, 0.190342279555, 10.499608631),
     (0.229756221487, 0.196701348119, 10.4996068296),
     (0.236115564591, 0.203060415779, 10.4996051067),
     (0.242474911101, 0.209419482534, 10.4996034624),
     (0.248834261095, 0.215778548385, 10.4996018965),
     (0.25519361465, 0.222137613333, 10.4996004093),
     (0.261552971847, 0.228496677376, 10.4995990006),
     (0.267912332763, 0.234855740514, 10.4995976703),
     (0.274271697476, 0.241214802749, 10.4995964187),
     (0.280631066065, 0.247573864079, 10.4995952455),
     (0.286990438607, 0.253932924506, 10.4995941508),
     (0.293349815182, 0.260291984028, 10.4995931348),
     (0.299709195868, 0.266651042646, 10.4995921971),
     (0.306068580742, 0.27301010036, 10.4995913381),
     (0.312427969884, 0.279369157169, 10.4995905576),
     (0.318787363372, 0.285728213074, 10.4995898555),
     (0.325146761283, 0.292087268076, 10.4995892321),
     (0.331506163697, 0.298446322173, 10.4995886871),
     (0.337865570691, 0.304805375365, 10.4995882207),
     (0.344224982345, 0.311164427654, 10.4995878328),
     (0.350584398736, 0.317523479038, 10.4995875234),
     (0.356943819942, 0.323882529519, 10.4995872927),
     (0.363303246043, 0.330241579095, 10.4995871403),
     (0.369662677116, 0.336600627766, 10.4995870665),
     (0.376022113239, 0.342959675534, 10.4995870713)],
    [(-0.337073395003, -0.381125773609, 11.0000883821),
     (-0.330714035128, -0.374766621891, 11.0000790742),
     (-0.324354678914, -0.368407471129, 11.0000698495),
     (-0.317995326284, -0.362048321321, 11.0000607079),
     (-0.311635977159, -0.355689172469, 11.0000516495),
     (-0.30527663146, -0.349330024571, 11.0000426742),
     (-0.298917289111, -0.342970877628, 11.0000337821),
     (-0.292557950031, -0.336611731639, 11.0000249731),
     (-0.286198614144, -0.330252586606, 11.0000162473),
     (-0.279839281369, -0.323893442528, 11.0000076047),
     (-0.27347995163, -0.317534299404, 10.9999990452),
     (-0.267120624847, -0.311175157235, 10.9999905689),
     (-0.260761300944, -0.304816016021, 10.9999821757),
     (-0.254401979839, -0.298456875762, 10.9999738657),
     (-0.248042661457, -0.292097736458, 10.9999656388),
     (-0.241683345718, -0.285738598109, 10.9999574951),
     (-0.235324032544, -0.279379460715, 10.9999494345),
     (-0.228964721857, -0.273020324275, 10.9999414572),
     (-0.222605413578, -0.266661188791, 10.9999335629),
     (-0.216246107629, -0.260302054261, 10.9999257518),
     (-0.209886803932, -0.253942920686, 10.9999180239),
     (-0.203527502408, -0.247583788066, 10.9999103791),
     (-0.197168202979, -0.241224656401, 10.9999028175),
     (-0.190808905566, -0.234865525691, 10.9998953389),
     (-0.184449610092, -0.228506395936, 10.9998879437),
     (-0.178090316478, -0.222147267136, 10.9998806315),
     (-0.171731024645, -0.21578813929, 10.9998734024),
     (-0.165371734516, -0.2094290124, 10.9998662566),
     (-0.159012446012, -0.203069886464, 10.999859194),
     (-0.152653159054, -0.196710761483, 10.9998522144),
     (-0.146293873564, -0.190351637457, 10.999845318),
     (-0.139934589464, -0.183992514387, 10.9998385047),
     (-0.133575306676, -0.177633392271, 10.9998317746),
     (-0.127216025122, -0.171274271109, 10.9998251278),
     (-0.120856744722, -0.164915150903, 10.999818564),
     (-0.114497465398, -0.158556031652, 10.9998120833),
     (-0.108138187073, -0.152196913356, 10.9998056859),
     (-0.101778909667, -0.145837796014, 10.9997993715),
     (-0.095419633103, -0.139478679628, 10.9997931404),
     (-0.0890603573021, -0.133119564196, 10.9997869923),
     (-0.0827010821862, -0.12676044972, 10.9997809275),
     (-0.0763418076766, -0.120401336198, 10.9997749457),
     (-0.0699825336953, -0.114042223632, 10.9997690472),
     (-0.0636232601639, -0.10768311202, 10.9997632318),
     (-0.0572639870037, -0.101324001363, 10.9997574995),
     (-0.0509047141368, -0.0949648916611, 10.9997518504),
     (-0.0445454414849, -0.0886057829141, 10.9997462845),
     (-0.0381861689691, -0.0822466751222, 10.9997408017),
     (-0.0318268965117, -0.0758875682852, 10.999735402),
     (-0.0254676240341, -0.069528462403, 10.9997300856),
     (-0.0191083514578, -0.063169357476, 10.9997248522),
     (-0.0127490787047, -0.0568102535038, 10.999719702),
     (-0.00638980569648, -0.0504511504865, 10.999714635),
     (-3.05323544753e-05, -0.0440920484244, 10.9997096511),
     (0.00632874139892, -0.0377329473168, 10.9997047504),
     (0.0126880156432, -0.0313738471647, 10.9996999328),
     (0.0190472904555, -0.0250147479672, 10.9996951984),
     (0.025406565915, -0.0186556497248, 10.9996905471),
     (0.0317658420996, -0.0122965524374, 10.999685979),
     (0.0381251190881, -0.00593745610515, 10.9996814939),
     (0.044484396958, 0.000421639272587, 10.9996770922),
     (0.0508436757883, 0.00678073369508, 10.9996727735),
     (0.0572029556576, 0.0131398271623, 10.9996685379),
     (0.0635622366432, 0.0194989196751, 10.9996643856),
     (0.0699215188244, 0.0258580112326, 10.9996603164),
     (0.0762808022794, 0.0322171018348, 10.9996563302),
     (0.0826400870859, 0.0385761914825, 10.9996524273),
     (0.0889993733229, 0.044935280175, 10.9996486075),
     (0.0953586610684, 0.0512943679126, 10.9996448709),
     (0.101717950401, 0.0576534546953, 10.9996412175),
     (0.108077241399, 0.0640125405227, 10.9996376471),
     (0.11443653414, 0.0703716253952, 10.9996341599),
     (0.120795828703, 0.0767307093128, 10.9996307559),
     (0.127155125167, 0.0830897922755, 10.9996274351),
     (0.133514423609, 0.089448874283, 10.9996241973),
     (0.139873724108, 0.0958079553355, 10.9996210427),
     (0.146233026742, 0.102167035433, 10.9996179713),
     (0.15259233159, 0.108526114576, 10.9996149831),
     (0.15895163873, 0.114885192763, 10.9996120779),
     (0.16531094824, 0.121244269996, 10.9996092559),
     (0.171670260199, 0.127603346273, 10.9996065171),
     (0.178029574685, 0.133962421596, 10.9996038614),
     (0.184388891776, 0.140321495963, 10.9996012888),
     (0.190748211551, 0.146680569375, 10.9995987994),
     (0.197107534087, 0.153039641833, 10.9995963932),
     (0.203466859464, 0.159398713335, 10.9995940702),
     (0.20982618776, 0.165757783882, 10.9995918302),
     (0.216185519052, 0.172116853475, 10.9995896734),
     (0.22254485342, 0.178475922112, 10.9995875998),
     (0.228904190942, 0.184834989794, 10.9995856093),
     (0.235263531695, 0.191194056521, 10.9995837019),
     (0.241622875759, 0.197553122293, 10.9995818777),
     (0.247982223212, 0.20391218711, 10.9995801367),
     (0.254341574131, 0.210271250972, 10.9995784787),
     (0.260700928596, 0.21663031388, 10.999576904),
     (0.267060286684, 0.222989375832, 10.9995754124),
     (0.273419648475, 0.229348436828, 10.9995740039),
     (0.279779014045, 0.23570749687, 10.9995726786),
     (0.286138383475, 0.242066555957, 10.9995714364),
     (0.292497756841, 0.248425614088, 10.9995702774),
     (0.298857134223, 0.254784671265, 10.9995692015),
     (0.305216515699, 0.261143727487, 10.9995682087),
     (0.311575901346, 0.267502782753, 10.9995672992),
     (0.317935291244, 0.273861837065, 10.9995664728),
     (0.324294685471, 0.280220890421, 10.9995657294),
     (0.330654084104, 0.286579942822, 10.9995650693),
     (0.337013487223, 0.292938994269, 10.9995644923),
     (0.343372894906, 0.29929804476, 10.9995639984),
     (0.349732307231, 0.305657094296, 10.9995635877),
     (0.356091724276, 0.312016142877, 10.9995632601),
     (0.362451146119, 0.318375190503, 10.9995630158),
     (0.36881057284, 0.324734237174, 10.9995628545),
     (0.375170004517, 0.331093282889, 10.9995627763),
     (0.381529441227, 0.33745232765, 10.9995627813)],
    [(-0.331566237063, -0.38663310365, 11.5000932922),
     (-0.32520687476, -0.380273949241, 11.5000834672),
     (-0.318847516136, -0.373914795838, 11.50007373),
     (-0.312488161112, -0.367555643441, 11.5000640805),
     (-0.30612880961, -0.36119649205, 11.5000545189),
     (-0.299769461552, -0.354837341664, 11.500045045),
     (-0.29341011686, -0.348478192284, 11.5000356589),
     (-0.287050775455, -0.34211904391, 11.5000263605),
     (-0.280691437258, -0.335759896541, 11.50001715),
     (-0.274332102192, -0.329400750178, 11.5000080272),
     (-0.267972770179, -0.323041604821, 11.4999989922),
     (-0.261613441138, -0.31668246047, 11.4999900449),
     (-0.255254114993, -0.310323317124, 11.4999811855),
     (-0.248894791665, -0.303964174784, 11.4999724138),
     (-0.242535471076, -0.29760503345, 11.4999637298),
     (-0.236176153148, -0.291245893122, 11.4999551338),
     (-0.2298168378, -0.284886753799, 11.4999466253),
     (-0.223457524957, -0.278527615482, 11.4999382048),
     (-0.217098214539, -0.272168478171, 11.4999298719),
     (-0.210738906469, -0.265809341866, 11.4999216269),
     (-0.204379600666, -0.259450206566, 11.4999134697),
     (-0.198020297054, -0.253091072272, 11.4999054001),
     (-0.191660995554, -0.246731938984, 11.4998974184),
     (-0.185301696087, -0.240372806702, 11.4998895244),
     (-0.178942398576, -0.234013675425, 11.4998817184),
     (-0.172583102942, -0.227654545155, 11.4998739999),
     (-0.166223809106, -0.22129541589, 11.4998663692),
     (-0.15986451699, -0.21493628763, 11.4998588264),
     (-0.153505226517, -0.208577160377, 11.4998513714),
     (-0.147145937607, -0.202218034129, 11.4998440041),
     (-0.140786650181, -0.195858908888, 11.4998367245),
     (-0.134427364163, -0.189499784652, 11.4998295327),
     (-0.128068079474, -0.183140661421, 11.4998224288),
     (-0.121708796034, -0.176781539196, 11.4998154126),
     (-0.115349513767, -0.170422417978, 11.4998084842),
     (-0.108990232592, -0.164063297765, 11.4998016435),
     (-0.102630952434, -0.157704178558, 11.4997948907),
     (-0.0962716732112, -0.151345060357, 11.4997882255),
     (-0.0899123948477, -0.144985943161, 11.4997816482),
     (-0.0835531172641, -0.138626826971, 11.4997751586),
     (-0.0771938403825, -0.132267711787, 11.4997687568),
     (-0.070834564124, -0.12590859761, 11.4997624427),
     (-0.0644752884109, -0.119549484437, 11.4997562165),
     (-0.0581160131646, -0.113190372271, 11.499750078),
     (-0.0517567383065, -0.10683126111, 11.4997440273),
     (-0.0453974637587, -0.100472150956, 11.4997380643),
     (-0.0390381894428, -0.0941130418064, 11.4997321892),
     (-0.03267891528, -0.0877539336634, 11.4997264018),
     (-0.0263196411925, -0.0813948265261, 11.4997207021),
     (-0.0199603671018, -0.0750357203945, 11.4997150903),
     (-0.0136010929293, -0.0686766152689, 11.4997095662),
     (-0.00724181859701, -0.0623175111491, 11.4997041299),
     (-0.00088254402659, -0.055958408035, 11.4996987814),
     (0.0054767308607, -0.049599305927, 11.4996935206),
     (0.0118360061424, -0.0432402048244, 11.4996883477),
     (0.018195281898, -0.0368811047282, 11.4996832624),
     (0.0245545582047, -0.0305220056374, 11.499678265),
     (0.0309138351417, -0.0241629075527, 11.4996733553),
     (0.0372731127867, -0.0178038104737, 11.4996685334),
     (0.0436323912187, -0.0114447144008, 11.4996637992),
     (0.0499916705151, -0.00508561933332, 11.4996591529),
     (0.0563509507551, 0.00127347472805, 11.4996545943),
     (0.062710232017, 0.00763256778328, 11.4996501234),
     (0.0690695143783, 0.0139916598332, 11.4996457404),
     (0.0754287979182, 0.0203507508769, 11.4996414451),
     (0.081788082715, 0.0267098409145, 11.4996372374),
     (0.0881473688463, 0.0330689299467, 11.4996331177),
     (0.0945066563911, 0.0394280179728, 11.4996290857),
     (0.100865945428, 0.0457871049931, 11.4996251415),
     (0.107225236034, 0.0521461910076, 11.4996212851),
     (0.113584528289, 0.058505276016, 11.4996175164),
     (0.11994382227, 0.0648643600186, 11.4996138355),
     (0.126303118056, 0.0712234430154, 11.4996102423),
     (0.132662415726, 0.0775825250064, 11.499606737),
     (0.139021715357, 0.0839416059913, 11.4996033194),
     (0.145381017028, 0.0903006859704, 11.4995999895),
     (0.151740320818, 0.0966597649437, 11.4995967475),
     (0.158099626804, 0.103018842911, 11.4995935932),
     (0.164458935065, 0.109377919873, 11.4995905267),
     (0.17081824568, 0.115736995828, 11.4995875479),
     (0.177177558726, 0.122096070778, 11.499584657),
     (0.183536874282, 0.128455144721, 11.4995818537),
     (0.189896192427, 0.134814217659, 11.4995791382),
     (0.196255513238, 0.141173289591, 11.4995765105),
     (0.202614836794, 0.147532360517, 11.4995739706),
     (0.208974163173, 0.153891430437, 11.4995715185),
     (0.215333492455, 0.160250499351, 11.4995691541),
     (0.221692824716, 0.16660956726, 11.4995668775),
     (0.228052160035, 0.172968634162, 11.4995646887),
     (0.234411498492, 0.179327700058, 11.4995625875),
     (0.240770840163, 0.185686764949, 11.4995605742),
     (0.247130185128, 0.192045828833, 11.4995586487),
     (0.253489533464, 0.198404891712, 11.4995568109),
     (0.259848885251, 0.204763953585, 11.4995550608),
     (0.266208240565, 0.211123014452, 11.4995533987),
     (0.272567599486, 0.217482074313, 11.4995518242),
     (0.278926962093, 0.223841133167, 11.4995503374),
     (0.285286328463, 0.230200191017, 11.4995489385),
     (0.291645698674, 0.23655924786, 11.4995476273),
     (0.298005072806, 0.242918303697, 11.4995464039),
     (0.304364450936, 0.249277358528, 11.4995452683),
     (0.310723833143, 0.255636412353, 11.4995442203),
     (0.317083219504, 0.261995465172, 11.4995432603),
     (0.323442610099, 0.268354516986, 11.4995423879),
     (0.329802005006, 0.274713567793, 11.4995416032),
     (0.336161404303, 0.281072617594, 11.4995409065),
     (0.342520808069, 0.28743166639, 11.4995402974),
     (0.348880216381, 0.293790714179, 11.4995397761),
     (0.355239629318, 0.300149760963, 11.4995393426),
     (0.361599046958, 0.30650880674, 11.4995389968),
     (0.36795846938, 0.312867851512, 11.4995387389),
     (0.374317896663, 0.319226895278, 11.4995385686),
     (0.380677328884, 0.325585938037, 11.4995384861),
     (0.387036766121, 0.331944979791, 11.4995384914)],
    [(-0.326059075525, -0.392140433666, 12.0000982023),
     (-0.319699710853, -0.385781276566, 12.0000878602),
     (-0.313340349877, -0.379422120523, 12.0000776105),
     (-0.306980992519, -0.373062965536, 12.0000674532),
     (-0.300621638699, -0.366703811606, 12.0000573883),
     (-0.29426228834, -0.360344658732, 12.0000474157),
     (-0.287902941364, -0.353985506915, 12.0000375357),
     (-0.281543597692, -0.347626356155, 12.0000277479),
     (-0.275184257246, -0.341267206451, 12.0000180526),
     (-0.268824919947, -0.334908057803, 12.0000084496),
     (-0.262465585717, -0.328548910213, 11.9999989391),
     (-0.256106254478, -0.322189763679, 11.999989521),
     (-0.249746926151, -0.315830618201, 11.9999801953),
     (-0.243387600658, -0.30947147378, 11.9999709619),
     (-0.23702827792, -0.303112330417, 11.9999618208),
     (-0.230668957861, -0.296753188109, 11.9999527724),
     (-0.224309640399, -0.290394046858, 11.9999438161),
     (-0.217950325459, -0.284034906663, 11.9999349524),
     (-0.211591012961, -0.277675767526, 11.9999261809),
     (-0.205231702827, -0.271316629445, 11.999917502),
     (-0.198872394978, -0.26495749242, 11.9999089155),
     (-0.192513089337, -0.258598356453, 11.9999004212),
     (-0.186153785824, -0.252239221542, 11.9998920194),
     (-0.179794484362, -0.245880087687, 11.9998837099),
     (-0.173435184873, -0.239520954889, 11.999875493),
     (-0.167075887277, -0.233161823148, 11.9998673683),
     (-0.160716591496, -0.226802692464, 11.999859336),
     (-0.154357297453, -0.220443562836, 11.9998513962),
     (-0.147998005069, -0.214084434264, 11.9998435488),
     (-0.141638714265, -0.20772530675, 11.9998357938),
     (-0.135279424963, -0.201366180292, 11.9998281311),
     (-0.128920137086, -0.195007054891, 11.9998205608),
     (-0.122560850553, -0.188647930546, 11.9998130829),
     (-0.116201565288, -0.182288807258, 11.9998056975),
     (-0.109842281212, -0.175929685027, 11.9997984044),
     (-0.103482998246, -0.169570563853, 11.9997912037),
     (-0.0971237163123, -0.163211443734, 11.9997840954),
     (-0.0907644353319, -0.156852324674, 11.9997770794),
     (-0.0844051552275, -0.150493206669, 11.999770156),
     (-0.0780458759199, -0.144134089721, 11.9997633248),
     (-0.0716865973313, -0.13777497383, 11.9997565861),
     (-0.0653273193828, -0.131415858995, 11.9997499397),
     (-0.0589680419965, -0.125056745218, 11.9997433858),
     (-0.0526087650941, -0.118697632496, 11.9997369242),
     (-0.0462494885969, -0.112338520832, 11.999730555),
     (-0.0398902124268, -0.105979410224, 11.9997242782),
     (-0.0335309365057, -0.0996203006733, 11.9997180939),
     (-0.0271716607546, -0.0932611921792, 11.9997120019),
     (-0.0208123850958, -0.0869020847416, 11.9997060022),
     (-0.0144531094508, -0.0805429783605, 11.9997000951),
     (-0.00809383374087, -0.0741838730365, 11.9996942802),
     (-0.00173455788815, -0.067824768769, 11.9996885578),
     (0.00462471818575, -0.0614656655581, 11.9996829278),
     (0.0109839945596, -0.0551065634042, 11.9996773901),
     (0.0173432713108, -0.0487474623065, 11.9996719449),
     (0.023702548519, -0.0423883622662, 11.999666592),
     (0.0300618262614, -0.0360292632821, 11.9996613315),
     (0.036421104617, -0.029670165355, 11.9996561634),
     (0.0427803836638, -0.0233110684845, 11.9996510878),
     (0.0491396634805, -0.0169519726711, 11.9996461044),
     (0.0554989441447, -0.0105928779138, 11.9996412135),
     (0.0618582257356, -0.00423378421354, 11.999636415),
     (0.0682175083313, 0.00212530842967, 11.9996317088),
     (0.0745767920096, 0.00848440001668, 11.9996270951),
     (0.0809360768494, 0.0148434905466, 11.9996225737),
     (0.0872953629293, 0.0212025800196, 11.9996181447),
     (0.0936546503266, 0.0275616684363, 11.9996138082),
     (0.100013939121, 0.033920755796, 11.9996095639),
     (0.106373229389, 0.040279842099, 11.9996054121),
     (0.11273252121, 0.0466389273454, 11.9996013527),
     (0.119091814663, 0.0529980115347, 11.9995973857),
     (0.125451109826, 0.0593570946674, 11.999593511),
     (0.131810406777, 0.0657161767434, 11.9995897288),
     (0.138169705593, 0.0720752577628, 11.999586039),
     (0.144529006355, 0.0784343377251, 11.9995824414),
     (0.15088830914, 0.0847934166308, 11.9995789364),
     (0.157247614026, 0.0911524944797, 11.9995755237),
     (0.163606921091, 0.0975115712721, 11.9995722034),
     (0.169966230415, 0.103870647007, 11.9995689755),
     (0.176325542075, 0.110229721686, 11.9995658399),
     (0.18268485615, 0.116588795308, 11.9995627968),
     (0.189044172718, 0.122947867873, 11.999559846),
     (0.195403491857, 0.129306939381, 11.9995569876),
     (0.201762813646, 0.135666009832, 11.9995542216),
     (0.208122138163, 0.142025079227, 11.999551548),
     (0.214481465486, 0.148384147565, 11.9995489669),
     (0.220840795695, 0.154743214846, 11.999546478),
     (0.227200128866, 0.16110228107, 11.9995440816),
     (0.233559465078, 0.167461346238, 11.9995417776),
     (0.239918804411, 0.173820410348, 11.9995395658),
     (0.246278146941, 0.180179473402, 11.9995374465),
     (0.252637492748, 0.186538535399, 11.9995354196),
     (0.258996841909, 0.192897596339, 11.9995334852),
     (0.265356194504, 0.199256656223, 11.999531643),
     (0.271715550609, 0.20561571505, 11.9995298933),
     (0.278074910305, 0.211974772819, 11.999528236),
     (0.284434273669, 0.218333829532, 11.9995266709),
     (0.290793640779, 0.224692885188, 11.9995251984),
     (0.297153011714, 0.231051939788, 11.9995238182),
     (0.303512386552, 0.23741099333, 11.9995225304),
     (0.309871765371, 0.243770045816, 11.999521335),
     (0.31623114825, 0.250129097245, 11.9995202319),
     (0.322590535267, 0.256488147617, 11.9995192213),
     (0.328949926501, 0.262847196932, 11.9995183031),
     (0.335309322029, 0.26920624519, 11.9995174771),
     (0.341668721931, 0.275565292392, 11.9995167437),
     (0.348028126284, 0.281924338537, 11.9995161025),
     (0.354387535166, 0.288283383624, 11.9995155538),
     (0.360746948657, 0.294642427655, 11.9995150975),
     (0.367106366835, 0.301001470629, 11.9995147334),
     (0.373465789776, 0.307360512547, 11.999514462),
     (0.379825217561, 0.313719553407, 11.9995142828),
     (0.386184650268, 0.320078593211, 11.9995141959),
     (0.392544087975, 0.326437631958, 11.9995142015)],
    [(-0.320551910338, -0.397647763657, 12.5001031124),
     (-0.314192543357, -0.391288603865, 12.5000922533),
     (-0.307833180088, -0.384929445181, 12.5000814911),
     (-0.301473820453, -0.378570287605, 12.5000708259),
     (-0.295114464375, -0.372211131136, 12.5000602577),
     (-0.288755111774, -0.365851975775, 12.5000497865),
     (-0.282395762573, -0.35949282152, 12.5000394124),
     (-0.276036416692, -0.353133668374, 12.5000291353),
     (-0.269677074055, -0.346774516335, 12.5000189552),
     (-0.263317734582, -0.340415365403, 12.5000088721),
     (-0.256958398194, -0.334056215579, 12.4999988861),
     (-0.250599064815, -0.327697066862, 12.499988997),
     (-0.244239734365, -0.321337919253, 12.499979205),
     (-0.237880406765, -0.314978772751, 12.49996951),
     (-0.231521081938, -0.308619627357, 12.4999599119),
     (-0.225161759806, -0.30226048307, 12.499950411),
     (-0.21880244029, -0.295901339892, 12.4999410069),
     (-0.212443123311, -0.289542197819, 12.4999317),
     (-0.206083808791, -0.283183056856, 12.49992249),
     (-0.199724496653, -0.276823916999, 12.4999133771),
     (-0.193365186817, -0.270464778249, 12.4999043612),
     (-0.187005879205, -0.264105640608, 12.4998954423),
     (-0.180646573739, -0.257746504074, 12.4998866204),
     (-0.17428727034, -0.251387368647, 12.4998778954),
     (-0.167927968931, -0.245028234328, 12.4998692677),
     (-0.161568669432, -0.238669101116, 12.4998607367),
     (-0.155209371766, -0.232309969012, 12.4998523028),
     (-0.148850075854, -0.225950838016, 12.499843966),
     (-0.142490781618, -0.219591708127, 12.4998357263),
     (-0.136131488979, -0.213232579345, 12.4998275835),
     (-0.12977219786, -0.206873451671, 12.4998195376),
     (-0.123412908181, -0.200514325105, 12.4998115888),
     (-0.117053619865, -0.194155199646, 12.4998037371),
     (-0.110694332833, -0.187796075294, 12.4997959824),
     (-0.104335047006, -0.181436952051, 12.4997883246),
     (-0.0979757623071, -0.175077829915, 12.4997807638),
     (-0.0916164786575, -0.168718708886, 12.4997733002),
     (-0.0852571959779, -0.162359588965, 12.4997659334),
     (-0.0788979141914, -0.156000470151, 12.4997586638),
     (-0.0725386332186, -0.149641352445, 12.4997514911),
     (-0.0661793529817, -0.143282235847, 12.4997444154),
     (-0.0598200734019, -0.136923120356, 12.4997374367),
     (-0.0534607944013, -0.130564005973, 12.499730555),
     (-0.0471015159016, -0.124204892697, 12.4997237704),
     (-0.0407422378239, -0.117845780529, 12.4997170828),
     (-0.0343829600904, -0.111486669468, 12.4997104921),
     (-0.0280236826228, -0.105127559515, 12.4997039986),
     (-0.0216644053422, -0.0987684506695, 12.4996976019),
     (-0.0153051281708, -0.0924093429316, 12.4996913024),
     (-0.00894585103018, -0.0860502363011, 12.4996850998),
     (-0.00258657384162, -0.0796911307786, 12.4996789942),
     (0.00377270347279, -0.0733320263634, 12.4996729857),
     (0.0101319809914, -0.0669729230558, 12.4996670742),
     (0.016491258793, -0.060613820856, 12.4996612596),
     (0.022850536955, -0.0542547197632, 12.4996555422),
     (0.0292098155571, -0.0478956197788, 12.4996499216),
     (0.0355690946763, -0.0415365209014, 12.4996443981),
     (0.0419283743919, -0.035177423132, 12.4996389716),
     (0.0482876547816, -0.02881832647, 12.4996336421),
     (0.0546469359244, -0.0224592309159, 12.4996284096),
     (0.0610062178976, -0.0161001364688, 12.4996232742),
     (0.0673655007806, -0.00974104312969, 12.4996182358),
     (0.0737247846515, -0.0033819508985, 12.4996132942),
     (0.0800840695879, 0.00297714022564, 12.4996084499),
     (0.086443355669, 0.00933623024185, 12.4996037024),
     (0.0928026429731, 0.0156953191501, 12.4995990519),
     (0.0991619315777, 0.0220544069513, 12.4995944986),
     (0.105521221562, 0.0284134936446, 12.4995900421),
     (0.111880513004, 0.0347725792303, 12.4995856827),
     (0.118239805982, 0.0411316637086, 12.4995814204),
     (0.124599100574, 0.0474907470789, 12.499577255),
     (0.130958396859, 0.0538498293416, 12.4995731866),
     (0.137317694915, 0.0602089104969, 12.4995692152),
     (0.143676994821, 0.0665679905446, 12.4995653409),
     (0.150036296654, 0.0729270694843, 12.4995615635),
     (0.156395600493, 0.0792861473165, 12.4995578832),
     (0.162754906417, 0.0856452240412, 12.4995542999),
     (0.169114214503, 0.0920042996584, 12.4995508136),
     (0.175473524831, 0.0983633741675, 12.4995474242),
     (0.181832837478, 0.104722447569, 12.4995441319),
     (0.188192152523, 0.111081519863, 12.4995409366),
     (0.194551470044, 0.117440591049, 12.4995378383),
     (0.200910790119, 0.123799661128, 12.499534837),
     (0.207270112827, 0.130158730099, 12.4995319327),
     (0.213629438246, 0.136517797962, 12.4995291254),
     (0.219988766454, 0.142876864718, 12.4995264152),
     (0.22634809753, 0.149235930366, 12.4995238019),
     (0.232707431552, 0.155594994906, 12.4995212857),
     (0.239066768599, 0.161954058339, 12.4995188664),
     (0.245426108749, 0.168313120664, 12.4995165441),
     (0.251785452079, 0.174672181881, 12.4995143189),
     (0.258144798669, 0.18103124199, 12.4995121906),
     (0.264504148597, 0.187390300992, 12.4995101594),
     (0.270863501941, 0.193749358886, 12.4995082251),
     (0.277222858779, 0.200108415673, 12.499506388),
     (0.28358221919, 0.206467471352, 12.4995046478),
     (0.289941583253, 0.212826525922, 12.4995030045),
     (0.296300951044, 0.219185579386, 12.4995014583),
     (0.302660322644, 0.225544631741, 12.4995000091),
     (0.309019698129, 0.231903682989, 12.4994986569),
     (0.315379077579, 0.23826273313, 12.4994974018),
     (0.321738461072, 0.244621782162, 12.4994962435),
     (0.328097848686, 0.250980830087, 12.4994951824),
     (0.334457240499, 0.257339876904, 12.4994942182),
     (0.34081663659, 0.263698922613, 12.499493351),
     (0.347176037037, 0.270057967215, 12.4994925808),
     (0.353535441919, 0.276417010709, 12.4994919076),
     (0.359894851314, 0.282776053095, 12.4994913315),
     (0.3662542653, 0.289135094374, 12.4994908523),
     (0.372613683955, 0.295494134544, 12.4994904701),
     (0.378973107358, 0.301853173607, 12.4994901851),
     (0.385332535587, 0.308212211563, 12.4994899969),
     (0.391691968721, 0.31457124841, 12.4994899057),
     (0.398051406837, 0.32093028415, 12.4994899116)],
    [(-0.315044741453, -0.403155093622, 13.0001080225),
     (-0.30868537222, -0.396795931139, 13.0000966463),
     (-0.302326006717, -0.390436769815, 13.0000853716),
     (-0.295966644865, -0.384077609649, 13.0000741985),
     (-0.289607286586, -0.377718450641, 13.0000631271),
     (-0.283247931802, -0.371359292792, 13.0000521573),
     (-0.276888580434, -0.365000136101, 13.0000412892),
     (-0.270529232404, -0.358640980568, 13.0000305227),
     (-0.264169887634, -0.352281826193, 13.0000198579),
     (-0.257810546046, -0.345922672977, 13.0000092946),
     (-0.25145120756, -0.33956352092, 12.9999988331),
     (-0.245091872099, -0.33320437002, 12.9999884731),
     (-0.238732539584, -0.326845220279, 12.9999782148),
     (-0.232373209937, -0.320486071697, 12.9999680581),
     (-0.22601388308, -0.314126924273, 12.9999580029),
     (-0.219654558934, -0.307767778007, 12.9999480496),
     (-0.213295237421, -0.3014086329, 12.9999381977),
     (-0.206935918463, -0.29504948895, 12.9999284477),
     (-0.20057660198, -0.28869034616, 12.999918799),
     (-0.194217287896, -0.282331204527, 12.9999092522),
     (-0.187857976131, -0.275972064053, 12.999899807),
     (-0.181498666607, -0.269612924738, 12.9998904633),
     (-0.175139359246, -0.26325378658, 12.9998812213),
     (-0.168780053969, -0.256894649582, 12.9998720809),
     (-0.1624207507, -0.250535513741, 12.9998630423),
     (-0.156061449357, -0.244176379059, 12.9998541051),
     (-0.149702149864, -0.237817245536, 12.9998452697),
     (-0.143342852142, -0.23145811317, 12.9998365359),
     (-0.136983556113, -0.225098981963, 12.9998279037),
     (-0.130624261698, -0.218739851915, 12.9998193732),
     (-0.124264968819, -0.212380723025, 12.9998109442),
     (-0.117905677398, -0.206021595294, 12.9998026169),
     (-0.111546387357, -0.19966246872, 12.9997943912),
     (-0.105187098617, -0.193303343305, 12.9997862673),
     (-0.098827811099, -0.186944219049, 12.9997782449),
     (-0.0924685247254, -0.180585095951, 12.999770324),
     (-0.0861092394185, -0.174225974012, 12.999762505),
     (-0.0797499550985, -0.167866853231, 12.9997547874),
     (-0.0733906716885, -0.161507733608, 12.9997471716),
     (-0.0670313891093, -0.155148615144, 12.9997396573),
     (-0.0606721072829, -0.148789497838, 12.9997322447),
     (-0.0543128261306, -0.142430381691, 12.9997249337),
     (-0.0479535455744, -0.136071266702, 12.9997177243),
     (-0.041594265536, -0.129712152871, 12.9997106167),
     (-0.0352349859367, -0.1233530402, 12.9997036105),
     (-0.0288757066985, -0.116993928686, 12.9996967061),
     (-0.0225164277432, -0.110634818331, 12.9996899033),
     (-0.0161571489918, -0.104275709134, 12.999683202),
     (-0.00979787036656, -0.0979166010962, 12.9996766025),
     (-0.00343859178912, -0.0915574942163, 12.9996701046),
     (0.00292068681934, -0.0851983884952, 12.9996637082),
     (0.00927996553669, -0.0788392839324, 12.9996574136),
     (0.0156392444413, -0.072480180528, 12.9996512205),
     (0.0219985236119, -0.0661210782823, 12.9996451291),
     (0.0283578031259, -0.0597619771945, 12.9996391394),
     (0.0347170830632, -0.053402877266, 12.9996332512),
     (0.0410763635005, -0.0470437784953, 12.9996274647),
     (0.0474356445172, -0.0406846808834, 12.9996217798),
     (0.0537949261912, -0.0343255844299, 12.9996161965),
     (0.0601542086012, -0.0279664891352, 12.9996107148),
     (0.0665134918248, -0.0216073949984, 12.9996053349),
     (0.072872775941, -0.0152483020204, 12.9996000565),
     (0.0792320610283, -0.00888921020123, 12.9995948797),
     (0.0855913471641, -0.00253011953995, 12.9995898046),
     (0.0919506344277, 0.00382896996249, 12.9995848311),
     (0.0983099228973, 0.0101880583061, 12.9995799592),
     (0.10466921265, 0.0165471454918, 12.999575189),
     (0.111028503766, 0.0229062315187, 12.9995705203),
     (0.117387796323, 0.0292653163871, 12.9995659533),
     (0.123747090398, 0.0356244000972, 12.999561488),
     (0.130106386072, 0.0419834826485, 12.9995571242),
     (0.13646568342, 0.0483425640413, 12.9995528621),
     (0.142824982523, 0.0547016442758, 12.9995487017),
     (0.149184283458, 0.0610607233518, 12.9995446429),
     (0.155543586305, 0.067419801269, 12.9995406856),
     (0.16190289114, 0.0737788780278, 12.99953683),
     (0.168262198043, 0.0801379536281, 12.999533076),
     (0.174621507091, 0.0864970280701, 12.9995294238),
     (0.180980818364, 0.0928561013532, 12.999525873),
     (0.187340131939, 0.0992151734778, 12.9995224239),
     (0.193699447894, 0.105574244444, 12.9995190765),
     (0.200058766309, 0.111933314251, 12.9995158306),
     (0.206418087262, 0.1182923829, 12.9995126863),
     (0.21277741083, 0.124651450391, 12.9995096438),
     (0.219136737092, 0.131010516723, 12.9995067028),
     (0.225496066127, 0.137369581896, 12.9995038636),
     (0.231855398012, 0.143728645911, 12.9995011258),
     (0.238214732827, 0.150087708767, 12.9994984897),
     (0.244574070649, 0.156446770465, 12.9994959553),
     (0.250933411557, 0.162805831004, 12.9994935224),
     (0.257292755629, 0.169164890385, 12.9994911912),
     (0.263652102944, 0.175523948607, 12.9994889616),
     (0.270011453579, 0.18188300567, 12.9994868337),
     (0.276370807614, 0.188242061575, 12.9994848073),
     (0.282730165125, 0.194601116321, 12.9994828827),
     (0.289089526193, 0.200960169909, 12.9994810596),
     (0.295448890895, 0.207319222338, 12.999479338),
     (0.30180825931, 0.213678273609, 12.9994777183),
     (0.308167631515, 0.22003732372, 12.9994762),
     (0.314527007589, 0.226396372674, 12.9994747834),
     (0.320886387611, 0.232755420469, 12.9994734685),
     (0.327245771659, 0.239114467105, 12.9994722551),
     (0.333605159811, 0.245473512582, 12.9994711435),
     (0.339964552145, 0.251832556901, 12.9994701334),
     (0.346323948741, 0.258191600061, 12.9994692248),
     (0.352683349675, 0.264550642063, 12.999468418),
     (0.359042755027, 0.270909682906, 12.9994677128),
     (0.365402164874, 0.277268722591, 12.9994671092),
     (0.371761579296, 0.283627761117, 12.9994666072),
     (0.378120998371, 0.289986798484, 12.9994662068),
     (0.384480422176, 0.296345834693, 12.9994659082),
     (0.39083985079, 0.302704869743, 12.999465711),
     (0.397199284293, 0.309063903634, 12.9994656155),
     (0.40355872276, 0.315422936367, 12.9994656216)],
    [(-0.309537568817, -0.408662423562, 13.5001129326),
     (-0.303178197391, -0.402303258388, 13.5001010393),
     (-0.296818829713, -0.395944094423, 13.5000892521),
     (-0.290459465702, -0.389584931667, 13.5000775712),
     (-0.284100105282, -0.383225770121, 13.5000659965),
     (-0.277740748373, -0.376866609783, 13.5000545281),
     (-0.271381394898, -0.370507450655, 13.500043166),
     (-0.265022044777, -0.364148292736, 13.5000319101),
     (-0.258662697934, -0.357789136027, 13.5000207605),
     (-0.252303354288, -0.351429980526, 13.5000097171),
     (-0.245944013763, -0.345070826235, 13.49999878),
     (-0.239584676279, -0.338711673153, 13.4999879491),
     (-0.233225341759, -0.33235252128, 13.4999772246),
     (-0.226866010123, -0.325993370617, 13.4999666062),
     (-0.220506681294, -0.319634221163, 13.499956094),
     (-0.214147355193, -0.313275072917, 13.4999456882),
     (-0.207788031742, -0.306915925882, 13.4999353885),
     (-0.201428710863, -0.300556780055, 13.4999251953),
     (-0.195069392476, -0.294197635438, 13.4999151081),
     (-0.188710076505, -0.28783849203, 13.4999051273),
     (-0.18235076287, -0.281479349831, 13.4998952528),
     (-0.175991451493, -0.275120208842, 13.4998854844),
     (-0.169632142296, -0.268761069062, 13.4998758223),
     (-0.1632728352, -0.262401930491, 13.4998662664),
     (-0.156913530128, -0.256042793129, 13.499856817),
     (-0.150554227, -0.249683656977, 13.4998474736),
     (-0.144194925739, -0.243324522033, 13.4998382365),
     (-0.137835626266, -0.236965388299, 13.4998291057),
     (-0.131476328502, -0.230606255775, 13.4998200812),
     (-0.12511703237, -0.224247124459, 13.4998111629),
     (-0.118757737791, -0.217887994353, 13.4998023507),
     (-0.112398444687, -0.211528865457, 13.4997936449),
     (-0.106039152979, -0.205169737769, 13.4997850454),
     (-0.0996798625892, -0.198810611291, 13.4997765521),
     (-0.093320573439, -0.192451486022, 13.4997681651),
     (-0.0869612854498, -0.186092361963, 13.4997598842),
     (-0.0806019985443, -0.179733239112, 13.4997517098),
     (-0.0742427126427, -0.173374117471, 13.4997436413),
     (-0.0678834276681, -0.167014997039, 13.4997356794),
     (-0.0615241435411, -0.160655877817, 13.4997278235),
     (-0.055164860184, -0.154296759804, 13.499720074),
     (-0.0488055775178, -0.147937643, 13.4997124307),
     (-0.0424462954648, -0.141578527406, 13.4997048936),
     (-0.0360870139466, -0.135219413021, 13.4996974629),
     (-0.0297277328844, -0.128860299845, 13.4996901383),
     (-0.0233684522003, -0.122501187879, 13.49968292),
     (-0.0170091718159, -0.116142077121, 13.499675808),
     (-0.0106498916525, -0.109782967574, 13.4996688021),
     (-0.00429061163225, -0.103423859235, 13.4996619026),
     (0.00206866832329, -0.097064752106, 13.4996551093),
     (0.0084279482929, -0.0907056461864, 13.4996484222),
     (0.0147872283544, -0.084346541476, 13.4996418414),
     (0.0211465085862, -0.0779874379748, 13.4996353669),
     (0.0275057890671, -0.0716283356832, 13.4996289986),
     (0.0338650698744, -0.0652692346004, 13.4996227367),
     (0.040224351088, -0.0589101347277, 13.4996165808),
     (0.0465836327847, -0.0525510360637, 13.4996105313),
     (0.0529429150439, -0.0461919386095, 13.4996045879),
     (0.0593021979433, -0.0398328423645, 13.4995987509),
     (0.0656614815619, -0.0334737473291, 13.49959302),
     (0.0720207659769, -0.0271146535025, 13.4995873956),
     (0.0783800512678, -0.0207555608857, 13.4995818773),
     (0.0847393375127, -0.0143964694785, 13.4995764651),
     (0.0910986247892, -0.00803737928011, 13.4995711594),
     (0.0974579131764, -0.00167829029142, 13.4995659598),
     (0.103817202753, 0.00468079748753, 13.4995608664),
     (0.110176493596, 0.0110398840577, 13.4995558794),
     (0.116535785784, 0.0173989694182, 13.4995509985),
     (0.122895079397, 0.0237580535694, 13.4995462239),
     (0.129254374511, 0.0301171365113, 13.4995415557),
     (0.135613671206, 0.0364762182435, 13.4995369935),
     (0.14197296956, 0.0428352987664, 13.4995325377),
     (0.148332269651, 0.0491943780801, 13.4995281881),
     (0.154691571557, 0.0555534561845, 13.4995239448),
     (0.161050875358, 0.0619125330791, 13.4995198077),
     (0.16741018113, 0.0682716087644, 13.4995157768),
     (0.173769488953, 0.0746306832405, 13.4995118522),
     (0.180128798905, 0.0809897565073, 13.4995080339),
     (0.186488111064, 0.0873488285643, 13.4995043218),
     (0.192847425508, 0.093707899412, 13.4995007159),
     (0.199206742316, 0.10006696905, 13.4994972163),
     (0.205566061567, 0.106426037479, 13.4994938229),
     (0.211925383337, 0.112785104698, 13.4994905357),
     (0.218284707707, 0.119144170708, 13.4994873548),
     (0.224644034754, 0.125503235509, 13.4994842802),
     (0.231003364556, 0.1318622991, 13.4994813119),
     (0.237362697192, 0.138221361482, 13.4994784497),
     (0.24372203274, 0.144580422654, 13.4994756938),
     (0.250081371279, 0.150939482617, 13.4994730442),
     (0.256440712887, 0.15729854137, 13.4994705007),
     (0.262800057642, 0.163657598914, 13.4994680635),
     (0.269159405622, 0.170016655249, 13.4994657326),
     (0.275518756906, 0.176375710374, 13.4994635079),
     (0.281878111573, 0.182734764289, 13.4994613894),
     (0.288237469699, 0.189093816996, 13.4994593773),
     (0.294596831365, 0.195452868492, 13.4994574714),
     (0.300956196648, 0.201811918779, 13.4994556716),
     (0.307315565627, 0.208170967857, 13.4994539782),
     (0.313674938379, 0.214530015725, 13.4994523909),
     (0.320034314983, 0.220889062384, 13.49945091),
     (0.326393695518, 0.227248107833, 13.4994495353),
     (0.332753080062, 0.233607152073, 13.4994482667),
     (0.339112468693, 0.239966195103, 13.4994471045),
     (0.34547186149, 0.246325236924, 13.4994460485),
     (0.351831258531, 0.252684277535, 13.4994450987),
     (0.358190659893, 0.259043316937, 13.4994442552),
     (0.364550065656, 0.265402355129, 13.4994435179),
     (0.370909475898, 0.271761392112, 13.4994428869),
     (0.377268890698, 0.278120427886, 13.4994423621),
     (0.383628310133, 0.284479462449, 13.4994419435),
     (0.389987734281, 0.290838495804, 13.4994416312),
     (0.396347163222, 0.297197527949, 13.4994414252),
     (0.402706597034, 0.303556558884, 13.4994413252),
     (0.409066035794, 0.30991558861, 13.4994413317)],
    [(-0.30403039238, -0.414169753476, 14.0001178428),
     (-0.297671018821, -0.40781058561, 14.0001054323),
     (-0.291311649025, -0.401451419005, 14.0000931327),
     (-0.284952282915, -0.39509225366, 14.0000809438),
     (-0.278592920412, -0.388733089575, 14.000068866),
     (-0.272233561437, -0.38237392675, 14.0000568989),
     (-0.265874205913, -0.376014765184, 14.0000450428),
     (-0.259514853761, -0.369655604879, 14.0000332975),
     (-0.253155504902, -0.363296445834, 14.0000216631),
     (-0.246796159259, -0.35693728805, 14.0000101396),
     (-0.240436816753, -0.350578131525, 13.999998727),
     (-0.234077477305, -0.34421897626, 13.9999874252),
     (-0.227718140837, -0.337859822256, 13.9999762343),
     (-0.221358807271, -0.331500669511, 13.9999651543),
     (-0.214999476529, -0.325141518027, 13.999954185),
     (-0.208640148532, -0.318782367803, 13.9999433268),
     (-0.202280823202, -0.312423218839, 13.9999325793),
     (-0.195921500461, -0.306064071135, 13.9999219429),
     (-0.189562180229, -0.299704924691, 13.9999114171),
     (-0.183202862429, -0.293345779507, 13.9999010024),
     (-0.176843546983, -0.286986635584, 13.9998906985),
     (-0.170484233812, -0.280627492921, 13.9998805054),
     (-0.164124922837, -0.274268351517, 13.9998704233),
     (-0.157765613981, -0.267909211374, 13.9998604519),
     (-0.151406307166, -0.261550072491, 13.9998505916),
     (-0.145047002311, -0.255190934868, 13.999840842),
     (-0.13868769934, -0.248831798506, 13.9998312033),
     (-0.132328398175, -0.242472663403, 13.9998216755),
     (-0.125969098736, -0.23611352956, 13.9998122586),
     (-0.119609800945, -0.229754396978, 13.9998029526),
     (-0.113250504724, -0.223395265656, 13.9997937573),
     (-0.106891209995, -0.217036135595, 13.9997846729),
     (-0.10053191668, -0.210677006793, 13.9997756995),
     (-0.0941726246995, -0.204317879251, 13.999766837),
     (-0.0878133339755, -0.197958752969, 13.9997580853),
     (-0.0814540444295, -0.191599627948, 13.9997494444),
     (-0.0750947559842, -0.185240504187, 13.9997409145),
     (-0.0687354685597, -0.178881381686, 13.9997324953),
     (-0.0623761820791, -0.172522260445, 13.9997241872),
     (-0.0560168964632, -0.166163140465, 13.9997159898),
     (-0.0496576116341, -0.159804021744, 13.9997079033),
     (-0.0432983275129, -0.153444904284, 13.9996999277),
     (-0.0369390440218, -0.147085788085, 13.9996920629),
     (-0.0305797610825, -0.140726673145, 13.9996843091),
     (-0.0242204786161, -0.134367559465, 13.999676666),
     (-0.0178611965448, -0.128008447046, 13.9996691339),
     (-0.0115019147902, -0.121649335887, 13.9996617127),
     (-0.00514263327357, -0.115290225988, 13.9996544022),
     (0.00121664808303, -0.108931117349, 13.9996472027),
     (0.00757592935792, -0.10257200997, 13.9996401141),
     (0.0139352106299, -0.0962129038522, 13.9996331362),
     (0.0202944919769, -0.0898537989941, 13.9996262693),
     (0.0266537734771, -0.0834946953961, 13.9996195133),
     (0.0330130552095, -0.0771355930586, 13.9996128681),
     (0.0393723372514, -0.0707764919808, 13.9996063339),
     (0.0457316196826, -0.064417392164, 13.9995999103),
     (0.0520909025799, -0.0580582936067, 13.9995935978),
     (0.0584501860228, -0.0516991963101, 13.9995873961),
     (0.0648094700889, -0.0453401002736, 13.9995813053),
     (0.0711687548572, -0.0389810054976, 13.9995753253),
     (0.0775280404051, -0.0326219119813, 13.9995694563),
     (0.0838873268117, -0.0262628197255, 13.999563698),
     (0.0902466141556, -0.0199037287304, 13.9995580506),
     (0.0966059025139, -0.0135446389948, 13.9995525141),
     (0.102965191966, -0.0071855505199, 13.9995470885),
     (0.109324482591, -0.000826463305602, 13.9995417736),
     (0.115683774465, 0.00553262264908, 13.9995365698),
     (0.122043067667, 0.0118917073431, 13.9995314767),
     (0.128402362277, 0.0182507907771, 13.9995264946),
     (0.134761658371, 0.0246098729509, 13.9995216233),
     (0.14112095603, 0.030968953864, 13.9995168628),
     (0.14748025533, 0.037328033517, 13.9995122132),
     (0.15383955635, 0.0436871119099, 13.9995076745),
     (0.160198859169, 0.0500461890426, 13.9995032468),
     (0.166558163864, 0.0564052649147, 13.9994989297),
     (0.172917470515, 0.0627643395266, 13.9994947236),
     (0.1792767792, 0.0691234128783, 13.9994906284),
     (0.185636089995, 0.0754824849699, 13.9994866441),
     (0.191995402982, 0.0818415558008, 13.9994827706),
     (0.198354718237, 0.0882006253716, 13.9994790079),
     (0.204714035839, 0.0945596936821, 13.9994753562),
     (0.211073355866, 0.100918760732, 13.9994718152),
     (0.217432678396, 0.107277826522, 13.9994683851),
     (0.223792003509, 0.113636891051, 13.9994650659),
     (0.230151331281, 0.119995954321, 13.9994618576),
     (0.236510661792, 0.12635501633, 13.9994587602),
     (0.24286999512, 0.132714077078, 13.9994557736),
     (0.249229331343, 0.139073136566, 13.9994528979),
     (0.25558867054, 0.145432194795, 13.9994501331),
     (0.261948012789, 0.151791251762, 13.999447479),
     (0.268307358168, 0.158150307469, 13.9994449358),
     (0.274666706755, 0.164509361916, 13.9994425036),
     (0.281026058629, 0.170868415103, 13.9994401822),
     (0.287385413869, 0.177227467029, 13.9994379716),
     (0.293744772552, 0.183586517695, 13.999435872),
     (0.300104134757, 0.189945567101, 13.9994338832),
     (0.306463500562, 0.196304615245, 13.9994320051),
     (0.312822870046, 0.202663662131, 13.9994302381),
     (0.319182243286, 0.209022707755, 13.9994285818),
     (0.325541620362, 0.215381752119, 13.9994270365),
     (0.331901001351, 0.221740795223, 13.999425602),
     (0.338260386333, 0.228099837066, 13.9994242783),
     (0.344619775384, 0.23445887765, 13.9994230656),
     (0.350979168584, 0.240817916972, 13.9994219637),
     (0.357338566011, 0.247176955034, 13.9994209725),
     (0.363697967743, 0.253535991837, 13.9994200924),
     (0.370057373859, 0.259895027378, 13.999419323),
     (0.376416784437, 0.266254061659, 13.9994186645),
     (0.382776199555, 0.27261309468, 13.999418117),
     (0.389135619292, 0.27897212644, 13.9994176801),
     (0.395495043725, 0.285331156941, 13.9994173543),
     (0.401854472934, 0.29169018618, 13.9994171393),
     (0.408213906996, 0.298049214159, 13.999417035),
     (0.41457334599, 0.304408240879, 13.9994170418)],
    [(-0.29852321209, -0.419677083365, 14.5001227529),
     (-0.292163836456, -0.413317912808, 14.5001098253),
     (-0.285804464603, -0.406958743562, 14.5000970132),
     (-0.279445096452, -0.400599575627, 14.5000843165),
     (-0.273085731924, -0.394240409003, 14.5000717354),
     (-0.266726370943, -0.38788124369, 14.5000592697),
     (-0.260367013429, -0.381522079688, 14.5000469196),
     (-0.254007659303, -0.375162916997, 14.5000346849),
     (-0.247648308488, -0.368803755617, 14.5000225658),
     (-0.241288960906, -0.362444595548, 14.5000105621),
     (-0.234929616477, -0.356085436789, 14.4999986739),
     (-0.228570275124, -0.349726279342, 14.4999869012),
     (-0.222210936769, -0.343367123206, 14.4999752441),
     (-0.215851601332, -0.337007968381, 14.4999637024),
     (-0.209492268735, -0.330648814867, 14.4999522761),
     (-0.203132938901, -0.324289662663, 14.4999409655),
     (-0.19677361175, -0.317930511771, 14.4999297701),
     (-0.190414287205, -0.311571362189, 14.4999186905),
     (-0.184054965187, -0.305212213919, 14.4999077262),
     (-0.177695645618, -0.298853066959, 14.4998968775),
     (-0.171336328419, -0.292493921311, 14.4998861443),
     (-0.164977013512, -0.286134776974, 14.4998755265),
     (-0.158617700819, -0.279775633948, 14.4998650243),
     (-0.152258390261, -0.273416492233, 14.4998546374),
     (-0.145899081761, -0.267057351828, 14.4998443663),
     (-0.139539775239, -0.260698212735, 14.4998342104),
     (-0.133180470618, -0.254339074953, 14.4998241701),
     (-0.126821167818, -0.247979938481, 14.4998142453),
     (-0.120461866763, -0.241620803321, 14.4998044361),
     (-0.114102567372, -0.235261669472, 14.4997947422),
     (-0.107743269568, -0.228902536934, 14.4997851638),
     (-0.101383973273, -0.222543405707, 14.499775701),
     (-0.095024678409, -0.216184275791, 14.4997663537),
     (-0.0886653848967, -0.209825147185, 14.4997571219),
     (-0.0823060926577, -0.203466019891, 14.4997480055),
     (-0.0759468016136, -0.197106893909, 14.4997390046),
     (-0.0695875116872, -0.190747769236, 14.4997301193),
     (-0.0632282227985, -0.184388645876, 14.4997213493),
     (-0.0568689348708, -0.178029523826, 14.499712695),
     (-0.0505096478247, -0.171670403087, 14.499704156),
     (-0.0441503615823, -0.16531128366, 14.4996957326),
     (-0.0377910760648, -0.158952165543, 14.4996874246),
     (-0.0314317911944, -0.152593048738, 14.4996792322),
     (-0.0250725068928, -0.146233933243, 14.4996711553),
     (-0.018713223081, -0.13987481906, 14.4996631938),
     (-0.0123539396812, -0.133515706188, 14.4996553478),
     (-0.00599465661518, -0.127156594626, 14.4996476174),
     (0.000364626196015, -0.120797484376, 14.4996400023),
     (0.00672390883018, -0.114438375437, 14.4996325028),
     (0.0130831913657, -0.108079267809, 14.4996251188),
     (0.0194424738813, -0.101720161493, 14.4996178503),
     (0.0258017564549, -0.0953610564868, 14.4996106972),
     (0.0321610391649, -0.089001952792, 14.4996036597),
     (0.0385203220901, -0.0826428504086, 14.4995967376),
     (0.0448796053077, -0.0762837493357, 14.4995899311),
     (0.0512388888978, -0.0699246495748, 14.4995832399),
     (0.057598172937, -0.0635655511243, 14.4995766644),
     (0.0639574575047, -0.0572064539853, 14.4995702043),
     (0.0703167426788, -0.0508473581572, 14.4995638597),
     (0.0766760285382, -0.0444882636406, 14.4995576305),
     (0.08303531516, -0.0381291704345, 14.4995515169),
     (0.0893946026238, -0.0317700785399, 14.4995455188),
     (0.0957538910078, -0.0254109879568, 14.499539636),
     (0.102113180389, -0.0190518986841, 14.4995338689),
     (0.108472470848, -0.0126928107229, 14.4995282172),
     (0.114831762461, -0.00633372407329, 14.4995226809),
     (0.121191055308, 2.53612658825e-05, 14.4995172602),
     (0.127550349466, 0.00638444529353, 14.4995119549),
     (0.133909645014, 0.0127435280102, 14.4995067652),
     (0.14026894203, 0.0191026094158, 14.4995016909),
     (0.146628240592, 0.0254616895099, 14.4994967321),
     (0.15298754078, 0.031820768293, 14.4994918888),
     (0.159346842671, 0.0381798457651, 14.499487161),
     (0.165706146343, 0.0445389219261, 14.4994825487),
     (0.172065451875, 0.0508979967756, 14.4994780518),
     (0.178424759346, 0.0572570703141, 14.4994736704),
     (0.184784068833, 0.0636161425416, 14.4994694046),
     (0.191143380414, 0.069975213458, 14.4994652543),
     (0.19750269417, 0.0763342830628, 14.4994612193),
     (0.203862010176, 0.0826933513566, 14.4994572999),
     (0.210221328513, 0.0890524183393, 14.499453496),
     (0.216580649258, 0.0954114840105, 14.4994498075),
     (0.22293997249, 0.101770548371, 14.4994462345),
     (0.229299298286, 0.10812961142, 14.499442777),
     (0.235658626726, 0.114488673158, 14.499439435),
     (0.242017957886, 0.120847733585, 14.4994362086),
     (0.248377291848, 0.1272067927, 14.4994330975),
     (0.254736628687, 0.133565850504, 14.499430102),
     (0.261095968483, 0.139924906997, 14.499427222),
     (0.267455311314, 0.146283962179, 14.4994244573),
     (0.273814657258, 0.152643016049, 14.4994218082),
     (0.280174006394, 0.159002068609, 14.4994192746),
     (0.286533358799, 0.165361119857, 14.4994168565),
     (0.292892714553, 0.171720169794, 14.4994145537),
     (0.299252073733, 0.17807921842, 14.4994123667),
     (0.305611436419, 0.184438265734, 14.499410295),
     (0.311970802688, 0.190797311737, 14.4994083387),
     (0.318330172618, 0.19715635643, 14.499406498),
     (0.324689546288, 0.20351539981, 14.4994047728),
     (0.331048923776, 0.20987444188, 14.499403163),
     (0.337408305161, 0.216233482638, 14.4994016688),
     (0.343767690521, 0.222592522085, 14.4994002899),
     (0.350127079934, 0.228951560221, 14.4993990267),
     (0.356486473479, 0.235310597046, 14.4993978788),
     (0.362845871234, 0.241669632559, 14.4993968464),
     (0.369205273277, 0.248028666761, 14.4993959296),
     (0.375564679687, 0.254387699652, 14.4993951281),
     (0.381924090541, 0.260746731232, 14.4993944422),
     (0.388283505919, 0.2671057615, 14.4993938718),
     (0.394642925899, 0.273464790457, 14.4993934168),
     (0.401002350558, 0.279823818103, 14.4993930774),
     (0.407361779975, 0.286182844437, 14.4993928535),
     (0.41372121423, 0.29254186946, 14.4993927448),
     (0.420080653399, 0.298900893172, 14.4993927519)],
    [(-0.293016027898, -0.425184413228, 15.000127663),
     (-0.286656650248, -0.41882523998, 15.0001142183),
     (-0.280297276395, -0.412466068094, 15.0001008937),
     (-0.273937906262, -0.406106897569, 15.0000876892),
     (-0.267578539769, -0.399747728406, 15.0000746048),
     (-0.261219176839, -0.393388560606, 15.0000616405),
     (-0.254859817394, -0.387029394166, 15.0000487963),
     (-0.248500461354, -0.380670229089, 15.0000360723),
     (-0.242141108642, -0.374311065374, 15.0000234684),
     (-0.235781759179, -0.36795190302, 15.0000109845),
     (-0.229422412887, -0.361592742028, 14.9999986209),
     (-0.223063069687, -0.355233582399, 14.9999863773),
     (-0.216703729502, -0.34887442413, 14.9999742538),
     (-0.210344392253, -0.342515267224, 14.9999622505),
     (-0.20398505786, -0.33615611168, 14.9999503671),
     (-0.197625726248, -0.329796957497, 14.9999386041),
     (-0.191266397335, -0.323437804677, 14.9999269609),
     (-0.184907071046, -0.317078653218, 14.9999154382),
     (-0.1785477473, -0.310719503121, 14.9999040352),
     (-0.17218842602, -0.304360354386, 14.9998927526),
     (-0.165829107128, -0.298001207013, 14.9998815901),
     (-0.159469790544, -0.291642061002, 14.9998705476),
     (-0.153110476191, -0.285282916352, 14.9998596252),
     (-0.14675116399, -0.278923773065, 14.9998488229),
     (-0.140391853864, -0.272564631139, 14.9998381409),
     (-0.134032545733, -0.266205490576, 14.9998275788),
     (-0.12767323952, -0.259846351374, 14.9998171369),
     (-0.121313935145, -0.253487213534, 14.9998068151),
     (-0.114954632532, -0.247128077056, 14.9997966135),
     (-0.1085953316, -0.24076894194, 14.9997865319),
     (-0.102236032272, -0.234409808186, 14.9997765704),
     (-0.09587673447, -0.228050675794, 14.999766729),
     (-0.0895174381153, -0.221691544763, 14.9997570078),
     (-0.0831581431298, -0.215332415094, 14.9997474068),
     (-0.0767988494345, -0.208973286788, 14.9997379258),
     (-0.0704395569511, -0.202614159844, 14.9997285648),
     (-0.0640802656024, -0.19625503426, 14.9997193241),
     (-0.0577209753083, -0.18989591004, 14.9997102033),
     (-0.0513616859922, -0.183536787181, 14.9997012027),
     (-0.0450023975746, -0.177177665684, 14.9996923223),
     (-0.0386431099778, -0.170818545549, 14.9996835619),
     (-0.0322838231228, -0.164459426776, 14.9996749216),
     (-0.0259245369318, -0.158100309365, 14.9996664015),
     (-0.0195652513265, -0.151741193316, 14.9996580015),
     (-0.0132059662281, -0.145382078629, 14.9996497215),
     (-0.00684668155863, -0.139022965304, 14.9996415617),
     (-0.000487397239873, -0.132663853341, 14.9996335221),
     (0.0058718868071, -0.126304742739, 14.9996256024),
     (0.0122311706601, -0.1199456335, 14.9996178029),
     (0.0185904543974, -0.113586525623, 14.9996101236),
     (0.0249497380979, -0.107227419107, 14.9996025643),
     (0.0313090218395, -0.100868313954, 14.9995951251),
     (0.0376683057004, -0.0945092101624, 14.9995878061),
     (0.0440275897596, -0.0881501077332, 14.9995806071),
     (0.0503868740943, -0.0817910066652, 14.9995735284),
     (0.0567461587844, -0.0754319069602, 14.9995665695),
     (0.0631054439067, -0.0690728086164, 14.999559731),
     (0.0694647295407, -0.062713711635, 14.9995530125),
     (0.075824015764, -0.0563546160154, 14.9995464141),
     (0.0821833026556, -0.0499955217582, 14.9995399357),
     (0.0885425902927, -0.0436364288623, 14.9995335776),
     (0.0949018787548, -0.0372773373288, 14.9995273395),
     (0.10126116812, -0.0309182471577, 14.9995212214),
     (0.107620458466, -0.0245591583479, 14.9995152237),
     (0.113979749872, -0.0182000709005, 14.9995093459),
     (0.120339042416, -0.0118409848155, 14.9995035881),
     (0.126698336176, -0.00548190009188, 14.9994979506),
     (0.133057631231, 0.000877183269372, 14.9994924331),
     (0.139416927658, 0.00723626526874, 14.9994870358),
     (0.145776225537, 0.0135953459062, 14.9994817586),
     (0.152135524945, 0.0199544251813, 14.9994766014),
     (0.158494825962, 0.0263135030945, 14.9994715643),
     (0.164854128664, 0.0326725796458, 14.9994666474),
     (0.171213433131, 0.0390316548351, 14.9994618506),
     (0.177572739441, 0.0453907286621, 14.9994571739),
     (0.183932047673, 0.0517498011271, 14.9994526173),
     (0.190291357904, 0.0581088722302, 14.9994481808),
     (0.196650670212, 0.0644679419715, 14.9994438644),
     (0.203009984678, 0.0708270103502, 14.9994396681),
     (0.209369301377, 0.077186077367, 14.9994355919),
     (0.21572862039, 0.083545143022, 14.9994316358),
     (0.222087941794, 0.0899042073144, 14.9994277998),
     (0.228447265668, 0.0962632702449, 14.9994240839),
     (0.23480659209, 0.102622331813, 14.9994204881),
     (0.241165921137, 0.10898139202, 14.9994170124),
     (0.24752525289, 0.115340450865, 14.9994136569),
     (0.253884587425, 0.121699508347, 14.9994104214),
     (0.260243924822, 0.128058564467, 14.9994073061),
     (0.266603265158, 0.134417619226, 14.9994043108),
     (0.272962608513, 0.140776672621, 14.9994014356),
     (0.279321954963, 0.147135724655, 14.9993986805),
     (0.285681304588, 0.153494775327, 14.9993960455),
     (0.292040657467, 0.159853824637, 14.9993935307),
     (0.298400013676, 0.166212872584, 14.9993911359),
     (0.304759373295, 0.17257191917, 14.9993888613),
     (0.311118736402, 0.178930964394, 14.9993867068),
     (0.317478103076, 0.185290008255, 14.9993846722),
     (0.323837473393, 0.191649050754, 14.999382758),
     (0.330196847434, 0.198008091891, 14.9993809637),
     (0.336556225277, 0.204367131666, 14.9993792895),
     (0.342915606998, 0.210726170079, 14.9993777355),
     (0.349274992679, 0.21708520713, 14.9993763015),
     (0.355634382394, 0.223444242819, 14.9993749877),
     (0.361993776225, 0.229803277145, 14.999373794),
     (0.368353174249, 0.236162310109, 14.9993727202),
     (0.374712576544, 0.242521341711, 14.9993717668),
     (0.381071983189, 0.248880371951, 14.9993709333),
     (0.387431394262, 0.255239400829, 14.9993702199),
     (0.39379080984, 0.261598428345, 14.9993696267),
     (0.400150230004, 0.267957454498, 14.9993691535),
     (0.406509654831, 0.27431647929, 14.9993688005),
     (0.412869084399, 0.28067550272, 14.9993685676),
     (0.419228518787, 0.287034524786, 14.9993684546),
     (0.425587958072, 0.293393545492, 14.9993684619)],
    [(-0.287508839753, -0.430691743066, 15.5001325731),
     (-0.281149460145, -0.424332567127, 15.5001186113),
     (-0.274790084352, -0.4179733926, 15.5001047742),
     (-0.268430712294, -0.411614219486, 15.5000910618),
     (-0.262071343895, -0.405255047784, 15.5000774742),
     (-0.255711979076, -0.398895877496, 15.5000640113),
     (-0.249352617758, -0.392536708619, 15.5000506731),
     (-0.242993259862, -0.386177541156, 15.5000374597),
     (-0.236633905312, -0.379818375105, 15.500024371),
     (-0.230274554027, -0.373459210467, 15.500011407),
     (-0.22391520593, -0.367100047242, 15.4999985678),
     (-0.217555860943, -0.360740885429, 15.4999858533),
     (-0.211196518987, -0.354381725029, 15.4999732636),
     (-0.204837179984, -0.348022566042, 15.4999607985),
     (-0.198477843854, -0.341663408468, 15.4999484581),
     (-0.192118510522, -0.335304252306, 15.4999362427),
     (-0.185759179906, -0.328945097558, 15.4999241518),
     (-0.179399851931, -0.322585944221, 15.4999121858),
     (-0.173040526516, -0.316226792298, 15.4999003443),
     (-0.166681203585, -0.309867641787, 15.4998886278),
     (-0.160321883057, -0.303508492689, 15.4998770359),
     (-0.153962564855, -0.297149345004, 15.4998655686),
     (-0.147603248901, -0.290790198732, 15.4998542262),
     (-0.141243935117, -0.284431053873, 15.4998430084),
     (-0.134884623423, -0.278071910425, 15.4998319156),
     (-0.128525313742, -0.271712768391, 15.4998209472),
     (-0.122166005995, -0.26535362777, 15.4998101037),
     (-0.115806700105, -0.258994488561, 15.4997993849),
     (-0.109447395992, -0.252635350765, 15.4997887909),
     (-0.103088093578, -0.246276214382, 15.4997783216),
     (-0.0967287927846, -0.239917079412, 15.4997679769),
     (-0.0903694935341, -0.233557945855, 15.4997577571),
     (-0.084010195748, -0.22719881371, 15.499747662),
     (-0.077650899348, -0.220839682978, 15.4997376916),
     (-0.0712916042552, -0.214480553659, 15.499727846),
     (-0.0649323103913, -0.208121425753, 15.4997181249),
     (-0.058573017679, -0.201762299259, 15.4997085288),
     (-0.0522137260382, -0.195403174179, 15.4996990572),
     (-0.0458544353925, -0.189044050511, 15.4996897105),
     (-0.0394951456622, -0.182684928256, 15.4996804885),
     (-0.0331358567696, -0.176325807413, 15.4996713912),
     (-0.0267765686358, -0.169966687984, 15.4996624186),
     (-0.020417281183, -0.163607569968, 15.4996535708),
     (-0.0140579943329, -0.157248453364, 15.4996448477),
     (-0.00769870800654, -0.150889338173, 15.4996362493),
     (-0.00133942212616, -0.144530224395, 15.4996277756),
     (0.00501986338656, -0.138171112029, 15.4996194267),
     (0.0113791486106, -0.131812001077, 15.4996112025),
     (0.0177384336236, -0.125452891537, 15.499603103),
     (0.024097718504, -0.119093783411, 15.4995951283),
     (0.0304570033307, -0.112734676697, 15.4995872783),
     (0.0368162881814, -0.106375571396, 15.499579553),
     (0.0431755731345, -0.100016467507, 15.4995719525),
     (0.049534858269, -0.0936573650323, 15.4995644766),
     (0.0558941436619, -0.0872982639693, 15.4995571256),
     (0.0622534293934, -0.0809391643201, 15.4995498991),
     (0.0686127155401, -0.0745800660831, 15.4995427976),
     (0.0749720021815, -0.0682209692593, 15.4995358206),
     (0.0813312893952, -0.0618618738482, 15.4995289685),
     (0.0876905772603, -0.0555027798504, 15.4995222409),
     (0.094049865854, -0.0491436872647, 15.4995156383),
     (0.100409155256, -0.0427845960923, 15.4995091603),
     (0.106768445544, -0.0364255063332, 15.4995028069),
     (0.113127736795, -0.0300664179863, 15.4994965784),
     (0.11948702909, -0.0237073310527, 15.4994904746),
     (0.125846322506, -0.0173482455324, 15.4994844953),
     (0.13220561712, -0.0109891614242, 15.499478641),
     (0.138564913013, -0.00463007872935, 15.4994729113),
     (0.144924210261, 0.00172900255275, 15.4994673064),
     (0.151283508944, 0.00808808242209, 15.4994618262),
     (0.157642809139, 0.0144471608781, 15.4994564707),
     (0.164002110926, 0.0208062379214, 15.4994512399),
     (0.170361414381, 0.0271653135519, 15.4994461339),
     (0.176720719584, 0.0335243877696, 15.4994411526),
     (0.183080026614, 0.039883460574, 15.499436296),
     (0.189439335547, 0.0462425319656, 15.4994315641),
     (0.195798646463, 0.0526016019444, 15.499426957),
     (0.20215795944, 0.0589606705104, 15.4994224746),
     (0.208517274557, 0.0653197376631, 15.4994181169),
     (0.214876591891, 0.071678803403, 15.4994138839),
     (0.221235911521, 0.07803786773, 15.4994097757),
     (0.227595233525, 0.0843969306437, 15.4994057921),
     (0.233954557983, 0.0907559921446, 15.4994019332),
     (0.240313884971, 0.0971150522327, 15.4993981992),
     (0.246673214568, 0.103474110908, 15.4993945898),
     (0.253032546853, 0.10983316817, 15.4993911053),
     (0.259391881904, 0.11619222402, 15.4993877453),
     (0.265751219799, 0.122551278456, 15.4993845101),
     (0.272110560617, 0.128910331479, 15.4993813997),
     (0.278469904436, 0.135269383089, 15.4993784139),
     (0.284829251335, 0.141628433286, 15.4993755528),
     (0.291188601391, 0.147987482071, 15.4993728165),
     (0.297547954682, 0.154346529442, 15.499370205),
     (0.303907311289, 0.1607055754, 15.499367718),
     (0.310266671288, 0.167064619946, 15.499365356),
     (0.316626034758, 0.173423663079, 15.4993631186),
     (0.322985401777, 0.179782704798, 15.4993610058),
     (0.329344772424, 0.186141745104, 15.4993590179),
     (0.335704146777, 0.192500783998, 15.4993571546),
     (0.342063524914, 0.198859821478, 15.499355416),
     (0.348422906914, 0.205218857545, 15.4993538023),
     (0.354782292856, 0.2115778922, 15.4993523131),
     (0.361141682815, 0.217936925441, 15.4993509488),
     (0.367501076873, 0.22429595727, 15.4993497091),
     (0.373860475108, 0.230654987685, 15.4993485941),
     (0.380219877596, 0.237014016687, 15.4993476039),
     (0.386579284417, 0.243373044276, 15.4993467384),
     (0.392938695649, 0.249732070452, 15.4993459976),
     (0.399298111371, 0.256091095216, 15.4993453816),
     (0.40565753166, 0.262450118566, 15.4993448902),
     (0.412016956595, 0.268809140503, 15.4993445236),
     (0.418376386254, 0.275168161027, 15.4993442817),
     (0.424735820717, 0.281527180138, 15.4993441644),
     (0.43109526006, 0.287886197836, 15.499344172)],
    [(-0.282001647602, -0.436199072879, 16.0001374832),
     (-0.275642266096, -0.429839894248, 16.0001230043),
     (-0.269282888421, -0.42348071708, 16.0001086548),
     (-0.262923514499, -0.417121541377, 16.0000944345),
     (-0.256564144252, -0.410762367136, 16.0000803436),
     (-0.250204777602, -0.40440319436, 16.000066382),
     (-0.24384541447, -0.398044023047, 16.0000525499),
     (-0.237486054777, -0.391684853197, 16.0000388471),
     (-0.231126698447, -0.385325684811, 16.0000252736),
     (-0.224767345399, -0.378966517889, 16.0000118295),
     (-0.218407995557, -0.37260735243, 15.9999985148),
     (-0.21204864884, -0.366248188435, 15.9999853294),
     (-0.205689305172, -0.359889025903, 15.9999722734),
     (-0.199329964474, -0.353529864835, 15.9999593466),
     (-0.192970626666, -0.347170705231, 15.9999465492),
     (-0.186611291673, -0.34081154709, 15.9999338813),
     (-0.180251959413, -0.334452390413, 15.9999213426),
     (-0.173892629811, -0.328093235199, 15.9999089334),
     (-0.167533302786, -0.32173408145, 15.9998966533),
     (-0.161173978261, -0.315374929163, 15.9998845029),
     (-0.154814656157, -0.30901577834, 15.9998724816),
     (-0.148455336396, -0.302656628981, 15.9998605897),
     (-0.1420960189, -0.296297481086, 15.9998488272),
     (-0.13573670359, -0.289938334654, 15.9998371939),
     (-0.129377390388, -0.283579189686, 15.9998256902),
     (-0.123018079215, -0.277220046182, 15.9998143156),
     (-0.116658769994, -0.270860904141, 15.9998030705),
     (-0.110299462646, -0.264501763563, 15.9997919547),
     (-0.103940157092, -0.258142624449, 15.9997809684),
     (-0.097580853255, -0.251783486799, 15.9997701113),
     (-0.091221551055, -0.245424350614, 15.9997593835),
     (-0.0848622504149, -0.239065215891, 15.9997487851),
     (-0.0785029512561, -0.232706082632, 15.9997383161),
     (-0.0721436535004, -0.226346950836, 15.9997279765),
     (-0.0657843570689, -0.219987820505, 15.9997177662),
     (-0.0594250618831, -0.213628691637, 15.9997076851),
     (-0.053065767866, -0.207269564232, 15.9996977336),
     (-0.0467064749374, -0.200910438292, 15.9996879112),
     (-0.0403471830207, -0.194551313815, 15.9996782183),
     (-0.0339878920365, -0.188192190802, 15.9996686547),
     (-0.0276286019069, -0.181833069252, 15.9996592205),
     (-0.0212693125531, -0.175473949167, 15.9996499156),
     (-0.0149100238972, -0.169114830544, 15.9996407401),
     (-0.008550735861, -0.162755713386, 15.9996316939),
     (-0.00219144836549, -0.156396597691, 15.999622777),
     (0.00416783866706, -0.15003748346, 15.9996139895),
     (0.010527125315, -0.143678370693, 15.9996053314),
     (0.0168864116573, -0.137319259389, 15.9995968026),
     (0.0232456977716, -0.130960149549, 15.9995884031),
     (0.0296049837363, -0.124601041173, 15.9995801331),
     (0.0359642696304, -0.118241934261, 15.9995719923),
     (0.0423235555316, -0.111882828812, 15.9995639809),
     (0.0486828415182, -0.105523724827, 15.9995560989),
     (0.0550421276691, -0.099164622306, 15.9995483461),
     (0.0614014140616, -0.0928055212479, 15.9995407229),
     (0.0677607007757, -0.0864464216546, 15.9995332287),
     (0.074119987888, -0.0800873235243, 15.9995258642),
     (0.080479275478, -0.0737282268581, 15.9995186288),
     (0.0868385636235, -0.0673691316555, 15.9995115229),
     (0.0931978524033, -0.0610100379171, 15.9995045461),
     (0.0995571418948, -0.0546509456417, 15.999497699),
     (0.105916432177, -0.0482918548304, 15.999490981),
     (0.112275723329, -0.0419327654833, 15.9994843923),
     (0.118635015428, -0.0355736775993, 15.9994779332),
     (0.124994308552, -0.0292145911794, 15.9994716032),
     (0.131353602781, -0.0228555062237, 15.9994654026),
     (0.137712898192, -0.0164964227311, 15.9994593314),
     (0.144072194863, -0.0101373407026, 15.9994533895),
     (0.150431492874, -0.00377826013781, 15.999447577),
     (0.156790792301, 0.00258081896339, 15.9994418938),
     (0.163150093225, 0.00893989660036, 15.9994363399),
     (0.169509395723, 0.0152989727737, 15.9994309154),
     (0.175868699873, 0.0216580474834, 15.9994256203),
     (0.182228005753, 0.0280171207295, 15.9994204545),
     (0.188587313443, 0.0343761925113, 15.999415418),
     (0.19494662302, 0.0407352628294, 15.9994105109),
     (0.201305934562, 0.0470943316839, 15.9994057331),
     (0.207665248148, 0.0534533990748, 15.9994010848),
     (0.214024563858, 0.0598124650014, 15.9993965656),
     (0.220383881767, 0.0661715294643, 15.9993921759),
     (0.226743201956, 0.0725305924635, 15.9993879155),
     (0.233102524502, 0.0788896539985, 15.9993837844),
     (0.239461849484, 0.0852487140698, 15.9993797826),
     (0.24582117698, 0.0916077726774, 15.9993759102),
     (0.252180507068, 0.0979668298214, 15.9993721672),
     (0.258539839826, 0.104325885502, 15.9993685536),
     (0.264899175334, 0.110684939718, 15.9993650692),
     (0.271258513669, 0.11704399247, 15.9993617142),
     (0.27761785491, 0.123403043758, 15.9993584886),
     (0.283977199135, 0.129762093583, 15.9993553922),
     (0.290336546423, 0.136121141943, 15.9993524251),
     (0.296695896851, 0.14248018884, 15.9993495875),
     (0.303055250498, 0.148839234273, 15.9993468792),
     (0.309414607443, 0.155198278242, 15.9993443002),
     (0.315773967762, 0.161557320747, 15.9993418507),
     (0.322133331536, 0.167916361789, 15.9993395304),
     (0.328492698843, 0.174275401366, 15.9993373393),
     (0.33485206976, 0.18063443948, 15.9993352778),
     (0.341211444367, 0.186993476129, 15.9993333455),
     (0.34757082274, 0.193352511315, 15.9993315426),
     (0.353930204959, 0.199711545037, 15.999329869),
     (0.360289591103, 0.206070577295, 15.9993283247),
     (0.366648981248, 0.212429608089, 15.9993269099),
     (0.373008375475, 0.21878863742, 15.9993256243),
     (0.379367773861, 0.225147665285, 15.9993244679),
     (0.385727176484, 0.231506691688, 15.9993234411),
     (0.392086583422, 0.237865716627, 15.9993225435),
     (0.398445994755, 0.244224740101, 15.9993217753),
     (0.40480541056, 0.250583762112, 15.9993211365),
     (0.411164830916, 0.256942782658, 15.9993206268),
     (0.4175242559, 0.263301801742, 15.9993202467),
     (0.423883685593, 0.269660819361, 15.9993199959),
     (0.430243120071, 0.276019835515, 15.9993198742),
     (0.436602559413, 0.282378850206, 15.9993198821)],
]

TEST_5_CORNERS = [
    Point(-0.0252862987308, -0.0252862962683, 7.01182317808),
    Point(0.0252862987308, 0.0252862962683, 7.01182317808),
    Point(0.0252862987308, 0.0252862962683, 10.9881768219),
    Point(-0.0252862987308, -0.0252862962683, 10.9881768219)
]
TEST_5_MESH = [
    [(-0.0252862987308, -0.0252862962683, 7.01182317808),
     (-0.0189271307231, -0.0189271296903, 7.01182317808),
     (-0.0125679629093, -0.0125679631516, 7.01182317808),
     (-0.00620879521115, -0.00620879665195, 7.01182317808),
     (0.000150372449663, 0.000150369808503, 7.01182317808),
     (0.0065095401515, 0.00650953622978, 7.01182317808),
     (0.0128687079727, 0.0128687026119, 7.01182317808),
     (0.0192278759916, 0.0192278689548, 7.01182317808),
     (0.0255870442865, 0.0255870352586, 7.01182317808)],
    [(-0.0252862987308, -0.0252862962683, 8.01182317808),
     (-0.0189271307231, -0.0189271296903, 8.01182317808),
     (-0.0125679629093, -0.0125679631515, 8.01182317808),
     (-0.00620879521115, -0.00620879665194, 8.01182317808),
     (0.000150372449663, 0.000150369808527, 8.01182317808),
     (0.0065095401515, 0.00650953622978, 8.01182317808),
     (0.0128687079727, 0.0128687026119, 8.01182317808),
     (0.0192278759916, 0.0192278689548, 8.01182317808),
     (0.0255870442865, 0.0255870352586, 8.01182317808)],
    [(-0.0252862987308, -0.0252862962683, 9.01182317808),
     (-0.0189271307231, -0.0189271296903, 9.01182317808),
     (-0.0125679629093, -0.0125679631515, 9.01182317808),
     (-0.00620879521115, -0.00620879665191, 9.01182317808),
     (0.000150372449663, 0.000150369808527, 9.01182317808),
     (0.0065095401515, 0.00650953622978, 9.01182317808),
     (0.0128687079727, 0.0128687026119, 9.01182317808),
     (0.0192278759916, 0.0192278689548, 9.01182317808),
     (0.0255870442865, 0.0255870352586, 9.01182317808)],
    [(-0.0252862987308, -0.0252862962683, 10.0118231781),
     (-0.0189271307231, -0.0189271296903, 10.0118231781),
     (-0.0125679629093, -0.0125679631515, 10.0118231781),
     (-0.00620879521115, -0.00620879665191, 10.0118231781),
     (0.000150372449663, 0.000150369808527, 10.0118231781),
     (0.0065095401515, 0.00650953622978, 10.0118231781),
     (0.0128687079727, 0.0128687026119, 10.0118231781),
     (0.0192278759916, 0.0192278689548, 10.0118231781),
     (0.0255870442865, 0.0255870352586, 10.0118231781)],
    [(-0.0252862987308, -0.0252862962683, 11.0118231781),
     (-0.0189271307231, -0.0189271296903, 11.0118231781),
     (-0.0125679629093, -0.0125679631515, 11.0118231781),
     (-0.00620879521115, -0.00620879665191, 11.0118231781),
     (0.000150372449663, 0.000150369808527, 11.0118231781),
     (0.0065095401515, 0.00650953622978, 11.0118231781),
     (0.0128687079727, 0.0128687026119, 11.0118231781),
     (0.0192278759916, 0.0192278689548, 11.0118231781),
     (0.0255870442865, 0.0255870352586, 11.0118231781)]
]

TEST_7_RUPTURE_1_CORNERS = [
    Point(-0.00799622929125, -0.00799622921338, 8.37128328516),
    Point(0.00799622929125, 0.00799622921338, 8.37128328516),
    Point(0.00799622929125, 0.00799622921338, 9.62871671484),
    Point(-0.00799622929125, -0.00799622921338, 9.62871671484)
]
TEST_7_RUPTURE_1_MESH = [
    [(-0.00799622929125, -0.00799622921338, 8.37128328516),
     (-0.00163706218523, -0.00163706218456, 8.37128328516),
     (0.0047221049398, 0.0047221048051, 8.37128328516),
     (0.0110812721622, 0.0110812717556, 8.37128328516)],
    [(-0.00799622929125, -0.00799622921337, 9.37128328516),
     (-0.00163706218523, -0.00163706218455, 9.37128328516),
     (0.0047221049398, 0.00472210480511, 9.37128328516),
     (0.0110812721622, 0.0110812717556, 9.37128328516)]
]

TEST_7_RUPTURE_2_CORNERS = [
    Point(-0.0252862987308, -0.0252862962683, 7.01182317808),
    Point(0.0252862987308, 0.0252862962683, 7.01182317808),
    Point(0.0252862987308, 0.0252862962683, 10.9881768219),
    Point(-0.0252862987308, -0.0252862962683, 10.9881768219)
]
TEST_7_RUPTURE_2_MESH = [
    [(-0.0252862987308, -0.0252862962683, 7.01182317808),
     (-0.0189271307231, -0.0189271296903, 7.01182317808),
     (-0.0125679629093, -0.0125679631516, 7.01182317808),
     (-0.00620879521115, -0.00620879665195, 7.01182317808),
     (0.000150372449663, 0.000150369808503, 7.01182317808),
     (0.0065095401515, 0.00650953622978, 7.01182317808),
     (0.0128687079727, 0.0128687026119, 7.01182317808),
     (0.0192278759916, 0.0192278689548, 7.01182317808),
     (0.0255870442865, 0.0255870352586, 7.01182317808)],
    [(-0.0252862987308, -0.0252862962683, 8.01182317808),
     (-0.0189271307231, -0.0189271296903, 8.01182317808),
     (-0.0125679629093, -0.0125679631515, 8.01182317808),
     (-0.00620879521115, -0.00620879665194, 8.01182317808),
     (0.000150372449663, 0.000150369808527, 8.01182317808),
     (0.0065095401515, 0.00650953622978, 8.01182317808),
     (0.0128687079727, 0.0128687026119, 8.01182317808),
     (0.0192278759916, 0.0192278689548, 8.01182317808),
     (0.0255870442865, 0.0255870352586, 8.01182317808)],
    [(-0.0252862987308, -0.0252862962683, 9.01182317808),
     (-0.0189271307231, -0.0189271296903, 9.01182317808),
     (-0.0125679629093, -0.0125679631515, 9.01182317808),
     (-0.00620879521115, -0.00620879665191, 9.01182317808),
     (0.000150372449663, 0.000150369808527, 9.01182317808),
     (0.0065095401515, 0.00650953622978, 9.01182317808),
     (0.0128687079727, 0.0128687026119, 9.01182317808),
     (0.0192278759916, 0.0192278689548, 9.01182317808),
     (0.0255870442865, 0.0255870352586, 9.01182317808)],
    [(-0.0252862987308, -0.0252862962683, 10.0118231781),
     (-0.0189271307231, -0.0189271296903, 10.0118231781),
     (-0.0125679629093, -0.0125679631515, 10.0118231781),
     (-0.00620879521115, -0.00620879665191, 10.0118231781),
     (0.000150372449663, 0.000150369808527, 10.0118231781),
     (0.0065095401515, 0.00650953622978, 10.0118231781),
     (0.0128687079727, 0.0128687026119, 10.0118231781),
     (0.0192278759916, 0.0192278689548, 10.0118231781),
     (0.0255870442865, 0.0255870352586, 10.0118231781)],
    [(-0.0252862987308, -0.0252862962683, 11.0118231781),
     (-0.0189271307231, -0.0189271296903, 11.0118231781),
     (-0.0125679629093, -0.0125679631515, 11.0118231781),
     (-0.00620879521115, -0.00620879665191, 11.0118231781),
     (0.000150372449663, 0.000150369808527, 11.0118231781),
     (0.0065095401515, 0.00650953622978, 11.0118231781),
     (0.0128687079727, 0.0128687026119, 11.0118231781),
     (0.0192278759916, 0.0192278689548, 11.0118231781),
     (0.0255870442865, 0.0255870352586, 11.0118231781)]
]

TEST_7_RUPTURE_3_CORNERS = [
    Point(-0.00399811467158, -0.0113083758289, 8.55543014749),
    Point(-0.00399811467158, 0.0113083758289, 8.55543014749),
    Point(0.00399811467158, 0.0113083758289, 9.44456985251),
    Point(0.00399811467158, -0.0113083758289, 9.44456985251)
]
TEST_7_RUPTURE_3_MESH = [
    [(-0.00399811467158, -0.0113083758289, 8.55543014749),
     (-0.00399811467158, -0.00231515553496, 8.55543014749),
     (-0.00399811467158, 0.00667806475902, 8.55543014749),
     (-0.00399811467158, 0.015671285053, 8.55543014749)],
    [(0.00236105249485, -0.0113083758469, 9.26253693001),
     (0.00236105241243, -0.00231515553863, 9.26253692598),
     (0.00236105245044, 0.00667806476961, 9.26253692598),
     (0.00236105253637, 0.0156712850779, 9.26253693807)]
]

TEST_7_RUPTURE_4_CORNERS = [
    Point(-0.0126431501863, -0.0357602239954, 7.59414668702),
    Point(-0.0126431501863, 0.0357602239954, 7.59414668702),
    Point(0.0126431501863, 0.0357602239954, 10.405853313),
    Point(0.0126431501863, -0.0357602239954, 10.405853313)
]
TEST_7_RUPTURE_4_MESH = [
    [(-0.0126431501863, -0.0357602239954, 7.59414668702),
     (-0.0126431501863, -0.0267670037015, 7.59414668702),
     (-0.0126431501863, -0.0177737834075, 7.59414668702),
     (-0.0126431501863, -0.00878056311352, 7.59414668702),
     (-0.0126431501863, 0.000212657180463, 7.59414668702),
     (-0.0126431501863, 0.00920587747445, 7.59414668702),
     (-0.0126431501863, 0.0181990977684, 7.59414668702),
     (-0.0126431501863, 0.0271923180624, 7.59414668702),
     (-0.0126431501863, 0.0361855383564, 7.59414668702)],
    [(-0.00628398209936, -0.035760224651, 8.30125349114),
     (-0.00628398237213, -0.0267670041922, 8.30125346091),
     (-0.00628398256436, -0.0177737837333, 8.30125343915),
     (-0.0062839826833, -0.00878056327449, 8.30125342665),
     (-0.00628398271805, 0.000212657184361, 8.30125342222),
     (-0.00628398267951, 0.00920587764321, 8.30125342706),
     (-0.0062839825568, 0.0181990981021, 8.30125343996),
     (-0.00628398236078, 0.0271923185609, 8.30125346212),
     (-0.00628398208422, 0.0361855390197, 8.30125349276)],
    [(7.51859875413e-05, -0.0357602253066, 9.00836029526),
     (7.51854419831e-05, -0.0267670046829, 9.0083602348),
     (7.51850575225e-05, -0.0177737840592, 9.00836019127),
     (7.51848196605e-05, -0.00878056343545, 9.00836016628),
     (7.51847501458e-05, 0.00021265718826, 9.00836015742),
     (7.51848272296e-05, 0.00920587781197, 9.00836016709),
     (7.51850726607e-05, 0.0181990984357, 9.00836019289),
     (7.51854646904e-05, 0.0271923190594, 9.00836023722),
     (7.51860178177e-05, 0.0361855396831, 9.00836029849)],
    [(0.00643435407444, -0.0357602259621, 9.71546709938),
     (0.0064343532561, -0.0267670051736, 9.71546700869),
     (0.00643435267941, -0.017773784385, 9.7154669434),
     (0.00643435232262, -0.00878056359642, 9.71546690591),
     (0.00643435221834, 0.000212657192158, 9.71546689261),
     (0.00643435233397, 0.00920587798073, 9.71546690712),
     (0.00643435270212, 0.0181990987693, 9.71546694582),
     (0.00643435329016, 0.0271923195579, 9.71546701232),
     (0.00643435411985, 0.0361855403465, 9.71546710422)],
    [(0.0127935221613, -0.0357602266177, 10.4225739035),
     (0.0127935210702, -0.0267670056643, 10.4225737826),
     (0.0127935203013, -0.0177737847108, 10.4225736955),
     (0.0127935198256, -0.00878056375738, 10.4225736455),
     (0.0127935196865, 0.000212657196057, 10.4225736278),
     (0.0127935198407, 0.00920587814949, 10.4225736472),
     (0.0127935203316, 0.0181990991029, 10.4225736987),
     (0.0127935211156, 0.0271923200564, 10.4225737874),
     (0.0127935222219, 0.0361855410098, 10.42257391)]
]

TEST_7_RUPTURE_5_CORNERS = [
    Point(-0.00799622929125, -0.00799622921338, 9.37128328516),
    Point(0.00799622929125, 0.00799622921338, 9.37128328516),
    Point(0.00799622929125, 0.00799622921338, 10.6287167148),
    Point(-0.00799622929125, -0.00799622921338, 10.6287167148)
]
TEST_7_RUPTURE_5_MESH = [
    [(-0.00799622929125, -0.00799622921338, 9.37128328516),
     (-0.00163706218523, -0.00163706218456, 9.37128328516),
     (0.0047221049398, 0.0047221048051, 9.37128328516),
     (0.0110812721622, 0.0110812717556, 9.37128328516)],
    [(-0.00799622929125, -0.00799622921337, 10.3712832852),
     (-0.00163706218523, -0.00163706218455, 10.3712832852),
     (0.0047221049398, 0.00472210480511, 10.3712832852),
     (0.0110812721622, 0.0110812717556, 10.3712832852)]
]

TEST_7_RUPTURE_6_CORNERS = [
    Point(-0.0252862987308, -0.0252862962683, 8.01182317808),
    Point(0.0252862987308, 0.0252862962683, 8.01182317808),
    Point(0.0252862987308, 0.0252862962683, 11.9881768219),
    Point(-0.0252862987308, -0.0252862962683, 11.9881768219),
]
TEST_7_RUPTURE_6_MESH = [
    [(-0.0252862987308, -0.0252862962683, 8.01182317808),
     (-0.0189271307231, -0.0189271296903, 8.01182317808),
     (-0.0125679629093, -0.0125679631516, 8.01182317808),
     (-0.00620879521115, -0.00620879665195, 8.01182317808),
     (0.000150372449663, 0.000150369808503, 8.01182317808),
     (0.0065095401515, 0.00650953622978, 8.01182317808),
     (0.0128687079727, 0.0128687026119, 8.01182317808),
     (0.0192278759916, 0.0192278689548, 8.01182317808),
     (0.0255870442865, 0.0255870352586, 8.01182317808)],
    [(-0.0252862987308, -0.0252862962683, 9.01182317808),
     (-0.0189271307231, -0.0189271296903, 9.01182317808),
     (-0.0125679629093, -0.0125679631515, 9.01182317808),
     (-0.00620879521115, -0.00620879665194, 9.01182317808),
     (0.000150372449663, 0.000150369808527, 9.01182317808),
     (0.0065095401515, 0.00650953622978, 9.01182317808),
     (0.0128687079727, 0.0128687026119, 9.01182317808),
     (0.0192278759916, 0.0192278689548, 9.01182317808),
     (0.0255870442865, 0.0255870352586, 9.01182317808)],
    [(-0.0252862987308, -0.0252862962683, 10.0118231781),
     (-0.0189271307231, -0.0189271296903, 10.0118231781),
     (-0.0125679629093, -0.0125679631515, 10.0118231781),
     (-0.00620879521115, -0.00620879665191, 10.0118231781),
     (0.000150372449663, 0.000150369808527, 10.0118231781),
     (0.0065095401515, 0.00650953622978, 10.0118231781),
     (0.0128687079727, 0.0128687026119, 10.0118231781),
     (0.0192278759916, 0.0192278689548, 10.0118231781),
     (0.0255870442865, 0.0255870352586, 10.0118231781)],
    [(-0.0252862987308, -0.0252862962683, 11.0118231781),
     (-0.0189271307231, -0.0189271296903, 11.0118231781),
     (-0.0125679629093, -0.0125679631515, 11.0118231781),
     (-0.00620879521115, -0.00620879665191, 11.0118231781),
     (0.000150372449663, 0.000150369808527, 11.0118231781),
     (0.0065095401515, 0.00650953622978, 11.0118231781),
     (0.0128687079727, 0.0128687026119, 11.0118231781),
     (0.0192278759916, 0.0192278689548, 11.0118231781),
     (0.0255870442865, 0.0255870352586, 11.0118231781)],
    [(-0.0252862987308, -0.0252862962683, 12.0118231781),
     (-0.0189271307231, -0.0189271296903, 12.0118231781),
     (-0.0125679629093, -0.0125679631515, 12.0118231781),
     (-0.00620879521115, -0.00620879665191, 12.0118231781),
     (0.000150372449663, 0.000150369808527, 12.0118231781),
     (0.0065095401515, 0.00650953622978, 12.0118231781),
     (0.0128687079727, 0.0128687026119, 12.0118231781),
     (0.0192278759916, 0.0192278689548, 12.0118231781),
     (0.0255870442865, 0.0255870352586, 12.0118231781)]
]

TEST_7_RUPTURE_7_CORNERS = [
    Point(-0.00399811467158, -0.0113083758289, 9.55543014749),
    Point(-0.00399811467158, 0.0113083758289, 9.55543014749),
    Point(0.00399811467158, 0.0113083758289, 10.4445698525),
    Point(0.00399811467158, -0.0113083758289, 10.4445698525)
]
TEST_7_RUPTURE_7_MESH = [
    [(-0.00399811467158, -0.0113083758289, 9.55543014749),
     (-0.00399811467158, -0.00231515553496, 9.55543014749),
     (-0.00399811467158, 0.00667806475902, 9.55543014749),
     (-0.00399811467158, 0.015671285053, 9.55543014749)],
    [(0.00236105249485, -0.0113083758469, 10.26253693),
     (0.00236105241243, -0.00231515553863, 10.262536926),
     (0.00236105245044, 0.00667806476961, 10.262536926),
     (0.00236105253637, 0.0156712850779, 10.2625369381)]
]

TEST_7_RUPTURE_8_CORNERS = [
    Point(-0.0126431501863, -0.0357602239954, 8.59414668702),
    Point(-0.0126431501863, 0.0357602239954, 8.59414668702),
    Point(0.0126431501863, 0.0357602239954, 11.405853313),
    Point(0.0126431501863, -0.0357602239954, 11.405853313),
]
TEST_7_RUPTURE_8_MESH = [
    [(-0.0126431501863, -0.0357602239954, 8.59414668702),
     (-0.0126431501863, -0.0267670037015, 8.59414668702),
     (-0.0126431501863, -0.0177737834075, 8.59414668702),
     (-0.0126431501863, -0.00878056311352, 8.59414668702),
     (-0.0126431501863, 0.000212657180463, 8.59414668702),
     (-0.0126431501863, 0.00920587747445, 8.59414668702),
     (-0.0126431501863, 0.0181990977684, 8.59414668702),
     (-0.0126431501863, 0.0271923180624, 8.59414668702),
     (-0.0126431501863, 0.0361855383564, 8.59414668702)],
    [(-0.00628398209936, -0.035760224651, 9.30125349114),
     (-0.00628398237213, -0.0267670041922, 9.30125346091),
     (-0.00628398256436, -0.0177737837333, 9.30125343915),
     (-0.0062839826833, -0.00878056327449, 9.30125342665),
     (-0.00628398271805, 0.000212657184361, 9.30125342222),
     (-0.00628398267951, 0.00920587764321, 9.30125342706),
     (-0.0062839825568, 0.0181990981021, 9.30125343996),
     (-0.00628398236078, 0.0271923185609, 9.30125346212),
     (-0.00628398208422, 0.0361855390197, 9.30125349276)],
    [(7.51859875413e-05, -0.0357602253066, 10.0083602953),
     (7.51854419831e-05, -0.0267670046829, 10.0083602348),
     (7.51850575225e-05, -0.0177737840592, 10.0083601913),
     (7.51848196605e-05, -0.00878056343545, 10.0083601663),
     (7.51847501458e-05, 0.00021265718826, 10.0083601574),
     (7.51848272296e-05, 0.00920587781197, 10.0083601671),
     (7.51850726607e-05, 0.0181990984357, 10.0083601929),
     (7.51854646904e-05, 0.0271923190594, 10.0083602372),
     (7.51860178177e-05, 0.0361855396831, 10.0083602985)],
    [(0.00643435407444, -0.0357602259621, 10.7154670994),
     (0.0064343532561, -0.0267670051736, 10.7154670087),
     (0.00643435267941, -0.017773784385, 10.7154669434),
     (0.00643435232262, -0.00878056359642, 10.7154669059),
     (0.00643435221834, 0.000212657192158, 10.7154668926),
     (0.00643435233397, 0.00920587798073, 10.7154669071),
     (0.00643435270212, 0.0181990987693, 10.7154669458),
     (0.00643435329016, 0.0271923195579, 10.7154670123),
     (0.00643435411985, 0.0361855403465, 10.7154671042)],
    [(0.0127935221613, -0.0357602266177, 11.4225739035),
     (0.0127935210702, -0.0267670056643, 11.4225737826),
     (0.0127935203013, -0.0177737847108, 11.4225736955),
     (0.0127935198256, -0.00878056375738, 11.4225736455),
     (0.0127935196865, 0.000212657196057, 11.4225736278),
     (0.0127935198407, 0.00920587814949, 11.4225736472),
     (0.0127935203316, 0.0181990991029, 11.4225736987),
     (0.0127935211156, 0.0271923200564, 11.4225737874),
     (0.0127935222219, 0.0361855410098, 11.42257391)]
]
